/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.govt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.govt.component.CloudreveHelper;
import com.geoway.ns.govt.entity.CloudreveRelation;
import com.geoway.ns.govt.mapper.CloudreveRelationMapper;
import com.geoway.ns.govt.service.ICloudreveService;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import java.net.HttpCookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CloudreveServiceImpl
extends ServiceImpl<CloudreveRelationMapper, CloudreveRelation>
implements ICloudreveService {
    @Autowired
    private CloudreveHelper cloudreveHelper;
    @Autowired
    private ITokenService tokenService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CloudreveRelation queryByUserId(String userid, String token) throws Exception {
        CloudreveRelation cloudreveRelation = (CloudreveRelation)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(CloudreveRelation::getUserId, (Object)userid));
        if (cloudreveRelation == null) {
            SysUserDTO user = this.getUser(userid, token);
            JSONObject res = this.cloudreveHelper.create(user);
            cloudreveRelation = new CloudreveRelation();
            cloudreveRelation.setUserId(userid);
            cloudreveRelation.setCuid(res.getString("userName"));
            cloudreveRelation.setCuname(user.getUsername());
            this.save(cloudreveRelation);
        }
        return cloudreveRelation;
    }

    @Override
    public HttpCookie login(String userid, String userName) {
        String pwd = userName = userName + this.cloudreveHelper.getSuffix();
        return this.cloudreveHelper.userLogin(userName, pwd);
    }

    private SysUserDTO getUser(String userId, String token) throws Exception {
        return this.tokenService.querySysUserByToken(token, Boolean.valueOf(true));
    }
}

