-- tb_hztj_catalog definition

-- Drop table

-- DROP TABLE tb_hztj_catalog;

CREATE TABLE tb_hztj_catalog (
	f_id varchar(36) NOT NULL,
	f_name varchar(64) NULL,
	f_level int2 NULL,
	f_pid varchar(36) NULL,
	f_param text NULL,
	f_sort int2 NULL,
	f_isdefault int2 NULL,
	f_xzqdm varchar(255) NULL,
	f_year varchar(255) NULL,
	f_years varchar(255) NULL,
	f_filllevel varchar(36) NULL,
	f_areaunit varchar(36) NULL,
	f_url varchar(255) NULL,
	f_datasource varchar(36) NULL,
	f_type int2 NULL DEFAULT 1,
	f_tablename varchar(255) NULL,
	f_dataversion varchar(255) NULL,
	f_overlaydataversion varchar(255) NULL,
	f_tjfams text NULL,
	f_key varchar(255) NULL,
	CONSTRAINT tb_hztj_catalog_pkey PRIMARY KEY (f_id)
);

INSERT INTO tbdm_domain (f_dicname,f_diccodelen,f_dictype,f_dicdesc,f_key) VALUES
	 ('汇总统计',20,0,'汇总统计相关字典配置','DIC_SummaryStatistic');

	 INSERT INTO tbdm_domainvalue (f_code,f_name,f_remark,f_pid,f_corder,f_dicno,f_level) VALUES
	 ('sd-year','sd-year','汇总统计三调年份',-1,0,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),0),
	 ('2019','2019','',10681,0,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('xzq-level','xzq-level','汇总统计行政级别',-1,1,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),0),
	 ('省级','1','',10683,0,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('地市级','2','',10683,1,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('县级','3','',10683,2,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('乡镇级','4','',10683,3,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('村级','5','',10683,4,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('area-unit','area-unit','汇总统计面积单位',-1,2,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),0),
	 ('公顷','1','',10689,0,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1);
INSERT INTO tbdm_domainvalue (f_code,f_name,f_remark,f_pid,f_corder,f_dicno,f_level) VALUES
	 ('万亩','0.0015','',10689,1,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('平方米','10000','',10689,2,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1),
	 ('亩','15','',10689,3,(select f_dicno from tbdm_domain where f_key = 'DIC_SummaryStatistic'),1);
INSERT INTO tbsys_sysparam (f_name,f_key,f_value,f_desc,f_group,f_userkey,f_type) VALUES
	 (NULL,'fineReport-url',decode('687474703A2F2F3132322E3139302E35362E33353A33313537352F776562726F6F742F6465636973696F6E2F766965772F7265706F72743F766965776C65743D','hex'),'帆软默认地址',7,'',0);





