/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.indicator.controller;

import com.geoway.ns.indicator.entity.TbIndexContentViewConfig;
import com.geoway.ns.indicator.service.IContentViewXMFactory;
import com.geoway.ns.indicator.service.TbIndexContentViewConfigService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6307\u6807\u7ba1\u7406\u5185\u5bb9\u5c55\u793a\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/zbgl/contentview"})
public class TbIndexContentViewController {
    private static final Logger log = LoggerFactory.getLogger(TbIndexContentViewController.class);
    @Autowired
    private TbIndexContentViewConfigService tbIndexContentViewConfigService;
    @Autowired
    private IContentViewXMFactory contentViewXMFactory;

    @ApiOperation(value="1-\u67e5\u8be2\u5c55\u793a\u914d\u7f6e")
    @RequestMapping(value={"/config/find"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<TbIndexContentViewConfig> findConfig(String indexId) {
        TbIndexContentViewConfig config = this.tbIndexContentViewConfigService.findConfig(indexId);
        return DataResponse.success((Object)config);
    }

    @ApiOperation(value="2-\u4fdd\u5b58\u6216\u66f4\u65b0\u5c55\u793a\u914d\u7f6e")
    @RequestMapping(value={"/config/save"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveOrUpdate(TbIndexContentViewConfig config) {
        this.tbIndexContentViewConfigService.config(config);
        return BaseResponse.success();
    }

    @ApiOperation(value="3-\u5220\u9664\u5c55\u793a\u914d\u7f6e")
    @RequestMapping(value={"/config/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse schemeDelete(String indexId) {
        this.tbIndexContentViewConfigService.deleteConfig(indexId);
        return BaseResponse.success();
    }

    @ApiOperation(value="4-\u67e5\u8be2\u5185\u5bb9\u67e5\u770b\u65b9\u5f0f\u5217\u8868")
    @RequestMapping(value={"/config/viewTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List> viewTypes() {
        List list = this.tbIndexContentViewConfigService.viewTypes();
        return DataResponse.success((Object)list);
    }

    @ApiOperation(value="5-\u6309\u9879\u76ee\u65b9\u5f0f\u67e5\u770b-\u67e5\u8be2\u8868\u5934\u6837\u5f0f\u5217\u8868")
    @RequestMapping(value={"/xm/viewTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List> headerTypes() {
        List list = this.contentViewXMFactory.headerTypes();
        return DataResponse.success((Object)list);
    }

    @ApiOperation(value="6-\u6309\u9879\u76ee\u65b9\u5f0f\u67e5\u770b-\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @RequestMapping(value={"/xm/list"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List> listXM(String indexId) {
        List list = this.contentViewXMFactory.listXM(indexId);
        return DataResponse.success((Object)list);
    }

    @ApiOperation(value="7-\u6309\u9879\u76ee\u65b9\u5f0f\u67e5\u770b-\u901a\u8fc7Excel\u65b9\u5f0f\u67e5\u770b\u5185\u5bb9")
    @RequestMapping(value={"/xm/contentByExcel"}, method={RequestMethod.GET})
    @ResponseBody
    public void xMcontentByExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam String indexId, @RequestParam String xmmc) throws Exception {
        this.contentViewXMFactory.contentByExcel(response, indexId, xmmc);
    }
}

