/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.FilterDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.basic.a.c;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.ns.mdc.domain.AutoimportRel;
import com.geoway.ns.mdc.domain.MdcApplicationApi;
import com.geoway.ns.mdc.mapper.MdcApplicationApiMapper;
import com.geoway.ns.mdc.service.IAutoImportService;
import com.geoway.ns.mdc.service.IDataCenterService;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.service.FileServerService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataCenterServiceImpl
implements IDataCenterService {
    @Autowired
    FileServerService fileServerService;
    @Autowired
    private IAutoImportService autoImportService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private FileStorageService fileStorageService;
    @Autowired
    MdcApplicationApiMapper mdcApplicationApiMapper;

    @Override
    public DataResponse uploadFile(String namespace, MultipartFile file) throws Exception {
        DataResponse baseObjectResponse = new DataResponse();
        FileServerResponse fileServerResponse = this.fileServerService.sendFileToServerOnSpeFolder(file, namespace);
        FileUploadResponse fileUploadResponse = fileServerResponse.convertToFileUploadResponse();
        baseObjectResponse.setResult((Object)fileUploadResponse);
        baseObjectResponse.setShowData(false);
        return baseObjectResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String namespace, JSONObject jsonObject) throws Exception {
        List<MdcApplicationApi> apis = this.mdcApplicationApiMapper.findByNamespace(namespace);
        if (apis == null || apis.size() == 0) {
            throw new Exception("\u6ca1\u6709\u53d1\u73b0\u6709\u7528\u7684api\u63a5\u53e3");
        }
        try (IFeatureWorkspace targetWorkspace = this.geoDatabaseService.openGeoWorkspace(apis.get(0).getDatasourcekey());){
            List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(namespace, null, null);
            Map<String, List<AutoimportRel>> targetTableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getTablename));
            Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
            if (srctableName2Fields == null || srctableName2Fields.keySet() == null || srctableName2Fields.keySet().size() == 0) {
                throw new Exception("\u6ca1\u6709\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f");
            }
            Map<String, IGeoDataset> targetTablename2FeatuerCalss = this.getTargetTablename2FeatuerCalss(targetWorkspace, targetTableName2Fields);
            for (String srcTableName : srctableName2Fields.keySet()) {
                JSONObject srcTableData = jsonObject.getJSONObject(srcTableName);
                if (srcTableData == null) continue;
                List<AutoimportRel> srcFields = srctableName2Fields.get(srcTableName);
                String targetTableName = srcFields.get(0).getTablename();
                IGeoDataset targetFeatureClass = targetTablename2FeatuerCalss.get(targetTableName);
                if (!this.startEdit(targetFeatureClass)) {
                    throw new RuntimeException(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", targetTableName));
                }
                this.InsertData(targetFeatureClass, srcFields, srcTableData, srcTableName, targetTableName, null);
                this.InsertChildData(targetTablename2FeatuerCalss, srctableName2Fields, srcTableData, srcTableName);
            }
            for (String targetTableName : targetTablename2FeatuerCalss.keySet()) {
                this.stopEdit(targetTablename2FeatuerCalss.get(targetTableName), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String namespace, String tablename, JSONObject postData) throws Exception {
        List<MdcApplicationApi> apis = this.mdcApplicationApiMapper.findByNamespace(namespace);
        if (apis == null || apis.size() == 0) {
            throw new Exception("\u6ca1\u6709\u53d1\u73b0\u6709\u7528\u7684api\u63a5\u53e3");
        }
        try (IFeatureWorkspace targetWorkspace = this.geoDatabaseService.openGeoWorkspace(apis.get(0).getDatasourcekey());){
            List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(namespace, null, null);
            Map<String, List<AutoimportRel>> targetTableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getTablename));
            Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
            if (srctableName2Fields == null || srctableName2Fields.keySet() == null || srctableName2Fields.keySet().size() == 0) {
                throw new Exception("\u6ca1\u6709\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f");
            }
            Map<String, IGeoDataset> targetTablename2FeatuerCalss = this.getTargetTablename2FeatuerCalss(targetWorkspace, targetTableName2Fields);
            JSONObject srcTableData = postData;
            List<AutoimportRel> srcFields = srctableName2Fields.get(tablename);
            String targetTableName = srcFields.get(0).getTablename();
            IGeoDataset targetFeatureClass = targetTablename2FeatuerCalss.get(targetTableName);
            if (!this.startEdit(targetFeatureClass)) {
                throw new RuntimeException(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", targetTableName));
            }
            this.InsertData(targetFeatureClass, srcFields, srcTableData, tablename, targetTableName, null);
            this.InsertChildData(targetTablename2FeatuerCalss, srctableName2Fields, srcTableData, tablename);
            for (String _targetTableName : targetTablename2FeatuerCalss.keySet()) {
                this.stopEdit(targetTablename2FeatuerCalss.get(_targetTableName), true);
            }
        }
    }

    private Map<String, IGeoDataset> getTargetTablename2FeatuerCalss(IFeatureWorkspace targetWorkspace, Map<String, List<AutoimportRel>> targetTableName2Fields) {
        HashMap<String, IGeoDataset> targetTablename2FeatuerCalss = new HashMap<String, IGeoDataset>();
        if (targetTableName2Fields != null && targetTableName2Fields.keySet() != null && targetTableName2Fields.keySet().size() > 0) {
            for (String targetTableName : targetTableName2Fields.keySet()) {
                List<AutoimportRel> targetFieldsDef = targetTableName2Fields.get(targetTableName);
                boolean existsGeometryField = targetFieldsDef.stream().anyMatch(field -> field.getFieldtype() == 14);
                Object targetFeatureClass = null;
                targetFeatureClass = existsGeometryField ? targetWorkspace.openFeatureClass(targetTableName) : targetWorkspace.openTable(targetTableName);
                if (targetFeatureClass == null) {
                    Fields targetFields = new Fields();
                    String[] geomField = new String[]{null};
                    String[] oidField = new String[]{null};
                    targetFieldsDef.forEach(arg_0 -> DataCenterServiceImpl.lambda$getTargetTablename2FeatuerCalss$1(geomField, (IFields)targetFields, oidField, arg_0));
                    if (targetFields.findFieldIndex("f_importtime") < 0) {
                        targetFields.addField((IField)new Field("f_importtime", "\u5165\u5e93\u65f6\u95f4", FieldType.DateTime));
                    }
                    if ((targetFeatureClass = existsGeometryField ? targetWorkspace.createFeatureClass(targetTableName, (IFields)targetFields, FeatureType.Polygon, geomField[0], null) : targetWorkspace.createTable(targetTableName, (IFields)targetFields)) == null) {
                        throw new RuntimeException("\u6253\u5f00\u76ee\u6807\u56fe\u5c42[" + targetTableName + "]\u5931\u8d25,\u4e14\u65b0\u5efa\u56fe\u5c42\u4ea6\u672a\u6210\u529f");
                    }
                    if (targetFeatureClass == null) continue;
                    if (existsGeometryField) {
                        targetFeatureClass.createSpatialIndex();
                    }
                    targetTablename2FeatuerCalss.put(targetTableName, (IGeoDataset)targetFeatureClass);
                    System.out.println(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u521b\u5efa\u6210\u529f", targetTableName));
                    continue;
                }
                targetTablename2FeatuerCalss.put(targetTableName, (IGeoDataset)targetFeatureClass);
                System.out.println(String.format("\u6253\u5f00\u76ee\u6807\u56fe\u5c42[%s]\u6210\u529f", targetTableName));
            }
        } else {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u76ee\u6807\u56fe\u5c42");
        }
        return targetTablename2FeatuerCalss;
    }

    private void InsertChildData(Map<String, IGeoDataset> targetTablename2FeatuerCalss, Map<String, List<AutoimportRel>> srctableName2Fields, JSONObject srcTableData, String srcTableName) {
        block9: {
            block8: {
                if (!srcTableData.containsKey((Object)"children") || srcTableData.getJSONArray("children") == null || srcTableData.getJSONArray("children").size() <= 0) break block8;
                JSONArray ChildrenDatas = srcTableData.getJSONArray("children");
                for (int i = 0; i < ChildrenDatas.size(); ++i) {
                    JSONObject jsonObjectChildrenItem = ChildrenDatas.getJSONObject(i);
                    for (String _srcTableName : jsonObjectChildrenItem.keySet()) {
                        JSONObject _childrenItemSrcTableData = jsonObjectChildrenItem.getJSONObject(_srcTableName);
                        List<AutoimportRel> _childrenItemsrcFields = srctableName2Fields.get(_srcTableName);
                        String _childrenItemTargetTableName = _childrenItemsrcFields.get(0).getTablename();
                        IGeoDataset _childrenItemTargetFeatureClass = targetTablename2FeatuerCalss.get(_childrenItemTargetTableName);
                        if (!this.startEdit(_childrenItemTargetFeatureClass)) {
                            throw new RuntimeException(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", _childrenItemTargetTableName));
                        }
                        this.InsertData(_childrenItemTargetFeatureClass, _childrenItemsrcFields, _childrenItemSrcTableData, _srcTableName, _childrenItemTargetTableName, srcTableData);
                    }
                }
                break block9;
            }
            if (srctableName2Fields == null || srctableName2Fields.keySet() == null || srctableName2Fields.keySet().size() <= 0) break block9;
            for (String _srcTableName : srctableName2Fields.keySet()) {
                IGeoDataset _childrenItemTargetFeatureClass;
                String _childrenItemTargetTableName;
                List<AutoimportRel> _childrenItemsrcFields;
                if (!srcTableData.containsKey((Object)_srcTableName) || srcTableName.equalsIgnoreCase(_srcTableName)) continue;
                Object srcTableDataValue = srcTableData.get((Object)_srcTableName);
                if (srcTableDataValue instanceof JSONArray || srcTableDataValue instanceof ArrayList) {
                    JSONArray _childrenItemSrcTableDatas = srcTableData.getJSONArray(_srcTableName);
                    _childrenItemsrcFields = srctableName2Fields.get(_srcTableName);
                    _childrenItemTargetTableName = _childrenItemsrcFields.get(0).getTablename();
                    _childrenItemTargetFeatureClass = targetTablename2FeatuerCalss.get(_childrenItemTargetTableName);
                    if (!this.startEdit(_childrenItemTargetFeatureClass)) {
                        throw new RuntimeException(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", _childrenItemTargetTableName));
                    }
                    for (int i = 0; i < _childrenItemSrcTableDatas.size(); ++i) {
                        this.InsertData(_childrenItemTargetFeatureClass, _childrenItemsrcFields, _childrenItemSrcTableDatas.getJSONObject(0), _srcTableName, _childrenItemTargetTableName, srcTableData);
                    }
                    continue;
                }
                if (!(srcTableDataValue instanceof JSONObject) && !(srcTableDataValue instanceof HashMap)) continue;
                JSONObject _childrenItemSrcTableData = srcTableData.getJSONObject(_srcTableName);
                _childrenItemsrcFields = srctableName2Fields.get(_srcTableName);
                _childrenItemTargetTableName = _childrenItemsrcFields.get(0).getTablename();
                _childrenItemTargetFeatureClass = targetTablename2FeatuerCalss.get(_childrenItemTargetTableName);
                if (!this.startEdit(_childrenItemTargetFeatureClass)) {
                    throw new RuntimeException(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", _childrenItemTargetTableName));
                }
                this.InsertData(_childrenItemTargetFeatureClass, _childrenItemsrcFields, _childrenItemSrcTableData, _srcTableName, _childrenItemTargetTableName, srcTableData);
            }
        }
    }

    private boolean deleteData(IGeoDataset geoDataset, IRow targeFeature) {
        boolean saveSuccess = false;
        if (geoDataset instanceof IFeatureClass) {
            IFeatureClass targetFeatureClass = (IFeatureClass)geoDataset;
            saveSuccess = targetFeatureClass.deleteFeature((Object)((IFeature)targeFeature));
        } else if (geoDataset instanceof ITable) {
            ITable targetTable = (ITable)geoDataset;
            saveSuccess = targetTable.deleteRow((Object)targeFeature);
        }
        return saveSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InsertData(IGeoDataset geoDataset, List<AutoimportRel> srcFields, JSONObject srcTableData, String srcTableName, String targetTableName, JSONObject parentData) {
        IFeatureCursor trgInsertCursor = null;
        IFeature targeFeature = null;
        ICursor trgTableInsertCursor = null;
        if (geoDataset instanceof IFeatureClass) {
            IFeatureClass targetFeatureClass = (IFeatureClass)geoDataset;
            trgInsertCursor = targetFeatureClass.insertFeature();
            targeFeature = targetFeatureClass.createFeature();
        } else if (geoDataset instanceof ITable) {
            ITable targetTable = (ITable)geoDataset;
            trgTableInsertCursor = targetTable.insertRow();
            targeFeature = targetTable.createRow();
        }
        Date startTime2 = new Date();
        long totalCount = 1L;
        long errorCount = 0L;
        long successCount = 0L;
        try {
            Integer fieldIndex = 0;
            while (fieldIndex < srcFields.size()) {
                Serializable fieldInfo = srcFields.get(fieldIndex);
                String srcFielName = fieldInfo.getImFieldname();
                if (!StringUtils.isEmpty((CharSequence)srcFielName)) {
                    if (srcFielName.indexOf(".") > -1) {
                        if (StringUtils.isNotEmpty((CharSequence)(srcFielName = srcFielName.split("\\.")[1]))) {
                            this.setFieldValue((IRow)targeFeature, (AutoimportRel)fieldInfo, parentData, srcFielName);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)srcFielName)) {
                        this.setFieldValue((IRow)targeFeature, (AutoimportRel)fieldInfo, srcTableData, srcFielName);
                    }
                }
                fieldInfo = fieldIndex;
                Integer n = fieldIndex = Integer.valueOf(fieldIndex + 1);
            }
            if (targeFeature.getFields().findFieldIndex("f_importtime") > 0) {
                targeFeature.setValue("f_importtime", (Object)new Date());
            }
            boolean saveSuccess = false;
            if (trgInsertCursor != null) {
                trgInsertCursor.insertFeature(targeFeature);
            } else {
                trgTableInsertCursor.insertRow((IRow)targeFeature);
            }
            if (saveSuccess) {
                ++successCount;
            } else {
                ++errorCount;
            }
            String text = DateTimeUtil.getTimeIntervalStr((Date)startTime2, (Date)new Date());
            System.out.println(String.format("%s\u5165\u5e93[%s]%s\uff1a\u5171%s\u4e2a\uff0c\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002\u603b\u8017\u65f6:%s", srcTableName, targetTableName, saveSuccess ? "\u6210\u529f" : "\u5931\u8d25", totalCount, successCount, errorCount, text));
        }
        finally {
            if (trgInsertCursor != null) {
                trgInsertCursor.release();
            }
            if (trgTableInsertCursor != null) {
                trgTableInsertCursor.release();
            }
        }
    }

    private void setFieldValue(IRow targeFeature, AutoimportRel fieldInfo, JSONObject srcTableData, String srcFielName) {
        String wkt = "";
        if (fieldInfo.getFieldtype().intValue() == FieldType.Shape.getValue()) {
            String clean;
            String[] coordsFields;
            IEnvelope dataExtent = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
            if (srcTableData.containsKey((Object)srcFielName)) {
                wkt = srcTableData.getString(srcFielName);
            } else if (srcFielName.indexOf("POINT(") > -1 && (coordsFields = (clean = srcFielName.replace("POINT(", "").replace(")", "")).trim().split(" ")).length == 2) {
                wkt = "POINT(" + srcTableData.getString(coordsFields[0]) + " " + srcTableData.getString(coordsFields[1]) + ")";
            }
            IGeometry pNewShape = GeometryFunc.createGeometry((String)wkt);
            if (pNewShape != null && pNewShape.getEnvelope() != null) {
                this.setEnvelop(dataExtent, pNewShape.getEnvelope());
            }
            ((IFeature)targeFeature).setGeometry(pNewShape);
            if (pNewShape != null) {
                System.out.println("wkt:" + pNewShape.toWkt());
            }
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Text.getValue() || fieldInfo.getFieldtype().intValue() == FieldType.String.getValue()) {
            String value = srcTableData.getString(srcFielName);
            if ("ASSIGN_UUID".equalsIgnoreCase(srcFielName)) {
                value = UUID.randomUUID().toString();
                srcTableData.put(fieldInfo.getFieldname(), (Object)value);
            }
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Double.getValue()) {
            Double value = srcTableData.getDouble(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Double.getValue()) {
            Float value = srcTableData.getFloat(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Int.getValue()) {
            Integer value = srcTableData.getInteger(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Long.getValue()) {
            Long value = srcTableData.getLong(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.String.getValue()) {
            Long value = srcTableData.getLong(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Short.getValue()) {
            Short value = srcTableData.getShort(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Byte.getValue()) {
            Byte value = srcTableData.getByte(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Boolean.getValue()) {
            Boolean value = srcTableData.getBoolean(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.DateTime.getValue()) {
            Date value = srcTableData.getDate(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        } else if (fieldInfo.getFieldtype().intValue() == FieldType.Decimal.getValue()) {
            BigDecimal value = srcTableData.getBigDecimal(srcFielName);
            targeFeature.setValue(fieldInfo.getFieldname(), (Object)value);
        }
    }

    @Override
    public DataQueryResult queryData(String namespace, String tablename, FeatureQueryFilterDTO queryFilterDTO, Boolean fieldConvert) {
        List<MdcApplicationApi> apis = this.mdcApplicationApiMapper.findByNamespace(namespace);
        List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(namespace, null, null);
        Map<String, List<AutoimportRel>> targetTableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getTablename));
        Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
        List<AutoimportRel> nodeFields = srctableName2Fields.get(tablename);
        if (nodeFields != null && nodeFields.size() > 0) {
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (AutoimportRel fld : nodeFields) {
                fieldNameList.add(fld.getFieldname());
            }
            queryFilterDTO.setFields(String.join((CharSequence)",", fieldNameList));
            DataQueryResult result = this.geoDatabaseService.queryGeoDataset(apis.get(0).getDatasourcekey(), nodeFields.get(0).getTablename(), (QueryFilterDTO)queryFilterDTO);
            if (fieldConvert.booleanValue()) {
                this.queryResultFieldConvert(result, srctableName2Fields.get(tablename));
            }
            result.setId(queryFilterDTO.getNodeId());
            result.setName(tablename);
            return result;
        }
        throw new RuntimeException("[" + tablename + "]\u8282\u70b9\u5b57\u6bb5\u4e3a\u7a7a");
    }

    @Override
    public DataQueryResult queryByObjectId(String namespace, String tablename, Object objectid, Boolean fieldConvert) {
        List<MdcApplicationApi> apis = this.mdcApplicationApiMapper.findByNamespace(namespace);
        List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(namespace, null, null);
        Map<String, List<AutoimportRel>> targetTableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getTablename));
        Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
        List<AutoimportRel> nodeFields = srctableName2Fields.get(tablename);
        if (nodeFields != null && nodeFields.size() > 0) {
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (AutoimportRel fld : nodeFields) {
                fieldNameList.add(fld.getFieldname());
            }
            DataQueryResult result = this.geoDatabaseService.queryByObjectId(apis.get(0).getDatasourcekey(), nodeFields.get(0).getTablename(), objectid, String.join((CharSequence)",", fieldNameList), Boolean.valueOf(true));
            if (fieldConvert.booleanValue()) {
                this.queryResultFieldConvert(result, srctableName2Fields.get(tablename));
            }
            result.setName(tablename);
            return result;
        }
        throw new RuntimeException("[" + tablename + "]\u8282\u70b9\u5b57\u6bb5\u4e3a\u7a7a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteByObjectId(String namespace, String tablename, Object objectid) {
        List<MdcApplicationApi> apis = this.mdcApplicationApiMapper.findByNamespace(namespace);
        if (apis == null || apis.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u53d1\u73b0\u6709\u7528\u7684api\u63a5\u53e3");
        }
        boolean saveSuccess = false;
        try (IFeatureWorkspace targetWorkspace = this.geoDatabaseService.openGeoWorkspace(apis.get(0).getDatasourcekey());){
            List<AutoimportRel> srcFields;
            String targetTableName;
            List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(namespace, null, null);
            Map<String, List<AutoimportRel>> targetTableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getTablename));
            Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
            if (srctableName2Fields == null || srctableName2Fields.keySet() == null || srctableName2Fields.keySet().size() == 0) {
                throw new RuntimeException("\u6ca1\u6709\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f");
            }
            Map<String, IGeoDataset> targetTablename2FeatuerCalss = this.getTargetTablename2FeatuerCalss(targetWorkspace, targetTableName2Fields);
            IGeoDataset targetFeatureClass = targetTablename2FeatuerCalss.get(targetTableName = (srcFields = srctableName2Fields.get(tablename)).get(0).getTablename());
            if (!this.startEdit(targetFeatureClass)) {
                throw new RuntimeException(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", targetTableName));
            }
            if (targetFeatureClass instanceof IFeatureClass) {
                IFeatureClass _targetFeatureClass = (IFeatureClass)targetFeatureClass;
                saveSuccess = _targetFeatureClass.deleteFeature(objectid);
            } else if (targetFeatureClass instanceof ITable) {
                ITable targetTable = (ITable)targetFeatureClass;
                saveSuccess = targetTable.deleteRow(objectid);
            }
            for (String _targetTableName : targetTablename2FeatuerCalss.keySet()) {
                this.stopEdit(targetTablename2FeatuerCalss.get(_targetTableName), true);
            }
        }
        return saveSuccess;
    }

    @Override
    public Long deleteByFiter(String namespace, String tablename, DataBatchDeleteDTO dataBatchDeleteDTO) {
        List<MdcApplicationApi> apis = this.mdcApplicationApiMapper.findByNamespace(namespace);
        List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(namespace, null, null);
        Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
        List<AutoimportRel> nodeFields = srctableName2Fields.get(tablename);
        if (nodeFields != null && nodeFields.size() > 0) {
            IFeatureWorkspace targetWorkspace = this.geoDatabaseService.openGeoWorkspace(apis.get(0).getDatasourcekey());
            ITable targetFeatureClass = targetWorkspace.openTable(nodeFields.get(0).getTablename());
            SpatialQueryFilter queryFilter = SpatailQueryUtil.buildFilter((FilterDTO)dataBatchDeleteDTO, (IGeoDataset)targetFeatureClass);
            long count = targetFeatureClass.deleteRow((IQueryFilter)queryFilter);
            return count;
        }
        throw new RuntimeException("[" + tablename + "]\u8282\u70b9\u5b57\u6bb5\u4e3a\u7a7a");
    }

    private void queryResultFieldConvert(DataQueryResult result, List<AutoimportRel> fieldLists) {
        if (fieldLists != null && fieldLists.size() > 0) {
            List returnFields = result.getFields();
            List _datas = result.getData();
            returnFields.forEach(f -> {
                AutoimportRel _fieldItem = fieldLists.stream().filter(p -> p.getFieldname().equalsIgnoreCase(f.getName())).findFirst().orElse(null);
                if (_fieldItem != null && StringUtils.isNotEmpty((CharSequence)_fieldItem.getImFieldname()) && _fieldItem.getImFieldname().indexOf(".") == -1 && _fieldItem.getImFieldname().indexOf("ASSIGN_UUID") == -1 && _fieldItem.getImFieldname().indexOf("(") == -1 && _fieldItem.getImFieldname().indexOf(")") == -1) {
                    if (_datas != null && _datas.size() > 0) {
                        for (int i = 0; i < _datas.size(); ++i) {
                            FeatureResult featureResult = (FeatureResult)_datas.get(i);
                            Map attributes = featureResult.getAttributes();
                            attributes.put(_fieldItem.getImFieldname(), attributes.get(f.getName()));
                            attributes.remove(f.getName());
                            featureResult.setAttributes(attributes);
                            _datas.set(i, featureResult);
                        }
                    }
                    f.setName(_fieldItem.getImFieldname());
                    result.setData(_datas);
                }
            });
        }
    }

    private void setEnvelop(IEnvelope newExtent, IEnvelope oldExtent) {
        newExtent.setRange(Double.min(newExtent.getXMin(), oldExtent.getXMin()), Double.min(newExtent.getYMin(), oldExtent.getYMin()), Double.max(newExtent.getXMax(), oldExtent.getXMax()), Double.max(newExtent.getYMax(), oldExtent.getYMax()));
    }

    private boolean startEdit(IGeoDataset trgFC) {
        IFeatureWorkspace pWorkspace = trgFC.getWorkspace();
        if (pWorkspace == null) {
            return false;
        }
        if (!pWorkspace.getInTransaction()) {
            pWorkspace.beginTransaction();
        }
        return true;
    }

    private void stopEdit(IGeoDataset trgFC, boolean isSave) {
        IFeatureWorkspace pWorkspace = trgFC.getWorkspace();
        if (pWorkspace != null && pWorkspace.getInTransaction()) {
            if (isSave) {
                pWorkspace.commitTransaction();
            } else {
                pWorkspace.rollbackTransaction();
            }
        }
    }

    private static /* synthetic */ void lambda$getTargetTablename2FeatuerCalss$1(String[] geomField, IFields targetFields, String[] oidField, AutoimportRel f) {
        if (f.getFieldtype() == 14) {
            geomField[0] = f.getFieldname();
            targetFields.addField((IField)new GeometryField(f.getFieldname(), f.getFieldalias(), GeometryType.MultiPolygon, c.createSpatialReference((int)4490), CoordinateType.XY));
        } else if (f.getFieldtype() == 4097) {
            oidField[0] = f.getFieldname();
            targetFields.addField((IField)new Field(f.getFieldname(), f.getFieldalias(), FieldType.getByValue((Integer)f.getFieldtype())));
        } else {
            targetFields.addField((IField)new Field(f.getFieldname(), f.getFieldalias(), FieldType.getByValue((Integer)f.getFieldtype())));
        }
    }
}

