/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.utils;

import com.geoway.ns.mdc.utils.ResultSetInfo;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SqliteTool {
    private Connection connection = null;
    private String _dbPath;
    private String _pwd;

    public SqliteTool(String _dbPath) {
        try {
            this._dbPath = _dbPath;
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + _dbPath);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            throw new RuntimeException("\u6253\u5f00\u6570\u636e\u5931\u8d25:" + var3.getMessage());
        }
    }

    public void Dispose() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResultSetInfo doQuery(String sql) {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        ResultSetInfo result = null;
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            resultSet = statement.executeQuery(sql);
            result = new ResultSetInfo(resultSet, statement);
            return result;
        }
        catch (SQLException var7) {
            System.out.println(sql);
            System.out.println("Exception:" + var7.getMessage());
            var7.printStackTrace();
            return null;
        }
    }

    public int doSql(String sql) {
        int count = 0;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            count = statement.executeUpdate(sql);
            this.closeAll(null, statement, null);
            return count;
        }
        catch (SQLException var6) {
            var6.printStackTrace();
            return count;
        }
    }

    public Object queryScale(String sql) {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        Object result = "";
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                result = resultSet.getObject(1);
            }
            this.closeAll(null, statement, resultSet);
            return result;
        }
        catch (SQLException var7) {
            System.out.println(sql);
            System.out.println("Exception:" + var7.getMessage());
            var7.printStackTrace();
            return null;
        }
    }

    public boolean isTableExist(String tableName) {
        String sql = "select count(*) from " + tableName + " where 1 = 2";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.CreateConnection();
            statement = this.CreateStatement(connection);
            resultSet = statement.executeQuery(sql);
            this.closeAll(null, statement, resultSet);
            return true;
        }
        catch (SQLException var7) {
            System.out.println(sql);
            System.out.println("Exception:" + var7.getMessage());
            var7.printStackTrace();
            return false;
        }
    }

    public ArrayList<String> getTables() {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            String sql = "select name from sqlite_master where type='table' order by name";
            ResultSetInfo resultSetInfo = this.doQuery(sql);
            ResultSet resultSet = null;
            if (resultSetInfo != null) {
                resultSet = resultSetInfo.getResultSet();
                while (resultSet.next()) {
                    String tableName = resultSet.getString("name");
                    tables.add(tableName);
                }
                resultSetInfo.Close();
            }
            return tables;
        }
        catch (Exception var6) {
            System.out.println(var6.getMessage());
            return null;
        }
    }

    public void closeAll(Connection con, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeAll(Connection con, Statement stmt, ResultSet rs, PreparedStatement ps) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean isTableExists(Statement statement, String tableName) throws SQLException {
        String sql = String.format("select count(1) from sqlite_master where type = 'table' and name = '%s'", tableName);
        ResultSet rs = statement.executeQuery(sql);
        int iResult = 0;
        while (rs.next()) {
            iResult = rs.getInt(1);
        }
        return iResult > 0;
    }

    private Statement CreateStatement(Connection connection) {
        try {
            return connection.createStatement();
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    private Connection CreateConnection() {
        try {
            if (this.connection == null) {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this._dbPath);
            }
            return this.connection;
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }
}

