/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller;

import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.ShapeExportDTO;
import com.geoway.ns.geoserver3.dto.WktExportDTO;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.service.AnalysisService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5b9e\u65f6\u5206\u6790\u76f8\u5173\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/analysis"})
public class AnalysisController {
    private static final Logger log = LoggerFactory.getLogger(AnalysisController.class);
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private IYZFXService yzfxService;

    @ApiOperation(value="1-\u4e0a\u4f20\u5206\u6790\u8303\u56f4")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public JSONObject upload(HttpServletRequest request, @RequestParam(value="encrypt", required=false, defaultValue="None") EncryptType encrypt, @RequestPart(value="fileData") MultipartFile[] files) throws Exception {
        return this.analysisService.upload(files, encrypt);
    }

    @ApiOperation(value="2-\u5206\u6790\u7ed3\u679c\u5bfc\u51faExcel")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(HttpServletRequest request, HttpServletResponse response, @RequestBody Map jsonParam) throws Exception {
        this.analysisService.excelExport(response, jsonParam);
    }

    @ApiOperation(value="3-\u56fe\u5f62wkt\u6570\u636e\u5bfc\u51fa")
    @RequestMapping(value={"/wktExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void wktExport(HttpServletRequest request, HttpServletResponse response, @RequestBody WktExportDTO wktExportDTO) throws Exception {
        this.analysisService.wktExport(response, wktExportDTO);
    }

    @ApiOperation(value="4-\u83b7\u53d6\u538b\u8986\u4fe1\u606f\uff08\u901a\u8fc7\u4efb\u52a1id\u7edf\u8ba1\uff09")
    @RequestMapping(value={"/getCoverInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public BaseResponse getCoverInfo(@RequestParam String uniqueTaskId) {
        JSONObject result = null;
        JSONObject responseObj = this.yzfxService.getCoverInfo(uniqueTaskId);
        if (!responseObj.getInteger("StatusCode").equals(200)) {
            log.error(responseObj.getString("Message"));
            throw new RuntimeException(responseObj.getString("Message"));
        }
        result = responseObj.getJSONObject("Results");
        return DataResponse.success((Object)result);
    }

    @ApiOperation(value="5-shape\u5bfc\u51fa")
    @RequestMapping(value={"/shapeExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void shapeExport(HttpServletRequest request, HttpServletResponse response, @RequestBody ShapeExportDTO shapeExportDTO) throws Exception {
        this.analysisService.shapeExport(response, shapeExportDTO);
    }
}

