/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.lshs.service.imp;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.geoserver3.dto.GLHSResult;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLHSDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.service.IGLHSService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterLSHSQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerBeforeDataQueryEvent;
import com.geoway.ns.onemap.lshs.dto.LSHSGraphAndFields;
import com.geoway.ns.onemap.lshs.dto.LSHSResultDetail;
import com.geoway.ns.onemap.lshs.entity.TbLSHS;
import com.geoway.ns.onemap.lshs.entity.TbLSHSTable;
import com.geoway.ns.onemap.lshs.mapper.TbLSHSMapper;
import com.geoway.ns.onemap.lshs.service.TbLSHSService;
import com.geoway.ns.onemap.lshs.service.TbLSHSTableService;
import com.geoway.ns.sys.enums.SysPowerEnum;
import com.geoway.ns.sys.service.SysPowerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbLSHSServiceImpl
extends ServiceImpl<TbLSHSMapper, TbLSHS>
implements TbLSHSService {
    @Autowired
    private TbLSHSMapper tbLSHSMapper;
    @Autowired
    private TbLSHSTableService tbLSHSTableService;
    @Autowired
    private IGLHSService glhsService;
    @Autowired
    private ITbAnalysisBaseInfoService tbAnalysisBaseInfoService;
    @Autowired
    private IYZFXService iyzfxService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private SysPowerService sysPowerService;

    @Override
    public List<TbLSHS> search(String name) {
        List list = null;
        list = StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)name.trim()) ? this.list((Wrapper)Wrappers.lambdaQuery(TbLSHS.class).orderByAsc(TbLSHS::getOrder)) : this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHS.class).like(TbLSHS::getName, (Object)name)).orderByAsc(TbLSHS::getOrder));
        return list;
    }

    @Override
    public List<TbLSHS> selectByToken(List<String> roleids, String userids) {
        List list = null;
        List lshs = this.sysPowerService.selectByToken(SysPowerEnum.LSHS.value, roleids, userids);
        List lhsIds = lshs.stream().map(sysPower -> Long.parseLong(sysPower.getMandateId())).collect(Collectors.toList());
        if (lhsIds == null && lhsIds.size() == 0) {
            return null;
        }
        list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHS.class).in(TbLSHS::getId, lhsIds)).orderByAsc(TbLSHS::getOrder));
        return list;
    }

    @Override
    public TbLSHS selectById(Serializable id) {
        return (TbLSHS)this.getById(id);
    }

    @Override
    public TbLSHS selectByName(String name) {
        return (TbLSHS)this.getOne((Wrapper)Wrappers.lambdaQuery(TbLSHS.class).eq(TbLSHS::getName, (Object)name));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbLSHS addOrUpdate(TbLSHS tbLSHS) {
        if (StringUtils.isEmpty((CharSequence)tbLSHS.getName())) {
            throw new RuntimeException("\u5386\u53f2\u56de\u6eaf\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tbLSHS.getStatus() == null) {
            tbLSHS.setStatus(false);
        }
        if (StringUtils.isEmpty((CharSequence)tbLSHS.getAlias())) {
            tbLSHS.setAlias(tbLSHS.getName());
        }
        TbLSHS exist = this.selectByName(tbLSHS.getName());
        if (tbLSHS.getId() == null || tbLSHS.getId().equals(-1)) {
            if (exist != null) {
                throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u540d");
            }
            Integer order = this.tbLSHSMapper.selectMaxOrder();
            order = order == null ? 1 : order + 1;
            tbLSHS.setOrder(order);
            this.save(tbLSHS);
        } else {
            if (exist != null && !exist.getId().equals(tbLSHS.getId())) {
                throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u540d");
            }
            this.updateById(tbLSHS);
        }
        this.addOrUpdateGLHSService(tbLSHS);
        this.updateById(tbLSHS);
        return tbLSHS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        TbLSHS lshs = (TbLSHS)this.getById(id);
        if (lshs == null) {
            return false;
        }
        this.removeById(id);
        this.tbLSHSTableService.deleteByLSHS(lshs);
        if (!"geoserver".equalsIgnoreCase(lshs.getServiceType()) || !StringUtils.isNotEmpty((CharSequence)lshs.getUrl())) {
            this.glhsService.delete(lshs.getServiceId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            Long id = Long.valueOf(idArr[i]);
            this.deleteById(id);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbLSHS curTable = (TbLSHS)this.getById(id);
        if (curTable == null) {
            return false;
        }
        TbLSHS maxTable = (TbLSHS)this.list((Wrapper)Wrappers.lambdaQuery(TbLSHS.class).orderByDesc(TbLSHS::getOrder)).get(0);
        return this.sort(id, maxTable.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbLSHS cur = (TbLSHS)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbLSHS cur = (TbLSHS)this.getById(id);
        if (cur == null) {
            return false;
        }
        int maxOrder = this.tbLSHSMapper.selectMaxOrder();
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, int order) {
        TbLSHS curLSHS = (TbLSHS)this.getById(id);
        if (curLSHS == null) {
            return true;
        }
        if (curLSHS.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curLSHS.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHS.class).ge(TbLSHS::getOrder, (Object)order)).lt(TbLSHS::getOrder, (Object)curLSHS.getOrder())).orderByAsc(TbLSHS::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbLSHS)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHS.class).gt(TbLSHS::getOrder, (Object)curLSHS.getOrder())).le(TbLSHS::getOrder, (Object)order)).orderByAsc(TbLSHS::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbLSHS)needUpdateList.get(i)).setOrder(curLSHS.getOrder() + i);
            }
        }
        curLSHS.setOrder(order);
        needUpdateList.add(curLSHS);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<LSHSResultDetail> analysis(Map<String, Object> param, String serviceName) {
        TbLSHS tbLSHS = this.selectByName(serviceName);
        if (tbLSHS == null) {
            throw new RuntimeException("\u5173\u8054\u56de\u6eaf\u65b9\u6848\u3010" + serviceName + "\u3011\u4e0d\u5b58\u5728");
        }
        List<TbLSHSTable> listTables = this.tbLSHSTableService.selectByLSHS(tbLSHS.getId(), false, false);
        List results = null;
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)tbLSHS.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)tbLSHS.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            results = this.glhsService.analysis(tbLSHS.getUrl(), param, applicationGuid, accessKey);
        } else {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerBeforeDataQueryEvent(this, param));
            TbAnalysisBaseInfo lshsBaseInfo = this.tbAnalysisBaseInfoService.findById(tbLSHS.getServiceId());
            results = this.glhsService.analysis(param, lshsBaseInfo.getName());
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerAfterLSHSQueryEvent(this, results));
        }
        if (results.size() != listTables.size()) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u7684\u5206\u6790\u9879\u4e0e\u4e00\u5f20\u56fe\u5206\u6790\u9879\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        List<Long> lstTableIds = listTables.stream().map(TbLSHSTable::getId).collect(Collectors.toList());
        Map<Long, LSHSGraphAndFields> mapLSHSGraphAndFields = this.tbLSHSTableService.queryDisplayConfigs(lstTableIds);
        ArrayList<LSHSResultDetail> res = new ArrayList<LSHSResultDetail>();
        LSHSGraphAndFields graphAndFields = null;
        HashMap<String, TbAnalysisYZFXDetail> yzfxDetailMap = new HashMap<String, TbAnalysisYZFXDetail>();
        for (int i = 0; i < listTables.size(); ++i) {
            TbLSHSTable tbLSHSTable = listTables.get(i);
            graphAndFields = mapLSHSGraphAndFields.get(tbLSHSTable.getId());
            Optional<GLHSResult> glhsResultOptinal = null;
            if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
                String accessKey = null;
                if (StringUtils.isNotEmpty((CharSequence)tbLSHS.getOtherParams())) {
                    JSONObject otherParams = JSONObject.parseObject((String)tbLSHS.getOtherParams());
                    accessKey = otherParams.getString("accessKey");
                }
                TbAnalysisYZFXDetail yzfxDetail = null;
                if (yzfxDetailMap.containsKey(tbLSHSTable.getServiceId())) {
                    yzfxDetail = (TbAnalysisYZFXDetail)yzfxDetailMap.get(tbLSHSTable.getServiceId());
                } else {
                    String serverRootUrl = tbLSHS.getUrl().split("/rest/glhs/")[0];
                    yzfxDetail = this.iyzfxService.findById(serverRootUrl, tbLSHSTable.getServiceId(), accessKey);
                    if (!yzfxDetailMap.containsKey(tbLSHSTable.getServiceId())) {
                        yzfxDetailMap.put(tbLSHSTable.getServiceId(), yzfxDetail);
                    }
                }
                String yzfxServiceName = yzfxDetail.getName();
                glhsResultOptinal = results.stream().filter(p -> yzfxServiceName.equals(p.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHSTable.getServicePhase()) && tbLSHSTable.getServicePhase().equalsIgnoreCase(p.getCurrentYear())).findFirst();
            } else {
                TbAnalysisYZFXDetail yzfxDetail = this.iyzfxService.findById(tbLSHSTable.getServiceId());
                String yzfxServiceName = yzfxDetail.getName();
                glhsResultOptinal = results.stream().filter(p -> yzfxServiceName.equals(p.getServiceType())).findFirst();
            }
            if (glhsResultOptinal == null || !glhsResultOptinal.isPresent()) {
                System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u7684\u5206\u6790\u7ed3\u679c");
                continue;
            }
            GLHSResult glhsResult = glhsResultOptinal.get();
            glhsResult.setOrder(tbLSHSTable.getOrder());
            glhsResult.setLayerAlias(tbLSHSTable.getNodeName());
            LSHSResultDetail lshsResultDetail = new LSHSResultDetail();
            BeanUtils.copyProperties((Object)glhsResult, (Object)lshsResultDetail);
            lshsResultDetail.setRender(tbLSHSTable.getRender());
            lshsResultDetail.setGraph(graphAndFields.getGraph());
            lshsResultDetail.setFields(graphAndFields.getFields());
            res.add(lshsResultDetail);
        }
        return res;
    }

    private void addOrUpdateGLHSService(TbLSHS tbLSHS) {
        if (!StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl()) || !"geoserver".equalsIgnoreCase(tbLSHS.getServiceType())) {
            String glhsName = "ONEMAP_glhs_" + tbLSHS.getId();
            String glhsAlias = "\u4e00\u5f20\u56fe_\u5173\u8054\u56de\u6eaf_" + tbLSHS.getName();
            TbAnalysisGLHSDetail glhsDetail = null;
            if (StringUtils.isEmpty((CharSequence)tbLSHS.getServiceId())) {
                if (this.glhsService.checkIsExist(glhsName)) {
                    throw new RuntimeException("\u5173\u8054\u56de\u6eaf\u670d\u52a1\u5df2\u7ecf\u5b58\u5728");
                }
                glhsDetail = new TbAnalysisGLHSDetail();
                glhsDetail.setYzfxList(new ArrayList());
            } else {
                glhsDetail = this.glhsService.findById(tbLSHS.getServiceId());
                if (glhsDetail == null) {
                    throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u83b7\u53d6\u5173\u8054\u5206\u6790\u670d\u52a1\u5931\u8d25");
                }
            }
            glhsDetail.setName(glhsName);
            glhsDetail.setAlias(glhsAlias);
            glhsDetail.setGroup("\u4e00\u5f20\u56fe4.0");
            glhsDetail.setDesc(tbLSHS.getDesc());
            glhsDetail.setStatus(Integer.valueOf(tbLSHS.getStatus() != false ? 1 : 0));
            glhsDetail = this.glhsService.save(glhsDetail);
            if (glhsDetail == null) {
                throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u66f4\u65b0\u5173\u8054\u56de\u6eaf\u670d\u52a1\u5931\u8d25");
            }
            tbLSHS.setServiceId(glhsDetail.getId());
        }
    }
}

