/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.service.impl;

import com.geoway.ns.onemap.multidata.dto.DKInfoDTO;
import com.geoway.ns.onemap.multidata.service.ClipImgAsyncHttpTaskService;
import com.geoway.ns.onemap.multidata.service.ClipImgTask;
import com.geoway.ns.onemap.multidata.service.GifService;
import com.geoway.ns.onemap.multidata.service.IMultiDataService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MultiDataServiceImpl
implements IMultiDataService {
    private final Logger logger = LoggerFactory.getLogger(MultiDataServiceImpl.class);
    @Value(value="${yzfx.screenshot:''}")
    private String yzfxScreenshotUrlStr;
    @Value(value="${project.workDir:''}")
    private String workDir;
    private String[] yzfxScreenshotUrls;
    @Autowired
    GifService gifService;

    @Override
    public void exportImage() {
    }

    @Override
    public String createMultiDataImage(DKInfoDTO dkInfoDTO) {
        if (this.yzfxScreenshotUrls == null && StringUtils.isNotEmpty((CharSequence)this.yzfxScreenshotUrlStr)) {
            this.getYzfxScreenshotUrls();
        }
        try {
            final ClipImgAsyncHttpTaskService task = new ClipImgAsyncHttpTaskService(dkInfoDTO, this.yzfxScreenshotUrls);
            Integer corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
            Integer maxmnumPoolSize = 100;
            if (maxmnumPoolSize < corePoolSize) {
                maxmnumPoolSize = corePoolSize * 2;
            }
            ThreadPoolExecutor service = new ThreadPoolExecutor(corePoolSize, maxmnumPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000));
            Thread t = new Thread(){

                @Override
                public void run() {
                    task.compute();
                }
            };
            service.submit(t);
            while (service.getActiveCount() + service.getQueue().size() > 0) {
                Thread.sleep(1000L);
            }
            service.shutdown();
            String fileName = UUID.randomUUID().toString().replace("-", "");
            String gifFilePath = this.workDir + File.separator + "gif" + File.separator + fileName + ".gif";
            File dir = new File(this.workDir + File.separator + "gif" + File.separator);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.gifService.createMultiDataGif(dkInfoDTO.getYears(), dkInfoDTO.getInterval(), dkInfoDTO.getWidth(), dkInfoDTO.getHeight(), gifFilePath);
            if (!service.awaitTermination(15L, TimeUnit.MINUTES)) {
                this.logger.error("\u6267\u884c\u4efb\u52a1isTerminated\u4efb\u52a1\u6267\u884c\u8d85\u65f6\uff01");
            }
            return fileName;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String createMultiDataImage2(DKInfoDTO dkInfoDTO) {
        if (this.yzfxScreenshotUrls == null && StringUtils.isNotEmpty((CharSequence)this.yzfxScreenshotUrlStr)) {
            this.getYzfxScreenshotUrls();
        }
        try {
            ForkJoinPool pool = new ForkJoinPool();
            ClipImgTask task = new ClipImgTask(dkInfoDTO, this.yzfxScreenshotUrls);
            ForkJoinTask<Boolean> result = pool.submit(task);
            try {
                Boolean sessuce = (Boolean)result.get();
                System.out.println("\u7ed3\u679c\uff1a" + sessuce);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            String fileName = UUID.randomUUID().toString().replace("-", "");
            String gifFilePath = this.workDir + File.separator + "gif" + File.separator + fileName + ".gif";
            File dir = new File(this.workDir + File.separator + "gif" + File.separator);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.gifService.createMultiDataGif(dkInfoDTO.getYears(), dkInfoDTO.getInterval(), dkInfoDTO.getWidth(), dkInfoDTO.getHeight(), gifFilePath);
            return fileName;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void download(HttpServletResponse response, String taskId, String outFileName) {
        try {
            String gifFilePath = this.workDir + File.separator + "gif" + File.separator + taskId + ".gif";
            File gifImgFile = new File(gifFilePath);
            FileInputStream input = new FileInputStream(gifImgFile);
            byte[] fileStream = IOUtils.toByteArray((InputStream)input);
            ((InputStream)input).close();
            response.setContentType("image/gif");
            response.setCharacterEncoding("utf-8");
            String attName = taskId + ".gif";
            if (StringUtils.isNotEmpty((CharSequence)outFileName)) {
                attName = outFileName + ".gif";
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attName, "UTF-8"));
            ServletOutputStream myout = response.getOutputStream();
            myout.write(fileStream);
            myout.flush();
            myout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getYzfxScreenshotUrls() {
        if (this.yzfxScreenshotUrls == null && StringUtils.isNotEmpty((CharSequence)this.yzfxScreenshotUrlStr)) {
            this.yzfxScreenshotUrls = this.yzfxScreenshotUrlStr.split(";");
        }
        return this.yzfxScreenshotUrls;
    }
}

