/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.service;

import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.ns.geoserver3.service.IQueryService;
import com.geoway.ns.geoserver3.service.IStatService;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service
public class ExcelTemplateService {
    @Autowired
    private DictionaryService dictionaryService;
    private static final String ExcelTemplate_DIC = "ExcelTemplate_DIC";
    private static final String Translate_DIC = "Translate_DIC";
    @Value(value="${project.template:templates}")
    private String excelTempltePath;
    @Autowired
    private IStatService statService;
    @Autowired
    private IQueryService queryService;

    private Map<String, String> getTransDict(Map<String, Object> srcDic, Map<String, String> valueDic) {
        Map filterObject = (Map)srcDic.get("filter");
        HashMap<String, String> result = new HashMap<String, String>();
        filterObject.forEach((k, v) -> {
            if (valueDic.containsKey(v)) {
                result.put((String)k, (String)valueDic.get(v));
            } else {
                result.put((String)k, v.toString());
            }
        });
        return result;
    }

    public List<Map.Entry> sortMap(Map map) {
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry o1, Map.Entry o2) {
                return Double.valueOf(o1.getKey().toString()).compareTo(Double.valueOf(o2.getKey().toString()));
            }
        });
        return list;
    }

    public void exportExcel(OutputStream outputStream, String modelName, Map<String, Object> params) {
        List<ExcelTemplate> templates = this.getTemplates();
        ExcelTemplate excelTemplate = templates.stream().filter(f -> f.getName().equals(modelName)).findFirst().orElse(null);
        if (excelTemplate == null) {
            throw new RuntimeException("\u6ca1\u6709\u5728\u5b57\u5178\u3010ExcelTemplate_DIC\u3011\u914d\u7f6e\u6a21\u677f\uff1a" + modelName);
        }
        List statResult = null;
        ExcelWriter excelWriter = ExcelUtil.getWriter((File)this.getTemplateFile(modelName));
        statResult = excelTemplate.getServiceType().equals("\u7edf\u8ba1") ? this.statService.analysis(params, excelTemplate.getServiceName()) : this.queryService.analysis(params, excelTemplate.getServiceName());
        this.replaceDynamicsParams(excelWriter, params);
        if (statResult != null && statResult.size() != 0) {
            int startRow = excelTemplate.getStartRow() - 1;
            int endRow = startRow + statResult.size();
            int startCol = excelTemplate.getStartCol() - 1;
            int endCol = startCol + ((Map)statResult.get(0)).size();
            for (int row = startRow; row < endRow; ++row) {
                List<Map.Entry> sortMap = this.sortMap((Map)statResult.get(row - startRow));
                for (int col = startCol; col < endCol; ++col) {
                    Object value = sortMap.get(col - startCol).getValue();
                    excelWriter.writeCellValue(col, row, value);
                }
            }
        }
        excelWriter.flush(outputStream, true);
    }

    private void replaceDynamicsParams(ExcelWriter excelWriter, Map<String, Object> params) {
        Map<String, String> tranParam = this.getTransDict(params, this.getTransDict());
        for (int i = 0; i < excelWriter.getRowCount(); ++i) {
            for (int j = 0; j < 100; ++j) {
                String value;
                Cell cell = excelWriter.getCell(j, i);
                if (cell == null || (value = cell.toString()) == null) continue;
                boolean replaced = false;
                for (Map.Entry<String, String> kv : tranParam.entrySet()) {
                    if (!value.contains(String.format("{%s}", kv.getKey()))) continue;
                    value = value.replace(String.format("{%s}", kv.getKey()), kv.getValue());
                    replaced = true;
                }
                if (!replaced) continue;
                excelWriter.writeCellValue(j, i, (Object)value);
            }
        }
    }

    private File getTemplateFile(String templateName) {
        try {
            String targetPath = Paths.get(this.excelTempltePath, templateName + ".xlsx").toFile().getAbsolutePath();
            File targetFile = new File(targetPath);
            if (!targetFile.exists()) {
                Resource resource = new PathMatchingResourcePatternResolver().getResource("data/template/" + templateName + ".xlsx");
                if (!resource.exists()) {
                    throw new RuntimeException("Excel\u3010" + templateName + "\u3011\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
                }
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                IOUtils.copy((InputStream)resource.getInputStream(), (File)targetFile);
            }
            return targetFile;
        }
        catch (Exception exception) {
            throw new RuntimeException("Excel\u3010" + templateName + "\u3011\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
        }
    }

    private List<ExcelTemplate> getTemplates() {
        ArrayList<ExcelTemplate> templates = new ArrayList<ExcelTemplate>();
        DmDictValueDTO dictionaryTree = this.dictionaryService.getDictionaryTree(ExcelTemplate_DIC);
        if (dictionaryTree == null) {
            throw new RuntimeException("\u6ca1\u6709\u914d\u7f6e\u5b57\u5178\uff1aExcelTemplate_DIC");
        }
        for (DmDictValueDTO valueDTO1 : dictionaryTree.getChildren()) {
            ExcelTemplate excelTemplate = new ExcelTemplate();
            excelTemplate.setName(valueDTO1.getCode());
            for (DmDictValueDTO valueDTO2 : valueDTO1.getChildren()) {
                if (valueDTO2.getName().equals("\u8d77\u59cb\u884c")) {
                    excelTemplate.setStartRow(Integer.parseInt(valueDTO2.getCode()));
                }
                if (valueDTO2.getName().equals("\u8d77\u59cb\u5217")) {
                    excelTemplate.setStartCol(Integer.parseInt(valueDTO2.getCode()));
                }
                if (valueDTO2.getName().equals("\u670d\u52a1\u540d\u79f0")) {
                    excelTemplate.setServiceName(valueDTO2.getCode());
                }
                if (!valueDTO2.getName().equals("\u670d\u52a1\u7c7b\u578b")) continue;
                excelTemplate.setServiceType(valueDTO2.getCode());
            }
            templates.add(excelTemplate);
        }
        return templates;
    }

    private Map<String, String> getTransDict() {
        HashMap<String, String> dic = new HashMap<String, String>();
        dic.put("SD", "\u4e09\u8c03");
        dic.put("ED", "\u4e8c\u8c03");
        dic.put("SDTKJ", "\u4e09\u8c03\u540c\u53e3\u5f84");
        DmDictValueDTO dictionaryTree = this.dictionaryService.getDictionaryTree(ExcelTemplate_DIC);
        if (dictionaryTree == null) {
            return dic;
        }
        DmDictValueDTO dictionaryTran = dictionaryTree.getChildren().stream().filter(f -> f.getName().equals(Translate_DIC) || f.getCode().equals(Translate_DIC)).findFirst().orElse(null);
        if (dictionaryTran == null) {
            return dic;
        }
        for (DmDictValueDTO valueDTO1 : dictionaryTran.getChildren()) {
            dic.put(valueDTO1.getName(), valueDTO1.getCode());
            dic.put(valueDTO1.getCode(), valueDTO1.getName());
        }
        return dic;
    }

    private static class ExcelTemplate {
        private String Name;
        private int startRow;
        private int startCol;
        private String serviceName;
        private String serviceType = "\u67e5\u8be2";

        public String getName() {
            return this.Name;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getStartCol() {
            return this.startCol;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public void setName(String Name) {
            this.Name = Name;
        }

        public void setStartRow(int startRow) {
            this.startRow = startRow;
        }

        public void setStartCol(int startCol) {
            this.startCol = startCol;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExcelTemplate)) {
                return false;
            }
            ExcelTemplate other = (ExcelTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartRow() != other.getStartRow()) {
                return false;
            }
            if (this.getStartCol() != other.getStartCol()) {
                return false;
            }
            String this$Name = this.getName();
            String other$Name = other.getName();
            if (this$Name == null ? other$Name != null : !this$Name.equals(other$Name)) {
                return false;
            }
            String this$serviceName = this.getServiceName();
            String other$serviceName = other.getServiceName();
            if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
                return false;
            }
            String this$serviceType = this.getServiceType();
            String other$serviceType = other.getServiceType();
            return !(this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExcelTemplate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartRow();
            result = result * 59 + this.getStartCol();
            String $Name = this.getName();
            result = result * 59 + ($Name == null ? 43 : $Name.hashCode());
            String $serviceName = this.getServiceName();
            result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
            String $serviceType = this.getServiceType();
            result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
            return result;
        }

        public String toString() {
            return "ExcelTemplateService.ExcelTemplate(Name=" + this.getName() + ", startRow=" + this.getStartRow() + ", startCol=" + this.getStartCol() + ", serviceName=" + this.getServiceName() + ", serviceType=" + this.getServiceType() + ")";
        }
    }
}

