/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.zncx.service.imp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.ns.onemap.zncx.entity.TbZNCX;
import com.geoway.ns.onemap.zncx.entity.TbZNCXTable;
import com.geoway.ns.onemap.zncx.entity.TbZNCXTableField;
import com.geoway.ns.onemap.zncx.mapper.TbZNCXTableMapper;
import com.geoway.ns.onemap.zncx.service.TbZNCXTableFieldService;
import com.geoway.ns.onemap.zncx.service.TbZNCXTableService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbZNCXTableServiceImpl
extends ServiceImpl<TbZNCXTableMapper, TbZNCXTable>
implements TbZNCXTableService {
    @Autowired
    private TbZNCXTableMapper TbZNCXTableMapper;
    @Autowired
    private TbZNCXTableFieldService TbZNCXTableFieldService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;

    @Override
    public List<TbZNCXTable> selectByZNCX(Long ZNCXId) {
        List ZNCXTables = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZNCXTable.class).eq(TbZNCXTable::getZncxId, (Object)ZNCXId)).orderByAsc(TbZNCXTable::getOrder));
        this.queryNodesDetail(ZNCXTables);
        return ZNCXTables;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbZNCXTable addOrUpdate(TbZNCXTable TbZNCXTable2) {
        ArrayList<TbZNCXTable> list = new ArrayList<TbZNCXTable>();
        list.add(TbZNCXTable2);
        this.addOrUpdateList(list);
        return TbZNCXTable2;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addOrUpdateList(Collection<TbZNCXTable> collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        List list = (List)collection;
        Long ZNCXId = ((TbZNCXTable)list.get(0)).getZncxId();
        Integer order = this.TbZNCXTableMapper.selectMaxOrder(ZNCXId);
        order = order == null ? 1 : order + 1;
        for (TbZNCXTable TbZNCXTable2 : collection) {
            if (TbZNCXTable2.getZncxId() == null || TbZNCXTable2.getZncxId().equals(-1)) {
                throw new RuntimeException("ZncxId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (TbZNCXTable2.getNodeId() == null || TbZNCXTable2.getNodeId().equals("-1")) {
                throw new RuntimeException("nodeId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.queryNodeDetail(TbZNCXTable2);
            if (TbZNCXTable2.getResCatalogNodeDTO() == null) {
                throw new RuntimeException("\u67e5\u8be2\u76ee\u5f55\u8282\u70b9\u5931\u8d25");
            }
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)TbZNCXTable2.getResCatalogNodeDTO();
            if (resCatalogDataNodeDTO == null || resCatalogDataNodeDTO.getDataset() == null || resCatalogDataNodeDTO.getDataset().getType().intValue() != DatasetTypeEnum.FeatureClass.getValue()) {
                throw new RuntimeException("\u6240\u9009\u6570\u636e\u96c6\u4e0d\u662f\u5408\u6cd5\u7684\u7a7a\u95f4\u56fe\u5c42");
            }
            if (TbZNCXTable2.getId() == null || TbZNCXTable2.getId().equals(-1)) {
                Integer n = order;
                Integer n2 = order = Integer.valueOf(order + 1);
                TbZNCXTable2.setOrder(n);
                this.save(TbZNCXTable2);
            } else {
                this.updateById(TbZNCXTable2);
            }
            if (TbZNCXTable2.getDisplayFields() != null && TbZNCXTable2.getDisplayFields().size() > 0) {
                TbZNCXTable2.getDisplayFields().forEach(p -> p.setType(2));
                this.TbZNCXTableFieldService.batchSaveOrUpdate(TbZNCXTable2.getId(), 2, TbZNCXTable2.getDisplayFields());
            }
            if (TbZNCXTable2.getQueryFields() != null && TbZNCXTable2.getQueryFields().size() > 0) {
                TbZNCXTable2.getQueryFields().forEach(p -> p.setType(1));
                this.TbZNCXTableFieldService.batchSaveOrUpdate(TbZNCXTable2.getId(), 1, TbZNCXTable2.getQueryFields());
            }
            if (TbZNCXTable2.getKeyFields() == null || TbZNCXTable2.getKeyFields().size() <= 0) continue;
            TbZNCXTable2.getKeyFields().forEach(p -> p.setType(0));
            this.TbZNCXTableFieldService.batchSaveOrUpdate(TbZNCXTable2.getId(), 0, TbZNCXTable2.getKeyFields());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        TbZNCXTable TbZNCXTable2 = (TbZNCXTable)this.TbZNCXTableMapper.selectById(id);
        boolean res = this.removeById(id);
        if (!res) {
            return false;
        }
        this.TbZNCXTableFieldService.deleteByTableId(TbZNCXTable2.getId());
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            Long id = Long.valueOf(idArr[i]);
            this.deleteById(id);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByZNCX(TbZNCX tbZNCX) {
        List<TbZNCXTable> TbZNCXTables = this.selectByZNCX(tbZNCX.getId());
        boolean res = this.remove((Wrapper)Wrappers.lambdaQuery(TbZNCXTable.class).eq(TbZNCXTable::getZncxId, (Object)tbZNCX.getId()));
        if (!res) {
            return false;
        }
        for (TbZNCXTable item : TbZNCXTables) {
            this.TbZNCXTableFieldService.deleteByTableId(item.getId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<TbZNCXTable> syncTables(Long ZNCXId) {
        List<TbZNCXTable> ZNCXTables = this.selectByZNCX(ZNCXId);
        this.queryNodesDetail(ZNCXTables);
        ZNCXTables.forEach(p -> {
            p.setKeyFields(this.TbZNCXTableFieldService.queryByTableIdandFieldType(p.getId(), 0));
            if (p.getKeyFields().size() > 0) {
                p.setDisplayConfigStatus(1);
            }
            p.setQueryFields(this.TbZNCXTableFieldService.queryByTableIdandFieldType(p.getId(), 1));
            List<TbZNCXTableField> tbZNCXTableFields = this.TbZNCXTableFieldService.queryByTableIdandFieldType(p.getId(), 2);
            if (tbZNCXTableFields.size() > 0) {
                p.setDisplayFields(tbZNCXTableFields);
            }
        });
        return ZNCXTables;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbZNCXTable curTable = (TbZNCXTable)this.getById(id);
        if (curTable == null) {
            return false;
        }
        TbZNCXTable maxTable = (TbZNCXTable)this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZNCXTable.class).eq(TbZNCXTable::getZncxId, (Object)curTable.getZncxId())).orderByDesc(TbZNCXTable::getOrder)).get(0);
        return this.sort(id, maxTable.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbZNCXTable cur = (TbZNCXTable)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbZNCXTable cur = (TbZNCXTable)this.getById(id);
        if (cur == null) {
            return false;
        }
        int maxOrder = this.TbZNCXTableMapper.selectMaxOrder(cur.getZncxId());
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, int order) {
        TbZNCXTable curTable = (TbZNCXTable)this.getById(id);
        if (curTable == null) {
            return true;
        }
        if (curTable.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curTable.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZNCXTable.class).eq(TbZNCXTable::getZncxId, (Object)curTable.getZncxId())).ge(TbZNCXTable::getOrder, (Object)order)).lt(TbZNCXTable::getOrder, (Object)curTable.getOrder())).orderByAsc(TbZNCXTable::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZNCXTable)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZNCXTable.class).eq(TbZNCXTable::getZncxId, (Object)curTable.getZncxId())).gt(TbZNCXTable::getOrder, (Object)curTable.getOrder())).le(TbZNCXTable::getOrder, (Object)order)).orderByAsc(TbZNCXTable::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZNCXTable)needUpdateList.get(i)).setOrder(curTable.getOrder() + i);
            }
        }
        curTable.setOrder(order);
        needUpdateList.add(curTable);
        return this.updateBatchById(needUpdateList);
    }

    private void queryNodesDetail(List<TbZNCXTable> zncxTables) {
        if (zncxTables == null) {
            return;
        }
        for (TbZNCXTable zncxTable : zncxTables) {
            this.queryNodeDetail(zncxTable);
        }
    }

    private void queryNodeDetail(TbZNCXTable zncxTable) {
        ResCatalogNodeDTO resCatalogNodeDTO = null;
        if (zncxTable.getResCatalogNodeDTO() == null) {
            try {
                resCatalogNodeDTO = this.resCatalogService.getNodeDetail(zncxTable.getNodeId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            resCatalogNodeDTO = zncxTable.getResCatalogNodeDTO();
        }
        if (resCatalogNodeDTO == null) {
            return;
        }
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        zncxTable.setResCatalogNodeDTO(resCatalogNodeDTO);
        zncxTable.setNodeName(resCatalogDataNodeDTO.getNodeName());
        zncxTable.setNodePhase(((ResCatalogDataNodeDTO)resCatalogNodeDTO).getNodePhase());
        DatasetDTO dataset = resCatalogDataNodeDTO.getDataset();
        ArrayList<TbZNCXTableField> displayFields = new ArrayList<TbZNCXTableField>();
        ((FeatureClassDTO)dataset).getFields().forEach(p -> {
            TbZNCXTableField tbZNCXTableField = new TbZNCXTableField();
            tbZNCXTableField.setTableId(zncxTable.getId());
            tbZNCXTableField.setName(p.getName());
            tbZNCXTableField.setAlias(p.getAliasName());
            tbZNCXTableField.setType(2);
            displayFields.add(tbZNCXTableField);
        });
        zncxTable.setDisplayFields(displayFields);
        String datasourceStr = dataset.getDataSource().getName() + ">" + dataset.getName() + "\uff08" + dataset.getAliasName() + "\uff09";
        zncxTable.setDataSource(datasourceStr);
    }
}

