/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.ztfx.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXField;
import com.geoway.ns.geoserver3.service.IDatabaseService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.onemap.service.AppCatalogNodeURLEncodeWrapper;
import com.geoway.ns.onemap.ztfx.dto.VersionTableMapping;
import com.geoway.ns.onemap.ztfx.dto.ZTFXGraphAndFields;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXCatalog;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXField;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXGraph;
import com.geoway.ns.onemap.ztfx.mapper.TbZTFXCatalogMapper;
import com.geoway.ns.onemap.ztfx.service.TbZTFXCatalogService;
import com.geoway.ns.onemap.ztfx.service.TbZTFXFieldService;
import com.geoway.ns.onemap.ztfx.service.TbZTFXGraphService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbZTFXCatalogServiceImpl
extends ServiceImpl<TbZTFXCatalogMapper, TbZTFXCatalog>
implements TbZTFXCatalogService {
    @Value(value="${proxy.onemap.enable:false}")
    public Boolean proxyEnable;
    @Autowired
    private IYZFXService yzfxService;
    @Autowired
    private IDatabaseService databaseService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private TbZTFXCatalogMapper ztfxCatalogMapper;
    @Autowired
    private TbZTFXGraphService ztfxGraphService;
    @Autowired
    private TbZTFXFieldService ztfxFieldService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;
    @Autowired
    private AppCatalogNodeURLEncodeWrapper appCatalogNodeURLEncodeWrapper;
    @Value(value="${geoserver.custom-analysis:true}")
    private Boolean customAnalysis;

    @Override
    public boolean saveOrUpdateInfo(TbZTFXCatalog ztfxCatalog) {
        if (StringUtils.isBlank((CharSequence)ztfxCatalog.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ztfxCatalog.getSchemeId())) {
            throw new RuntimeException("\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ztfxCatalog.getPId())) {
            ztfxCatalog.setPId("-1");
        }
        if (ztfxCatalog.getType().equals(2) && (ztfxCatalog.getVersionTableMappings() == null || ztfxCatalog.getVersionTableMappings().size() == 0)) {
            throw new RuntimeException("\u5206\u6790\u9879\u8282\u70b9\u7684\u5206\u6790\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TbZTFXCatalog exist = (TbZTFXCatalog)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getName, (Object)ztfxCatalog.getName())).eq(TbZTFXCatalog::getSchemeId, (Object)ztfxCatalog.getSchemeId()));
        if (StringUtils.isEmpty((CharSequence)ztfxCatalog.getId())) {
            Integer order;
            if (ztfxCatalog.getType().equals(1)) {
                if (exist != null && exist.getPId().equals(ztfxCatalog.getPId())) {
                    throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
                }
            } else if (ztfxCatalog.getType().equals(2) && exist != null) {
                throw new RuntimeException("\u5b58\u5728\u540c\u540d\u5206\u6790\u9879");
            }
            order = (order = this.ztfxCatalogMapper.selectMaxOrder(ztfxCatalog.getSchemeId(), ztfxCatalog.getPId())) == null ? 1 : order + 1;
            ztfxCatalog.setOrder(order);
            if (StringUtils.isNotEmpty((CharSequence)ztfxCatalog.getServiceType()) && ztfxCatalog.getServiceType().equalsIgnoreCase("geoserver")) {
                ztfxCatalog.setVersionTableMapping(JSON.toJSONString(ztfxCatalog.getVersionTableMappings()));
            } else if (this.customAnalysis.booleanValue()) {
                ztfxCatalog.setServiceId("custom-datasource");
                ztfxCatalog.setServiceName("\u538b\u5360\u5206\u6790\u81ea\u5b9a\u4e49\u6570\u636e\u6e90");
                ztfxCatalog.setVersionTableMapping(JSON.toJSONString(ztfxCatalog.getVersionTableMappings()));
            } else if (StringUtils.isEmpty((CharSequence)ztfxCatalog.getUrl())) {
                this.addOrUpdateYZFXService(ztfxCatalog);
            }
            try {
                return this.save(ztfxCatalog);
            }
            catch (Exception e) {
                if (!(StringUtils.isNotEmpty((CharSequence)ztfxCatalog.getServiceType()) && ztfxCatalog.getServiceType().equalsIgnoreCase("geoserver") || this.customAnalysis.booleanValue() || !StringUtils.isEmpty((CharSequence)ztfxCatalog.getUrl()))) {
                    this.yzfxService.delete(ztfxCatalog.getServiceId());
                }
                throw e;
            }
        }
        if (ztfxCatalog.getType().equals(1)) {
            if (exist != null && exist.getPId().equals(ztfxCatalog.getPId()) && !exist.getId().equals(ztfxCatalog.getId())) {
                throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
            }
        } else if (ztfxCatalog.getType().equals(2) && exist != null && !exist.getId().equals(ztfxCatalog.getId())) {
            throw new RuntimeException("\u5b58\u5728\u540c\u540d\u5206\u6790\u9879");
        }
        if (StringUtils.isNotEmpty((CharSequence)ztfxCatalog.getServiceType()) && ztfxCatalog.getServiceType().equalsIgnoreCase("geoserver")) {
            ztfxCatalog.setVersionTableMapping(JSON.toJSONString(ztfxCatalog.getVersionTableMappings()));
        } else if (this.customAnalysis.booleanValue()) {
            ztfxCatalog.setVersionTableMapping(JSON.toJSONString(ztfxCatalog.getVersionTableMappings()));
        } else if (StringUtils.isEmpty((CharSequence)ztfxCatalog.getUrl())) {
            this.addOrUpdateYZFXService(ztfxCatalog);
        }
        return this.updateById(ztfxCatalog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbZTFXCatalog queryDetail(String id, boolean syncCatalogInfo) {
        TbZTFXCatalog tbZTFXCatalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (tbZTFXCatalog == null || StringUtils.isEmpty((CharSequence)tbZTFXCatalog.getVersionTableMapping())) {
            return null;
        }
        tbZTFXCatalog.setVersionTableMappings(VersionTableMapping.listFromJSON(tbZTFXCatalog.getVersionTableMapping()));
        if (StringUtils.isEmpty((CharSequence)tbZTFXCatalog.getUrl()) && !this.customAnalysis.booleanValue() && syncCatalogInfo) {
            for (VersionTableMapping versionTableMapping : tbZTFXCatalog.getVersionTableMappings()) {
                ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(versionTableMapping.getNodeId());
                if (resCatalogNodeDTO == null) {
                    throw new RuntimeException("\u8282\u70b9\u5df2\u88ab\u5220\u9664");
                }
                versionTableMapping.setNodeName(resCatalogNodeDTO.getNodeName());
            }
            this.addOrUpdateYZFXService(tbZTFXCatalog);
            this.updateById(tbZTFXCatalog);
        }
        return tbZTFXCatalog;
    }

    @Override
    public List<TbZTFXCatalog> queryTree(String schemeId, String name) {
        List list = null;
        if (StringUtils.isBlank((CharSequence)name)) {
            list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)schemeId)).orderByAsc(TbZTFXCatalog::getOrder));
        } else {
            list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)schemeId)).like(TbZTFXCatalog::getName, (Object)name)).orderByAsc(TbZTFXCatalog::getOrder));
            ArrayList<TbZTFXCatalog> parents = new ArrayList<TbZTFXCatalog>();
            for (TbZTFXCatalog catalog : list) {
                this.queryParentLoop(parents, catalog.getPId());
            }
            for (TbZTFXCatalog parent : parents) {
                if (list.stream().anyMatch(p -> p.getId().equals(parent.getId()))) continue;
                list.add(parent);
            }
        }
        this.queryDisplayConfigStatus(list);
        return this.constructTree(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        TbZTFXCatalog catalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        return this.deleteCatalogLoop(catalog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        String[] idsArray;
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        for (String id : idsArray = ids.split(",")) {
            TbZTFXCatalog catalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
            if (catalog == null) continue;
            this.deleteCatalogLoop(catalog);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBySchemeId(String schemeId) {
        List list = this.list((Wrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)schemeId));
        if (list != null && list.size() > 0) {
            for (TbZTFXCatalog catalog : list) {
                this.deleteRelates(catalog);
            }
        }
        return this.remove((Wrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)schemeId));
    }

    @Override
    public boolean displayConfig(ZTFXGraphAndFields graphAndFields) {
        if (graphAndFields == null) {
            return false;
        }
        String catalogId = graphAndFields.getCatalogId();
        if (StringUtils.isBlank((CharSequence)catalogId)) {
            throw new RuntimeException("\u5206\u6790\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (graphAndFields.getGraph() != null) {
            graphAndFields.getGraph().setCatalogId(catalogId);
            this.ztfxGraphService.deleteByCatalogId(catalogId);
            this.ztfxGraphService.saveOrUpdateInfo(graphAndFields.getGraph());
        }
        this.ztfxFieldService.deleteByCatalogId(catalogId);
        this.ztfxFieldService.batchSaveOrUpdate(catalogId, graphAndFields.getFields());
        return true;
    }

    @Override
    public ZTFXGraphAndFields queryDisplayConfig(String id) {
        ZTFXGraphAndFields graphAndFields = new ZTFXGraphAndFields();
        graphAndFields.setCatalogId(id);
        TbZTFXGraph graph = this.ztfxGraphService.queryByCatalogId(id);
        graphAndFields.setGraph(graph);
        List<TbZTFXField> fields = this.ztfxFieldService.queryByCatalogId(id);
        Collections.sort(fields);
        graphAndFields.setFields(fields);
        return graphAndFields;
    }

    @Override
    public boolean moveToFirst(String id) {
        return this.sort(id, 1);
    }

    @Override
    public boolean moveToLast(String id) {
        TbZTFXCatalog curCatalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        TbZTFXCatalog maxCatalog = (TbZTFXCatalog)this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(TbZTFXCatalog::getPId, (Object)curCatalog.getPId())).orderByDesc(TbZTFXCatalog::getOrder)).get(0);
        return this.sort(id, maxCatalog.getOrder());
    }

    @Override
    public boolean moveToPre(String id) {
        TbZTFXCatalog curCatalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        if (curCatalog.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, curCatalog.getOrder() - 1);
    }

    @Override
    public boolean moveToNext(String id) {
        TbZTFXCatalog curCatalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        int maxOrder = this.ztfxCatalogMapper.selectMaxOrder(curCatalog.getSchemeId(), curCatalog.getPId());
        if (curCatalog.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, curCatalog.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(String id, int order) {
        TbZTFXCatalog curCatalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return true;
        }
        if (curCatalog.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curCatalog.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(TbZTFXCatalog::getPId, (Object)curCatalog.getPId())).ge(TbZTFXCatalog::getOrder, (Object)order)).lt(TbZTFXCatalog::getOrder, (Object)curCatalog.getOrder())).orderByAsc(TbZTFXCatalog::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZTFXCatalog)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(TbZTFXCatalog::getPId, (Object)curCatalog.getPId())).gt(TbZTFXCatalog::getOrder, (Object)curCatalog.getOrder())).le(TbZTFXCatalog::getOrder, (Object)order)).orderByAsc(TbZTFXCatalog::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZTFXCatalog)needUpdateList.get(i)).setOrder(curCatalog.getOrder() + i);
            }
        }
        curCatalog.setOrder(order);
        needUpdateList.add(curCatalog);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public ServiceMetadataDAO metadata(String id) {
        TbZTFXCatalog catalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (!catalog.getType().equals(2)) {
            throw new RuntimeException("\u975e\u5206\u6790\u9879\u8282\u70b9\u4e0d\u5b58\u5728\u670d\u52a1\u5143\u6570\u636e\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)catalog.getUrl()) && "geoserver".equalsIgnoreCase(catalog.getServiceType())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)catalog.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)catalog.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            return this.yzfxService.metadata(catalog.getUrl(), applicationGuid, accessKey);
        }
        if (this.customAnalysis.booleanValue()) {
            catalog.setVersionTableMappings(VersionTableMapping.listFromJSON(catalog.getVersionTableMapping()));
            if (catalog.getVersionTableMappings() == null || catalog.getVersionTableMappings().size() == 0) {
                throw new RuntimeException("\u672a\u5173\u8054\u5206\u6790\u6570\u636e");
            }
            VersionTableMapping curVersion = catalog.getVersionTableMappings().get(0);
            ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
            if (resCatalogDataNodeDTO == null) {
                throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
            String dataUrl = "geoserver:" + featureDatasetDTO.getDsKey() + "/" + featureDatasetDTO.getFullName().replace(".", "/");
            HashMap<String, Object> customAnalysisItem = new HashMap<String, Object>();
            JSONArray analysisDatas = new JSONArray();
            JSONObject analysisData = new JSONObject();
            analysisData.put("dataType", (Object)"default");
            analysisData.put("fields", null);
            analysisData.put("whereClause", null);
            analysisData.put("dataUrl", (Object)dataUrl);
            analysisDatas.add((Object)analysisData);
            customAnalysisItem.put("analysisDatas", analysisDatas);
            customAnalysisItem.put("analysisAlgorithm", null);
            customAnalysisItem.put("analysisItemName", resCatalogDataNodeDTO.getNodeId());
            return this.yzfxService.getAlgorithmFieldsMeta(customAnalysisItem);
        }
        if (StringUtils.isBlank((CharSequence)catalog.getServiceId())) {
            throw new RuntimeException("\u5206\u6790\u9879\u8282\u70b9\u5bf9\u5e94\u7684\u538b\u5360\u5206\u6790\u670d\u52a1ID\u4e3a\u7a7a");
        }
        TbAnalysisYZFXDetail yzfxDetail = this.yzfxService.findById(catalog.getServiceId());
        return this.yzfxService.metadata(yzfxDetail.getName());
    }

    @Override
    public Object findCustoms() {
        return this.yzfxService.findCustoms();
    }

    @Override
    public DatasetRenderDTO queryRender(String id, String year) {
        TbZTFXCatalog curCatalog = (TbZTFXCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return null;
        }
        curCatalog.setVersionTableMappings(VersionTableMapping.listFromJSON(curCatalog.getVersionTableMapping()));
        if (curCatalog.getVersionTableMappings() == null || curCatalog.getVersionTableMappings().size() == 0) {
            return null;
        }
        VersionTableMapping curVersion = VersionTableMapping.findByYear(curCatalog.getVersionTableMappings(), year);
        if (curVersion == null) {
            return null;
        }
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        DatasetRenderDTO render = resCatalogDataNodeDTO.getRender();
        if (this.proxyEnable.booleanValue()) {
            try {
                this.appCatalogNodeURLEncodeWrapper.urlManage(render);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return render;
    }

    private void queryDisplayConfigStatus(List<TbZTFXCatalog> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        List<String> catlogIds = list.stream().filter(p -> p.getType().equals(2)).map(p -> p.getId()).collect(Collectors.toList());
        List<TbZTFXGraph> lstGraphs = this.ztfxGraphService.queryByCatalogIds(catlogIds);
        for (TbZTFXCatalog catalog : list) {
            Optional<TbZTFXGraph> optionalGraph = lstGraphs.stream().filter(p -> p.getCatalogId().equals(catalog.getId())).findFirst();
            if (optionalGraph == null || !optionalGraph.isPresent()) continue;
            catalog.setDisplayConfigStatus(1);
        }
    }

    private List<TbZTFXCatalog> constructTree(List<TbZTFXCatalog> list) {
        ArrayList<TbZTFXCatalog> roots = new ArrayList<TbZTFXCatalog>();
        for (TbZTFXCatalog catalog : list) {
            if (!StringUtils.isEmpty((CharSequence)catalog.getVersionTableMapping())) {
                catalog.setVersionTableMappings(VersionTableMapping.listFromJSON(catalog.getVersionTableMapping()));
            }
            List<TbZTFXCatalog> children = list.stream().filter(p -> p.getPId().equals(catalog.getId())).collect(Collectors.toList());
            catalog.setChildren(children);
            if (!"-1".equals(catalog.getPId())) continue;
            roots.add(catalog);
        }
        return roots;
    }

    private void queryParentLoop(List<TbZTFXCatalog> parents, String pId) {
        if ("-1".equals(pId)) {
            return;
        }
        TbZTFXCatalog parent = (TbZTFXCatalog)this.getById((Serializable)((Object)pId));
        if (parent == null) {
            return;
        }
        parents.add(parent);
        this.queryParentLoop(parents, parent.getPId());
    }

    private boolean deleteCatalogLoop(TbZTFXCatalog catalog) {
        List children = this.list((Wrapper)Wrappers.lambdaQuery(TbZTFXCatalog.class).eq(TbZTFXCatalog::getPId, (Object)catalog.getId()));
        if (children != null && children.size() > 0) {
            for (TbZTFXCatalog child : children) {
                this.deleteCatalogLoop(child);
            }
        }
        this.deleteRelates(catalog);
        return this.removeById((Serializable)((Object)catalog.getId()));
    }

    private boolean deleteRelates(TbZTFXCatalog catalog) {
        if (catalog.getType().equals(2)) {
            this.ztfxGraphService.deleteByCatalogId(catalog.getId());
            this.ztfxFieldService.deleteByCatalogId(catalog.getId());
            if (!StringUtils.isBlank((CharSequence)catalog.getServiceId())) {
                try {
                    if (StringUtils.isEmpty((CharSequence)catalog.getUrl()) && !this.customAnalysis.booleanValue()) {
                        this.yzfxService.delete(catalog.getServiceId());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private void addOrUpdateYZFXService(TbZTFXCatalog tbZTFXCatalog) {
        if (tbZTFXCatalog.getVersionTableMappings() == null || tbZTFXCatalog.getVersionTableMappings().size() == 0) {
            tbZTFXCatalog.setVersionTableMapping(null);
            return;
        }
        int versionSize = tbZTFXCatalog.getVersionTableMappings().size();
        VersionTableMapping curTableMapping = tbZTFXCatalog.getVersionTableMappings().get(versionSize - 1);
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curTableMapping.getNodeId());
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        if (resCatalogDataNodeDTO == null) {
            return;
        }
        FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
        if (!this.databaseService.addDatabase(featureDatasetDTO.getDsKey())) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
        }
        TbAnalysisYZFXDetail yzfxDetail = null;
        if (!StringUtils.isEmpty((CharSequence)tbZTFXCatalog.getServiceId())) {
            yzfxDetail = this.yzfxService.findById(tbZTFXCatalog.getServiceId());
        }
        if (yzfxDetail == null) {
            yzfxDetail = new TbAnalysisYZFXDetail();
            String serviceName = "ONEMAP_ztfx_" + tbZTFXCatalog.getName() + "_" + featureDatasetDTO.getName();
            String serviceAlias = "\u4e00\u5f20\u56fe-\u4e13\u9898\u5206\u6790-" + tbZTFXCatalog.getName() + "-" + featureDatasetDTO.getAliasName();
            serviceName = this.realYZFXServiceName(serviceName);
            yzfxDetail.setName(serviceName);
            yzfxDetail.setAlias(serviceAlias);
        }
        yzfxDetail.setGroup("\u4e00\u5f20\u56fe4.0-\u4e13\u9898\u5206\u6790");
        yzfxDetail.setStatus(Integer.valueOf(1));
        yzfxDetail.setInputParams(new ArrayList());
        yzfxDetail.setCustomServiceClass(tbZTFXCatalog.getCustomServiceClass());
        yzfxDetail.setLayer(featureDatasetDTO.getName());
        yzfxDetail.setLayerAlias(featureDatasetDTO.getAliasName());
        yzfxDetail.setDatasourceKey(featureDatasetDTO.getDsKey());
        yzfxDetail.setPrimaryField(featureDatasetDTO.getOidField());
        yzfxDetail.setShapeField(featureDatasetDTO.getShapeField());
        List<TbAnalysisYZFXField> commonFields = this.getYZFXField(featureDatasetDTO.getFields());
        ArrayList<TbAnalysisYZFXField> lstRemoveFields = new ArrayList<TbAnalysisYZFXField>();
        ArrayList<JSONObject> lstGeoserverMapping = new ArrayList<JSONObject>();
        JSONObject tempGeoserverMapping = null;
        for (int i = 0; i < versionSize - 1; ++i) {
            VersionTableMapping versionTableMapping = tbZTFXCatalog.getVersionTableMappings().get(i);
            if (StringUtils.isEmpty((CharSequence)versionTableMapping.getYear())) {
                throw new RuntimeException("\u6570\u636e\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)versionTableMapping.getDatasetId())) {
                throw new RuntimeException("\u6570\u636e\u96c6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!Objects.equals(versionTableMapping.getDatasetType(), 2)) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u7d20\u7c7b\u8282\u70b9");
            }
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)versionTableMapping.getDatasetId());
            if (!this.databaseService.addDatabase(datasetNameInfo.getDsKey())) {
                throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
            }
            ResCatalogNodeDTO tempCatalogNodeDTO = this.resCatalogService.getNodeDetail(versionTableMapping.getNodeId());
            ResCatalogDataNodeDTO tempCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tempCatalogNodeDTO;
            if (tempCatalogDataNodeDTO == null) {
                return;
            }
            FeatureClassDTO tempFeatureDatasetDTO = (FeatureClassDTO)tempCatalogDataNodeDTO.getDataset();
            if (!this.databaseService.addDatabase(tempFeatureDatasetDTO.getDsKey())) {
                throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
            }
            tempGeoserverMapping = new JSONObject();
            tempGeoserverMapping.put("datasourceKey", (Object)tempFeatureDatasetDTO.getDsKey());
            tempGeoserverMapping.put("version", (Object)versionTableMapping.getYear());
            tempGeoserverMapping.put("tableName", (Object)tempFeatureDatasetDTO.getName());
            lstGeoserverMapping.add(tempGeoserverMapping);
            for (TbAnalysisYZFXField yzfxField : commonFields) {
                Optional<FieldDTO> optionalFieldDTO = tempFeatureDatasetDTO.getFields().stream().filter(p -> p.getName().equalsIgnoreCase(yzfxField.getName())).findFirst();
                if (optionalFieldDTO != null && optionalFieldDTO.isPresent()) continue;
                lstRemoveFields.add(yzfxField);
            }
            commonFields.removeAll(lstRemoveFields);
            lstRemoveFields.clear();
        }
        tempGeoserverMapping = new JSONObject();
        tempGeoserverMapping.put("datasourceKey", (Object)featureDatasetDTO.getDsKey());
        tempGeoserverMapping.put("version", (Object)curTableMapping.getYear());
        tempGeoserverMapping.put("tableName", (Object)featureDatasetDTO.getName());
        lstGeoserverMapping.add(tempGeoserverMapping);
        yzfxDetail.setFields(commonFields);
        yzfxDetail.setVersionTableMapping(JSON.toJSONString(lstGeoserverMapping));
        yzfxDetail = this.yzfxService.save(yzfxDetail);
        tbZTFXCatalog.setVersionTableMapping(JSON.toJSONString(tbZTFXCatalog.getVersionTableMappings()));
        tbZTFXCatalog.setServiceId(yzfxDetail.getId());
        tbZTFXCatalog.setServiceName(yzfxDetail.getName());
    }

    private String realYZFXServiceName(String yzfxServiceName) {
        String realServiceName = yzfxServiceName;
        if (this.yzfxService.checkIsExist(yzfxServiceName)) {
            for (int i = 1; i < Integer.MAX_VALUE && this.yzfxService.checkIsExist(realServiceName = yzfxServiceName + "_" + i); ++i) {
            }
        }
        return realServiceName;
    }

    private List<TbAnalysisYZFXField> getYZFXField(List<FieldDTO> fields) {
        ArrayList<TbAnalysisYZFXField> fieldList = new ArrayList<TbAnalysisYZFXField>();
        TbAnalysisYZFXField tbAnalysisYZFXField = null;
        int order = 1;
        for (FieldDTO field : fields) {
            tbAnalysisYZFXField = new TbAnalysisYZFXField();
            tbAnalysisYZFXField.setName(field.getName());
            tbAnalysisYZFXField.setAlias(field.getAliasName());
            tbAnalysisYZFXField.setReturnName(field.getName().toUpperCase());
            tbAnalysisYZFXField.setType(this.covertType(field.getFieldType()));
            tbAnalysisYZFXField.setOrder(Integer.valueOf(order++));
            fieldList.add(tbAnalysisYZFXField);
        }
        return fieldList;
    }

    private String covertType(int value) {
        FieldType fieldType = FieldType.getByValue((Integer)value);
        switch (fieldType) {
            case Int: {
                return "int4";
            }
            case OID: {
                return "oid";
            }
            case Blob: {
                return "blob";
            }
            case Byte: {
                return "byte";
            }
            case Long: {
                return "long";
            }
            case Text: 
            case String: {
                return "string";
            }
            case Float: {
                return "float";
            }
            case Shape: {
                return "geometry";
            }
            case Short: {
                return "short";
            }
            case Double: {
                return "double";
            }
            case Boolean: {
                return "boolean";
            }
            case Decimal: {
                return "decimal";
            }
            default: {
                return "unknown";
            }
            case DateTime: 
        }
        return "datetime";
    }
}

