-- ----------------------------
--2023年6月18日，oyyh，创建在线分析相关库表
-- ----------------------------

-- ----------------------------
-- 1.创建在线分析方案表tb_onemap4_zxfx_scheme
-- ----------------------------
CREATE TABLE tb_onemap4_zxfx_scheme (
                                        f_id varchar(40) NULL,
                                        f_name varchar(200) NULL,
                                        f_desc text NULL,
                                        f_isdefault int2 NULL DEFAULT 0,
                                        f_order int4 NULL,
                                        CONSTRAINT tb_onemap4_zxfx_scheme_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_onemap4_zxfx_scheme_f_isdefault_idx ON tb_onemap4_zxfx_scheme (f_isdefault,f_order);
COMMENT ON TABLE tb_onemap4_zxfx_scheme IS '在线分析方案表';
COMMENT ON COLUMN tb_onemap4_zxfx_scheme.f_id IS 'id';
COMMENT ON COLUMN tb_onemap4_zxfx_scheme.f_name IS '名称';
COMMENT ON COLUMN tb_onemap4_zxfx_scheme.f_desc IS '描述';
COMMENT ON COLUMN tb_onemap4_zxfx_scheme.f_isdefault IS 'int2';

-- ----------------------------
-- 2.创建在线分析目录表tb_onemap4_zxfx_catalog
-- ----------------------------
CREATE TABLE tb_onemap4_zxfx_catalog (
                                         f_id varchar(40) NULL,
                                         f_pid varchar(40) NULL,
                                         f_scheme_id varchar(40) NULL,
                                         f_name varchar(200) NULL,
                                         f_type int2 NULL,
                                         f_model_id varchar(40) NULL,
                                         f_order int4 NULL,
                                         f_paramset text NULL,
                                         CONSTRAINT tb_onemap4_zxfx_catalog_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_onemap4_zxfx_catalog_f_pid_idx ON tb_onemap4_zxfx_catalog (f_pid,f_scheme_id,f_name,f_order);
COMMENT ON TABLE tb_onemap4_zxfx_catalog IS '在线分析目录表';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_id IS 'id';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_pid IS '父id';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_scheme_id IS '方案ID';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_name IS '名称';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_type IS '类型：1:目录节点，2：算子节点';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_model_id IS '模型ID，当f_type为算子节点时需设置';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_order IS '排序';
COMMENT ON COLUMN tb_onemap4_zxfx_catalog.f_paramset IS '参数设置，目前只支持combo_year_node类型参数设置，格式：{"具体参数名称":{"年份":"资源目录节点ID"}}';

-- ----------------------------
-- 3.创建在线分析算子表tb_onemap4_zxfx_model
-- ----------------------------
CREATE TABLE tb_onemap4_zxfx_model (
                                       f_id varchar(40) NULL,
                                       f_name varchar(200) NULL,
                                       f_group varchar(200) NULL,
                                       f_desc text NULL,
                                       f_type int2 NULL,
                                       f_service_id varchar(40) NULL,
                                       f_order int4 NULL,
                                       CONSTRAINT tb_onemap4_zxfx_model_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_onemap4_zxfx_model_f_name_idx ON tb_onemap4_zxfx_model (f_name,f_group,f_order);
COMMENT ON TABLE tb_onemap4_zxfx_model IS '在线分析算子表';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_id IS 'id';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_name IS '名称';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_group IS '分组';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_desc IS '描述';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_type IS '类型，1:atlas算子，2：geoserver3算子';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_service_id IS '算子服务ID';
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_order IS '排序';

-- ----------------------------
-- 4.在线分析算子参数表tb_onemap4_zxfx_model_param
-- ----------------------------
CREATE TABLE tb_onemap4_zxfx_model_param (
                                             f_id varchar(40) NULL,
                                             f_model_id varchar(40) NULL,
                                             f_name varchar(200) NULL,
                                             f_type varchar(200) NULL,
                                             f_alias varchar(200) NULL,
                                             f_group varchar(200) NULL,
                                             f_desc text NULL,
                                             f_order int4 NULL,
                                             f_enable int2 NULL DEFAULT 1,
                                             f_required int2 NULL DEFAULT 1,
                                             f_defaultvalue text NULL,
                                             f_dickey varchar(50) NULL,
                                             f_source varchar(200) NULL,
                                             f_precondition text NULL,
                                             CONSTRAINT tb_onemap4_zxfx_model_param_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_onemap4_zxfx_model_param_f_model_id_idx ON tb_onemap4_zxfx_model_param (f_model_id,f_name,f_order);
COMMENT ON TABLE tb_onemap4_zxfx_model_param IS '在线分析算子参数表';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_id IS 'id';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_model_id IS '模型id';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_name IS '名称，与底层算子名称一致，不允许修改';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_type IS '类型，区别底层算子类型，参考ModelParamTypeEnum';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_alias IS '别名';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_group IS '分组';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_desc IS '描述';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_order IS '排序';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_enable IS '是否启用';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_required IS '是否必填';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_defaultvalue IS '默认值';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_dickey IS '字典key';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_source IS '来源，当f_type为field、fields、whereclause、output_layertable时需设置';
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_precondition IS '前提条件，只有满足前提条件才会显示UI';