/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.lshs;

import com.geoway.ns.onemap.lshs.dto.LSHSResultDetail;
import com.geoway.ns.onemap.lshs.entity.TbLSHS;
import com.geoway.ns.onemap.lshs.service.TbLSHSService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.ResultResponse;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5386\u53f2\u56de\u6eaf\u65b9\u6848\u7ba1\u7406"})
@Controller
@RequestMapping(value={"/lshs"})
public class TbLSHSController {
    private static final Logger log = LoggerFactory.getLogger(TbLSHSController.class);
    @Autowired
    private TbLSHSService tbLSHSService;
    @Autowired
    protected ITokenService tokenService;

    @RequestMapping(value={"/selectAll"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="1-\u67e5\u8be2\u6240\u6709")
    public DataResponse<List<TbLSHS>> selectAll() {
        return DataResponse.success(this.tbLSHSService.search(null));
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="2-\u6309\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\uff0cname\u4e3a\u7a7a\u5219\u4e3a\u67e5\u8be2\u6240\u6709")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u67e5\u8be2\u5173\u952e\u5b57", dataTypeClass=String.class)})
    public DataResponse<List<TbLSHS>> search(@RequestParam(value="name", required=false) @Nullable String name) {
        return DataResponse.success(this.tbLSHSService.search(name));
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="3-\u4fdd\u5b58\uff08\u65b0\u589e\u548c\u4fee\u6539\u90fd\u7528\u8be5\u63a5\u53e3\uff09")
    public BaseResponse add(TbLSHS tbLSHS) {
        return DataResponse.success((Object)this.tbLSHSService.addOrUpdate(tbLSHS));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="4-\u901a\u8fc7ID\u5220\u9664")
    public BaseResponse delete(@RequestParam(value="id") Long id) {
        boolean res = this.tbLSHSService.deleteById(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/deleteMulti"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="5-\u6279\u91cf\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5217\u8868\uff0c\u591a\u4e2aid\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", required=true, dataTypeClass=String.class)})
    public BaseResponse deleteMulti(@RequestParam(value="ids") String ids) {
        boolean res = this.tbLSHSService.deleteMulti(ids);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToFirst"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="6-\u7f6e\u9876")
    public BaseResponse updateToFirst(@RequestParam(value="id") Long id) {
        boolean res = this.tbLSHSService.updateToFirst(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToLast"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="7-\u7f6e\u5e95")
    public BaseResponse updateToLast(@RequestParam(value="id") Long id) {
        boolean res = this.tbLSHSService.updateToLast(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToPre"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="8-\u4e0a\u79fb")
    public BaseResponse updateToPre(@RequestParam(value="id") Long id) {
        boolean res = this.tbLSHSService.updateToPre(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToSuffix"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u4e0b\u79fb")
    public BaseResponse updateToSuffix(@RequestParam(value="id") Long id) {
        boolean res = this.tbLSHSService.updateToSuffix(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/moveSort"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u62d6\u62fd\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u66f4\u65b0\u5143\u7d20\u7684id", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="targetOrder", value="\u76ee\u6807\u4f4d\u7f6e\u5143\u7d20\u7684\u5e8f\u53f7", required=true, dataTypeClass=Integer.class)})
    public BaseResponse moveSort(@RequestParam(value="id") Long id, @RequestParam(value="targetOrder") Integer targetOrder) {
        boolean res = this.tbLSHSService.sort(id, targetOrder);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/{serviceName}"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="11-\u5386\u53f2\u56de\u6eaf\u5206\u6790")
    public BaseResponse lshs(@RequestBody Map<String, Object> param, @PathVariable String serviceName) {
        List<LSHSResultDetail> res = this.tbLSHSService.analysis(param, serviceName);
        return ResultResponse.success(res);
    }

    @RequestMapping(value={"/selectByToken"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="12-\u67e5\u8be2\u7528\u6237\u5df2\u6388\u6743\u5217\u8868")
    public DataResponse<List<TbLSHS>> selectByToken(HttpServletRequest request) {
        String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
        SysUserDTO sysUser = null;
        try {
            sysUser = this.tokenService.querySysUserByToken(token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return DataResponse.success(this.tbLSHSService.selectByToken(sysUser.getRoles().stream().map(SimpleRole::getId).map(String::valueOf).collect(Collectors.toList()), sysUser.getId()));
    }
}

