/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.glfx.service.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.ns.geoserver3.dto.GLFXResult;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLFXDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.service.IGLFXService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterGLCXQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerBeforeDataQueryEvent;
import com.geoway.ns.onemap.glfx.dto.GLFXGraphAndFields;
import com.geoway.ns.onemap.glfx.dto.GLFXResultDetail;
import com.geoway.ns.onemap.glfx.entity.TbGLFX;
import com.geoway.ns.onemap.glfx.entity.TbGLFXTable;
import com.geoway.ns.onemap.glfx.mapper.TbGLFXMapper;
import com.geoway.ns.onemap.glfx.service.TbGLFXService;
import com.geoway.ns.onemap.glfx.service.TbGLFXTableService;
import com.geoway.ns.sys.enums.SysPowerEnum;
import com.geoway.ns.sys.service.SysPowerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbGLFXServiceImpl
extends ServiceImpl<TbGLFXMapper, TbGLFX>
implements TbGLFXService {
    @Autowired
    private TbGLFXMapper tbGLFXMapper;
    @Autowired
    private TbGLFXTableService tbGLFXTableService;
    @Autowired
    private IGLFXService glfxService;
    @Autowired
    private ITbAnalysisBaseInfoService tbAnalysisBaseInfoService;
    @Autowired
    private IYZFXService iyzfxService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Value(value="${geoserver.custom-analysis:true}")
    private Boolean customAnalysis;
    @Autowired
    private SysPowerService sysPowerService;

    @Override
    public List<TbGLFX> search(String name) {
        List list = null;
        list = StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)name.trim()) ? this.list((Wrapper)Wrappers.lambdaQuery(TbGLFX.class).orderByAsc(TbGLFX::getOrder)) : this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFX.class).like(TbGLFX::getName, (Object)name)).orderByAsc(TbGLFX::getOrder));
        return list;
    }

    @Override
    public List<TbGLFX> selectByToken(List<String> roleids, String userids) {
        List list = null;
        List lshs = this.sysPowerService.selectByToken(SysPowerEnum.GLFX.value, roleids, userids);
        List lhsIds = lshs.stream().map(sysPower -> Long.parseLong(sysPower.getMandateId())).collect(Collectors.toList());
        if (lhsIds == null && lhsIds.size() == 0) {
            return null;
        }
        list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFX.class).in(TbGLFX::getId, lhsIds)).orderByAsc(TbGLFX::getOrder));
        return list;
    }

    @Override
    public TbGLFX selectById(Serializable id) {
        return (TbGLFX)this.getById(id);
    }

    @Override
    public TbGLFX selectByName(String name) {
        return (TbGLFX)this.getOne((Wrapper)Wrappers.lambdaQuery(TbGLFX.class).eq(TbGLFX::getName, (Object)name));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbGLFX addOrUpdate(TbGLFX tbGLFX) {
        if (StringUtils.isEmpty((CharSequence)tbGLFX.getName())) {
            throw new RuntimeException("\u5173\u8054\u5206\u6790\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tbGLFX.getStatus() == null) {
            tbGLFX.setStatus(false);
        }
        if (StringUtils.isEmpty((CharSequence)tbGLFX.getAlias())) {
            tbGLFX.setAlias(tbGLFX.getName());
        }
        TbGLFX exist = this.selectByName(tbGLFX.getName());
        if (tbGLFX.getId() == null || tbGLFX.getId().equals(-1)) {
            if (exist != null) {
                throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u540d");
            }
            Integer order = this.tbGLFXMapper.selectMaxOrder();
            order = order == null ? 1 : order + 1;
            tbGLFX.setOrder(order);
            this.save(tbGLFX);
        } else {
            if (exist != null && !exist.getId().equals(tbGLFX.getId())) {
                throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u540d");
            }
            this.updateById(tbGLFX);
        }
        this.addOrUpdateGLHSService(tbGLFX);
        this.updateById(tbGLFX);
        return tbGLFX;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        TbGLFX glfx = (TbGLFX)this.getById(id);
        if (glfx == null) {
            return false;
        }
        this.removeById(id);
        this.tbGLFXTableService.deleteByGLFX(glfx);
        if (!("geoserver".equalsIgnoreCase(glfx.getServiceType()) && StringUtils.isNotEmpty((CharSequence)glfx.getUrl()) || this.customAnalysis.booleanValue())) {
            this.glfxService.delete(glfx.getServiceId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            Long id = Long.valueOf(idArr[i]);
            this.deleteById(id);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbGLFX curTable = (TbGLFX)this.getById(id);
        if (curTable == null) {
            return false;
        }
        TbGLFX maxTable = (TbGLFX)this.list((Wrapper)Wrappers.lambdaQuery(TbGLFX.class).orderByDesc(TbGLFX::getOrder)).get(0);
        return this.sort(id, maxTable.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbGLFX cur = (TbGLFX)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbGLFX cur = (TbGLFX)this.getById(id);
        if (cur == null) {
            return false;
        }
        int maxOrder = this.tbGLFXMapper.selectMaxOrder();
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, int order) {
        TbGLFX curGLFX = (TbGLFX)this.getById(id);
        if (curGLFX == null) {
            return true;
        }
        if (curGLFX.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curGLFX.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFX.class).ge(TbGLFX::getOrder, (Object)order)).lt(TbGLFX::getOrder, (Object)curGLFX.getOrder())).orderByAsc(TbGLFX::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbGLFX)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFX.class).gt(TbGLFX::getOrder, (Object)curGLFX.getOrder())).le(TbGLFX::getOrder, (Object)order)).orderByAsc(TbGLFX::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbGLFX)needUpdateList.get(i)).setOrder(curGLFX.getOrder() + i);
            }
        }
        curGLFX.setOrder(order);
        needUpdateList.add(curGLFX);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<GLFXResultDetail> analysis(Map<String, Object> param, String serviceName) {
        TbGLFX tbGLFX = this.selectByName(serviceName);
        if (tbGLFX == null) {
            throw new RuntimeException("\u5173\u8054\u5206\u6790\u65b9\u6848\u3010" + serviceName + "\u3011\u4e0d\u5b58\u5728");
        }
        List<TbGLFXTable> listTables = this.tbGLFXTableService.selectByGLFX(tbGLFX.getId(), false, true);
        List results = null;
        if ("geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)tbGLFX.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)tbGLFX.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            results = this.glfxService.analysis(tbGLFX.getUrl(), param, applicationGuid, accessKey);
        } else if (this.customAnalysis.booleanValue()) {
            JSONArray customAnalysisItems = new JSONArray();
            for (int i = 0; i < listTables.size(); ++i) {
                TbGLFXTable tbGLFXTable = listTables.get(i);
                ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tbGLFXTable.getResCatalogNodeDTO();
                if (resCatalogDataNodeDTO == null) {
                    throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
                }
                FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
                String dataUrl = "geoserver:" + featureDatasetDTO.getDsKey() + "/" + featureDatasetDTO.getFullName().replace(".", "/");
                JSONObject customAnalysisItem = new JSONObject();
                JSONArray analysisDatas = new JSONArray();
                JSONObject analysisData = new JSONObject();
                analysisData.put("dataType", (Object)"default");
                analysisData.put("fields", null);
                analysisData.put("whereClause", null);
                analysisData.put("dataUrl", (Object)dataUrl);
                analysisDatas.add((Object)analysisData);
                customAnalysisItem.put("analysisDatas", (Object)analysisDatas);
                customAnalysisItem.put("analysisAlgorithm", null);
                customAnalysisItem.put("analysisItemName", (Object)tbGLFXTable.getNodeId());
                customAnalysisItems.add((Object)customAnalysisItem);
            }
            param.put("customAnalysisItems", customAnalysisItems);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerBeforeDataQueryEvent(this, param));
            results = this.glfxService.analysis(param, "custom-datasource");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerAfterGLCXQueryEvent(this, results));
        } else {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerBeforeDataQueryEvent(this, param));
            TbAnalysisBaseInfo glfxBaseInfo = this.tbAnalysisBaseInfoService.findById(tbGLFX.getServiceId());
            results = this.glfxService.analysis(param, glfxBaseInfo.getName());
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerAfterGLCXQueryEvent(this, results));
        }
        if (results.size() != listTables.size()) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u7684\u5206\u6790\u9879\u4e0e\u4e00\u5f20\u56fe\u5206\u6790\u9879\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        List<Long> lstTableIds = listTables.stream().map(TbGLFXTable::getId).collect(Collectors.toList());
        Map<Long, GLFXGraphAndFields> mapGLFXGraphAndFields = this.tbGLFXTableService.queryDisplayConfigs(lstTableIds);
        ArrayList<GLFXResultDetail> res = new ArrayList<GLFXResultDetail>();
        GLFXGraphAndFields graphAndFields = null;
        for (int i = 0; i < listTables.size(); ++i) {
            TbGLFXTable tbGLFXTable = listTables.get(i);
            graphAndFields = mapGLFXGraphAndFields.get(tbGLFXTable.getId());
            String yzfxServiceName = null;
            if ("geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) {
                String applicationGuid = null;
                String accessKey = null;
                if (StringUtils.isNotEmpty((CharSequence)tbGLFX.getOtherParams())) {
                    JSONObject otherParams = JSONObject.parseObject((String)tbGLFX.getOtherParams());
                    applicationGuid = otherParams.getString("ApplicationGUID");
                    accessKey = otherParams.getString("accessKey");
                }
                String serverRootUrl = tbGLFX.getUrl().split("/rest/glfx/")[0];
                TbAnalysisYZFXDetail yzfxDetail = this.iyzfxService.findById(serverRootUrl, tbGLFXTable.getServiceId(), accessKey);
                yzfxServiceName = yzfxDetail.getName();
            } else if (this.customAnalysis.booleanValue()) {
                yzfxServiceName = tbGLFXTable.getNodeId();
            } else {
                TbAnalysisBaseInfo yzfxBaseInfo = this.tbAnalysisBaseInfoService.findById(tbGLFXTable.getServiceId());
                yzfxServiceName = yzfxBaseInfo.getName();
            }
            String finalYzfxServiceName = yzfxServiceName;
            Optional<GLFXResult> glhsResultOptinal = results.stream().filter(p -> finalYzfxServiceName.equals(p.getServiceType())).findFirst();
            if (glhsResultOptinal == null || !glhsResultOptinal.isPresent()) {
                System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u7684\u5206\u6790\u7ed3\u679c");
                continue;
            }
            GLFXResult glhsResult = glhsResultOptinal.get();
            glhsResult.setOrder(tbGLFXTable.getOrder().intValue());
            glhsResult.setLayerAlias(tbGLFXTable.getNodeName());
            GLFXResultDetail glfxResultDetail = new GLFXResultDetail();
            BeanUtils.copyProperties((Object)glhsResult, (Object)glfxResultDetail);
            glfxResultDetail.setRender(tbGLFXTable.getRender());
            glfxResultDetail.setGraph(graphAndFields.getGraph());
            glfxResultDetail.setFields(graphAndFields.getFields());
            res.add(glfxResultDetail);
        }
        return res;
    }

    private void addOrUpdateGLHSService(TbGLFX tbGLFX) {
        if (!StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl()) || !"geoserver".equalsIgnoreCase(tbGLFX.getServiceType())) {
            if (this.customAnalysis.booleanValue()) {
                tbGLFX.setServiceId("custom-datasource");
            } else {
                String glhsName = "ONEMAP_glfx_" + tbGLFX.getId();
                String glhsAlias = "\u4e00\u5f20\u56fe_\u5173\u8054\u5206\u6790_" + tbGLFX.getName();
                TbAnalysisGLFXDetail glfxDetail = null;
                if (StringUtils.isEmpty((CharSequence)tbGLFX.getServiceId())) {
                    if (this.glfxService.checkIsExist(glhsName)) {
                        throw new RuntimeException("\u5173\u8054\u5206\u6790\u670d\u52a1\u5df2\u7ecf\u5b58\u5728");
                    }
                    glfxDetail = new TbAnalysisGLFXDetail();
                    glfxDetail.setYzfxList(new ArrayList());
                } else {
                    glfxDetail = this.glfxService.findById(tbGLFX.getServiceId());
                    if (glfxDetail == null) {
                        throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u83b7\u53d6\u5173\u8054\u5206\u6790\u670d\u52a1\u5931\u8d25");
                    }
                }
                glfxDetail.setName(glhsName);
                glfxDetail.setAlias(glhsAlias);
                glfxDetail.setGroup("\u4e00\u5f20\u56fe4.0");
                glfxDetail.setDesc(tbGLFX.getDesc());
                glfxDetail.setStatus(Integer.valueOf(tbGLFX.getStatus() != false ? 1 : 0));
                glfxDetail = this.glfxService.save(glfxDetail);
                if (glfxDetail == null) {
                    throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u66f4\u65b0\u5173\u8054\u5206\u6790\u670d\u52a1\u5931\u8d25");
                }
                tbGLFX.setServiceId(glfxDetail.getId());
            }
        }
    }
}

