/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.theme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.onemap.theme.entity.TbTheme;
import com.geoway.ns.onemap.theme.mapper.TbThemeMapper;
import com.geoway.ns.onemap.theme.service.TbSceneService;
import com.geoway.ns.onemap.theme.service.TbThemeService;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TbThemeServiceImp
extends ServiceImpl<TbThemeMapper, TbTheme>
implements TbThemeService {
    @Autowired
    private TbThemeMapper tbThemeMapper;
    @Autowired
    private TbSceneService tbSceneService;

    @Override
    public List<TbTheme> listByGroup(Long groupId, String key) {
        if (key == null) {
            key = "";
        }
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbTheme.class).eq(TbTheme::getGroupId, (Object)groupId)).like(TbTheme::getName, (Object)key)).orderByAsc(TbTheme::getOrder));
    }

    @Override
    public TbTheme info(Long id) {
        return (TbTheme)this.getById(id);
    }

    @Override
    public TbTheme addOrUpdate(TbTheme param) {
        boolean res;
        if (param.getId() == null) {
            Long order = this.tbThemeMapper.selectMaxOrder(param.getGroupId());
            order = order == null ? 1L : order + 1L;
            param.setOrder(order);
        }
        if (res = this.saveOrUpdate(param)) {
            return param;
        }
        throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public String uploadPic(MultipartFile file) {
        if (file != null) {
            String fileName = file.getOriginalFilename();
            assert (fileName != null);
            String fileSuffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            try {
                String base64Str = this.getBase64Before(fileSuffix) + Base64.getEncoder().encodeToString(file.getBytes());
                return base64Str;
            }
            catch (IOException e) {
                throw new RuntimeException("\u56fe\u7247\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    private String getBase64Before(String fileSuffix) {
        switch (fileSuffix) {
            case "svg": 
            case "SVG": {
                return "data:image/" + fileSuffix + "+xml;base64,";
            }
        }
        return "data:image/" + fileSuffix + ";base64,";
    }

    @Override
    public boolean remove(Long id) {
        boolean res = this.removeById(id);
        if (!res) {
            return false;
        }
        this.tbSceneService.removeByTheme(id);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removes(List<Long> ids) {
        boolean res = this.removeByIds(ids);
        if (!res) {
            return false;
        }
        ids.forEach(id -> this.tbSceneService.removeByTheme((Long)id));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeByGroup(Long groupId) {
        boolean res = this.remove((Wrapper)new QueryWrapper().lambda().eq(TbTheme::getGroupId, (Object)groupId));
        if (!res) {
            return false;
        }
        List<TbTheme> tbThemes = this.listByGroup(groupId, null);
        tbThemes.forEach(tbTheme -> this.remove(tbTheme.getId()));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbTheme cur = (TbTheme)this.getById(id);
        if (cur == null) {
            return false;
        }
        TbTheme max = (TbTheme)this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbTheme.class).eq(TbTheme::getGroupId, (Object)cur.getGroupId())).orderByDesc(TbTheme::getOrder)).get(0);
        return this.sort(id, max.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbTheme cur = (TbTheme)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1L)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbTheme cur = (TbTheme)this.getById(id);
        if (cur == null) {
            return false;
        }
        Long maxOrder = this.tbThemeMapper.selectMaxOrder(cur.getGroupId());
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, Long order) {
        TbTheme cur = (TbTheme)this.getById(id);
        if (cur == null) {
            return true;
        }
        if (cur.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (cur.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbTheme.class).eq(TbTheme::getGroupId, (Object)cur.getGroupId())).ge(TbTheme::getOrder, (Object)order)).lt(TbTheme::getOrder, (Object)cur.getOrder())).orderByAsc(TbTheme::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbTheme)needUpdateList.get(i)).setOrder(order + (long)i + 1L);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbTheme.class).eq(TbTheme::getGroupId, (Object)cur.getGroupId())).gt(TbTheme::getOrder, (Object)cur.getOrder())).le(TbTheme::getOrder, (Object)order)).orderByAsc(TbTheme::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbTheme)needUpdateList.get(i)).setOrder(cur.getOrder() + (long)i);
            }
        }
        cur.setOrder(order);
        needUpdateList.add(cur);
        return this.updateBatchById(needUpdateList);
    }
}

