-- ----------------------------
--2023年6月26日，oyyh，根据最新设计修改在线分析相关库表设计
-- ----------------------------

--1.修改在线分析目录表（删除参数配置字段）
ALTER TABLE tb_onemap4_zxfx_catalog DROP COLUMN f_paramset;

--2.新增在线分析模型分组表
CREATE TABLE tb_onemap4_zxfx_model_group (
                                             f_id varchar(40) NULL,
                                             f_name varchar(200) NULL,
                                             f_order int4 NULL,
                                             CONSTRAINT tb_onemap4_zxfx_model_group_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_zxfx_model_group IS '在线分析模型分组表';
COMMENT ON COLUMN tb_onemap4_zxfx_model_group.f_id IS 'id';
COMMENT ON COLUMN tb_onemap4_zxfx_model_group.f_name IS '分组名称';
COMMENT ON COLUMN tb_onemap4_zxfx_model_group.f_order IS '排序';

--3.修改在线分析模型表（删除分组字段，增加分组id和注册时间字段）
DROP INDEX tb_onemap4_zxfx_model_f_name_idx;
ALTER TABLE tb_onemap4_zxfx_model DROP COLUMN f_group;
ALTER TABLE tb_onemap4_zxfx_model ADD f_group_id varchar(40) NULL;
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_group_id IS '分组id';
ALTER TABLE tb_onemap4_zxfx_model ADD f_register_time timestamp NULL;
COMMENT ON COLUMN tb_onemap4_zxfx_model.f_register_time IS '注册时间';
CREATE INDEX tb_onemap4_zxfx_model_f_name_idx ON tb_onemap4_zxfx_model (f_name,f_type,f_order,f_group_id);

--4.修改在线分析模型参数表（删除f_dickey、f_source，增加f_origin_alias、f_origin_type、f_content_set）
ALTER TABLE tb_onemap4_zxfx_model_param DROP COLUMN f_dickey;
ALTER TABLE tb_onemap4_zxfx_model_param DROP COLUMN f_source;
ALTER TABLE tb_onemap4_zxfx_model_param ADD f_origin_alias varchar(200) NULL;
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_origin_alias IS '原始参数别名';
ALTER TABLE tb_onemap4_zxfx_model_param ADD f_origin_type varchar(200) NULL;
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_origin_type IS '原始参数类型（经过翻译后的类型）';
ALTER TABLE tb_onemap4_zxfx_model_param ADD f_content_set text NULL;
COMMENT ON COLUMN tb_onemap4_zxfx_model_param.f_content_set IS '内容设置，json格式，如果type为Radio、Combo、Check需设置dicKey，如果type为ComboYearNode需设置nodes({"年份":"资源目录节点ID"})，如果type为Field、Fields、Whereclause、OutputLayer需设置source，其它类型不用设置';
