/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.analysis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.ns.onemap.analysis.entity.TbBizDataAnalysis;
import com.geoway.ns.onemap.analysis.request.DataAnalysisRequest;
import com.geoway.ns.onemap.analysis.service.DataAnalysisService;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.service.FileServerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5927\u6570\u636e\u5206\u6790\u4e13\u9898"})
@RestController
@RequestMapping(value={"dataAnalysis"})
public class DataAnalysisController {
    private final Logger logger = LoggerFactory.getLogger(DataAnalysisController.class);
    @Resource
    private DataAnalysisService dataAnalysisService;
    @Autowired
    FileServerService fileServerService;

    @ApiOperation(value="\u68c0\u67e5\u670d\u52a1\u540d\u79f0\u662f\u5426\u5b58\u5728")
    @RequestMapping(value={"/checkNameExists"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse checkNameExists(@RequestParam(value="name", required=true) String name) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (this.dataAnalysisService.checksServerName(name)) {
                response.setData((Object)true);
            } else {
                response.setData((Object)false);
            }
            response.setStatus("OK");
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5206\u6790")
    @RequestMapping(value={"/saveAll.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse saveAll(@RequestBody DataAnalysisRequest dataAnalysisRequest) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData((Object)this.dataAnalysisService.saveAll(dataAnalysisRequest.getDataAnalysis(), dataAnalysisRequest.getDataAnalysisCharts()));
            response.setMessage("\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5206\u6790")
    @RequestMapping(value={"/save.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse save(@ModelAttribute TbBizDataAnalysis dataAnalysis) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (this.dataAnalysisService.customSave(dataAnalysis)) {
                dataAnalysis = this.dataAnalysisService.runServer(dataAnalysis);
                dataAnalysis = this.dataAnalysisService.searchTaskById(dataAnalysis);
                response.setData((Object)dataAnalysis);
                response.setMessage("\u4fdd\u5b58\u6210\u529f!");
            } else {
                response.setMessage("\u4fdd\u5b58\u5931\u8d25!");
            }
            response.setStatus("OK");
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5206\u6790\u72b6\u6001")
    @RequestMapping(value={"/getState.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getState(@RequestParam(value="fid", required=true) String fid) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_id", (Object)fid);
            TbBizDataAnalysis dataAnalysis = (TbBizDataAnalysis)this.dataAnalysisService.getOne((Wrapper)queryWrapper);
            response.setData((Object)this.dataAnalysisService.searchTaskById(dataAnalysis));
            response.setStatus("OK");
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u8fd0\u884c\u6570\u636e\u5206\u6790")
    @RequestMapping(value={"/runAnalysis.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse runAnalysis(@RequestParam(value="fid", required=true) String fid) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_id", (Object)fid);
            TbBizDataAnalysis dataAnalysis = (TbBizDataAnalysis)this.dataAnalysisService.getOne((Wrapper)queryWrapper);
            dataAnalysis = this.dataAnalysisService.runServer(dataAnalysis);
            response.setData((Object)this.dataAnalysisService.searchTaskById(dataAnalysis));
            response.setStatus("OK");
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6392\u5e8f")
    @RequestMapping(value={"/setStore.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse setStore(@RequestParam(value="fid", required=true) String fid, @RequestParam(value="type", required=true) String type) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_id", (Object)fid);
            TbBizDataAnalysis dataAnalysis = (TbBizDataAnalysis)this.dataAnalysisService.getOne((Wrapper)queryWrapper);
            if (this.dataAnalysisService.setStroe(dataAnalysis, type).booleanValue()) {
                response.setStatus("OK");
                response.setMessage("\u6210\u529f\uff01");
            } else {
                response.setStatus("FAILURE");
                response.setMessage("\u8bbe\u7f6e\u6392\u5e8f\u5931\u8d25!");
            }
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/page.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse page(@RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size, @RequestParam(value="title", required=false) String title) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.like((Object)"f_title", (Object)(title == null ? "" : title))).orderByAsc((Object)"f_store");
            Page pages = (Page)this.dataAnalysisService.page((IPage)new Page((long)page.intValue(), (long)size.intValue()), (Wrapper)queryWrapper);
            response.setStatus("OK");
            response.setData((Object)pages);
        }
        catch (Exception e) {
            response.setStatus("FAILURE");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4e0a\u4f20\u56fe\u7247")
    @RequestMapping(value={"/uploadImage.do"}, headers={"Accept=*/*"}, method={RequestMethod.POST})
    @ResponseBody
    public void uploadImage(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file", required=true) MultipartFile multipartFile) throws Exception {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            FileUploadResponse fileUploadResponse = this.fileServerService.sendFileToServer(multipartFile).convertToFileUploadResponse();
            baseObjectResponse.setData((Object)fileUploadResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        baseObjectResponse.buildJsonResponse(response, (BaseResponse)baseObjectResponse, this.logger);
    }

    @ApiOperation(value="\u5220\u9664\u56fe\u7247")
    @RequestMapping(value={"/removeImage.do"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse removeImage(@RequestParam(value="absolutePath", required=true) String absolutePath) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        try {
            this.fileServerService.deleteFile(absolutePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseObjectResponse.setStatus("FAILURE");
            baseObjectResponse.setMessage(e.getMessage());
        }
        return baseObjectResponse;
    }
}

