/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.maptool;

import com.geoway.ns.onemap.maptool.entity.BizMaptoolUser;
import com.geoway.ns.onemap.maptool.service.BizMaptoolUserService;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.service.ITokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u5173\u8054\u5730\u56fe\u5de5\u5177"})
@RestController
@RequestMapping(value={"/maptoolUser"})
public class MaptoolUserController {
    @Autowired
    BizMaptoolUserService bizMaptoolUserService;
    @Autowired
    ITokenService iTokenService;

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/list"})
    public BaseResponse list(HttpServletRequest request) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String currentUserId = this.iTokenService.queryCurrentSysUserId();
            List<BizMaptoolUser> mapToolUsers = this.bizMaptoolUserService.listByUser(currentUserId);
            response.setData(mapToolUsers.stream().map(map -> map.getKey()).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/add"})
    public BaseResponse add(@RequestParam(value="key", required=true) String key) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String currentUserId = this.iTokenService.queryCurrentSysUserId();
            List<BizMaptoolUser> mapToolUsers = this.bizMaptoolUserService.add(currentUserId, key);
            response.setData(mapToolUsers.stream().map(map -> map.getKey()).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u66f4\u65b0\u5217\u8868")
    @PostMapping(value={"/updateList"})
    public BaseResponse updateList(HttpServletRequest request, @RequestParam(value="keysStr", required=true) String keysStr) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String currentUserId = this.iTokenService.queryCurrentSysUserId();
            if (StringUtils.isBlank((String)keysStr)) {
                this.bizMaptoolUserService.deleteByUser(currentUserId);
            } else {
                String[] split = keysStr.split(",");
                ArrayList<BizMaptoolUser> list = new ArrayList<BizMaptoolUser>();
                for (int i = 0; i < split.length; ++i) {
                    BizMaptoolUser mu = new BizMaptoolUser();
                    mu.setUserid(currentUserId);
                    mu.setKey(split[i]);
                    list.add(mu);
                }
                List<BizMaptoolUser> mapToolUsers = this.bizMaptoolUserService.updateList(list, currentUserId);
                response.setData(mapToolUsers.stream().map(map -> map.getKey()).collect(Collectors.toList()));
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public BaseResponse delete(HttpServletRequest request, @RequestParam(value="key", required=true) String key) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String currentUserId = this.iTokenService.queryCurrentSysUserId();
            this.bizMaptoolUserService.deleteOneByUserAndKey(currentUserId, key);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }
}

