/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.onlinequery;

import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.ns.onemap.onlineQuery.entity.OnlineQueryFields;
import com.geoway.ns.onemap.onlineQuery.service.OnlineQueryFieldsService;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5728\u7ebf\u67e5\u8be2\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/onlineQuery"})
public class OnlineQueryController {
    @Autowired
    OnlineQueryFieldsService onlineQueryFieldsService;

    @ApiOperation(value="\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse add(List<OnlineQueryFields> fields) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (!this.onlineQueryFieldsService.add(fields).booleanValue()) {
                response.markFailure();
                response.setMessage("\u65b0\u589e\u5931\u8d25");
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public BaseResponse delete(@RequestParam(value="nodeId", required=true) String nodeId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.onlineQueryFieldsService.deleteByNodeId(nodeId);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u66f4\u65b0")
    @RequestMapping(value={"/updateList"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse updateList(@RequestBody List<OnlineQueryFields> fields) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            if (!this.onlineQueryFieldsService.updateList(fields).booleanValue()) {
                response.markFailure();
                response.setMessage("\u66f4\u65b0\u5931\u8d25");
            }
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5217\u8868")
    @PostMapping(value={"/list"})
    public BaseResponse list(@RequestParam(value="nodeId", required=true) String nodeId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List<OnlineQueryFields> onlineQueryFieldsList = this.onlineQueryFieldsService.listByNodeId(nodeId);
            response.setData(onlineQueryFieldsList);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="01-\u5728\u7ebf\u67e5\u8be2\u5206\u6790\u63a5\u53e3")
    @PostMapping(value={"/query"})
    public Response<DataQueryResult> queryData(@RequestBody FeatureQueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.onlineQueryFieldsService.queryData(queryFilterDTO));
    }
}

