/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.djtj.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.onemap.common.constants.EnumTaskStatus;
import com.geoway.ns.onemap.djtj.entity.Task;
import com.geoway.ns.onemap.djtj.listener.TaskListener;
import com.geoway.ns.onemap.djtj.mapper.TaskMapper;
import com.geoway.ns.onemap.djtj.service.TaskService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
extends ServiceImpl<TaskMapper, Task>
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Value(value="${cloud.query.enable:true}")
    private Boolean enable;

    @Override
    public boolean add(Task entity, boolean start) throws Exception {
        entity.setProgress(0);
        entity.setCreateTime(new Date());
        entity.setStatus(EnumTaskStatus.Init.value);
        if (start) {
            String taskId = this.startTask(entity);
            entity.setJobId(taskId);
            entity.setStartTime(new Date());
            entity.setStatus(EnumTaskStatus.Running.value);
            entity.setEndTime(null);
            entity.setProgress(0);
        }
        return this.save(entity);
    }

    @Override
    public boolean start(String id) throws Exception {
        Task entity = (Task)this.getById((Serializable)((Object)id));
        if (ObjectUtil.isNull((Object)entity)) {
            throw new RuntimeException(String.format("\u65e0\u4efb\u52a1id\u4e3a\u3010%s\u3011\u7684\u4efb\u52a1,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", id));
        }
        String djfxTaskId = this.startTask(entity);
        entity.setJobId(djfxTaskId);
        entity.setProgress(0);
        entity.setStatus(EnumTaskStatus.Init.value);
        return this.update(entity);
    }

    @Override
    public boolean pause(String id) {
        return false;
    }

    @Override
    public boolean stop(String id) {
        return false;
    }

    @Override
    public boolean delete(Task entity) {
        return false;
    }

    @Override
    public boolean update(Task entity) {
        this.taskListener(entity);
        return this.updateById(entity);
    }

    @Override
    public boolean updateStatus(String id, int status) {
        Task entity = (Task)this.getById((Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException(String.format("\u65e0\u4efb\u52a1id\u4e3a\u3010%s\u3011\u7684\u4efb\u52a1,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", id));
        }
        entity.setStatus(status);
        EnumTaskStatus enumStatus = EnumTaskStatus.getEnumByValue(status);
        if (EnumTaskStatus.Failed == enumStatus || EnumTaskStatus.Succeed == enumStatus) {
            entity.setProgress(100);
        }
        return this.update(entity);
    }

    @Override
    public boolean updateProgress(String id, int progress) {
        Task entity = (Task)this.getById((Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException(String.format("\u65e0\u4efb\u52a1id\u4e3a\u3010%s\u3011\u7684\u4efb\u52a1,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", id));
        }
        entity.setProgress(progress);
        return this.update(entity);
    }

    @Override
    public String getLog(String id) throws Exception {
        Task entity = (Task)this.getById((Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException(String.format("\u65e0\u4efb\u52a1id\u4e3a\u3010%s\u3011\u7684\u4efb\u52a1", id));
        }
        return this.getTaskLog(entity.getJobId());
    }

    @Override
    public List<Task> getTasks(List<String> ids) {
        QueryWrapper serviceWrapper = new QueryWrapper();
        serviceWrapper.lambda().in(Task::getId, ids);
        return this.list((Wrapper)serviceWrapper);
    }

    @Override
    public Task getByJobId(String jobId) {
        QueryWrapper serviceWrapper = new QueryWrapper();
        serviceWrapper.lambda().eq(Task::getJobId, (Object)jobId);
        return (Task)this.getOne((Wrapper)serviceWrapper);
    }

    @Override
    public String getTaskScheduleUrl() throws Exception {
        return this.geoserver3ConfigService.getUrl();
    }

    private void taskListener(Task entity) {
        EnumTaskStatus enumStatus = EnumTaskStatus.getEnumByValue(entity.getStatus());
        if (EnumTaskStatus.Failed == enumStatus || EnumTaskStatus.Succeed == enumStatus) {
            TaskListener.getTaskFinishedListeners().forEach(f -> f.test(entity));
        }
    }

    private String startTask(Task entity) throws Exception {
        String url = this.getTaskScheduleUrl() + entity.getHandler();
        String result = ((HttpRequest)HttpRequest.post((String)url).body(entity.getParam()).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        log.error("\u5f00\u59cbhttp\u4efb\u52a1\uff1aurl:" + url + ",param: " + entity.getParam());
        System.out.println("\u521b\u5efa\u5e76\u6267\u884c\u53e0\u52a0\u5206\u6790\u4efb\u52a1b:" + result);
        JSONObject resultObject = JSONObject.parseObject((String)result);
        String statusCode = resultObject.getString("StatusCode");
        if (!"200".equals(statusCode) && !"-1".equals(statusCode)) {
            log.error(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:" + resultObject.getString("Message"));
            throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return resultObject.getString("UniqueTaskID");
    }

    private String getTaskLog(String jobId) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("jobId", (Object)jobId);
        String url = this.getTaskScheduleUrl() + "/rest/task/getJobLogDetailByJobId";
        String result = ((HttpRequest)HttpRequest.post((String)url).body(jsonObject.toJSONString()).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        JSONObject resultObject = JSONObject.parseObject((String)result);
        String statusCode = resultObject.getString("StatusCode");
        if (!"200".equals(statusCode)) {
            log.error(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u83b7\u53d6\u65e5\u5fd7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:" + resultObject.getString("message"));
            throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return resultObject.getJSONObject("Results").getString("logContent");
    }
}

