/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.encrypttool.listener;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.event.DatasetAfterDataQueryEvent;
import com.geoway.adf.dms.datasource.event.DatasetBeforeDataQueryEvent;
import com.geoway.ns.geoserver3.dto.GLFXResult;
import com.geoway.ns.geoserver3.dto.GLHSResult;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterGLCXQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterLSHSQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterYZFXQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerBeforeDataQueryEvent;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"right.dataset-py-enable"}, havingValue="true")
public class DatasetEventListener {
    @Autowired
    private BizEncryptRecordsService bizEncryptRecordsService;
    private static final Logger logger = LoggerFactory.getLogger(DatasetEventListener.class);

    @EventListener
    public void handleBeforeDataQueryEvent(DatasetBeforeDataQueryEvent event) {
        block5: {
            QueryFilterBasicDTO queryFilter;
            block6: {
                System.out.println("Received custom event - " + event);
                queryFilter = event.getQueryFilter();
                if (queryFilter == null) break block5;
                List filterGeometrys = queryFilter.getGeometryList();
                if (filterGeometrys == null) break block6;
                ArrayList<String> newFilterGeometrys = new ArrayList<String>();
                for (String filterGeometry : filterGeometrys) {
                    System.out.println(filterGeometry);
                    try {
                        newFilterGeometrys.add(this.bizEncryptRecordsService.wktEncrypt(queryFilter.getGeometry(), EncryptType.Encrypt));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u504f\u8f6c\u6b63\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                break block5;
            }
            if (queryFilter.getGeometry() == null) break block5;
            System.out.println(queryFilter.getGeometry());
            try {
                queryFilter.setGeometry(this.bizEncryptRecordsService.wktEncrypt(queryFilter.getGeometry(), EncryptType.Encrypt));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u504f\u8f6c\u6b63\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    @EventListener
    public void handleAfterDataQueryEvent(DatasetAfterDataQueryEvent event) {
        System.out.println("Received custom event - " + event);
        DataQueryResult dataQueryResult = event.getDataQueryResult();
        if (dataQueryResult != null) {
            for (FeatureResult featureResult : dataQueryResult.getData()) {
                System.out.println(featureResult.getGeometry());
                if (featureResult.getGeometry() == null) continue;
                try {
                    featureResult.setGeometry(this.bizEncryptRecordsService.wktEncrypt(featureResult.getGeometry(), EncryptType.Decrypt));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c\u6b63\u8f6c\u504f\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @EventListener
    public void handleGeoServerBeforeDataQueryEvent(GeoServerBeforeDataQueryEvent event) {
        System.out.println("Received custom event - " + (Object)((Object)event));
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("\u8bf7\u6c42\u5f00\u59cb\u65f6\u95f4: " + now.format(formatter));
        Instant start = Instant.now();
        Map<String, Object> dataQueryResult = event.getQueryFilter();
        if (dataQueryResult != null) {
            List Blocks = (List)dataQueryResult.get("Blocks");
            for (Object block : Blocks) {
                LinkedHashMap blockJson = (LinkedHashMap)block;
                if (blockJson.containsKey("WKT") && StringUtils.isNotEmpty((CharSequence)blockJson.get("WKT").toString())) {
                    try {
                        blockJson.put("WKT", this.bizEncryptRecordsService.wktEncrypt(blockJson.get("WKT").toString(), EncryptType.Encrypt));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u504f\u8f6c\u6b63\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                System.out.println(blockJson.get("WKT"));
                System.out.println(blockJson.get("GeoJSON"));
            }
            dataQueryResult.put("Blocks", Blocks);
            System.out.println("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0 + "\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u504f\u79fb\u6570\u636e\u91cf" + Blocks.size());
        }
    }

    @EventListener
    public void handleGeoServerAfterYZFXQueryEvent(GeoServerAfterYZFXQueryEvent event) {
        System.out.println("Received custom event - " + (Object)((Object)event));
        Instant start = Instant.now();
        JSONObject dataQueryResult = event.getDataQueryResult();
        if (dataQueryResult.containsKey((Object)"Results") && dataQueryResult.getJSONArray("Results").size() > 0) {
            JSONArray jsonArray = dataQueryResult.getJSONArray("Results");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject.containsKey((Object)"YZWKT") && StringUtils.isNotEmpty((CharSequence)jsonObject.getString("YZWKT"))) {
                    try {
                        jsonObject.put("YZWKT", (Object)this.bizEncryptRecordsService.wktEncrypt(jsonObject.getString("YZWKT"), EncryptType.Decrypt));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c\u6b63\u8f6c\u504f\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                jsonArray.set(i, (Object)jsonObject);
            }
            dataQueryResult.put("Results", (Object)jsonArray);
            System.out.println("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0 + "\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u504f\u79fb\u6570\u636e\u91cf" + jsonArray.size());
        }
    }

    @EventListener
    public void handleGeoServerAfterGLCXQueryEvent(GeoServerAfterGLCXQueryEvent event) {
        System.out.println("Received custom event - " + (Object)((Object)event));
        Instant start = Instant.now();
        List<GLFXResult> dataQueryResults = event.getDataQueryResult();
        if (dataQueryResults != null && dataQueryResults.size() > 0) {
            dataQueryResults.forEach(p -> {
                if (p.getResults() != null) {
                    JSONArray jsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)p.getResults()));
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        if (jsonObject.containsKey((Object)"YZWKT") && StringUtils.isNotEmpty((CharSequence)jsonObject.getString("YZWKT"))) {
                            try {
                                jsonObject.put("YZWKT", (Object)this.bizEncryptRecordsService.wktEncrypt(jsonObject.getString("YZWKT"), EncryptType.Decrypt));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c\u6b63\u8f6c\u504f\u5931\u8d25\uff1a" + e.getMessage());
                            }
                        }
                        jsonArray.set(i, (Object)jsonObject);
                    }
                    p.setResults((Object)jsonArray);
                }
            });
            System.out.println("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0 + "\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u504f\u79fb\u6570\u636e\u91cf" + dataQueryResults.size());
        }
    }

    @EventListener
    public void handleGeoServerAfterLSHSQueryEvent(GeoServerAfterLSHSQueryEvent event) {
        System.out.println("Received custom event - " + (Object)((Object)event));
        Instant start = Instant.now();
        List<GLHSResult> dataQueryResults = event.getDataQueryResult();
        if (dataQueryResults != null && dataQueryResults.size() > 0) {
            dataQueryResults.forEach(p -> {
                if (p.getResults() != null) {
                    JSONArray jsonArray = JSONArray.parseArray((String)JSONArray.toJSONString((Object)p.getResults()));
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        if (jsonObject.containsKey((Object)"YZWKT") && StringUtils.isNotEmpty((CharSequence)jsonObject.getString("YZWKT"))) {
                            try {
                                jsonObject.put("YZWKT", (Object)this.bizEncryptRecordsService.wktEncrypt(jsonObject.getString("YZWKT"), EncryptType.Decrypt));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c\u6b63\u8f6c\u504f\u5931\u8d25\uff1a" + e.getMessage());
                            }
                        }
                        jsonArray.set(i, (Object)jsonObject);
                    }
                    p.setResults((Object)jsonArray);
                }
            });
            System.out.println("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0 + "\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u504f\u79fb\u6570\u636e\u91cf" + dataQueryResults.size());
        }
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("\u5386\u53f2\u56de\u6eaf\u7ed3\u675f\u65f6\u95f4: " + now.format(formatter));
    }
}

