/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.lshs.service.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.entity.ResCatalogNode;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLHSDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLHS_YZFX;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXField;
import com.geoway.ns.geoserver3.service.IGLHSService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.geoserver3.service.impl.DatabaseServiceImpl;
import com.geoway.ns.onemap.lshs.dto.LSHSGraphAndFields;
import com.geoway.ns.onemap.lshs.entity.TbLSHS;
import com.geoway.ns.onemap.lshs.entity.TbLSHSGraph;
import com.geoway.ns.onemap.lshs.entity.TbLSHSTable;
import com.geoway.ns.onemap.lshs.entity.TbLSHSTableField;
import com.geoway.ns.onemap.lshs.mapper.TbLSHSMapper;
import com.geoway.ns.onemap.lshs.mapper.TbLSHSTableMapper;
import com.geoway.ns.onemap.lshs.service.TbLSHSGraphService;
import com.geoway.ns.onemap.lshs.service.TbLSHSTableFieldService;
import com.geoway.ns.onemap.lshs.service.TbLSHSTableService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class TbLSHSTableServiceImpl
extends ServiceImpl<TbLSHSTableMapper, TbLSHSTable>
implements TbLSHSTableService {
    @Autowired
    private TbLSHSTableMapper tbLSHSTableMapper;
    @Autowired
    private TbLSHSMapper tbLSHSMapper;
    @Autowired
    private TbLSHSGraphService tbLSHSGraphService;
    @Autowired
    private TbLSHSTableFieldService tbLSHSTableFieldService;
    @Autowired
    private IGLHSService glhsService;
    @Autowired
    private IYZFXService yzfxService;
    @Autowired
    private DatabaseServiceImpl databaseService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;
    @Value(value="${geoserver.custom-analysis:true}")
    private Boolean customAnalysis;

    @Override
    public List<TbLSHSTable> selectByLSHS(Long lshsId, boolean queryDisplayConfigStatus, boolean queryDataNode) {
        List lshsTables = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHSTable.class).eq(TbLSHSTable::getLshsId, (Object)lshsId)).orderByAsc(TbLSHSTable::getOrder));
        if (queryDisplayConfigStatus) {
            this.queryDisplayConfigStatus(lshsTables);
        }
        this.queryNodesDetail(lshsTables, queryDataNode);
        return lshsTables;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbLSHSTable addOrUpdate(TbLSHSTable tbLSHSTable) {
        ArrayList<TbLSHSTable> list = new ArrayList<TbLSHSTable>();
        list.add(tbLSHSTable);
        this.addOrUpdateList(list);
        return tbLSHSTable;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addOrUpdateList(Collection<TbLSHSTable> collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        List list = (List)collection;
        Long lshsId = ((TbLSHSTable)list.get(0)).getLshsId();
        TbLSHS tbLSHS = (TbLSHS)this.tbLSHSMapper.selectById(lshsId);
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            try {
                this.saveOrUpdateBatch(collection);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (this.customAnalysis.booleanValue()) {
            try {
                Integer order = this.tbLSHSTableMapper.selectMaxOrder(lshsId);
                order = order == null ? 1 : order + 1;
                for (TbLSHSTable tbLSHSTable : collection) {
                    tbLSHSTable.setServiceId("custom-datasource");
                    Integer n = order;
                    Integer n2 = order = Integer.valueOf(order + 1);
                    tbLSHSTable.setOrder(n);
                }
                this.saveOrUpdateBatch(collection);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        TbAnalysisGLHSDetail glhsDetail = this.glhsService.findById(tbLSHS.getServiceId());
        Integer order = this.tbLSHSTableMapper.selectMaxOrder(lshsId);
        order = order == null ? 1 : order + 1;
        for (TbLSHSTable tbLSHSTable : collection) {
            if (tbLSHSTable.getLshsId() == null || tbLSHSTable.getLshsId().equals(-1)) {
                throw new RuntimeException("lshsId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tbLSHSTable.getNodeId() == null || tbLSHSTable.getNodeId().equals("-1")) {
                throw new RuntimeException("nodeId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.queryNodeDetail(tbLSHSTable, true);
            if (tbLSHSTable.getResCatalogNodeDTO() == null) {
                throw new RuntimeException("\u67e5\u8be2\u76ee\u5f55\u8282\u70b9\u5931\u8d25");
            }
            if (StringUtils.isEmpty((CharSequence)tbLSHSTable.getNodePhase())) {
                throw new RuntimeException("\u6570\u636e\u65f6\u76f8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tbLSHSTable.getResCatalogNodeDTO();
            if (resCatalogDataNodeDTO == null || resCatalogDataNodeDTO.getDataset() == null || resCatalogDataNodeDTO.getDataset().getType().intValue() != DatasetTypeEnum.FeatureClass.getValue()) {
                throw new RuntimeException("\u6240\u9009\u6570\u636e\u96c6\u4e0d\u662f\u5408\u6cd5\u7684\u7a7a\u95f4\u56fe\u5c42");
            }
            this.addOrUpdateYzfxService(tbLSHS, tbLSHSTable);
            if (tbLSHSTable.getId() == null || tbLSHSTable.getId().equals(-1)) {
                Integer n = order;
                Integer n3 = order = Integer.valueOf(order + 1);
                tbLSHSTable.setOrder(n);
                try {
                    this.save(tbLSHSTable);
                }
                catch (Exception e) {
                    this.yzfxService.delete(tbLSHSTable.getServiceId());
                    throw e;
                }
                TbAnalysisGLHS_YZFX glhs_yzfx = new TbAnalysisGLHS_YZFX();
                glhs_yzfx.setGlhsId(glhsDetail.getId());
                glhs_yzfx.setYzfxId(tbLSHSTable.getServiceId());
                glhs_yzfx.setYear(tbLSHSTable.getNodePhase());
                glhs_yzfx.setOrder(tbLSHSTable.getOrder());
                glhsDetail.getYzfxList().add(glhs_yzfx);
            }
            this.updateById(tbLSHSTable);
            Optional<TbAnalysisGLHS_YZFX> optional = glhsDetail.getYzfxList().stream().filter(p -> p.getYzfxId().equals(tbLSHSTable.getServiceId())).findFirst();
            if (optional == null || !optional.isPresent()) continue;
            optional.get().setYear(tbLSHSTable.getNodePhase());
            optional.get().setOrder(tbLSHSTable.getOrder());
        }
        this.glhsService.save(glhsDetail);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        TbLSHSTable tbLSHSTable = (TbLSHSTable)this.tbLSHSTableMapper.selectById(id);
        boolean res = this.removeById(id);
        if (!res) {
            return false;
        }
        TbLSHS tbLSHS = (TbLSHS)this.tbLSHSMapper.selectById(tbLSHSTable.getLshsId());
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            this.tbLSHSGraphService.deleteByTableId(tbLSHSTable.getId());
            this.tbLSHSTableFieldService.deleteByTableId(tbLSHSTable.getId());
        } else if (this.customAnalysis.booleanValue()) {
            this.tbLSHSGraphService.deleteByTableId(tbLSHSTable.getId());
            this.tbLSHSTableFieldService.deleteByTableId(tbLSHSTable.getId());
        } else {
            this.tbLSHSGraphService.deleteByTableId(tbLSHSTable.getId());
            this.tbLSHSTableFieldService.deleteByTableId(tbLSHSTable.getId());
            this.deleteGLHSItem(tbLSHSTable, tbLSHS.getServiceId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            Long id = Long.valueOf(idArr[i]);
            this.deleteById(id);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByLSHS(TbLSHS tbLSHS) {
        List<TbLSHSTable> tbLSHSTables = this.selectByLSHS(tbLSHS.getId(), false, false);
        boolean res = this.remove((Wrapper)Wrappers.lambdaQuery(TbLSHSTable.class).eq(TbLSHSTable::getLshsId, (Object)tbLSHS.getId()));
        if (!res) {
            return false;
        }
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            for (TbLSHSTable item : tbLSHSTables) {
                this.tbLSHSGraphService.deleteByTableId(item.getId());
                this.tbLSHSTableFieldService.deleteByTableId(item.getId());
            }
        } else if (this.customAnalysis.booleanValue()) {
            for (TbLSHSTable item : tbLSHSTables) {
                this.tbLSHSGraphService.deleteByTableId(item.getId());
                this.tbLSHSTableFieldService.deleteByTableId(item.getId());
            }
        } else {
            for (TbLSHSTable item : tbLSHSTables) {
                this.tbLSHSGraphService.deleteByTableId(item.getId());
                this.tbLSHSTableFieldService.deleteByTableId(item.getId());
                this.deleteGLHSItem(item, tbLSHS.getServiceId());
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<TbLSHSTable> syncTables(Long lshsId) {
        List<TbLSHSTable> lshsTables = this.selectByLSHS(lshsId, true, true);
        TbLSHS tbLSHS = (TbLSHS)this.tbLSHSMapper.selectById(lshsId);
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            if (lshsTables == null || lshsTables.size() == 0) {
                String accessKey = null;
                if (StringUtils.isNotEmpty((CharSequence)tbLSHS.getOtherParams())) {
                    JSONObject otherParams = JSONObject.parseObject((String)tbLSHS.getOtherParams());
                    accessKey = otherParams.getString("accessKey");
                }
                TbAnalysisGLHSDetail tbAnalysisGLHSDetail = this.glhsService.findByServerUrl(tbLSHS.getUrl(), accessKey);
                String serverRootUrl = tbLSHS.getUrl().split("/rest/glhs/")[0];
                List yzfxLists = null;
                try {
                    yzfxLists = this.yzfxService.findAll(serverRootUrl, accessKey);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tbAnalysisGLHSDetail != null && tbAnalysisGLHSDetail.getYzfxList() != null && tbAnalysisGLHSDetail.getYzfxList().size() > 0) {
                    for (TbAnalysisGLHS_YZFX yzfx : tbAnalysisGLHSDetail.getYzfxList()) {
                        TbAnalysisBaseInfo result;
                        TbLSHSTable tbLSHSTable = new TbLSHSTable();
                        tbLSHSTable.setLshsId(lshsId);
                        tbLSHSTable.setServiceId(yzfx.getYzfxId());
                        tbLSHSTable.setOrder(yzfx.getOrder());
                        if (yzfxLists != null && yzfxLists.size() > 0 && (result = (TbAnalysisBaseInfo)yzfxLists.stream().filter(item -> yzfx.getYzfxId().equals(item.getId())).findFirst().orElse(null)) != null) {
                            tbLSHSTable.setServiceName(result.getAlias() + "(" + result.getName() + ")");
                        }
                        if (StringUtils.isEmpty((CharSequence)tbLSHSTable.getServiceName())) {
                            if (StringUtils.isNotEmpty((CharSequence)yzfx.getYear())) {
                                tbLSHSTable.setServiceName(tbAnalysisGLHSDetail.getAlias() + "-" + yzfx.getYear());
                            } else {
                                tbLSHSTable.setServiceName(tbAnalysisGLHSDetail.getAlias() + "-" + yzfx.getYzfxId());
                            }
                        }
                        tbLSHSTable.setServicePhase(yzfx.getYear());
                        if (lshsTables == null) {
                            lshsTables = new ArrayList<TbLSHSTable>();
                        }
                        lshsTables.add(tbLSHSTable);
                    }
                }
            }
        } else if (!this.customAnalysis.booleanValue()) {
            List<TbLSHSTable> delTables = lshsTables.stream().filter(p -> p.getResCatalogNodeDTO() == null).collect(Collectors.toList());
            delTables.forEach(p -> this.deleteById(p.getId()));
            lshsTables.removeAll(delTables);
            this.addOrUpdateList(lshsTables);
        }
        return lshsTables;
    }

    @Override
    public boolean displayConfig(LSHSGraphAndFields graphAndFields) {
        if (graphAndFields == null) {
            return false;
        }
        Long tableId = graphAndFields.getTableId();
        if (tableId == null || tableId.equals(-1)) {
            throw new RuntimeException("\u5206\u6790\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (graphAndFields.getGraph() != null) {
            graphAndFields.getGraph().setTableId(tableId);
            this.tbLSHSGraphService.deleteByTableId(tableId);
            this.tbLSHSGraphService.saveOrUpdateInfo(graphAndFields.getGraph());
        }
        this.tbLSHSTableFieldService.deleteByTableId(tableId);
        this.tbLSHSTableFieldService.batchSaveOrUpdate(tableId, graphAndFields.getFields());
        return true;
    }

    @Override
    public LSHSGraphAndFields queryDisplayConfig(Long id) {
        TbLSHSTable lshsTable = (TbLSHSTable)this.getById(id);
        if (lshsTable == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        LSHSGraphAndFields graphAndFields = new LSHSGraphAndFields();
        graphAndFields.setTableId(id);
        TbLSHSGraph graph = this.tbLSHSGraphService.queryByTableId(id);
        graphAndFields.setGraph(graph);
        List<TbLSHSTableField> fields = this.tbLSHSTableFieldService.queryByTableId(id);
        Collections.sort(fields);
        graphAndFields.setFields(fields);
        return graphAndFields;
    }

    @Override
    public Map<Long, LSHSGraphAndFields> queryDisplayConfigs(List<Long> ids) {
        List<TbLSHSGraph> lshsGraphs = this.tbLSHSGraphService.queryByTableIds(ids);
        List<TbLSHSTableField> lshsTableFields = this.tbLSHSTableFieldService.queryByTableIds(ids);
        HashMap<Long, LSHSGraphAndFields> mapLSHSGraphAndFields = new HashMap<Long, LSHSGraphAndFields>();
        LSHSGraphAndFields graphAndFields = null;
        for (TbLSHSGraph glfxGraph : lshsGraphs) {
            graphAndFields = new LSHSGraphAndFields();
            graphAndFields.setTableId(glfxGraph.getTableId());
            graphAndFields.setGraph(glfxGraph);
            List<TbLSHSTableField> fields = lshsTableFields.stream().filter(p -> Objects.equals(p.getTableId(), glfxGraph.getTableId())).collect(Collectors.toList());
            Collections.sort(fields);
            graphAndFields.setFields(fields);
            mapLSHSGraphAndFields.put(glfxGraph.getTableId(), graphAndFields);
        }
        return mapLSHSGraphAndFields;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbLSHSTable curTable = (TbLSHSTable)this.getById(id);
        if (curTable == null) {
            return false;
        }
        TbLSHSTable maxTable = (TbLSHSTable)this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHSTable.class).eq(TbLSHSTable::getLshsId, (Object)curTable.getLshsId())).orderByDesc(TbLSHSTable::getOrder)).get(0);
        return this.sort(id, maxTable.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbLSHSTable cur = (TbLSHSTable)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbLSHSTable cur = (TbLSHSTable)this.getById(id);
        if (cur == null) {
            return false;
        }
        int maxOrder = this.tbLSHSTableMapper.selectMaxOrder(cur.getLshsId());
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, int order) {
        int i;
        TbLSHSTable curTable = (TbLSHSTable)this.getById(id);
        if (curTable == null) {
            return true;
        }
        if (curTable.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curTable.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHSTable.class).eq(TbLSHSTable::getLshsId, (Object)curTable.getLshsId())).ge(TbLSHSTable::getOrder, (Object)order)).lt(TbLSHSTable::getOrder, (Object)curTable.getOrder())).orderByAsc(TbLSHSTable::getOrder));
            for (i = 0; i < needUpdateList.size(); ++i) {
                ((TbLSHSTable)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbLSHSTable.class).eq(TbLSHSTable::getLshsId, (Object)curTable.getLshsId())).gt(TbLSHSTable::getOrder, (Object)curTable.getOrder())).le(TbLSHSTable::getOrder, (Object)order)).orderByAsc(TbLSHSTable::getOrder));
            for (i = 0; i < needUpdateList.size(); ++i) {
                ((TbLSHSTable)needUpdateList.get(i)).setOrder(curTable.getOrder() + i);
            }
        }
        curTable.setOrder(order);
        needUpdateList.add(curTable);
        TbLSHS tbLSHS = (TbLSHS)this.tbLSHSMapper.selectById(curTable.getLshsId());
        if (!("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl()) || this.customAnalysis.booleanValue())) {
            TbAnalysisGLHSDetail glhsDetail = this.glhsService.findById(tbLSHS.getServiceId());
            for (TbLSHSTable tbLSHSTable : needUpdateList) {
                Optional<TbAnalysisGLHS_YZFX> optionalGLHS_YZFX = glhsDetail.getYzfxList().stream().filter(p -> p.getYzfxId().equals(tbLSHSTable.getServiceId())).findFirst();
                if (optionalGLHS_YZFX == null || !optionalGLHS_YZFX.isPresent()) continue;
                TbAnalysisGLHS_YZFX glhs_yzfx = optionalGLHS_YZFX.get();
                glhs_yzfx.setOrder(tbLSHSTable.getOrder());
            }
            this.glhsService.save(glhsDetail);
        }
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public ServiceMetadataDAO metadata(Long id) {
        TbLSHSTable tbLSHSTable = (TbLSHSTable)this.tbLSHSTableMapper.selectById(id);
        TbLSHS tbLSHS = (TbLSHS)this.tbLSHSMapper.selectById(tbLSHSTable.getLshsId());
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)tbLSHS.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)tbLSHS.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            String serverRootUrl = tbLSHS.getUrl().split("/rest/glhs/")[0];
            TbAnalysisYZFXDetail yzfxDetail = this.yzfxService.findById(serverRootUrl, tbLSHSTable.getServiceId(), accessKey);
            String yzfxServiceUrl = serverRootUrl + "/rest/yzfx/" + yzfxDetail.getName();
            return this.yzfxService.metadata(yzfxServiceUrl, applicationGuid, accessKey);
        }
        if (this.customAnalysis.booleanValue()) {
            this.queryNodeDetail(tbLSHSTable, true);
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tbLSHSTable.getResCatalogNodeDTO();
            if (resCatalogDataNodeDTO == null) {
                throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
            String dataUrl = "geoserver:" + featureDatasetDTO.getDsKey() + "/" + featureDatasetDTO.getFullName().replace(".", "/");
            HashMap<String, Object> customAnalysisItem = new HashMap<String, Object>();
            JSONArray analysisDatas = new JSONArray();
            JSONObject analysisData = new JSONObject();
            analysisData.put("dataType", (Object)"default");
            analysisData.put("fields", null);
            analysisData.put("whereClause", null);
            analysisData.put("dataUrl", (Object)dataUrl);
            analysisDatas.add((Object)analysisData);
            customAnalysisItem.put("analysisDatas", analysisDatas);
            customAnalysisItem.put("analysisAlgorithm", null);
            customAnalysisItem.put("analysisItemName", tbLSHSTable.getNodeId());
            return this.yzfxService.getAlgorithmFieldsMeta(customAnalysisItem);
        }
        TbAnalysisYZFXDetail yzfxDetail = this.yzfxService.findById(tbLSHSTable.getServiceId());
        return this.yzfxService.metadata(yzfxDetail.getName());
    }

    private void queryDisplayConfigStatus(List<TbLSHSTable> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        List<Long> tableIds = list.stream().map(p -> p.getId()).collect(Collectors.toList());
        List<TbLSHSGraph> lstGraphs = this.tbLSHSGraphService.queryByTableIds(tableIds);
        Map<Long, TbLSHSGraph> mapGraphs = lstGraphs.stream().collect(Collectors.toMap(TbLSHSGraph::getTableId, person -> person));
        for (TbLSHSTable lshsTable : list) {
            if (mapGraphs.containsKey(lshsTable.getId())) {
                lshsTable.setDisplayConfigStatus(1);
                continue;
            }
            lshsTable.setDisplayConfigStatus(0);
        }
    }

    private void queryNodesDetail(List<TbLSHSTable> lshsTables, boolean queryDataNode) {
        if (lshsTables == null) {
            return;
        }
        List nodeIds = lshsTables.stream().map(TbLSHSTable::getNodeId).collect(Collectors.toList());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (TbLSHSTable lshsTable : lshsTables) {
            this.queryNodeDetail(lshsTable, queryDataNode);
        }
        stopWatch.stop();
        System.out.println(String.format("\u67e5\u8be2\u8d44\u6e90\u76ee\u5f55%d\u4e2a\u8282\u70b9\u8be6\u60c5\u8017\u65f6\uff1a%f\u79d2", nodeIds.size(), stopWatch.getTotalTimeSeconds()));
    }

    private void queryNodeDetail(TbLSHSTable lshsTable, boolean queryDataNode) {
        if (queryDataNode) {
            ResCatalogNodeDTO resCatalogNodeDTO = null;
            if (lshsTable.getResCatalogNodeDTO() == null) {
                try {
                    resCatalogNodeDTO = this.resCatalogService.getNodeDetail(lshsTable.getNodeId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                resCatalogNodeDTO = lshsTable.getResCatalogNodeDTO();
            }
            if (resCatalogNodeDTO == null) {
                return;
            }
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
            lshsTable.setResCatalogNodeDTO(resCatalogNodeDTO);
            lshsTable.setNodeName(resCatalogDataNodeDTO.getNodeName());
            lshsTable.setNodePhase(((ResCatalogDataNodeDTO)resCatalogNodeDTO).getNodePhase());
            DatasetDTO dataset = resCatalogDataNodeDTO.getDataset();
            String datasourceStr = dataset.getDataSource().getName() + ">" + dataset.getName() + "\uff08" + dataset.getAliasName() + "\uff09";
            lshsTable.setDataSource(datasourceStr);
            lshsTable.setRender(resCatalogDataNodeDTO.getRender());
        } else {
            ResCatalogNode resCatalogNode = this.resCatalogService.selectByNodeId(lshsTable.getNodeId());
            lshsTable.setNodeName(resCatalogNode.getNodeName());
            lshsTable.setNodePhase(resCatalogNode.getDataPhase());
            lshsTable.setDataSource(resCatalogNode.getDatasetName());
            DatasetRenderDTO datasetRenderDTO = this.resCatalogService.getNodeRender(lshsTable.getNodeId());
            lshsTable.setRender(datasetRenderDTO);
        }
    }

    private void addOrUpdateYzfxService(TbLSHS tbLSHS, TbLSHSTable tbLSHSTable) {
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tbLSHSTable.getResCatalogNodeDTO();
        if (!this.databaseService.addDatabase(resCatalogDataNodeDTO.getDataset().getDsKey())) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
        }
        FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
        String oidField = featureDatasetDTO.getOidField().toUpperCase();
        String shapeField = featureDatasetDTO.getShapeField().toUpperCase();
        List fields = featureDatasetDTO.getFields();
        TbAnalysisYZFXDetail yzfxDetail = null;
        if (!StringUtils.isEmpty((CharSequence)tbLSHSTable.getServiceId())) {
            yzfxDetail = this.yzfxService.findById(tbLSHSTable.getServiceId());
        }
        if (yzfxDetail == null) {
            yzfxDetail = new TbAnalysisYZFXDetail();
            String serviceName = "ONEMAP_glhs_" + tbLSHS.getId() + "_" + featureDatasetDTO.getName();
            String serviceAlias = "\u4e00\u5f20\u56fe_\u5173\u8054\u56de\u6eaf_" + tbLSHS.getAlias() + "_" + resCatalogDataNodeDTO.getNodeName();
            serviceName = this.realYZFXServiceName(serviceName);
            yzfxDetail.setName(serviceName);
            yzfxDetail.setAlias(serviceAlias);
        }
        yzfxDetail.setGroup("\u4e00\u5f20\u56fe4.0-\u5173\u8054\u56de\u6eaf");
        yzfxDetail.setStatus(Integer.valueOf(1));
        yzfxDetail.setLayer(featureDatasetDTO.getName());
        yzfxDetail.setLayerAlias(featureDatasetDTO.getAliasName());
        yzfxDetail.setDatasourceKey(featureDatasetDTO.getDsKey());
        yzfxDetail.setPrimaryField(oidField);
        yzfxDetail.setShapeField(shapeField);
        yzfxDetail.setFields(this.getYZFXField(fields));
        yzfxDetail.setInputParams(new ArrayList());
        yzfxDetail = this.yzfxService.save(yzfxDetail);
        tbLSHSTable.setServiceId(yzfxDetail.getId());
    }

    private String realYZFXServiceName(String yzfxServiceName) {
        String realServiceName = yzfxServiceName;
        if (this.yzfxService.checkIsExist(yzfxServiceName)) {
            for (int i = 1; i < Integer.MAX_VALUE && this.yzfxService.checkIsExist(realServiceName = yzfxServiceName + "_" + i); ++i) {
            }
        }
        return realServiceName;
    }

    private List<TbAnalysisYZFXField> getYZFXField(List<FieldDTO> fields) {
        ArrayList<TbAnalysisYZFXField> fieldList = new ArrayList<TbAnalysisYZFXField>();
        TbAnalysisYZFXField tbAnalysisYZFXField = null;
        int order = 1;
        for (FieldDTO field : fields) {
            tbAnalysisYZFXField = new TbAnalysisYZFXField();
            tbAnalysisYZFXField.setName(field.getName());
            tbAnalysisYZFXField.setAlias(field.getAliasName());
            tbAnalysisYZFXField.setReturnName(field.getName().toUpperCase());
            tbAnalysisYZFXField.setType(this.covertType(field.getFieldType()));
            tbAnalysisYZFXField.setOrder(Integer.valueOf(order++));
            fieldList.add(tbAnalysisYZFXField);
        }
        return fieldList;
    }

    private String covertType(int value) {
        FieldType fieldType = FieldType.getByValue((Integer)value);
        switch (fieldType) {
            case Int: {
                return "int4";
            }
            case OID: {
                return "oid";
            }
            case Blob: {
                return "blob";
            }
            case Byte: {
                return "byte";
            }
            case Long: {
                return "long";
            }
            case Text: 
            case String: {
                return "string";
            }
            case Float: {
                return "float";
            }
            case Shape: {
                return "geometry";
            }
            case Short: {
                return "short";
            }
            case Double: {
                return "double";
            }
            case Boolean: {
                return "boolean";
            }
            case Decimal: {
                return "decimal";
            }
            default: {
                return "unknown";
            }
            case DateTime: 
        }
        return "datetime";
    }

    private void deleteGLHSItem(TbLSHSTable tbLSHSTable, String glhsServiceId) {
        try {
            this.yzfxService.delete(tbLSHSTable.getServiceId());
            TbAnalysisGLHSDetail glhsDetail = this.glhsService.findById(glhsServiceId);
            List glhsYzfxList = glhsDetail.getYzfxList();
            Optional<TbAnalysisGLHS_YZFX> optionalItem = glhsYzfxList.stream().filter(p -> p.getYzfxId().equals(tbLSHSTable.getServiceId())).findFirst();
            if (optionalItem != null && optionalItem.isPresent()) {
                glhsYzfxList.remove(optionalItem.get());
                this.glhsService.save(glhsDetail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

