/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.service;

import cn.hutool.core.img.gif.AnimatedGifEncoder;
import cn.hutool.core.img.gif.GifDecoder;
import com.geoway.ns.onemap.multidata.dto.YearLayerInfoDTO;
import com.geoway.ns.onemap.multidata.enums.ImageLocationEnum;
import com.geoway.ns.onemap.multidata.support.ImgUtils;
import com.geoway.ns.onemap.multidata.support.WatermarkUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GifService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createMultiDataGif(List<YearLayerInfoDTO> years, Integer interval, Integer w, Integer h, String newPicPath) {
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        try {
            System.out.println("AnimatedGifEncoder\uff1a" + (e == null));
            e.setRepeat(0);
            e.start(newPicPath);
            if (w != null && h != null) {
                e.setSize(w.intValue(), h.intValue());
            }
            System.out.println("years\uff1a" + (years == null));
            for (int i = 0; i < years.size(); ++i) {
                BufferedImage bufferedImage;
                YearLayerInfoDTO yearLayerInfoDTO = years.get(i);
                System.out.println("yearLayerInfoDTO\uff1a" + (yearLayerInfoDTO == null));
                if (StringUtils.isEmpty((CharSequence)yearLayerInfoDTO.getBase64Result()) && yearLayerInfoDTO.getResultImage() == null) {
                    System.out.println("\u56fe\u7247\u4e3a\u7a7a");
                    continue;
                }
                e.setDelay(interval * 1000);
                BufferedImage bufferedImage2 = bufferedImage = yearLayerInfoDTO.getResultImage() != null ? yearLayerInfoDTO.getResultImage() : ImgUtils.base64ToImage(yearLayerInfoDTO.getBase64Result());
                if (StringUtils.isNotEmpty((CharSequence)yearLayerInfoDTO.getDataYear())) {
                    bufferedImage = WatermarkUtil.addWatermark(bufferedImage, 1, "\u65f6\u76f8\uff1a" + yearLayerInfoDTO.getDataYear(), ImageLocationEnum.topLeft, 12, null, "#2473d8", 10);
                }
                if (StringUtils.isNotEmpty((CharSequence)yearLayerInfoDTO.getDataSourceText())) {
                    bufferedImage = WatermarkUtil.addWatermark(bufferedImage, 1, yearLayerInfoDTO.getDataSourceText(), ImageLocationEnum.bottomRight, 12, null, "#0d150fcc", 10);
                }
                if (StringUtils.isNotEmpty((CharSequence)yearLayerInfoDTO.getDataCreditText())) {
                    Integer type = yearLayerInfoDTO.getDataCreditText().length() > 100 ? 2 : 1;
                    bufferedImage = WatermarkUtil.addWatermark(bufferedImage, type, yearLayerInfoDTO.getDataCreditText(), ImageLocationEnum.bottomLeft, 12, null, null, 5);
                }
                e.addFrame(bufferedImage);
            }
        }
        catch (Exception ex) {
            System.out.println("jpgToGif Failed:");
            ex.printStackTrace();
        }
        finally {
            System.out.println("\u5b8c\u6210\u7ed8\u5236");
            e.finish();
        }
    }

    private synchronized void jpgToGif(String[] pic, String newPic, Integer interval) {
        try {
            AnimatedGifEncoder e = new AnimatedGifEncoder();
            e.setRepeat(0);
            e.start(newPic);
            BufferedImage[] src = new BufferedImage[pic.length];
            for (int i = 0; i < src.length; ++i) {
                e.setDelay(interval * 1000);
                src[i] = ImageIO.read(new File(pic[i]));
                e.addFrame(src[i]);
            }
            e.finish();
        }
        catch (Exception e) {
            System.out.println("jpgToGif Failed:");
            e.printStackTrace();
        }
    }

    private synchronized String[] splitGif(String gifName, String path) {
        try {
            GifDecoder decoder = new GifDecoder();
            decoder.read(gifName);
            int n = decoder.getFrameCount();
            String[] subPic = new String[n];
            for (int i = 0; i < n; ++i) {
                BufferedImage frame = decoder.getFrame(i);
                subPic[i] = path + String.valueOf(i) + ".jpg";
                FileOutputStream out = new FileOutputStream(subPic[i]);
                ImageIO.write((RenderedImage)frame, "jpeg", out);
                out.flush();
                out.close();
            }
            return subPic;
        }
        catch (Exception e) {
            System.out.println("splitGif Failed!");
            e.printStackTrace();
            return null;
        }
    }

    private String createJpgByFont(String s, int smallWidth, Color bgcolor, Color fontcolor, String fontPath, String jpgname) {
        try {
            BufferedImage bimage = new BufferedImage(s.length() * smallWidth, smallWidth, 1);
            Graphics2D g = bimage.createGraphics();
            g.setColor(bgcolor);
            g.fillRect(0, 0, smallWidth, smallWidth);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(fontcolor);
            File file = new File(fontPath);
            Font font = Font.createFont(0, file);
            g.setFont(font.deriveFont((float)smallWidth));
            g.drawString(s, 0, smallWidth);
            g.dispose();
            FileOutputStream out = new FileOutputStream(jpgname);
            ImageIO.write((RenderedImage)bimage, "jpeg", out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.out.println("createJpgByFont Failed!");
            e.printStackTrace();
        }
        return jpgname;
    }

    private void createBigJPG(ArrayList smallJPG, int bigWidth, int smallWidth, Color bgColor, String picName) {
        try {
            if (bigWidth < smallWidth) {
                return;
            }
            int colCount = bigWidth / smallWidth;
            int leftMargin = (int)((float)(bigWidth - colCount * smallWidth) / 2.0f);
            int rowCount = smallJPG.size();
            int setWidth = bigWidth;
            int setHeight = smallWidth * rowCount;
            BufferedImage bufImage = new BufferedImage(setWidth, setHeight, 1);
            Graphics2D g = bufImage.createGraphics();
            g.setColor(bgColor);
            g.fillRect(0, 0, setWidth, setHeight);
            int y = 0;
            for (int i = 0; i < rowCount; ++i) {
                ArrayList col = (ArrayList)smallJPG.get(i);
                int x = leftMargin;
                for (int j = 0; j < col.size(); ++j) {
                    String jpgname = (String)col.get(j);
                    ImageIcon icon = new ImageIcon(jpgname);
                    Image img = icon.getImage();
                    int imgWidth = img.getHeight(null);
                    g.drawImage(img, x, y, null);
                    x += imgWidth;
                }
                y += smallWidth;
            }
            g.dispose();
            FileOutputStream out = new FileOutputStream(picName);
            ImageIO.write((RenderedImage)bufImage, "jpeg", out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.out.println("createBigJPG Failed!");
            e.printStackTrace();
        }
    }

    public static void createImage(String str, Font font, File outFile) throws Exception {
        Rectangle2D r = font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        ImageIO.write((RenderedImage)image, "png", outFile);
    }

    public static void combineImage(List<String> urlList, int width, int height, String destPath, String imgFormat) throws IOException {
        BufferedImage combinedImage = new BufferedImage(width, height, 2);
        Graphics g = combinedImage.getGraphics();
        for (String urlStr : urlList) {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(10000);
            InputStream in = conn.getInputStream();
            BufferedImage image = ImageIO.read(in);
            g.drawImage(image, 0, 0, width, height, null);
        }
        ImageIO.write((RenderedImage)combinedImage, imgFormat, new File(destPath));
    }
}

