/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.tscx.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.query.StatQueryNodeFilterDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.dto.query.StatMethodEnum;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.onemap.tscx.service.MapServerDatabaseService;
import com.geoway.ns.onemap.tscx.service.impl.GeoJsonUtil;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MapServerDatabaseServiceImpl
implements MapServerDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(MapServerDatabaseServiceImpl.class);
    @Resource
    DataSourceService dataSourceService;

    @Override
    public DataQueryResult queryGeoDataset(String datasetId, QueryFilterDTO queryFilterDTO) {
        int end;
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
        String serviceUrl = this.getQueryServiceUrl(serviceDatasetDTO.getServiceUrl());
        String result = HttpUtil.get((String)serviceUrl, this.getQueryParam(queryFilterDTO, false, false));
        log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String oidFieldName = this.getOIDField(jsonObject.getJSONArray("fields"));
        List<FeatureResult> featureResults = this.praseFeatureResult(jsonObject.getJSONArray("features"), oidFieldName);
        List<ReturnField> returnFields = this.praseReturnField(jsonObject.getJSONArray("fields"));
        DataQueryResult dataQueryResult = new DataQueryResult();
        dataQueryResult.setId(datasetId);
        dataQueryResult.setAliasName(datasetDTO.getAliasName());
        dataQueryResult.setName(datasetDTO.getName());
        dataQueryResult.setFields(returnFields);
        dataQueryResult.setTotal(Long.valueOf(featureResults.stream().count()));
        int start = queryFilterDTO.getPageIndex() * queryFilterDTO.getRows();
        int n = end = start + queryFilterDTO.getRows() > featureResults.size() ? featureResults.size() : start + queryFilterDTO.getRows();
        if (start > featureResults.size()) {
            dataQueryResult.setData(null);
        } else {
            dataQueryResult.setData(featureResults.subList(start, end));
        }
        return dataQueryResult;
    }

    @Override
    public DataQueryResult queryGeoDataset(String datasetId, String objectId) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
        String serviceUrl = this.getQueryServiceUrl(serviceDatasetDTO.getServiceUrl());
        String result = HttpUtil.get((String)serviceUrl, this.getQueryParam(objectId));
        log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String oidFieldName = this.getOIDField(jsonObject.getJSONArray("fields"));
        List<FeatureResult> featureResults = this.praseFeatureResult(jsonObject.getJSONArray("features"), oidFieldName);
        List<ReturnField> returnFields = this.praseReturnField(jsonObject.getJSONArray("fields"));
        DataQueryResult dataQueryResult = new DataQueryResult();
        dataQueryResult.setId(datasetId);
        dataQueryResult.setAliasName(datasetDTO.getAliasName());
        dataQueryResult.setName(datasetDTO.getName());
        dataQueryResult.setFields(returnFields);
        dataQueryResult.setTotal(Long.valueOf(featureResults.stream().count()));
        dataQueryResult.setData(featureResults);
        return dataQueryResult;
    }

    private String getQueryServiceUrl(String serviceUrl) {
        String[] strUrls = serviceUrl.split("\\?", 2);
        String url = "";
        url = strUrls.length > 1 ? strUrls[0] + "/0/query?" + strUrls[1] : strUrls[0] + "/0/query?";
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        return url;
    }

    @Override
    public List<CatalogDataNodeFieldsDTO> queryDataNodeFields(String datasetId, Boolean onlyNumber) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
        String serviceUrl = this.getQueryServiceUrl(serviceDatasetDTO.getServiceUrl());
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setRows(Integer.valueOf(10));
        queryFilterDTO.setPageIndex(Integer.valueOf(0));
        queryFilterDTO.setCondition("1=2");
        queryFilterDTO.setFields("*");
        String result = HttpUtil.get((String)serviceUrl, this.getQueryParam(queryFilterDTO, false, false));
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        List<CatalogDataNodeFieldsDTO> results = this.praseCatalogDataNodeFields(jsonObject.getJSONArray("fields"));
        List fields = ListUtil.findAll(results, f -> {
            FieldType type = FieldType.getByValue((Integer)f.getFieldType());
            switch (type) {
                case String: 
                case Unknown: 
                case Boolean: 
                case Byte: 
                case DateTime: 
                case Blob: 
                case Text: 
                case OID: {
                    return onlyNumber == false;
                }
                case Short: 
                case Int: 
                case Long: 
                case Float: 
                case Double: 
                case Decimal: {
                    return true;
                }
            }
            return false;
        });
        return fields;
    }

    @Override
    public Long queryDataCount(String datasetId, QueryFilterDTO queryFilterDTO) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
        String serviceUrl = this.getQueryServiceUrl(serviceDatasetDTO.getServiceUrl());
        String result = HttpUtil.get((String)serviceUrl, this.getQueryParam(queryFilterDTO, true, false));
        log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        return jsonObject.getLong("count");
    }

    @Override
    public List<Object> queryDataFieldUniqValues(String datasetId, QueryFilterDTO queryFilterDTO, int limit) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
        String serviceUrl = this.getQueryServiceUrl(serviceDatasetDTO.getServiceUrl());
        String result = HttpUtil.get((String)serviceUrl, this.getQueryParam(queryFilterDTO, false, true));
        log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        List<FeatureResult> featureResults = this.praseFeatureResult(jsonObject.getJSONArray("features"), "");
        return featureResults.stream().map(f -> f.getAttributes().values().stream().collect(Collectors.toList()).get(0)).filter(f -> f != null).distinct().collect(Collectors.toList());
    }

    @Override
    public List<StatQueryResultDTO> queryStatMulti(String datasetId, StatQueryNodeFilterDTO statQueryNodeFilterDTO) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
        String serviceUrl = this.getQueryServiceUrl(serviceDatasetDTO.getServiceUrl());
        String result = HttpUtil.get((String)serviceUrl, this.getQueryParam(statQueryNodeFilterDTO));
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        List<FeatureResult> featureResults = this.praseFeatureResult(jsonObject.getJSONArray("features"), "");
        ArrayList<StatQueryResultDTO> resultDTOS = new ArrayList<StatQueryResultDTO>();
        List groupByFields = Arrays.stream(statQueryNodeFilterDTO.getGroupBy().split(",")).collect(Collectors.toList());
        for (FeatureResult featureResult : featureResults) {
            StatQueryResultDTO statQueryResultDTO = new StatQueryResultDTO();
            HashMap values = new HashMap();
            HashMap groups = new HashMap();
            statQueryResultDTO.setGroups(groups);
            statQueryResultDTO.setValues(values);
            for (Map.Entry kv : featureResult.getAttributes().entrySet()) {
                if (groupByFields.stream().filter(f -> f.toLowerCase().equals(((String)kv.getKey()).toLowerCase())).count() > 0L) {
                    groups.put(kv.getKey(), kv.getValue() == null ? "" : kv.getValue().toString());
                    continue;
                }
                values.put(kv.getKey(), Double.parseDouble(kv.getValue().toString()));
            }
            resultDTOS.add(statQueryResultDTO);
        }
        return resultDTOS;
    }

    private String getOIDField(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!jsonObject.getString("type").equals("esriFieldTypeOID")) continue;
            return jsonObject.getString("name");
        }
        return "";
    }

    private List<FeatureResult> praseFeatureResult(JSONArray jsonArray, String oidField) {
        ArrayList<FeatureResult> featureResults = new ArrayList<FeatureResult>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            FeatureResult featureResult = new FeatureResult();
            JSONObject attrsJSONObject = jsonObject.getJSONObject("attributes");
            HashMap attributes = new HashMap();
            featureResult.setAttributes(attributes);
            for (Map.Entry entry : attrsJSONObject.entrySet()) {
                attributes.put(entry.getKey(), entry.getValue());
                if (!((String)entry.getKey()).equals(oidField)) continue;
                featureResult.setObjectId(entry.getValue());
            }
            JSONObject geometryJsonObject = jsonObject.getJSONObject("geometry");
            if (geometryJsonObject != null) {
                featureResult.setGeometry(this.praseGeometry(geometryJsonObject).toText());
            }
            featureResults.add(featureResult);
        }
        return featureResults;
    }

    public static void main(String[] args) {
        String json = FileUtil.readString((String)"C:\\Users\\Administrator\\Desktop\\testjson.txt", (Charset)Charset.defaultCharset());
        JSONObject jsonObject3 = JSONObject.parseObject((String)json);
        JSONArray jsonArray = jsonObject3.getJSONArray("features");
        ArrayList<FeatureResult> featureResults = new ArrayList<FeatureResult>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            FeatureResult featureResult = new FeatureResult();
            JSONObject attrsJSONObject = jsonObject.getJSONObject("attributes");
            HashMap attributes = new HashMap();
            featureResult.setAttributes(attributes);
            for (Map.Entry entry : attrsJSONObject.entrySet()) {
                attributes.put(entry.getKey(), entry.getValue());
            }
            featureResults.add(featureResult);
        }
    }

    public JSONObject praseGeoJson(String wkt) {
        JSONObject wkidObj = new JSONObject();
        wkidObj.put("wkid", (Object)"4490");
        JSONObject rings = new JSONObject();
        JSONObject geoJSon = null;
        try {
            geoJSon = GeoJsonUtil.parsePolygon2Geojson(GeoJsonUtil.toGeometry(wkt));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        JSONArray coordinates = geoJSon.getJSONArray("coordinates");
        rings.put("rings", (Object)coordinates);
        return rings;
    }

    public Geometry praseGeometry(JSONObject dkJSONObj) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        JSONArray dkRings = (JSONArray)dkJSONObj.get((Object)"rings");
        Object dkGeometry = null;
        for (int j = 0; j < dkRings.size(); ++j) {
            JSONArray ring = (JSONArray)dkRings.get(j);
            Coordinate[] coords = new Coordinate[ring.size()];
            for (int k = 0; k < ring.size(); ++k) {
                Coordinate coord;
                JSONArray coordinateArr = ring.getJSONArray(k);
                coords[k] = coord = new Coordinate(coordinateArr.getDouble(0).doubleValue(), coordinateArr.getDouble(1).doubleValue());
            }
            Polygon polygon = geometryFactory.createPolygon(coords);
            dkGeometry = dkGeometry == null ? polygon : (dkGeometry.contains((Geometry)polygon) ? dkGeometry.difference((Geometry)polygon) : dkGeometry.union((Geometry)polygon));
        }
        return dkGeometry;
    }

    private List<ReturnField> praseReturnField(JSONArray jsonArray) {
        ArrayList<ReturnField> returnFields = new ArrayList<ReturnField>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ReturnField returnField = new ReturnField();
            returnField.setAlias(jsonObject.getString("alias"));
            returnField.setName(jsonObject.getString("name"));
            returnFields.add(returnField);
        }
        return returnFields;
    }

    private List<CatalogDataNodeFieldsDTO> praseCatalogDataNodeFields(JSONArray jsonArray) {
        ArrayList<CatalogDataNodeFieldsDTO> catalogDataNodeFields = new ArrayList<CatalogDataNodeFieldsDTO>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            CatalogDataNodeFieldsDTO catalogDataNodeFieldsDTO = new CatalogDataNodeFieldsDTO();
            catalogDataNodeFieldsDTO.setAliasName(jsonObject.getString("alias"));
            catalogDataNodeFieldsDTO.setName(jsonObject.getString("name"));
            catalogDataNodeFieldsDTO.setDisplay(Boolean.valueOf(true));
            catalogDataNodeFieldsDTO.setOrder(Integer.valueOf(i));
            switch (jsonObject.getString("type")) {
                case "esriFieldTypeOID": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.OID.getValue()));
                    break;
                }
                case "esriFieldTypeBigInteger": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Long.getValue()));
                    break;
                }
                case "esriFieldTypeBlob": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Byte.getValue()));
                    break;
                }
                case "esriFieldTypeDate": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.DateTime.getValue()));
                    break;
                }
                case "esriFieldTypeDouble": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Double.getValue()));
                    break;
                }
                case "esriFieldTypeGeometry": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Shape.getValue()));
                    break;
                }
                case "esriFieldTypeGlobalID": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.String.getValue()));
                    break;
                }
                case "esriFieldTypeGUID": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.String.getValue()));
                    break;
                }
                case "esriFieldTypeInteger": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Int.getValue()));
                    break;
                }
                case "esriFieldTypeRaster": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Unknown.getValue()));
                    break;
                }
                case "esriFieldTypeSingle": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Float.getValue()));
                    break;
                }
                case "esriFieldTypeSmallInteger": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.Short.getValue()));
                    break;
                }
                case "esriFieldTypeString": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.String.getValue()));
                    break;
                }
                case "esriFieldTypeXML": {
                    catalogDataNodeFieldsDTO.setFieldType(Integer.valueOf(FieldType.String.getValue()));
                }
            }
            catalogDataNodeFields.add(catalogDataNodeFieldsDTO);
        }
        return catalogDataNodeFields;
    }

    private Map<String, Object> getQueryParam(String objectId) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("where", URLEncoder.encode("", "UTF-8"));
            map.put("text", "");
            map.put("objectIds", objectId);
            map.put("time", "");
            map.put("geometryType", "esriGeometryPolygon");
            map.put("inSR", "");
            map.put("spatialRel", "esriSpatialRelIntersects");
            map.put("relationParam", "");
            map.put("outFields", "*");
            map.put("returnGeometry", true);
            map.put("maxAllowableOffset", "");
            map.put("geometryPrecision", "");
            map.put("outSR", "");
            map.put("returnIdsOnly", false);
            map.put("returnCountOnly", false);
            map.put("orderByFields", "");
            map.put("groupByFieldsForStatistics", "");
            map.put("outStatistics", "");
            map.put("returnZ", false);
            map.put("returnM", false);
            map.put("gdbVersion", "");
            map.put("returnDistinctValues", false);
            map.put("f", "pjson");
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> getQueryParam(QueryFilterDTO queryFilterDTO, boolean returnCountOnly, boolean returnDistinctValues) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String where = queryFilterDTO.getCondition();
            if (StrUtil.isBlank((CharSequence)where)) {
                where = "1=1";
            }
            map.put("where", URLEncoder.encode(where, "UTF-8"));
            map.put("text", "");
            map.put("objectIds", "");
            map.put("time", "");
            String geometry = queryFilterDTO.getGeometry();
            if (queryFilterDTO.getGeometryList() != null && queryFilterDTO.getGeometryList().size() > 0) {
                geometry = (String)queryFilterDTO.getGeometryList().get(0);
            }
            if (StrUtil.isBlank((CharSequence)geometry)) {
                map.put("geometry", "");
            } else {
                map.put("geometry", URLEncoder.encode(this.praseGeoJson(geometry).toString(), "UTF-8"));
            }
            map.put("geometryType", "esriGeometryPolygon");
            map.put("inSR", "");
            map.put("spatialRel", "esriSpatialRelIntersects");
            map.put("relationParam", "");
            if (StrUtil.isBlank((CharSequence)queryFilterDTO.getFields())) {
                map.put("outFields", "*");
            } else {
                map.put("outFields", queryFilterDTO.getFields());
            }
            map.put("returnGeometry", queryFilterDTO.getReturnGeometry());
            map.put("maxAllowableOffset", "");
            map.put("geometryPrecision", "");
            map.put("outSR", "");
            map.put("returnIdsOnly", false);
            map.put("returnCountOnly", returnCountOnly);
            map.put("orderByFields", "");
            map.put("groupByFieldsForStatistics", "");
            map.put("outStatistics", "");
            map.put("returnZ", false);
            map.put("returnM", false);
            map.put("gdbVersion", "");
            map.put("returnDistinctValues", returnDistinctValues);
            map.put("f", "pjson");
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> getQueryParam(StatQueryNodeFilterDTO statDTO) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String where = statDTO.getCondition();
            if (StrUtil.isBlank((CharSequence)where)) {
                where = "1=1";
            }
            map.put("where", URLEncoder.encode(where, "UTF-8"));
            map.put("text", "");
            map.put("objectIds", "");
            map.put("time", "");
            String geometry = statDTO.getGeometry();
            if (statDTO.getGeometryList() != null && statDTO.getGeometryList().size() > 0) {
                geometry = (String)statDTO.getGeometryList().get(0);
            }
            if (StrUtil.isBlank((CharSequence)geometry)) {
                map.put("geometry", "");
            } else {
                map.put("geometry", URLEncoder.encode(this.praseGeoJson(geometry).toString(), "UTF-8"));
            }
            map.put("geometryType", "esriGeometryPolygon");
            map.put("inSR", "");
            map.put("spatialRel", "esriSpatialRelIntersects");
            map.put("relationParam", "");
            if (StrUtil.isBlank((CharSequence)statDTO.getFields())) {
                map.put("outFields", "*");
            } else {
                map.put("outFields", statDTO.getFields());
            }
            map.put("returnGeometry", false);
            map.put("maxAllowableOffset", "");
            map.put("geometryPrecision", "");
            map.put("outSR", "");
            map.put("returnIdsOnly", false);
            map.put("returnCountOnly", false);
            map.put("orderByFields", "");
            map.put("groupByFieldsForStatistics", statDTO.getGroupBy());
            JSONArray jsonArray = new JSONArray();
            for (String statField : statDTO.getFields().split(",")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("onStatisticField", (Object)statField);
                jsonObject.put("outStatisticFieldName", (Object)statField);
                StatMethodEnum statMethodEnum = StatMethodEnum.getByValue((Integer)statDTO.getStatMethod());
                switch (statMethodEnum) {
                    case Number: {
                        jsonObject.put("statisticType", (Object)"count");
                        break;
                    }
                    case Sum: {
                        jsonObject.put("statisticType", (Object)"sum");
                        break;
                    }
                    case Max: {
                        jsonObject.put("statisticType", (Object)"max");
                        break;
                    }
                    case Min: {
                        jsonObject.put("statisticType", (Object)"min");
                        break;
                    }
                    case Average: {
                        jsonObject.put("statisticType", (Object)"avg");
                        break;
                    }
                    case UniqueNumber: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7edf\u8ba1\u7c7b\u578b:" + StatMethodEnum.UniqueNumber.getDesc());
                    }
                }
                jsonArray.add((Object)jsonObject);
            }
            map.put("outStatistics", URLEncoder.encode(jsonArray.toJSONString()));
            map.put("returnZ", false);
            map.put("returnM", false);
            map.put("gdbVersion", "");
            map.put("returnDistinctValues", false);
            map.put("f", "pjson");
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

