CREATE TABLE "tb_biz_data_analysis"
(
    "f_id"                varchar(36) NOT NULL,
    "f_title"             varchar(100),
    "f_desc"              varchar(200),
    "f_map_source"        varchar(255),
    "f_image"             varchar(255),
    "f_server_name"       varchar(255),
    "f_server_id"         varchar(36),
    "f_diagramjson"       text,
    "f_server_status"     varchar(36),
    "f_create_time"       timestamp(6),
    "f_update_time"       timestamp(6),
    "f_server_model_id"   varchar(36),
    "f_server_task_id"    varchar(36),
    "f_server_task_state" varchar(36),
    "f_store"             int4,
    "f_openparammetas"    text,
    "f_map_source_type"   varchar(32),
    "f_publisher"         varchar(32),
    "f_publish_date"      timestamp(6),
    "f_related_data"      varchar(255),
    CONSTRAINT "tb_biz_data_analysis_pk" PRIMARY KEY ("f_id")
)
;

CREATE INDEX "tb_biz_data_analysis_f_id_idx" ON "tb_biz_data_analysis" USING btree (
    "f_id" "pg_catalog"."text_ops" ASC NULLS LAST
    );

CREATE INDEX "tb_biz_data_analysis_f_server_id_idx" ON "tb_biz_data_analysis" USING btree (
    "f_server_id" "pg_catalog"."text_ops" ASC NULLS LAST
    );

COMMENT
ON COLUMN "tb_biz_data_analysis"."f_map_source_type" IS '数据分析地图源类型';

COMMENT
ON COLUMN "tb_biz_data_analysis"."f_publisher" IS '发布人';

COMMENT
ON COLUMN "tb_biz_data_analysis"."f_publish_date" IS '发布时间';

COMMENT
ON COLUMN "tb_biz_data_analysis"."f_related_data" IS '相关数据';


CREATE TABLE "tb_biz_data_analysis_chart"
(
    "f_id"               varchar(64) NOT NULL,
    "f_data_analysis_id" varchar(64) NOT NULL,
    "f_title"            varchar(250),
    "f_type"             varchar(64),
    "f_params"           text,
    "f_create_time"      timestamp(6),
    "f_update_time"      timestamp(6),
    CONSTRAINT "tb_biz_data_analysis_chart_pk" PRIMARY KEY ("f_id")
)
;

CREATE INDEX "tb_biz_data_analysis_chart_f_id_idx" ON "tb_biz_data_analysis_chart" USING btree (
    "f_id" "pg_catalog"."text_ops" ASC NULLS LAST
    );