CREATE TABLE tb_onemap4_overlay_cache(
    f_id             varchar(50)  NOT NULL,
    f_pid            varchar(50)  NOT NULL,
    f_userid         varchar(50)  NOT NULL,
    f_name           varchar(50)  ,
    f_nodetype       int2         ,
    f_datatype       int2         ,
    f_datarender     text         ,
    f_objectid       varchar(50)  ,
    f_tempauthorization int2 NULL DEFAULT 0,
    f_servertype     varchar(50)  ,
    f_serverurl      varchar(255) ,
    f_offlinewkt     text         ,
    f_offlinesetting text         ,
    f_sort           int2         ,
    CONSTRAINT pk_tb_onemap4_overlay_cache PRIMARY KEY (f_id)
);

INSERT INTO tb_onemap4_overlay_cache
(f_id, f_pid, f_userid, f_name, f_nodetype, f_datatype, f_objectid, f_tempauthorization, f_servertype, f_serverurl, f_offlinewkt, f_offlinesetting)
VALUES('0', '-1', '-1', '默认分组', 1, NULL, NULL, 0, NULL, NULL, NULL, NULL);

COMMENT ON COLUMN tb_onemap4_overlay_cache.f_id IS '对象id';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_pid IS '节点名称';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_userid IS '用户ID';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_name IS '节点名称';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_nodetype IS '节点类型( 1 组节点  2.数据节点）';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_datatype IS '数据类型( 1 服务资源  2.第三方服务 3.离线文件）';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_datarender IS '图层四至、最大最小层级等设置（json）';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_objectid IS '服务资源节点关联ID';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_tempauthorization IS '是否临时授权(1正式授权，0临时授权）';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_servertype IS '第三方服务类型';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_serverurl IS '第三方服务地址';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_offlinewkt IS '离线文件解析wkt字符串';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_offlinesetting IS '离线文件图层颜色、透明度、线宽等设置（json）';
COMMENT ON COLUMN tb_onemap4_overlay_cache.f_sort IS '排序值';