/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.onemap.multidata.dto.DKInfoDTO;
import com.geoway.ns.onemap.multidata.dto.YearLayerInfoDTO;
import com.geoway.ns.onemap.multidata.support.HttpClientPoolUtil;
import com.geoway.ns.onemap.multidata.support.WKTUtil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RecursiveTask;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipImgTask
extends RecursiveTask<Boolean> {
    private static final long serialVersionUID = -2888128865370482082L;
    private final Logger logger = LoggerFactory.getLogger(ClipImgTask.class);
    Double bufferDistince = 0.0;
    private String[] yzfxScreenshotUrls;
    DKInfoDTO dkInfoDTO;
    YearLayerInfoDTO yearLayerItem;
    Map<String, Object> imageParams;

    public ClipImgTask(DKInfoDTO dkInfoDTO, String[] yzfxScreenshotUrls) {
        this.dkInfoDTO = dkInfoDTO;
        this.yzfxScreenshotUrls = yzfxScreenshotUrls;
    }

    private ClipImgTask(YearLayerInfoDTO yearLayerItem, Map<String, Object> params, String[] yzfxScreenshotUrls) {
        this.yearLayerItem = yearLayerItem;
        this.imageParams = params;
        this.yzfxScreenshotUrls = yzfxScreenshotUrls;
    }

    private String geYzfxScreenshotUrl() {
        if (this.yzfxScreenshotUrls != null && this.yzfxScreenshotUrls.length == 1) {
            return this.yzfxScreenshotUrls[0];
        }
        if (this.yzfxScreenshotUrls != null && this.yzfxScreenshotUrls.length > 1) {
            int index = (int)(Math.random() * (double)this.yzfxScreenshotUrls.length);
            return this.yzfxScreenshotUrls[index];
        }
        this.logger.error("yzfxScreenshotUrls\u53c2\u6570\u4e3a\u7a7a");
        return null;
    }

    @Override
    protected Boolean compute() {
        if (this.imageParams != null) {
            System.out.println("\u5f00\u59cb\u6267\u884c\u622a\u56fe\u670d\u52a1");
            String screenshotUrl = this.geYzfxScreenshotUrl();
            BufferedImage imageBase64 = HttpClientPoolUtil.execute4Img(screenshotUrl, HttpClientPoolUtil.getPostListNameValuePair(this.imageParams));
            if (imageBase64 != null) {
                System.out.println("\u56fe\u7247\u4fdd\u5b58\u6210\u529f");
                this.yearLayerItem.setResultImage(imageBase64);
                return true;
            }
            screenshotUrl = this.geYzfxScreenshotUrl();
            imageBase64 = HttpClientPoolUtil.execute4Img(screenshotUrl, HttpClientPoolUtil.getPostListNameValuePair(this.imageParams));
            if (imageBase64 != null) {
                this.yearLayerItem.setResultImage(imageBase64);
                return true;
            }
            return false;
        }
        ArrayList<ClipImgTask> taskList = new ArrayList<ClipImgTask>();
        for (YearLayerInfoDTO yearLayerInfoDTO : this.dkInfoDTO.getYears()) {
            try {
                System.out.println("\u521b\u5efa\u5206\u4efb\u52a1");
                Map<String, Object> params = this.getRequestParam(yearLayerInfoDTO, this.dkInfoDTO.getBoxx(), this.dkInfoDTO.getWkt(), null, null, this.dkInfoDTO.getWidth(), this.dkInfoDTO.getHeight());
                ClipImgTask task = new ClipImgTask(yearLayerInfoDTO, params, this.yzfxScreenshotUrls);
                taskList.add(task);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Boolean computing = null;
        try {
            if (taskList.size() > 0) {
                for (ClipImgTask task : ClipImgTask.invokeAll(taskList)) {
                    if (task == null) continue;
                    if (null == computing) {
                        computing = (Boolean)task.join();
                        continue;
                    }
                    computing = (Boolean)task.join() != false && computing != false;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.warn("\u5e76\u884c\u6267\u884c\u4efb\u52a1:", (Throwable)exception);
        }
        return computing;
    }

    private String getValidFileName(String str) {
        Pattern FilePattern = Pattern.compile("[\\\\/:*?\"<>|]");
        return str == null ? null : FilePattern.matcher(str).replaceAll("");
    }

    protected Map<String, Object> getRequestParam(YearLayerInfoDTO imageParam, String boxxwkt, String xmWkt, String yzfxwkt, String yzfxZYXJwkt, Integer width, Integer height) {
        JSONObject drawJson;
        Geometry boxGeometry = null;
        if (width == null) {
            width = 500;
        }
        if (height == null) {
            height = 500;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)boxxwkt)) {
                boxGeometry = WKTUtil.wktToGeom(boxxwkt);
                boxGeometry = boxGeometry.getEnvelope();
            } else if (StringUtils.isNotEmpty((CharSequence)xmWkt)) {
                Geometry xmGeometry = WKTUtil.wktToGeom(xmWkt);
                boxGeometry = xmGeometry.getEnvelope();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        JSONArray drawJsonArr = new JSONArray();
        if (StringUtils.isNotEmpty((CharSequence)yzfxwkt) && StringUtils.isNotEmpty((CharSequence)yzfxZYXJwkt) && yzfxwkt.equalsIgnoreCase(yzfxZYXJwkt)) {
            drawJson = new JSONObject();
            drawJson.put("wkt", (Object)yzfxwkt);
            drawJson.put("color", (Object)"#00FFFF");
            drawJson.put("transparency", (Object)1);
            drawJson.put("filled", (Object)true);
            drawJson.put("width", (Object)3);
            drawJson.put("dotted", (Object)false);
            drawJson.put("fillColor", (Object)"#00FFFF");
            drawJson.put("fillTransparency", (Object)0.6);
            drawJsonArr.add((Object)drawJson);
            if (StringUtils.isEmpty((CharSequence)boxxwkt)) {
                try {
                    Geometry xmGeometry = WKTUtil.wktToGeom(xmWkt);
                    Geometry yzfxGeometry = WKTUtil.wktToGeom(yzfxwkt);
                    boxGeometry = xmGeometry.union(yzfxGeometry);
                    boxGeometry = boxGeometry.getEnvelope();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)yzfxwkt)) {
                drawJson = new JSONObject();
                drawJson.put("wkt", (Object)yzfxwkt);
                drawJson.put("fillColor", (Object)"#00FFFF");
                drawJson.put("fillTransparency", (Object)0.6);
                drawJson.put("color", (Object)"#00FFFF");
                drawJson.put("transparency", (Object)1);
                drawJson.put("filled", (Object)true);
                drawJson.put("width", (Object)2);
                drawJson.put("dotted", (Object)false);
                drawJsonArr.add((Object)drawJson);
                if (StringUtils.isEmpty((CharSequence)boxxwkt)) {
                    try {
                        Geometry xmGeometry = WKTUtil.wktToGeom(xmWkt);
                        Geometry yzfxGeometry = WKTUtil.wktToGeom(yzfxwkt);
                        boxGeometry = xmGeometry.union(yzfxGeometry);
                        boxGeometry = boxGeometry.getEnvelope();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)yzfxZYXJwkt)) {
                JSONObject drawJsonZY = new JSONObject();
                drawJsonZY.put("wkt", (Object)yzfxZYXJwkt);
                drawJsonZY.put("color", (Object)"#0FFFFF");
                drawJsonZY.put("transparency", (Object)1);
                drawJsonZY.put("filled", (Object)false);
                drawJsonZY.put("width", (Object)3);
                drawJsonZY.put("dotted", (Object)false);
                drawJsonArr.add((Object)drawJsonZY);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)xmWkt)) {
            JSONObject drawJsonXM = new JSONObject();
            drawJsonXM.put("wkt", (Object)xmWkt);
            drawJsonXM.put("color", (Object)"#FF0000");
            drawJsonXM.put("transparency", (Object)1);
            drawJsonXM.put("filled", (Object)false);
            drawJsonXM.put("width", (Object)3);
            drawJsonXM.put("dotted", (Object)true);
            drawJsonArr.add((Object)drawJsonXM);
        }
        if (boxGeometry != null && this.bufferDistince > 0.0) {
            boxGeometry = boxGeometry.buffer(this.bufferDistince.doubleValue()).getEnvelope();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serviceJson", imageParam.getServicejson());
        params.put("boxWkt", WKTUtil.geomToWkt(boxGeometry));
        params.put("color", "#FF0000");
        params.put("drawWidth", 3);
        params.put("width", width);
        params.put("height", height);
        params.put("drawJson", drawJsonArr);
        return params;
    }
}

