/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.encrypttool.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.event.DatasetAfterDataQueryEvent;
import com.geoway.adf.dms.datasource.event.DatasetBeforeDataQueryEvent;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.geoserver3.dto.GLHSResult;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterGLCXQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterLSHSQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterYZFXQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerBeforeDataQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerBeforeLSHSQueryEvent;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.onemap.lshs.entity.TbLSHSTable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"right.dataset-py-enable"}, havingValue="true")
public class DatasetEventListener {
    @Autowired
    private BizEncryptRecordsService bizEncryptRecordsService;
    private static final Logger logger = LoggerFactory.getLogger(DatasetEventListener.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private ResCatalogNodeService resCatalogNodeService;

    @EventListener
    public void handleBeforeDataQueryEvent(DatasetBeforeDataQueryEvent event) {
        block5: {
            QueryFilterBasicDTO queryFilter;
            block6: {
                JSONObject object;
                Boolean offset;
                String nodeId;
                AppCatalogNodeDTO appCatalogNodeDTO;
                AppCatalogDataNodeDTO appCatalogDataNodeDTO;
                String extension;
                System.out.println("Received custom event - " + event);
                queryFilter = event.getQueryFilter();
                if (queryFilter == null || !StringUtils.isNotBlank((CharSequence)(extension = (appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)(appCatalogNodeDTO = this.appCatalogNodeService.getNodeDetail(nodeId = ((FeatureQueryFilterDTO)queryFilter).getNodeId()))).getRender().getExtension())) || !(offset = (object = JSON.parseObject((String)extension)).getBoolean("rectifyOffset")).booleanValue()) break block5;
                List filterGeometrys = queryFilter.getGeometryList();
                if (filterGeometrys == null) break block6;
                ArrayList<String> newFilterGeometrys = new ArrayList<String>();
                for (String filterGeometry : filterGeometrys) {
                    System.out.println(filterGeometry);
                    try {
                        newFilterGeometrys.add(this.bizEncryptRecordsService.wktEncrypt(queryFilter.getGeometry(), EncryptType.Encrypt));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u504f\u8f6c\u6b63\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                break block5;
            }
            if (queryFilter.getGeometry() == null) break block5;
            System.out.println(queryFilter.getGeometry());
            try {
                queryFilter.setGeometry(this.bizEncryptRecordsService.wktEncrypt(queryFilter.getGeometry(), EncryptType.Encrypt));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u504f\u8f6c\u6b63\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    @EventListener
    public void handleAfterDataQueryEvent(DatasetAfterDataQueryEvent event) {
        JSONObject object;
        Boolean offset;
        DatasetDTO dataset;
        String extension;
        System.out.println("Received custom event - " + event);
        DataQueryResult dataQueryResult = event.getDataQueryResult();
        if (dataQueryResult != null && StringUtils.isNotBlank((CharSequence)(extension = (dataset = this.dataSourceService.getDatasetDetailWithoutException(dataQueryResult.getId())).getRender().getExtension())) && (offset = (object = JSON.parseObject((String)extension)).getBoolean("rectifyOffset")).booleanValue()) {
            for (FeatureResult featureResult : dataQueryResult.getData()) {
                System.out.println(featureResult.getGeometry());
                if (featureResult.getGeometry() == null) continue;
                try {
                    featureResult.setGeometry(this.bizEncryptRecordsService.wktEncrypt(featureResult.getGeometry(), EncryptType.Decrypt));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u8bf7\u6c42\u7ed3\u679c\uff0c\u6b63\u8f6c\u504f\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @EventListener
    public void handleGeoServerBeforeDataQueryEvent(GeoServerBeforeDataQueryEvent event) {
    }

    @EventListener
    public void handleGeoServerBeforeLSHSQueryEvent(GeoServerBeforeLSHSQueryEvent event) {
        JSONObject object;
        Boolean offset;
        String extension;
        System.out.println("Received custom event - " + (Object)((Object)event));
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("\u8bf7\u6c42\u5f00\u59cb\u65f6\u95f4: " + now.format(formatter));
        Instant start = Instant.now();
        Map<String, Object> dataQueryResult = event.getQueryFilter();
        List<TbLSHSTable> tbLSHSTables = event.getListTables();
        if (dataQueryResult != null && StringUtils.isNotBlank((CharSequence)(extension = tbLSHSTables.get(0).getRender().getExtension())) && (offset = (object = JSON.parseObject((String)extension)).getBoolean("rectifyOffset")).booleanValue()) {
            List Blocks = (List)dataQueryResult.get("Blocks");
            for (Object block : Blocks) {
                LinkedHashMap blockJson = (LinkedHashMap)block;
                if (blockJson.containsKey("WKT") && StringUtils.isNotEmpty((CharSequence)blockJson.get("WKT").toString())) {
                    try {
                        blockJson.put("WKT", this.bizEncryptRecordsService.wktEncrypt(blockJson.get("WKT").toString(), EncryptType.Encrypt));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u504f\u8f6c\u6b63\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                System.out.println(blockJson.get("WKT"));
                System.out.println(blockJson.get("GeoJSON"));
            }
            dataQueryResult.put("Blocks", Blocks);
            System.out.println("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0 + "\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u504f\u79fb\u6570\u636e\u91cf" + Blocks.size());
        }
    }

    @EventListener
    public void handleGeoServerAfterYZFXQueryEvent(GeoServerAfterYZFXQueryEvent event) {
    }

    @EventListener
    public void handleGeoServerAfterGLCXQueryEvent(GeoServerAfterGLCXQueryEvent event) {
    }

    @EventListener
    public void handleGeoServerAfterLSHSQueryEvent(GeoServerAfterLSHSQueryEvent event) {
        JSONObject object;
        Boolean offset;
        String extension;
        System.out.println("Received custom event - " + (Object)((Object)event));
        Instant start = Instant.now();
        List<GLHSResult> dataQueryResults = event.getDataQueryResult();
        List<TbLSHSTable> tbLSHSTables = event.getListTables();
        Map<String, Object> dataQueryResult = event.getQueryFilter();
        if (dataQueryResults != null && dataQueryResults.size() > 0 && StringUtils.isNotBlank((CharSequence)(extension = tbLSHSTables.get(0).getRender().getExtension())) && (offset = (object = JSON.parseObject((String)extension)).getBoolean("rectifyOffset")).booleanValue()) {
            ArrayList<String> blockList = new ArrayList<String>();
            List Blocks = (List)dataQueryResult.get("Blocks");
            for (Object block : Blocks) {
                LinkedHashMap blockJson = (LinkedHashMap)block;
                if (blockJson.containsKey("WKT") && StringUtils.isNotEmpty((CharSequence)blockJson.get("WKT").toString())) {
                    try {
                        blockList.add(blockJson.get("WKT").toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u8bf7\u6c42\u53c2\u6570\uff0c\u6b63\u8f6c\u504f\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                System.out.println(blockJson.get("WKT"));
                System.out.println(blockJson.get("GeoJSON"));
            }
            dataQueryResults.forEach(p -> p.setBlocks((Object)blockList.toArray()));
            System.out.println("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0 + "\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u504f\u79fb\u6570\u636e\u91cf" + dataQueryResults.size());
        }
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("\u5386\u53f2\u56de\u6eaf\u7ed3\u675f\u65f6\u95f4: " + now.format(formatter));
    }
}

