/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.ztfx.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.geoserver3.dto.GLFXResult;
import com.geoway.ns.geoserver3.service.IGLFXService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.onemap.encrypttool.event.GeoServerAfterYZFXQueryEvent;
import com.geoway.ns.onemap.encrypttool.event.GeoServerBeforeDataQueryEvent;
import com.geoway.ns.onemap.ztfx.dto.SingleZTFXRequestData;
import com.geoway.ns.onemap.ztfx.dto.SingleZTFXResult;
import com.geoway.ns.onemap.ztfx.dto.VersionTableMapping;
import com.geoway.ns.onemap.ztfx.dto.ZTFXGraphAndFields;
import com.geoway.ns.onemap.ztfx.dto.ZTFXRequestData;
import com.geoway.ns.onemap.ztfx.dto.ZTFXResultDetail;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXCatalog;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXScheme;
import com.geoway.ns.onemap.ztfx.entity.ZtfxSchemeUser;
import com.geoway.ns.onemap.ztfx.mapper.TbZTFXSchemeMapper;
import com.geoway.ns.onemap.ztfx.mapper.ZtfxSchemeUserMapper;
import com.geoway.ns.onemap.ztfx.service.TbZTFXCatalogService;
import com.geoway.ns.onemap.ztfx.service.TbZTFXSchemeService;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysPowerEnum;
import com.geoway.ns.sys.exception.ServiceException;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.SysPowerService;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.github.yulichang.wrapper.JoinAbstractLambdaWrapper;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TbZTFXSchemeServiceImpl
extends ServiceImpl<TbZTFXSchemeMapper, TbZTFXScheme>
implements TbZTFXSchemeService {
    private final String ztfx_service_name = "onemap4-ztfx";
    private final String ztfx_service_alias = "\u4e00\u5f20\u56fe4.0-\u4e13\u9898\u5206\u6790\uff08\u8bf7\u52ff\u624b\u52a8\u5220\u9664\u548c\u505c\u6b62\uff09";
    @Value(value="${cloud.query.defaultUserid:''}")
    private String defaultUserid;
    @Resource
    private ITokenService tokenService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;
    @Autowired
    private TbZTFXSchemeMapper ztfxSchemeMapper;
    @Autowired
    private TbZTFXCatalogService ztfxCatalogService;
    @Autowired
    private IGLFXService glfxService;
    @Autowired
    private IYZFXService yzfxService;
    @Resource
    ZtfxSchemeUserMapper ztfxSchemeUserMapper;
    @Value(value="${geoserver.custom-analysis:true}")
    private Boolean customAnalysis;
    @Autowired
    UserClient userClient;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private SysPowerService sysPowerService;

    @Override
    public boolean saveOrUpdateInfo(TbZTFXScheme ztfxScheme) {
        TbZTFXScheme originDefault;
        if (StringUtils.isBlank((CharSequence)ztfxScheme.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)ztfxScheme.getAlias())) {
            ztfxScheme.setAlias(ztfxScheme.getName());
        }
        if (ztfxScheme.getIsDefault() == null) {
            ztfxScheme.setIsDefault(0);
        }
        if (ztfxScheme.getIsDefault().equals(1) && (originDefault = (TbZTFXScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(TbZTFXScheme.class).eq(TbZTFXScheme::getIsDefault, (Object)1))) != null) {
            originDefault.setIsDefault(0);
            this.updateById(originDefault);
        }
        TbZTFXScheme exist = (TbZTFXScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(TbZTFXScheme.class).eq(TbZTFXScheme::getName, (Object)ztfxScheme.getName()));
        if (StringUtils.isEmpty((CharSequence)ztfxScheme.getId())) {
            if (exist != null) {
                throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728");
            }
            Integer order = this.ztfxSchemeMapper.selectMaxOrder();
            order = order == null ? 1 : order + 1;
            ztfxScheme.setOrder(order);
            return this.save(ztfxScheme);
        }
        if (exist != null && !exist.getId().equals(ztfxScheme.getId())) {
            throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728");
        }
        return this.updateById(ztfxScheme);
    }

    @Override
    public List<TbZTFXScheme> queryList(String group) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(TbZTFXScheme.class).orderByAsc(TbZTFXScheme::getOrder);
        if (StringUtils.isNotEmpty((CharSequence)group)) {
            wrapper.eq(TbZTFXScheme::getGroup, (Object)group);
        }
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<TbZTFXScheme> listByUser() throws Exception {
        SysUserDTO sysUser = this.tokenService.queryCurrentSysUserWithNull();
        Assert.isTrue((sysUser != null ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List lshs = this.sysPowerService.selectByToken(SysPowerEnum.YZFX.value, sysUser.getRoles().stream().map(SimpleRole::getId).map(String::valueOf).collect(Collectors.toList()), sysUser.getId());
        List lhsIds = lshs.stream().map(sysPower -> sysPower.getMandateId()).collect(Collectors.toList());
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        String finalUserId = sysUser.getId();
        queryWrapper.leftJoin(ZtfxSchemeUser.class, on -> (JoinAbstractLambdaWrapper)((JoinAbstractLambdaWrapper)on.eq(TbZTFXScheme::getId, ZtfxSchemeUser::getPlanId)).eq(ZtfxSchemeUser::getUserId, (Object)finalUserId));
        queryWrapper.eq(ZtfxSchemeUser::getUserId, (Object)finalUserId);
        if (lhsIds != null && lhsIds.size() > 0) {
            ((MPJLambdaWrapper)queryWrapper.or()).in(TbZTFXScheme::getId, lhsIds);
        }
        queryWrapper.orderByAsc(TbZTFXScheme::getOrder);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public TbZTFXScheme queryDefault() {
        return (TbZTFXScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(TbZTFXScheme.class).eq(TbZTFXScheme::getIsDefault, (Object)1));
    }

    @Override
    public boolean setDefault(String id) {
        TbZTFXScheme originDefault = (TbZTFXScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(TbZTFXScheme.class).eq(TbZTFXScheme::getIsDefault, (Object)1));
        if (originDefault != null) {
            originDefault.setIsDefault(0);
            this.updateById(originDefault);
        }
        TbZTFXScheme tbZTFXScheme = (TbZTFXScheme)this.getById((Serializable)((Object)id));
        tbZTFXScheme.setIsDefault(1);
        return this.updateById(tbZTFXScheme);
    }

    @Override
    public boolean deleteById(String id) {
        this.ztfxCatalogService.deleteBySchemeId(id);
        return this.removeById((Serializable)((Object)id));
    }

    @Override
    public SingleZTFXResult singleAnalysis(SingleZTFXRequestData requestData) {
        this.checkSingleZTFXRequestData(requestData);
        HashMap<String, Object> geoserverRequestParams = new HashMap<String, Object>();
        geoserverRequestParams.put("AnalysisID", requestData.getAnalysisId());
        geoserverRequestParams.put("Blocks", requestData.getBlocks());
        geoserverRequestParams.put("saverecord", true);
        geoserverRequestParams.put("SFFHTX", true);
        geoserverRequestParams.put("unCovered", false);
        geoserverRequestParams.put("YearMonth", requestData.getYear());
        JSONObject yzfxResponse = new JSONObject();
        VersionTableMapping curVersion = VersionTableMapping.findByYear(requestData.getTbZTFXCatalog().getVersionTableMappings(), requestData.getYear());
        if ("geoserver".equalsIgnoreCase(requestData.getTbZTFXCatalog().getServiceType()) && StringUtils.isNotEmpty((CharSequence)requestData.getTbZTFXCatalog().getUrl())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)requestData.getTbZTFXCatalog().getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)requestData.getTbZTFXCatalog().getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            requestData.getTbZTFXCatalog().getOtherParams();
            yzfxResponse = this.yzfxService.analysis(requestData.getTbZTFXCatalog().getUrl(), geoserverRequestParams, applicationGuid, accessKey);
        } else if (this.customAnalysis.booleanValue()) {
            ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
            if (resCatalogDataNodeDTO == null) {
                throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
            String dataUrl = "geoserver:" + featureDatasetDTO.getDsKey() + "/" + featureDatasetDTO.getFullName().replace(".", "/");
            JSONObject customAnalysisItem = new JSONObject();
            JSONArray analysisDatas = new JSONArray();
            JSONObject analysisData = new JSONObject();
            analysisData.put("dataType", (Object)"default");
            analysisData.put("fields", null);
            analysisData.put("whereClause", null);
            analysisData.put("dataUrl", (Object)dataUrl);
            analysisDatas.add((Object)analysisData);
            customAnalysisItem.put("analysisDatas", (Object)analysisDatas);
            customAnalysisItem.put("analysisAlgorithm", (Object)requestData.getTbZTFXCatalog().getCustomServiceClass());
            customAnalysisItem.put("analysisItemName", null);
            geoserverRequestParams.put("customAnalysisItem", customAnalysisItem);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerBeforeDataQueryEvent(this, geoserverRequestParams));
            yzfxResponse = this.yzfxService.analysis(geoserverRequestParams, "custom-datasource");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerAfterYZFXQueryEvent(this, yzfxResponse));
        } else if (StringUtils.isNotEmpty((CharSequence)requestData.getTbZTFXCatalog().getServiceId())) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerBeforeDataQueryEvent(this, geoserverRequestParams));
            yzfxResponse = this.yzfxService.analysis(geoserverRequestParams, requestData.getTbZTFXCatalog().getServiceName());
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeoServerAfterYZFXQueryEvent(this, yzfxResponse));
        }
        if (!yzfxResponse.getInteger("StatusCode").equals(200)) {
            this.log.error(yzfxResponse.getString("Message"));
            throw new RuntimeException(yzfxResponse.getString("Message"));
        }
        SingleZTFXResult ztfxResult = new SingleZTFXResult();
        ztfxResult.setCatalogId(requestData.getCatalogId());
        ztfxResult.setCatalogName(requestData.getTbZTFXCatalog().getName());
        ztfxResult.setYear(requestData.getYear());
        ztfxResult.setUniqueTaskId(yzfxResponse.getString("UniqueTaskID"));
        ztfxResult.setResults(yzfxResponse.getJSONArray("Results"));
        ZTFXGraphAndFields ztfxGraphAndFields = this.ztfxCatalogService.queryDisplayConfig(requestData.getCatalogId());
        ztfxResult.setGraph(ztfxGraphAndFields.getGraph());
        ztfxResult.setFields(ztfxGraphAndFields.getFields());
        DatasetRenderDTO renderDTO = this.resCatalogService.getNodeRender(curVersion.getNodeId());
        ztfxResult.setRender(renderDTO);
        return ztfxResult;
    }

    private void checkZTFXRequestData(ZTFXRequestData requestData) {
        if (requestData == null) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (requestData.getBlocks() == null || requestData.getBlocks().size() == 0) {
            throw new RuntimeException("\u5206\u6790\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (requestData.getAnalysisItems() == null || requestData.getAnalysisItems().size() == 0) {
            throw new RuntimeException("\u5206\u6790\u9879\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TbZTFXCatalog tbZTFXCatalog = null;
        for (ZTFXRequestData.AnalysisItem analysisItem : requestData.getAnalysisItems()) {
            tbZTFXCatalog = this.ztfxCatalogService.queryDetail(analysisItem.getCatalogId(), false);
            if (tbZTFXCatalog == null || !tbZTFXCatalog.getType().equals(2)) {
                throw new RuntimeException("\u5206\u6790\u9879\u8bbe\u7f6e\u9519\u8bef\uff1a\u5206\u6790\u9879\u4e0d\u5b58\u5728\u6216\u8005\u5206\u6790\u9879\u7c7b\u578b\u4e0d\u5bf9!");
            }
            if (tbZTFXCatalog.getVersionTableMappings() == null || tbZTFXCatalog.getVersionTableMappings().size() == 0) {
                throw new RuntimeException("\u5206\u6790\u9879\u3010" + tbZTFXCatalog.getName() + "\u3011\u7684\u5206\u6790\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (analysisItem.getYears() == null || analysisItem.getYears().size() == 0) {
                throw new RuntimeException("\u5206\u6790\u9879\u3010" + tbZTFXCatalog.getName() + "\u3011\u7684\u5f85\u5206\u6790\u7248\u672c\u672a\u8bbe\u7f6e\uff01");
            }
            analysisItem.setTbZTFXCatalog(tbZTFXCatalog);
        }
    }

    private void checkSingleZTFXRequestData(SingleZTFXRequestData requestData) {
        if (requestData == null) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (requestData.getBlocks() == null || requestData.getBlocks().size() == 0) {
            throw new RuntimeException("\u5206\u6790\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)requestData.getCatalogId())) {
            throw new RuntimeException("\u5206\u6790ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TbZTFXCatalog tbZTFXCatalog = this.ztfxCatalogService.queryDetail(requestData.getCatalogId(), false);
        if (tbZTFXCatalog == null || !tbZTFXCatalog.getType().equals(2)) {
            throw new RuntimeException("\u5206\u6790\u9879\u8bbe\u7f6e\u9519\u8bef\uff1a\u5206\u6790\u9879\u4e0d\u5b58\u5728\u6216\u8005\u5206\u6790\u9879\u7c7b\u578b\u4e0d\u5bf9!");
        }
        if (tbZTFXCatalog.getVersionTableMappings() == null || tbZTFXCatalog.getVersionTableMappings().size() == 0) {
            throw new RuntimeException("\u5206\u6790\u9879\u3010" + tbZTFXCatalog.getName() + "\u3011\u7684\u5206\u6790\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        requestData.setTbZTFXCatalog(tbZTFXCatalog);
    }

    private Map convertToGeoserverRequestMap(ZTFXRequestData requestData) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("AnalysisID", requestData.getAnalysisId());
        requestParams.put("Blocks", requestData.getBlocks());
        ArrayList geoserverAnalysisItems = new ArrayList();
        HashMap<String, String> geoserverAnalysisItem = null;
        for (ZTFXRequestData.AnalysisItem analysisItem : requestData.getAnalysisItems()) {
            for (String year : analysisItem.getYears()) {
                geoserverAnalysisItem = new HashMap<String, String>();
                geoserverAnalysisItem.put("serviceName", analysisItem.getTbZTFXCatalog().getServiceName());
                geoserverAnalysisItem.put("year", year);
                geoserverAnalysisItems.add(geoserverAnalysisItem);
            }
        }
        requestParams.put("analysisItems", geoserverAnalysisItems);
        return requestParams;
    }

    private List<ZTFXResultDetail> convertResult(ZTFXRequestData requestData, List<GLFXResult> glfxResults) {
        ArrayList<ZTFXResultDetail> ztfxResultDetails = new ArrayList<ZTFXResultDetail>();
        ZTFXResultDetail ztfxResultDetail = null;
        ZTFXResultDetail.YearResult yearResult = null;
        ZTFXGraphAndFields ztfxGraphAndFields = null;
        for (ZTFXRequestData.AnalysisItem analysisItem : requestData.getAnalysisItems()) {
            ztfxGraphAndFields = this.ztfxCatalogService.queryDisplayConfig(analysisItem.getCatalogId());
            ztfxResultDetail = new ZTFXResultDetail();
            ztfxResultDetail.setCatalogId(analysisItem.getCatalogId());
            ztfxResultDetail.setCatalogName(analysisItem.getTbZTFXCatalog().getName());
            ztfxResultDetail.setGraph(ztfxGraphAndFields.getGraph());
            ztfxResultDetail.setFields(ztfxGraphAndFields.getFields());
            for (String year : analysisItem.getYears()) {
                yearResult = new ZTFXResultDetail.YearResult();
                yearResult.setYear(year);
                VersionTableMapping curVersion = VersionTableMapping.findByYear(analysisItem.getTbZTFXCatalog().getVersionTableMappings(), year);
                ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
                ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
                yearResult.setRender(resCatalogDataNodeDTO.getRender());
                Optional<GLFXResult> optionalGLFXResult = glfxResults.stream().filter(p -> p.getServiceType().equals(analysisItem.getTbZTFXCatalog().getServiceName()) && Objects.equals(p.getCurrentYear(), year)).findFirst();
                if (optionalGLFXResult != null && optionalGLFXResult.isPresent()) {
                    yearResult.setResults(optionalGLFXResult.get().getResults());
                }
                ztfxResultDetail.getResults().add(yearResult);
            }
            ztfxResultDetails.add(ztfxResultDetail);
        }
        return ztfxResultDetails;
    }

    @Override
    public String addPlanUser(String token, String planId, String ids) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        if (StrUtil.isBlank((CharSequence)ids)) {
            throw new ServiceException("\u7528\u6237id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        String filterParam = "id_IN_" + ids;
        List userList = this.userClient.getUserList(filterParam);
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < userList.size(); ++i) {
            RpcSysUser userObj = (RpcSysUser)userList.get(i);
            ZtfxSchemeUser ztfxSchemeUser = new ZtfxSchemeUser();
            ztfxSchemeUser.setUserId(userObj.getId());
            ztfxSchemeUser.setRname(userObj.getAname());
            ztfxSchemeUser.setUserName(userObj.getName());
            ztfxSchemeUser.setPhone(userObj.getTel());
            ztfxSchemeUser.setPlanId(planId);
            ztfxSchemeUser.setDepartment(String.join((CharSequence)",", userObj.getOrgNames()));
            this.ztfxSchemeUserMapper.insert(ztfxSchemeUser);
        }
        return errMsg.toString();
    }

    @Override
    public void deletePlanUser(String ids) {
        this.ztfxSchemeUserMapper.deleteBatchIds(Arrays.asList(ids.split(",")));
    }

    @Override
    public IPage<ZtfxSchemeUser> queryPlanUserList(String planId, String key, int page, int size) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        if (page < 1) {
            throw new ServiceException("\u9875\u7801\u53c2\u6570\u503c\u5f02\u5e38");
        }
        if (size < 1) {
            throw new ServiceException("\u6bcf\u9875\u663e\u793a\u4e2a\u6570\u53c2\u6570\u503c\u5f02\u5e38");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(ZtfxSchemeUser.class);
        if (!StrUtil.isBlank((CharSequence)key)) {
            wrapper.and(w -> {
                LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)w.like(ZtfxSchemeUser::getUserName, (Object)key)).or()).like(ZtfxSchemeUser::getRname, (Object)key)).or()).like(ZtfxSchemeUser::getPhone, (Object)key);
            });
        }
        wrapper.eq(ZtfxSchemeUser::getPlanId, (Object)planId);
        Page pages = new Page((long)page, (long)size);
        return this.ztfxSchemeUserMapper.selectPage((IPage)pages, (Wrapper)wrapper);
    }

    @Override
    public JSONObject getCoverInfo(String uniqueTaskId, String catalogId) {
        TbZTFXCatalog tbZTFXCatalog;
        if (StringUtils.isNotEmpty((CharSequence)catalogId) && "geoserver".equalsIgnoreCase((tbZTFXCatalog = this.ztfxCatalogService.queryDetail(catalogId, false)).getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbZTFXCatalog.getUrl())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)tbZTFXCatalog.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)tbZTFXCatalog.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            return this.yzfxService.getCoverInfo(tbZTFXCatalog.getUrl(), uniqueTaskId, applicationGuid, accessKey);
        }
        return this.yzfxService.getCoverInfo(uniqueTaskId);
    }
}

