/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.theme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.onemap.theme.entity.TbThemeGroup;
import com.geoway.ns.onemap.theme.mapper.TbThemeGroupMapper;
import com.geoway.ns.onemap.theme.service.TbThemeGroupService;
import com.geoway.ns.onemap.theme.service.TbThemeService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbThemeGroupServiceImp
extends ServiceImpl<TbThemeGroupMapper, TbThemeGroup>
implements TbThemeGroupService {
    @Autowired
    private TbThemeGroupMapper groupMapper;
    @Autowired
    private TbThemeService tbThemeService;

    @Override
    public List<TbThemeGroup> listWithTheme(String key) {
        List<TbThemeGroup> groupList = this.list((Wrapper)new QueryWrapper().lambda().orderByAsc(TbThemeGroup::getOrder));
        groupList = groupList.stream().map(tbThemeGroup -> {
            tbThemeGroup.setThemes(this.tbThemeService.listByGroup(tbThemeGroup.getId(), key));
            return tbThemeGroup;
        }).collect(Collectors.toList());
        return groupList;
    }

    @Override
    public TbThemeGroup info(Long id) {
        return (TbThemeGroup)this.getById(id);
    }

    @Override
    public TbThemeGroup addOrUpdate(TbThemeGroup param) {
        boolean res;
        if (param.getId() == null) {
            Long order = this.groupMapper.selectMaxOrder();
            order = order == null ? 1L : order + 1L;
            param.setOrder(order);
        }
        if (res = this.saveOrUpdate(param)) {
            return param;
        }
        throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean remove(Long id) {
        boolean res = this.removeById(id);
        if (!res) {
            return false;
        }
        this.tbThemeService.removeByGroup(id);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removes(List<Long> ids) {
        boolean res = this.removeByIds(ids);
        if (!res) {
            return false;
        }
        ids.forEach(id -> this.tbThemeService.removeByGroup((Long)id));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbThemeGroup tbThemeGroup = (TbThemeGroup)this.getById(id);
        if (tbThemeGroup == null) {
            return false;
        }
        TbThemeGroup maxGroup = (TbThemeGroup)this.list((Wrapper)Wrappers.lambdaQuery(TbThemeGroup.class).orderByDesc(TbThemeGroup::getOrder)).get(0);
        return this.sort(id, maxGroup.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbThemeGroup cur = (TbThemeGroup)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1L)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbThemeGroup cur = (TbThemeGroup)this.getById(id);
        if (cur == null) {
            return false;
        }
        Long maxOrder = this.groupMapper.selectMaxOrder();
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, Long order) {
        TbThemeGroup cur = (TbThemeGroup)this.getById(id);
        if (cur == null) {
            return true;
        }
        if (cur.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (cur.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbThemeGroup.class).ge(TbThemeGroup::getOrder, (Object)order)).lt(TbThemeGroup::getOrder, (Object)cur.getOrder())).orderByAsc(TbThemeGroup::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbThemeGroup)needUpdateList.get(i)).setOrder(order + (long)i + 1L);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbThemeGroup.class).gt(TbThemeGroup::getOrder, (Object)cur.getOrder())).le(TbThemeGroup::getOrder, (Object)order)).orderByAsc(TbThemeGroup::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbThemeGroup)needUpdateList.get(i)).setOrder(cur.getOrder() + (long)i);
            }
        }
        cur.setOrder(order);
        needUpdateList.add(cur);
        return this.updateBatchById(needUpdateList);
    }
}

