/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.support;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImgUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImgUtils.class);

    public static String inputStream2ImgStr(InputStream screenshotInputStream) {
        try {
            ByteArrayOutputStream outStream = null;
            try {
                outStream = new ByteArrayOutputStream();
                byte[] buffer1 = new byte[1024];
                int len = 0;
                while ((len = screenshotInputStream.read(buffer1)) != -1) {
                    outStream.write(buffer1, 0, len);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
            BASE64Encoder encoder = new BASE64Encoder();
            String base64Str = encoder.encode(outStream.toByteArray());
            return base64Str.replaceAll("\\r\\n", "");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String file2ImgStr(File screenshot) {
        try {
            byte[] data = null;
            try {
                FileInputStream in = new FileInputStream(screenshot);
                data = new byte[((InputStream)in).available()];
                ((InputStream)in).read(data);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BASE64Encoder encoder = new BASE64Encoder();
            String base64Str = encoder.encode(data);
            return base64Str.replaceAll("\\r\\n", "");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage base64ToImage(String base64String) {
        byte[] imageBytes = Base64.getDecoder().decode(base64String);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            BufferedImage image = ImageIO.read(bis);
            bis.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isBase64Encode(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, value);
    }

    public static boolean isBase64(String str) {
        try {
            BASE64Decoder encoder = new BASE64Decoder();
            encoder.decodeBuffer(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

