/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.support;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.Args;

public class URLEncodedUtilsEx
extends URLEncodedUtils {
    private static final BitSet URLENCODER = new BitSet(256);

    public static String formatNmew2(Iterable<? extends NameValuePair> parameters, char parameterSeparator, String charset) {
        Args.notNull(parameters, (String)"Parameters");
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtilsEx.urlEncodeSpecificChars(nameValuePair.getName(), charset);
            String encodedValue = URLEncodedUtilsEx.urlEncodeSpecificChars(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append(parameterSeparator);
            }
            System.out.println("\u8bf7\u6c42\u53c2\u6570AAA\uff1a" + encodedName + "=" + encodedValue);
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    public static String formatNmew(Iterable<? extends NameValuePair> parameters, char parameterSeparator, Charset charset) {
        Args.notNull(parameters, (String)"Parameters");
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtilsEx.encodeFormFields(nameValuePair.getName(), charset);
            String encodedValue = "";
            encodedValue = URLEncodedUtilsEx.encodeFormFields(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append(parameterSeparator);
            }
            if (nameValuePair.getName().equalsIgnoreCase("boxWkt")) {
                System.out.println("\u8bf7\u6c42\u53c2\u6570AAA-org\uff1a" + nameValuePair.getName() + "=" + nameValuePair.getValue());
                System.out.println("\u8bf7\u6c42\u53c2\u6570AAA\uff1a" + encodedName + "=" + encodedValue);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encodeFormFields(String content, Charset charset) {
        return content == null ? null : URLEncodedUtilsEx.urlEncode(content, charset != null ? charset : Consts.UTF_8, URLENCODER, false);
    }

    private static String urlEncode(String content, Charset charset, BitSet safechars, boolean blankAsPlus) {
        if (content == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safechars.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                buf.append("+");
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    private static String urlEncodeSpecificChars(String content, String charset) {
        StringBuffer encodedString = new StringBuffer();
        for (char c : content.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                encodedString.append(c);
                continue;
            }
            try {
                if (c == ' ') {
                    encodedString.append("%20");
                    continue;
                }
                encodedString.append(URLEncoder.encode(String.valueOf(c), charset));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return encodedString.toString();
    }
}

