/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.config;

import cn.hutool.core.io.file.FileNameUtil;
import com.geoway.adf.dms.config.dao.DmDictionaryDao;
import com.geoway.adf.dms.config.entity.DmDictionary;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.ns.sys.utils.TenantUserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

@Configuration
@Order(value=-2147483648)
public class Onemap4DicConfig {
    private static final Logger log = LoggerFactory.getLogger(Onemap4DicConfig.class);
    private static final String Dic_LOCATION = "dic";
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private DmDictionaryDao dmDictionaryDao;
    @Autowired
    private TenantUserUtil tenantUserUtil;

    @Bean
    public void loadOnemap4Dic() {
        try {
            Resource[] resources;
            System.out.println("\u66f4\u65b0\u5b57\u5178\uff1a------------------------------------------------------");
            this.tenantUserUtil.userManage();
            for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("dic/*.xml")) {
                String fileName = FileNameUtil.getPrefix((String)resource.getFilename());
                DmDictionary dictionary = this.dmDictionaryDao.selectByKey(fileName);
                if (dictionary != null) continue;
                System.out.println("\u66f4\u65b0\u5b57\u5178\uff1a" + fileName);
                MockMultipartFile multipartFile = new MockMultipartFile(fileName + ".xml", fileName + ".xml", "xml", resource.getInputStream());
                this.dictionaryService.importXml((MultipartFile)multipartFile, null);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.out.println(e);
        }
    }
}

