/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.proofquery;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.sys.dto.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3e\u8bc1\u7167\u7247\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/proofquery"})
public class ProofQueryController {
    @Resource
    private SysParamsService sysParamsService;
    @Autowired
    private RedisTemplate redisTemplate;

    @RequestMapping(value={"/CreateCloudQueryTask"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u901a\u8fc7\u7ed8\u5236\u56fe\u5f62\u7684wkt\u6570\u636e\u521b\u5efa\u4e91\u67e5\u8be2\u4efb\u52a1")
    public BaseResponse CreateCloudQueryTask(@RequestParam(value="WKT") String WKT) {
        try {
            Boolean hasKey = this.redisTemplate.hasKey((Object)"proofQueryToken");
            if (!hasKey.booleanValue()) {
                this.GetToken();
            }
            String token = this.redisTemplate.opsForValue().get((Object)"proofQueryToken").toString();
            String url = this.sysParamsService.getDetail("ProofQueryParms", "server_ip").getValue();
            JSONObject paramJson = new JSONObject();
            paramJson.put("WKT", (Object)WKT);
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)paramJson.toJSONString());
            Request request = new Request.Builder().url(url + "/api/cggl/CreateCloudQueryTask").method("POST", body).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + token).build();
            Response response = null;
            response = client.newCall(request).execute();
            JSONObject resJson = JSONObject.parseObject((String)response.body().string());
            return BaseResponse.success((String)resJson.getString("Data"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return BaseResponse.error((Exception)e);
        }
    }

    @RequestMapping(value={"/GetCloudQueryResult"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u901a\u8fc7\u4e91\u67e5\u8be2\u4efb\u52a1\u6807\u8bc6\u7801\u83b7\u53d6\u4efb\u52a1\u67e5\u8be2\u7ed3\u679c")
    public BaseResponse GetCloudQueryResult(@RequestParam(value="taskBsm") String taskBsm) {
        try {
            JSONArray jsonArray;
            Boolean hasKey = this.redisTemplate.hasKey((Object)"proofQueryToken");
            if (!hasKey.booleanValue()) {
                this.GetToken();
            }
            String token = this.redisTemplate.opsForValue().get((Object)"proofQueryToken").toString();
            String url = this.sysParamsService.getDetail("ProofQueryParms", "server_ip").getValue();
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)("[" + taskBsm + "]"));
            Request request = new Request.Builder().url(url + "/api/cggl/GetCloudQueryTaskStateInfo").method("POST", body).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + token).build();
            Response response = null;
            response = client.newCall(request).execute();
            JSONObject resJson = JSONObject.parseObject((String)response.body().string());
            if (resJson.getString("Code").equals("200") && (jsonArray = resJson.getJSONArray("Data")).getJSONObject(0).getString("TaskState").equals("2")) {
                client = new OkHttpClient().newBuilder().build();
                request = new Request.Builder().url(url + "/api/cggl/GetCloudQueryResult?taskBsm=" + taskBsm).addHeader("Authorization", "Bearer " + token).get().build();
                response = client.newCall(request).execute();
                return BaseResponse.success((String)response.body().string());
            }
            return BaseResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return BaseResponse.error((Exception)e);
        }
    }

    public void GetToken() {
        try {
            String url = this.sysParamsService.getDetail("ProofQueryParms", "server_ip").getValue();
            FormBody.Builder builder = new FormBody.Builder();
            builder.add("grant_type", this.sysParamsService.getDetail("ProofQueryParms", "grant_type").getValue());
            builder.add("username", this.sysParamsService.getDetail("ProofQueryParms", "username").getValue());
            builder.add("password", this.sysParamsService.getDetail("ProofQueryParms", "password").getValue());
            FormBody requestBody = builder.build();
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url + "/token").post((RequestBody)requestBody).build();
            Response response = client.newCall(request).execute();
            JSONObject resJson = JSONObject.parseObject((String)response.body().string());
            this.redisTemplate.opsForValue().set((Object)"proofQueryToken", (Object)resJson.getString("access_token"), (long)resJson.getInteger("expires_in").intValue(), TimeUnit.SECONDS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

