/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.djtj.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.ns.geoserver3.constant.Adf4GeoserverSpatialRelEnum;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.onemap.common.constants.EnumOnlineStatisticsUrl;
import com.geoway.ns.onemap.common.constants.EnumTaskStatus;
import com.geoway.ns.onemap.common.constants.EnumXxlTaskType;
import com.geoway.ns.onemap.djtj.entity.SuperimposedStatisticalRecord;
import com.geoway.ns.onemap.djtj.entity.Task;
import com.geoway.ns.onemap.djtj.listener.TaskListener;
import com.geoway.ns.onemap.djtj.mapper.SuperimposedStatisticalRecordMapper;
import com.geoway.ns.onemap.djtj.service.SuperimposedStatisticalRecordService;
import com.geoway.ns.onemap.djtj.service.TaskService;
import com.geoway.ns.onemap.service.AnalysisService;
import com.geoway.ns.sys.utils.Md5Utils;
import com.geoway.ns.sys.utils.RedisUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SuperimposedStatisticalRecordServiceImpl
extends ServiceImpl<SuperimposedStatisticalRecordMapper, SuperimposedStatisticalRecord>
implements SuperimposedStatisticalRecordService {
    private static final Logger logger = LoggerFactory.getLogger(SuperimposedStatisticalRecordServiceImpl.class);
    @Resource
    private AnalysisService iAnalysisEngineService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private TaskService taskService;
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Value(value="${xxlCallBackUrl:''}")
    private String callBackUrl;
    private static final String DjfxStatResultRedisKey = "DjfxStatResult:";
    private static final String DjfxStatParamKey = "DjfxStatParamKey:";

    @PostConstruct
    public void postConstruct() {
        TaskListener.addTaskFinishedListener(task -> {
            try {
                EnumTaskStatus status = EnumTaskStatus.getEnumByValue(task.getStatus());
                if (status == EnumTaskStatus.Succeed) {
                    Object object = this.redisUtil.get(DjfxStatResultRedisKey + task.getId());
                    if (object == null) {
                        return true;
                    }
                    SuperimposedStatisticalRecord record = (SuperimposedStatisticalRecord)object;
                    this.addSuperimposedStatisticalRecord(record);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            return true;
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object addSuperimposedStatisticalRecord(SuperimposedStatisticalRecord superimposedStatisticalRecord) throws Exception {
        JSONArray result;
        SuperimposedStatisticalRecord originSuperimposedStatisticalRecord = this.judgeIsRecExist(superimposedStatisticalRecord);
        if (ObjectUtil.isNull((Object)originSuperimposedStatisticalRecord)) {
            Task task = Task.builder().status(EnumTaskStatus.Init.value).name(superimposedStatisticalRecord.getFirstTableName() + "|" + superimposedStatisticalRecord.getSecondTableName()).group(EnumXxlTaskType.OnlineStatistics.type).handler(EnumOnlineStatisticsUrl.CreateAndStartTask.url).author("OnlineStatist").desc("OnlineStatist").build();
            Map<String, Object> param = this.buildDjfxQueryParam(superimposedStatisticalRecord);
            if (param.isEmpty()) {
                throw new Exception("\u7edf\u8ba1\u5206\u6790\u4efb\u52a1\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            task.setParam(JSONObject.toJSONString(param));
            if (superimposedStatisticalRecord.getDraft() == 1) {
                this.taskService.add(task, false);
                superimposedStatisticalRecord.setTaskId(task.getId());
                this.save(superimposedStatisticalRecord);
                return "\u7edf\u8ba1\u4efb\u52a1\u4fdd\u5b58\u6210\u529f\uff01\u8bf7\u7a0d\u540e\u2026\u2026";
            }
            this.taskService.add(task, true);
            superimposedStatisticalRecord.setTaskId(task.getId());
            this.redisUtil.set(DjfxStatParamKey + task.getId(), (Object)superimposedStatisticalRecord);
            this.save(superimposedStatisticalRecord);
            if (task.getStatus().equals(EnumTaskStatus.Succeed.value)) {
                return this.getCustomStat(superimposedStatisticalRecord, true);
            }
            return "\u7edf\u8ba1\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01\u8bf7\u7a0d\u540e\u2026\u2026";
        }
        if (StringUtils.isNotEmpty((CharSequence)superimposedStatisticalRecord.getDefaultStattaskId()) && (result = this.getCustomStatResultByTaskId(superimposedStatisticalRecord.getDefaultStattaskId())) != null) {
            return result;
        }
        Task task = (Task)this.taskService.getById((Serializable)((Object)originSuperimposedStatisticalRecord.getTaskId()));
        Boolean refresh = superimposedStatisticalRecord.getRefresh();
        Map<String, Object> param = this.buildDjfxQueryParam(superimposedStatisticalRecord);
        if (param.isEmpty()) {
            throw new Exception("\u7edf\u8ba1\u5206\u6790\u4efb\u52a1\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        task.setParam(JSONObject.toJSONString(param));
        this.taskService.update(task);
        superimposedStatisticalRecord.setTaskId(task.getId());
        superimposedStatisticalRecord.setId(originSuperimposedStatisticalRecord.getId());
        if (originSuperimposedStatisticalRecord.getDraft() == 1) {
            if (superimposedStatisticalRecord.getDraft() == 2) {
                this.redisUtil.set(DjfxStatParamKey + task.getId(), (Object)superimposedStatisticalRecord);
                this.updateById(superimposedStatisticalRecord);
                this.taskService.start(task.getId());
                if (task.getStatus().equals(EnumTaskStatus.Succeed.value)) {
                    return this.getCustomStat(superimposedStatisticalRecord, true);
                }
                return "\u7edf\u8ba1\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01\u8bf7\u7a0d\u540e\u2026\u2026";
            }
            return "\u7edf\u8ba1\u4efb\u52a1\u4fee\u6539\u6210\u529f\uff01";
        }
        this.redisUtil.set(DjfxStatParamKey + task.getId(), (Object)superimposedStatisticalRecord);
        if (refresh != null && refresh.booleanValue()) {
            this.taskService.start(task.getId());
        }
        if (task.getStatus().equals(EnumTaskStatus.Succeed.value)) {
            return this.getCustomStat(superimposedStatisticalRecord, false);
        }
        return "\u7edf\u8ba1\u6570\u636e\u6b63\u5728\u751f\u6210\u4e2d\uff01\u8bf7\u7a0d\u540e\u2026\u2026";
    }

    private JSONArray getCustomStat(SuperimposedStatisticalRecord superimposedStatisticalRecord, Boolean isSetDefault) throws IllegalAccessException {
        JSONArray jsonArray = new JSONArray();
        if (ObjectUtil.isNotNull((Object)superimposedStatisticalRecord)) {
            JSONObject param = new JSONObject();
            Task task = (Task)this.taskService.getById((Serializable)((Object)superimposedStatisticalRecord.getTaskId()));
            param.put("ApplicationGUID", (Object)this.geoserver3ConfigService.getApplicationGuid());
            param.put("AnalysisID", (Object)UUID.randomUUID().toString());
            param.put("djfxTaskId", (Object)task.getJobId());
            param.put("groupFields", (Object)superimposedStatisticalRecord.getGroupFields());
            param.put("statFields", (Object)superimposedStatisticalRecord.getStatFields());
            param.put("filter", (Object)MapUtil.of((Object)"whereclause", (Object)superimposedStatisticalRecord.getFilter()));
            param.put("Blocks", superimposedStatisticalRecord.getBlocks() != null ? JSONArray.parseObject((String)superimposedStatisticalRecord.getBlocks(), List.class) : null);
            if (StringUtils.isNotEmpty((CharSequence)superimposedStatisticalRecord.getSpatialRel())) {
                param.put("SpatialRel", (Object)Adf4GeoserverSpatialRelEnum.getGeoserverSpatialRelEnum((String)superimposedStatisticalRecord.getSpatialRel()));
            }
            String paramMd5 = Md5Utils.getMD5Str((String)param.toJSONString(), (String)"UTF-8");
            if (this.redisUtil.hasKey(DjfxStatResultRedisKey + paramMd5)) {
                return JSONArray.parseArray((String)this.redisUtil.get(DjfxStatResultRedisKey + paramMd5).toString());
            }
            JSONObject objectResult = this.iAnalysisEngineService.doCustomStatTask(param);
            String message = objectResult.getString("Message");
            if (StrUtil.isNotBlank((CharSequence)message) && "success".equals(message)) {
                jsonArray = objectResult.getJSONArray("Results");
            }
            if (jsonArray != null && jsonArray.size() > 0) {
                this.redisUtil.set(DjfxStatResultRedisKey + paramMd5, (Object)jsonArray.toJSONString());
            }
            if (isSetDefault.booleanValue() && StrUtil.isNotBlank((CharSequence)message) && "success".equals(message)) {
                String statTaskId = objectResult.getString("UniqueTaskID");
                superimposedStatisticalRecord.setDefaultStattaskId(statTaskId);
                this.updateById(superimposedStatisticalRecord);
            }
            return jsonArray;
        }
        return jsonArray;
    }

    private JSONArray getCustomStatResultByTaskId(String taskId) throws IllegalAccessException {
        JSONArray jsonArray = null;
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            JSONObject result = this.geoserver3TaskService.findResult(taskId);
            return result.getJSONArray("Results");
        }
        return jsonArray;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSuperimposedStatisticalRecord(SuperimposedStatisticalRecord superimposedStatisticalRecord) throws Exception {
        if (StrUtil.isBlank((CharSequence)superimposedStatisticalRecord.getId())) {
            throw new Exception("\u7edf\u8ba1\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        SuperimposedStatisticalRecord originSuperimposedStatisticalRecord = (SuperimposedStatisticalRecord)this.getById((Serializable)((Object)superimposedStatisticalRecord.getId()));
        if (ObjectUtil.isNotNull((Object)originSuperimposedStatisticalRecord)) {
            this.removeById((Serializable)((Object)originSuperimposedStatisticalRecord.getId()));
            this.taskService.removeById((Serializable)((Object)originSuperimposedStatisticalRecord.getTaskId()));
        }
    }

    @Override
    public IPage<SuperimposedStatisticalRecord> getSuperimposedStatisticalRecordPage(SuperimposedStatisticalRecord superimposedStatisticalRecord) throws Exception {
        if (ObjectUtil.isEmpty((Object)superimposedStatisticalRecord.getRows()) || ObjectUtil.isEmpty((Object)superimposedStatisticalRecord.getPage())) {
            throw new Exception("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        Page superimposedStatisticalRecordPage = new Page((long)superimposedStatisticalRecord.getPage().intValue(), (long)superimposedStatisticalRecord.getRows().intValue());
        return ((SuperimposedStatisticalRecordMapper)this.baseMapper).getSuperimposedStatisticalRecordPage((Page<SuperimposedStatisticalRecord>)superimposedStatisticalRecordPage, superimposedStatisticalRecord);
    }

    @Override
    public SuperimposedStatisticalRecord judgeIsRecExist(SuperimposedStatisticalRecord superimposedStatisticalRecord) throws Exception {
        if (StrUtil.isBlank((CharSequence)superimposedStatisticalRecord.getFirstTableId())) {
            throw new Exception("\u9009\u62e9\u7684\u7b2c\u4e00\u4e2a\u56fe\u5c42id\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (StrUtil.isBlank((CharSequence)superimposedStatisticalRecord.getFirstTableName())) {
            throw new Exception("\u9009\u62e9\u7684\u7b2c\u4e00\u4e2a\u56fe\u5c42\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (StrUtil.isBlank((CharSequence)superimposedStatisticalRecord.getSecondTableId())) {
            throw new Exception("\u9009\u62e9\u7684\u7b2c\u4e8c\u4e2a\u56fe\u5c42id\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (StrUtil.isBlank((CharSequence)superimposedStatisticalRecord.getSecondTableName())) {
            throw new Exception("\u9009\u62e9\u7684\u7b2c\u4e8c\u4e2a\u56fe\u5c42\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (StrUtil.isBlank((CharSequence)superimposedStatisticalRecord.getTjParam())) {
            throw new Exception("\u7edf\u8ba1\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        QueryWrapper superimposedStatisticalRecordQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)superimposedStatisticalRecordQueryWrapper.lambda().in(SuperimposedStatisticalRecord::getSchemeName, new Object[]{superimposedStatisticalRecord.getSchemeName()})).in(SuperimposedStatisticalRecord::getFirstTableId, new Object[]{superimposedStatisticalRecord.getFirstTableId()})).in(SuperimposedStatisticalRecord::getSecondTableId, new Object[]{superimposedStatisticalRecord.getSecondTableId()})).in(SuperimposedStatisticalRecord::getTaskType, new Object[]{superimposedStatisticalRecord.getTaskType()});
        return (SuperimposedStatisticalRecord)this.getOne((Wrapper)superimposedStatisticalRecordQueryWrapper);
    }

    @Override
    public Map<String, Object> buildDjfxQueryParam(SuperimposedStatisticalRecord superimposedStatisticalRecord) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        AppCatalogDataNodeDTO jsonObject = (AppCatalogDataNodeDTO)this.appCatalogNodeService.getNodeDetail(superimposedStatisticalRecord.getFirstTableId());
        if (jsonObject != null && StrUtil.isNotBlank((CharSequence)jsonObject.getDataset().getDsKey())) {
            param.put("layer1Url", "geoserver:" + jsonObject.getDataset().getDsKey() + "/" + jsonObject.getDataset().getFullName().replace(".", "/"));
            jsonObject = (AppCatalogDataNodeDTO)this.appCatalogNodeService.getNodeDetail(superimposedStatisticalRecord.getSecondTableId());
            if (jsonObject != null && StrUtil.isNotBlank((CharSequence)jsonObject.getDataset().getDsKey())) {
                param.put("layer2Url", "geoserver:" + jsonObject.getDataset().getDsKey() + "/" + jsonObject.getDataset().getFullName().replace(".", "/"));
            }
        }
        if (!param.isEmpty()) {
            Boolean refresh = superimposedStatisticalRecord.getRefresh();
            if (refresh != null && refresh.booleanValue()) {
                param.put("refreshCache", refresh);
            }
            param.put("callBackUrl", this.callBackUrl);
            param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
            param.put("AnalysisID", UUID.randomUUID().toString());
        }
        return param;
    }

    @Override
    public Map<String, Object> queryResultFields(String layerNodeId1, String layerNodeId2) throws Exception {
        AppCatalogDataNodeDTO jsonObject2;
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        HashMap<String, String> param = new HashMap<String, String>(8);
        AppCatalogDataNodeDTO jsonObject1 = (AppCatalogDataNodeDTO)this.appCatalogNodeService.getNodeDetail(layerNodeId1);
        if (jsonObject1 != null && StrUtil.isNotBlank((CharSequence)jsonObject1.getDataset().getDsKey())) {
            param.put("layer1Url", "geoserver:" + jsonObject1.getDataset().getDsKey() + "/" + jsonObject1.getDataset().getFullName().replace(".", "/"));
            resultData.put("layerNode1", jsonObject1);
        }
        if ((jsonObject2 = (AppCatalogDataNodeDTO)this.appCatalogNodeService.getNodeDetail(layerNodeId2)) != null && StrUtil.isNotBlank((CharSequence)jsonObject2.getDataset().getDsKey())) {
            param.put("layer2Url", "geoserver:" + jsonObject2.getDataset().getDsKey() + "/" + jsonObject2.getDataset().getFullName().replace(".", "/"));
            resultData.put("layerNode2", jsonObject2);
        }
        String url = this.taskService.getTaskScheduleUrl() + EnumOnlineStatisticsUrl.getResultFields.url;
        String result = ((HttpRequest)HttpRequest.post((String)url).body(JSONObject.toJSONString(param)).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        this.log.error("\u5f00\u59cbhttp\u4efb\u52a1\uff1aurl:" + url + ",param: " + param);
        System.out.println("\u521b\u5efa\u5e76\u6267\u884c\u53e0\u52a0\u5206\u6790\u4efb\u52a1b:" + result);
        resultData.put("resultFields", JSONObject.parseArray((String)result));
        return resultData;
    }
}

