/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.support;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.BindException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClientPoolUtil {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClientPoolUtil.class);
    public static PoolingNHttpClientConnectionManager cm = null;
    public static CloseableHttpAsyncClient httpClient = null;
    private static final String DEFAULT_CONTENT_TYPE = "application/json; charset=UTF-8";
    private static final String DEFAULT_FORM_URLENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    private static final int DEFAUL_CONNECTREQUEST_TTIME_OUT = 1;
    private static final int DEFAUL_CONNECT_TTIME_OUT = 10;
    private static final int DEFAUL_SOCKET_TTIME_OUT = 10;
    private static final int Http_Default_Keep_Time = 60;
    private static final int routeCount = 500;
    private static final int totalCount = 1000;
    public static ConnectionKeepAliveStrategy defaultStrategy = new ConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            int keepTime = 60;
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("format KeepAlive timeout exception, exception:", (Throwable)e);
                }
            }
            return keepTime * 1000;
        }
    };

    public static synchronized void initPools() {
        if (httpClient == null) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).setConnectionRequestTimeout(1000).build();
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setConnectTimeout(10000).setSoTimeout(10000).setSoKeepAlive(true).build();
            DefaultConnectingIOReactor ioReactor = null;
            try {
                ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
                ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                    public boolean handle(IOException ex) {
                        logger.error(ex.getMessage());
                        return ex instanceof BindException;
                    }

                    public boolean handle(RuntimeException ex) {
                        logger.error(ex.getMessage());
                        return ex instanceof UnsupportedOperationException;
                    }
                });
            }
            catch (IOReactorException e) {
                e.printStackTrace();
            }
            cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            cm.setDefaultMaxPerRoute(500);
            cm.setMaxTotal(1000);
            httpClient = HttpAsyncClients.custom().setKeepAliveStrategy(defaultStrategy).setConnectionManager((NHttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        httpClient.close();
                    }
                    catch (IOException e) {
                        logger.error("HttpClient close exception", (Throwable)e);
                    }
                }
            });
            httpClient.start();
        }
    }

    public static CloseableHttpAsyncClient getHttpClient() {
        return httpClient;
    }

    public static PoolingNHttpClientConnectionManager getHttpConnectionManager() {
        return cm;
    }

    public static void execute(String uri, Map<String, Object> data, FutureCallback<HttpResponse> callback) {
        long startTime = System.currentTimeMillis();
        HttpEntityEnclosingRequestBase method = null;
        try {
            if (httpClient == null) {
                AsyncHttpClientPoolUtil.initPools();
            }
            method = (HttpEntityEnclosingRequestBase)AsyncHttpClientPoolUtil.createHttpRequest(uri, "POST", DEFAULT_CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            if (data != null && data.size() > 0) {
                logger.info("\u622a\u56fe\u8bf7\u6c42\u53c2\u6570\uff1a" + data);
                method.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(data), Charset.forName("UTF-8")));
            }
            httpClient.execute((HttpUriRequest)method, callback);
        }
        catch (Exception e) {
            if (method != null) {
                method.abort();
            }
            e.printStackTrace();
            logger.error("execute post request exception, url:" + uri + ", exception:" + e.toString() + ", cost time(ms):" + (System.currentTimeMillis() - startTime));
        }
    }

    public static void execute(String uri, List<NameValuePair> data, FutureCallback<HttpResponse> callback) {
        long startTime = System.currentTimeMillis();
        Object httpEntity = null;
        HttpEntityEnclosingRequestBase method = null;
        try {
            if (httpClient == null) {
                AsyncHttpClientPoolUtil.initPools();
            }
            method = (HttpEntityEnclosingRequestBase)AsyncHttpClientPoolUtil.createHttpRequest(uri, "POST", DEFAULT_FORM_URLENCODED_CONTENT_TYPE, "*/*");
            if (data != null && data.size() > 0) {
                logger.info("\u622a\u56fe\u8bf7\u6c42\u53c2\u6570\uff1a" + data);
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(data, Charset.forName("UTF-8")));
            }
            httpClient.execute((HttpUriRequest)method, callback);
        }
        catch (Exception e) {
            if (method != null) {
                method.abort();
            }
            e.printStackTrace();
            logger.error("execute post request exception, url:" + uri + ", exception:" + e.toString() + ", cost time(ms):" + (System.currentTimeMillis() - startTime));
        }
    }

    public static HttpRequestBase createHttpRequest(String uri, String methodName, String contentType, String accept) {
        if (httpClient == null) {
            AsyncHttpClientPoolUtil.initPools();
        }
        Object method = null;
        method = "PUT".equalsIgnoreCase(methodName) ? new HttpPut(uri) : ("POST".equalsIgnoreCase(methodName) ? new HttpPost(uri) : ("GET".equalsIgnoreCase(methodName) ? new HttpGet(uri) : new HttpPost(uri)));
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        method.addHeader("Content-Type", contentType);
        method.addHeader("Accept", accept);
        return method;
    }

    public static void startHttpClient() {
        if (httpClient == null) {
            AsyncHttpClientPoolUtil.initPools();
        } else {
            httpClient.start();
        }
    }

    public static void closeHttpClient() {
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Boolean isRunning() {
        if (httpClient == null) {
            return false;
        }
        return httpClient.isRunning();
    }
}

