/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.theme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.onemap.theme.entity.TbScene;
import com.geoway.ns.onemap.theme.mapper.TbSceneMapper;
import com.geoway.ns.onemap.theme.service.TbSceneService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbSceneServiceImp
extends ServiceImpl<TbSceneMapper, TbScene>
implements TbSceneService {
    @Resource
    private TbSceneMapper tbSceneMapper;

    @Override
    public List<TbScene> listByTheme(Long themeId) {
        List all = this.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TbScene::getThemeId, (Object)themeId)).orderByAsc(TbScene::getOrder));
        List<TbScene> scenesTree = all.stream().filter(scene -> scene.getPid().equals(-1L)).map(scene -> {
            scene.setChildren(this.getTree((TbScene)scene, all));
            return scene;
        }).collect(Collectors.toList());
        return scenesTree;
    }

    private List<TbScene> getTree(TbScene root, List<TbScene> all) {
        return all.stream().filter(scene -> scene.getPid().equals(root.getId())).map(scene -> {
            scene.setChildren(this.getTree((TbScene)scene, all));
            return scene;
        }).collect(Collectors.toList());
    }

    @Override
    public TbScene info(Long id) {
        return (TbScene)this.getById(id);
    }

    @Override
    public TbScene addOrUpdate(TbScene param) {
        boolean res;
        if (param.getId() == null) {
            Long order = this.tbSceneMapper.selectMaxOrder(param.getThemeId());
            order = order == null ? 1L : order + 1L;
            param.setOrder(order);
        }
        if (param.getPid() == null) {
            param.setPid(-1L);
        }
        if (res = this.saveOrUpdate(param)) {
            return param;
        }
        throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public boolean remove(Long id) {
        return super.removeById((Serializable)id);
    }

    @Override
    public boolean removes(List<Long> ids) {
        return super.removeByIds(ids);
    }

    @Override
    public boolean removeByTheme(Long themeId) {
        return this.remove((Wrapper)new QueryWrapper().lambda().eq(TbScene::getThemeId, (Object)themeId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbScene cur = (TbScene)this.getById(id);
        if (cur == null) {
            return false;
        }
        TbScene max = (TbScene)this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbScene.class).eq(TbScene::getThemeId, (Object)cur.getThemeId())).orderByDesc(TbScene::getOrder)).get(0);
        return this.sort(id, max.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbScene cur = (TbScene)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1L)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbScene cur = (TbScene)this.getById(id);
        if (cur == null) {
            return false;
        }
        Long maxOrder = this.tbSceneMapper.selectMaxOrder(cur.getThemeId());
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, Long order) {
        TbScene cur = (TbScene)this.getById(id);
        if (cur == null) {
            return true;
        }
        if (cur.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (cur.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbScene.class).eq(TbScene::getThemeId, (Object)cur.getThemeId())).ge(TbScene::getOrder, (Object)order)).lt(TbScene::getOrder, (Object)cur.getOrder())).orderByAsc(TbScene::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbScene)needUpdateList.get(i)).setOrder(order + (long)i + 1L);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbScene.class).eq(TbScene::getThemeId, (Object)cur.getThemeId())).gt(TbScene::getOrder, (Object)cur.getOrder())).le(TbScene::getOrder, (Object)order)).orderByAsc(TbScene::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbScene)needUpdateList.get(i)).setOrder(cur.getOrder() + (long)i);
            }
        }
        cur.setOrder(order);
        needUpdateList.add(cur);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public TbScene copy(Long originId, Long tarId) {
        TbScene tar;
        TbScene origin = (TbScene)this.getById(originId);
        if (!origin.getType().equals(2)) {
            throw new RuntimeException("\u88ab\u62f7\u8d1d\u7684\u4e0d\u662f\u4e00\u4e2a\u573a\u666f");
        }
        if (!tarId.equals(-1L) && !(tar = (TbScene)this.getById(tarId)).getType().equals(1)) {
            throw new RuntimeException("\u76ee\u6807\u573a\u666f\u4e0d\u662f\u4e00\u4e2a\u573a\u666f\u5206\u7ec4");
        }
        origin.setId(null);
        origin.setPid(tarId);
        return this.addOrUpdate(origin);
    }
}

