/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.zyqd.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson2.JSON;
import com.geoway.adf.dms.catalog.dao.ResCatalogNodeDao;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.inventory.ResDataInventoryConfigDTO;
import com.geoway.adf.dms.catalog.entity.ResCatalogNode;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.config.dto.frontscheme.FrontSchemeDTO;
import com.geoway.adf.dms.config.dto.meta.MetaDataDTO;
import com.geoway.adf.dms.config.dto.meta.MetaDataValueDTO;
import com.geoway.adf.dms.config.service.FrontSchemeService;
import com.geoway.adf.dms.config.service.MetaDataService;
import com.geoway.adf.dms.datasource.entity.DsStatistic;
import com.geoway.adf.dms.datasource.service.DataSourceStatisticService;
import com.geoway.ns.onemap.zyqd.service.ResDataInventoryOnemapService;
import com.geoway.ns.onemap.zyqd.vo.ResDataVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ResDataInventoryOnemapServiceImpl
implements ResDataInventoryOnemapService {
    private static final Logger log = LoggerFactory.getLogger(ResDataInventoryOnemapServiceImpl.class);
    @Resource
    private ResCatalogNodeService resCatalogService;
    @Resource
    private FrontSchemeService frontSchemeService;
    @Resource
    private ResCatalogNodeDao resCatalogNodeDao;
    @Resource
    private MetaDataService metaDataService;
    @Resource
    private DataSourceStatisticService dataSourceStatisticService;
    @Resource
    private RedisTemplate redisTemplate;
    @Autowired
    private ThreadPoolTaskExecutor poolTaskExecutor;

    @Override
    public ResCatalogNodeDTO getTree(String nodeId) {
        ResCatalogNodeDTO filterTree;
        BoundValueOperations boundValueOps = this.redisTemplate.boundValueOps((Object)"ResCatalogNodeTree");
        if (boundValueOps.get() == null) {
            FrontSchemeDTO scheme = this.frontSchemeService.getDetailByKey("resMetaInventory");
            if (scheme == null) {
                return new ResCatalogNodeDTO();
            }
            ResDataInventoryConfigDTO config = (ResDataInventoryConfigDTO)JSON.parseObject((String)scheme.getContent(), ResDataInventoryConfigDTO.class);
            HashSet<String> nodeIds = new HashSet<String>(config.getCheckedNodeIds());
            ResCatalogNodeDTO catalogTree = this.resCatalogService.getCatalogTree(null, null, null, Boolean.valueOf(false), Boolean.valueOf(false));
            filterTree = this.filterTree(catalogTree, nodeIds, "");
            boundValueOps.set((Object)filterTree, 30L, TimeUnit.SECONDS);
        } else {
            filterTree = (ResCatalogNodeDTO)boundValueOps.get();
        }
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            filterTree = this.getByNodeId(filterTree, nodeId);
        }
        return filterTree;
    }

    @Override
    public List metaList(String nodeId) {
        ResCatalogNodeDTO tree = this.getTree(nodeId);
        ArrayList<ResDataVO> list = new ArrayList<ResDataVO>();
        FrontSchemeDTO scheme = this.frontSchemeService.getDetailByKey("resMetaInventory");
        ResDataInventoryConfigDTO config = (ResDataInventoryConfigDTO)JSON.parseObject((String)scheme.getContent(), ResDataInventoryConfigDTO.class);
        this.manageMeta(tree, list, config);
        return list;
    }

    private void manageMeta(ResCatalogNodeDTO tree, List<ResDataVO> results, ResDataInventoryConfigDTO config) {
        List children = tree.getChildren();
        if (CollectionUtil.isEmpty((Collection)children)) {
            return;
        }
        for (ResCatalogNodeDTO child : children) {
            ResDataVO dataVO;
            if ("show".equals(child.getDescribe()) && (dataVO = this.nodeMetaManage(tree.getDescribe(), child, config)) != null) {
                results.add(dataVO);
            }
            if (!CollectionUtil.isNotEmpty((Collection)child.getChildren())) continue;
            this.manageMeta(child, results, config);
        }
    }

    private ResCatalogNodeDTO getByNodeId(ResCatalogNodeDTO filterTree, String nodeId) {
        if (filterTree.getNodeId().equals(nodeId)) {
            return filterTree;
        }
        List children = filterTree.getChildren();
        if (children != null && !children.isEmpty()) {
            for (ResCatalogNodeDTO child : children) {
                ResCatalogNodeDTO nodeDTO = this.getByNodeId(child, nodeId);
                if (nodeDTO == null) continue;
                return nodeDTO;
            }
        }
        return null;
    }

    private ResDataVO nodeMetaManage(String treeName, ResCatalogNodeDTO node, ResDataInventoryConfigDTO config) {
        ArrayList<MetaDataValueDTO> values = new ArrayList<MetaDataValueDTO>();
        MetaDataDTO detail = this.metaDataService.getMetaDataDetail(Integer.valueOf(0), node.getNodeId(), Boolean.valueOf(true));
        if (detail == null) {
            return null;
        }
        values.addAll(detail.getValues());
        MetaDataValueDTO namesMeta = (MetaDataValueDTO)values.get(0);
        namesMeta.setValue(treeName);
        MetaDataValueDTO nameMeta = (MetaDataValueDTO)values.get(1);
        nameMeta.setValue(node.getNodeName());
        MetaDataValueDTO dataSizeMeta = (MetaDataValueDTO)values.get(values.size() - 2);
        MetaDataValueDTO dataCountMeta = (MetaDataValueDTO)values.get(values.size() - 1);
        MetaDataValueDTO masterLayer = new MetaDataValueDTO();
        masterLayer.setFieldName("\u4e3b\u8981\u56fe\u5c42");
        if (node.getNodeType() == 0) {
            AtomicLong dataSize = new AtomicLong(0L);
            AtomicLong dataCount = new AtomicLong(0L);
            List nodes = this.resCatalogService.selectByFatherId(node.getNodeId());
            if (nodes != null && !nodes.isEmpty()) {
                ConcurrentHashMap.KeySetView names = ConcurrentHashMap.newKeySet();
                ArrayList<CompletableFuture<Void>> completableFutureList = new ArrayList<CompletableFuture<Void>>();
                for (ResCatalogNode nodeDTO : nodes) {
                    completableFutureList.add(CompletableFuture.runAsync(() -> {
                        DsStatistic statistic;
                        BoundValueOperations boundValueOps = this.redisTemplate.boundValueOps((Object)("ResCatalogNodeStatic:" + nodeDTO.getId()));
                        Object o = boundValueOps.get();
                        names.add(nodeDTO.getNodeName());
                        if (o == null) {
                            statistic = this.dataSourceStatisticService.getDataStatistic(nodeDTO.getDatasetId());
                            if (statistic == null) {
                                return;
                            }
                            boundValueOps.set((Object)statistic, 3L, TimeUnit.MINUTES);
                        } else {
                            statistic = (DsStatistic)o;
                        }
                        dataSize.addAndGet(statistic.getDataSize());
                        dataCount.addAndGet(statistic.getDataCount());
                    }, (Executor)this.poolTaskExecutor));
                }
                ((CompletableFuture)CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0])).exceptionally(e -> {
                    throw new RuntimeException(e.getMessage(), (Throwable)e);
                })).join();
                masterLayer.setValue(names.isEmpty() ? node.getNodeName() : String.join((CharSequence)",", names));
            } else {
                masterLayer.setValue(node.getNodeName());
            }
            if (StringUtils.isBlank((CharSequence)dataSizeMeta.getValue())) {
                dataSizeMeta.setValue(this.calculation(dataSize.get(), config.getDataSizeUnit()));
            }
            if (StringUtils.isBlank((CharSequence)dataCountMeta.getValue())) {
                dataCountMeta.setValue(String.valueOf(dataCount.get()));
            }
        } else {
            ResCatalogNode catalogNode = this.resCatalogService.selectByNodeId(node.getNodeId());
            masterLayer.setValue(catalogNode.getDatasetName());
            DsStatistic dbStatistic = this.dataSourceStatisticService.getDataStatistic(catalogNode.getDatasetId());
            if (dbStatistic != null) {
                if (StringUtils.isBlank((CharSequence)dataSizeMeta.getValue())) {
                    dataSizeMeta.setValue(this.calculation(dbStatistic.getDataSize(), config.getDataSizeUnit()));
                }
                if (StringUtils.isBlank((CharSequence)dataCountMeta.getValue())) {
                    dataCountMeta.setValue(String.valueOf(dbStatistic.getDataCount()));
                }
            }
        }
        values.add(masterLayer);
        return ResDataVO.builder().nodeId(node.getNodeId()).meta(values).build();
    }

    private String calculation(Long size, String unit) {
        return BigDecimal.valueOf((double)size.longValue() / Math.pow(1024.0, 3.0)).setScale(4, RoundingMode.CEILING).toString();
    }

    private ResCatalogNodeDTO filterTree(ResCatalogNodeDTO node, Set<String> nodeIds, String names) {
        if (nodeIds.contains(node.getNodeId())) {
            return ResDataInventoryOnemapServiceImpl.copyNodeWithoutChildren(node, "show");
        }
        if (CollectionUtil.isNotEmpty((Collection)node.getChildren())) {
            ArrayList<ResCatalogNodeDTO> filters = new ArrayList<ResCatalogNodeDTO>();
            for (ResCatalogNodeDTO child : node.getChildren()) {
                ResCatalogNodeDTO childNode = this.filterTree(child, nodeIds, node.getNodeName().equals("\u6570\u636e\u76ee\u5f55") ? "" : names + node.getNodeName() + "/");
                if (childNode == null) continue;
                filters.add(childNode);
            }
            if (!filters.isEmpty()) {
                ResCatalogNodeDTO newNode = ResDataInventoryOnemapServiceImpl.copyNodeWithoutChildren(node, "");
                newNode.setDescribe(names + newNode.getNodeName());
                newNode.setChildren(filters);
                return newNode;
            }
        }
        return null;
    }

    private static ResCatalogNodeDTO copyNodeWithoutChildren(ResCatalogNodeDTO original, String type) {
        ResCatalogNodeDTO newNode = new ResCatalogNodeDTO();
        newNode.setNodeId(original.getNodeId());
        newNode.setNodeName(original.getNodeName());
        newNode.setDescribe("show");
        newNode.setFatherId(original.getFatherId());
        newNode.setOrder(original.getOrder());
        newNode.setNodeType(original.getNodeType());
        return newNode;
    }
}

