-- 叠加统计分析
-- DROP TABLE IF EXISTS "tb_onemap4_djtj_service_task";
CREATE TABLE "tb_onemap4_djtj_service_task" (
  "f_id" varchar NOT NULL,
  "f_taskid" int4,
  "f_status" int4,
  "f_progress" int4,
  "f_param" text,
  "f_group" varchar(64),
  "f_name" varchar(255),
  "f_createtime" timestamp(6),
  "f_starttime" timestamp(6),
  "f_endtime" timestamp(6),
  "f_handler" varchar(255),
  "f_desc" text,
  "f_author" varchar(255)
);
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_id" IS '记录主键';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_taskid" IS '任务id';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_status" IS '任务状态';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_progress" IS '任务进度';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_param" IS '任务参数';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_group" IS '任务分组';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_name" IS '任务名称';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_createtime" IS '创建时间';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_starttime" IS '开始时间';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_endtime" IS '结束时间';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_desc" IS '是描述';
COMMENT ON COLUMN "tb_onemap4_djtj_service_task"."f_author" IS '用户';

-- 叠加统计分析-分析参数表
-- DROP TABLE IF EXISTS "tb_onemap4_djtj_task_record";
CREATE TABLE "tb_onemap4_djtj_task_record" (
  "f_id" varchar(32) NOT NULL,
  "f_firsttableid" varchar(255),
  "f_firsttablename" varchar(255),
  "f_secondtableid" varchar(255),
  "f_secondtablename" varchar(255),
  "f_taskid" varchar(32),
  "f_createtime" timestamp(6),
  "f_firstlayertablename" varchar(255),
  "f_secondlayertablename" varchar(255),
  "f_tasktype" int2,
  "f_schemename" varchar(255),
  "f_draft" int2
);
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_firsttableid" IS '选择第一个图层的id';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_firsttablename" IS '选择的第一个图层的名称';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_secondtableid" IS '选择第二个图层的id';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_secondtablename" IS '选择的第二个图层的名称';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_taskid" IS '叠加统计的任务id';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_createtime" IS '叠加统计任务创建时间';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_firstlayertablename" IS '选择的第一个图层的中文名称';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_secondlayertablename" IS '选择的第一个图层的中文名称';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_tasktype" IS '统计类型：1、叠加统计，2、汇总统计';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_schemename" IS '方案名称';
COMMENT ON COLUMN "tb_onemap4_djtj_task_record"."f_draft" IS '是否保存为草稿：1、是 2、否';
