/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.encrypttool.service.impl;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.onemap.encrypttool.entity.BizEncryptRecords;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.mapper.BizEncryptRecordsMapper;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.support.query.MyQueryMapperUtil;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizEncryptRecordsServiceImpl
extends ServiceImpl<BizEncryptRecordsMapper, BizEncryptRecords>
implements BizEncryptRecordsService {
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Resource
    private FileServerService fileServerService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    private static Map<String, BizEncryptRecords> runningTasks = new ConcurrentHashMap<String, BizEncryptRecords>();

    @Override
    public boolean pauseById(String id) {
        return true;
    }

    @Override
    public boolean continueById(String id) {
        return true;
    }

    @Override
    public IPage<BizEncryptRecords> queryPageByFilter(String filterParam, String sortParam, int page, int size) throws Exception {
        MyQueryMapperUtil qmu = new MyQueryMapperUtil();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, BizEncryptRecords.class);
        Page pageT = new Page((long)page, (long)size);
        IPage bizEncryptRecordsIPage = this.page((IPage)pageT, (Wrapper)queryWrapper);
        FileServer fileServer = this.fileServerService.findDefault();
        bizEncryptRecordsIPage.getRecords().forEach(p -> {
            if (StrUtil.isNotBlank((CharSequence)p.getResultfile())) {
                p.setResultfile(fileServer.getEndpoint() + "/" + fileServer.getBucket() + "/" + p.getResultfile());
            }
        });
        return bizEncryptRecordsIPage;
    }

    @Override
    public IPage<BizEncryptRecords> queryPageByFilter(String tasktype, String filterParam, String sortParam, int page, int size) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)tasktype)) {
            filterParam = StringUtils.isNotEmpty((CharSequence)filterParam) ? filterParam + ";Q_tasktype_S_EQ=" + tasktype : "Q_tasktype_S_EQ=" + tasktype;
        }
        return this.queryPageByFilter(filterParam, sortParam, page, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveEncryptRecords(MultipartFile file) {
        String id = UUID.randomUUID().toString();
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + id;
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        BizEncryptRecords bizEncryptRecords = new BizEncryptRecords();
        bizEncryptRecords.setId(id);
        try {
            FileServerResponse oldFile = this.fileServerService.sendFileToServer(file);
            String tempFilePath = tempDirPath + File.separator + file.getOriginalFilename();
            File tempFile = new File(tempFilePath);
            file.transferTo(tempFile);
            bizEncryptRecords.setName(tempFile.getName());
            bizEncryptRecords.setSourcefile(oldFile.getPath());
            bizEncryptRecords.setUploadtime(new Date());
            bizEncryptRecords.setState(1);
            bizEncryptRecords.setProgress(0L);
            this.dataEncrypt(id, tempDirPath, tempFilePath, bizEncryptRecords);
            bizEncryptRecords.setState(3);
            bizEncryptRecords.setTasktype("encrypt");
        }
        catch (Exception e) {
            bizEncryptRecords.setState(0);
            e.printStackTrace();
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
        this.saveOrUpdate(bizEncryptRecords);
        return id;
    }

    @Override
    public String saveEncryptRecordsAsync(MultipartFile file) {
        String id = UUID.randomUUID().toString();
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + id;
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            FileServerResponse oldFile = this.fileServerService.sendFileToServer(file);
            String tempFilePath = tempDirPath + File.separator + file.getOriginalFilename();
            File tempFile = new File(tempFilePath);
            file.transferTo(tempFile);
            BizEncryptRecords bizEncryptRecords = new BizEncryptRecords();
            bizEncryptRecords.setId(id);
            bizEncryptRecords.setName(tempFile.getName());
            bizEncryptRecords.setSourcefile(oldFile.getPath());
            bizEncryptRecords.setUploadtime(new Date());
            bizEncryptRecords.setState(1);
            bizEncryptRecords.setProgress(0L);
            bizEncryptRecords.setTasktype("encrypt");
            this.saveOrUpdate(bizEncryptRecords);
            this.threadPoolTaskExecutorData.execute(() -> {
                try {
                    this.dataEncrypt(id, tempDirPath, tempFilePath, bizEncryptRecords);
                }
                catch (Exception e) {
                    bizEncryptRecords.setState(0);
                    this.saveOrUpdate(bizEncryptRecords);
                    e.printStackTrace();
                }
            });
            runningTasks.put(id, bizEncryptRecords);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    @Override
    public String wktEncrypt(String oldWkt, EncryptType encryptType) throws Exception {
        JSONObject configJson = this.getEncryptionConfig();
        String declassificationUrl = configJson.getString("url");
        String declassificationRequestid = configJson.getString("requestid");
        String declassificationToken = configJson.getString("token");
        ArrayList<String> wkbList = new ArrayList<String>();
        Integer wkbnum = 1;
        wkbList.add(this.wktToWkb(oldWkt));
        if (EncryptType.Encrypt == encryptType) {
            return this.S_Location_EncryptComplexGeometryByWKBArray(declassificationUrl, declassificationRequestid, declassificationToken, wkbnum, wkbList, true);
        }
        if (EncryptType.Decrypt == encryptType) {
            List<Coordinate[]> oldCoordinates = this.fromWKT(oldWkt);
            double OFFSET = 1.0E-4;
            boolean hasSinglePoint = false;
            for (int i = 0; i < oldCoordinates.size(); ++i) {
                Coordinate[] coords = oldCoordinates.get(i);
                if (coords == null || coords.length != 1) continue;
                hasSinglePoint = true;
                Coordinate original = coords[0];
                Coordinate[] expanded = new Coordinate[]{original, new Coordinate(original.x + 1.0E-4, original.y, original.z), new Coordinate(original.x, original.y + 1.0E-4, original.z), original};
                oldCoordinates.set(i, expanded);
            }
            List<Coordinate[]> transformedCoordinates = this.polygonTransform(declassificationUrl, declassificationRequestid, declassificationToken, oldCoordinates);
            ArrayList<Coordinate[]> finalResult = new ArrayList(transformedCoordinates.size());
            if (hasSinglePoint) {
                for (Coordinate[] transformed : transformedCoordinates) {
                    if (transformed == null || transformed.length == 0) continue;
                    Coordinate[] singlePoint = new Coordinate[]{transformed[0]};
                    finalResult.add(singlePoint);
                }
            } else {
                finalResult = transformedCoordinates;
            }
            return this.coordinateArrayToGeometry(finalResult);
        }
        return oldWkt;
    }

    @Override
    public double[] pointEncrypt(double x, double y) throws Exception {
        JSONObject configJson = this.getEncryptionConfig();
        String declassificationUrl = configJson.getString("url");
        String declassificationRequestid = configJson.getString("requestid");
        String declassificationToken = configJson.getString("token");
        return this.S_XYChangeList(declassificationUrl, declassificationRequestid, declassificationToken, x, y, true);
    }

    public String coordinateArrayToGeometry(List<Coordinate[]> coordinateList) {
        GeometryFactory geometryFactory = new GeometryFactory();
        this.log.error("\uff08\u6d4b\u79d1\u9662\uff09coordinateArrayToGeometry\uff1a" + coordinateList.size());
        if (coordinateList == null || coordinateList.size() == 0) {
            return null;
        }
        if (coordinateList.get(0).length == 1) {
            return " POINT(" + coordinateList.get((int)0)[0].x + " " + coordinateList.get((int)0)[0].y + ")";
        }
        Polygon[] polygons = new Polygon[coordinateList.size()];
        int i = 0;
        for (Coordinate[] coordinates : coordinateList) {
            Polygon polygon;
            ArrayList<Coordinate> shellCoordinates = new ArrayList<Coordinate>();
            ArrayList holesCoordinates = new ArrayList();
            Coordinate firstCoordinate = new Coordinate();
            int ringNum = 0;
            int pointNum = 0;
            for (Coordinate coordinate : coordinates) {
                if (firstCoordinate.x == 0.0 && ringNum > 1) {
                    firstCoordinate = coordinate;
                }
                if (ringNum == 0) {
                    shellCoordinates.add(coordinate);
                } else {
                    if (holesCoordinates.size() < ringNum) {
                        holesCoordinates.add(new ArrayList());
                    }
                    ((List)holesCoordinates.get(ringNum - 1)).add(coordinate);
                }
                if (firstCoordinate.x == coordinate.x && firstCoordinate.y == coordinate.y && ++pointNum > 1) {
                    firstCoordinate = new Coordinate();
                    ++ringNum;
                    pointNum = 0;
                    continue;
                }
                if (firstCoordinate.x != 0.0) continue;
                firstCoordinate = coordinate;
            }
            LinearRing[] holesRing = new LinearRing[holesCoordinates.size()];
            int h = 0;
            for (List list : holesCoordinates) {
                holesRing[h] = geometryFactory.createLinearRing(list.toArray(new Coordinate[0]));
                ++h;
            }
            LinearRing shellRing = geometryFactory.createLinearRing(shellCoordinates.toArray(new Coordinate[0]));
            polygons[i] = polygon = geometryFactory.createPolygon(shellRing, holesRing);
            ++i;
        }
        MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygons);
        return multiPolygon.toText();
    }

    @Override
    public List<Coordinate[]> fromWKT(String wkt) {
        try {
            ArrayList<Coordinate[]> coordinates = new ArrayList<Coordinate[]>();
            GeometryFactory geometryFactory = new GeometryFactory();
            WKTReader reader = new WKTReader(geometryFactory);
            Geometry geometry = null;
            geometry = reader.read(wkt);
            int numGeometries = geometry.getNumGeometries();
            for (int i = 0; i < numGeometries; ++i) {
                coordinates.add(geometry.getGeometryN(i).getCoordinates());
            }
            return coordinates;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String saveFormatConvertRecords(MultipartFile file, String readType) {
        String id = UUID.randomUUID().toString();
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + id;
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            FileServerResponse oldFile = this.fileServerService.sendFileToServer(file);
            String tempFilePath = tempDirPath + File.separator + file.getOriginalFilename();
            File tempFile = new File(tempFilePath);
            file.transferTo(tempFile);
            BizEncryptRecords bizEncryptRecords = new BizEncryptRecords();
            bizEncryptRecords.setId(id);
            bizEncryptRecords.setName(tempFile.getName());
            bizEncryptRecords.setSourcefile(oldFile.getPath());
            bizEncryptRecords.setUploadtime(new Date());
            bizEncryptRecords.setState(1);
            bizEncryptRecords.setProgress(0L);
            String url = this.geoserver3ConfigService.getUrl();
            String serverUrl = url + "/rest/analysis/upload";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("fileData", tempFile);
            paramMap.put("readType", readType);
            String resultStr = HttpUtil.post((String)serverUrl, paramMap);
            JSONObject resultObj = JSON.parseObject((String)resultStr);
            if (resultObj != null && "500".equals(resultObj.getString("StatusCode"))) {
                bizEncryptRecords.setState(0);
                bizEncryptRecords.setProgress(100L);
            } else {
                bizEncryptRecords.setState(3);
                bizEncryptRecords.setProgress(100L);
            }
            bizEncryptRecords.setTasktype("txtconvert");
            bizEncryptRecords.setResult(resultStr);
            this.saveOrUpdate(bizEncryptRecords);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public List<Coordinate[]> polygonTransform(String url, String requestId, String token, List<Coordinate[]> coordinateList) {
        ArrayList<Coordinate[]> newCoordinateList = new ArrayList<Coordinate[]>();
        for (Coordinate[] coordinates : coordinateList) {
            String xyz = "[";
            for (int i = 0; i < coordinates.length; ++i) {
                Coordinate coordinate = coordinates[i];
                xyz = xyz + "[" + coordinate.x + "," + coordinate.y + "],";
            }
            xyz = xyz.substring(0, xyz.length() - 1);
            xyz = xyz + "]";
            String data = this.polygontransform(url, requestId, token, coordinates.length, xyz, true);
            String[] points = data.split("],\\[");
            this.log.error("\uff08\u6d4b\u79d1\u9662\uff09points\uff1a" + points.length);
            Coordinate[] newCoordinates = new Coordinate[points.length];
            this.log.error("\uff08\u6d4b\u79d1\u9662\uff09newCoordinates\uff1a" + newCoordinates.length);
            Integer i = 0;
            for (String xy : points) {
                try {
                    Coordinate coordinate;
                    this.log.error("\uff08\u6d4b\u79d1\u9662\uff09\uff1a" + xy);
                    String x = xy.split(",")[0].replace("[", "").replace("]", "");
                    String y = xy.split(",")[1].replace("[", "").replace("]", "");
                    newCoordinates[i.intValue()] = coordinate = new Coordinate(Double.valueOf(x).doubleValue(), Double.valueOf(y).doubleValue());
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                catch (Exception e) {
                    this.log.error("\uff08\u6d4b\u79d1\u9662\uff09Exception\uff1a" + e.getMessage());
                    e.printStackTrace();
                }
            }
            newCoordinateList.add(newCoordinates);
        }
        this.log.error("\uff08\u6d4b\u79d1\u9662\uff09\uff1aend");
        return newCoordinateList;
    }

    public void dataEncrypt(String id, String tempDirPath, String tempFilePath, BizEncryptRecords bizEncryptRecords) throws Exception {
        File tempFile = new File(tempFilePath);
        String name = FileUtil.getFileNameWithoutExtension((String)tempFilePath);
        String tempNewFilePath = tempDirPath;
        if (tempFilePath.toLowerCase(Locale.ROOT).endsWith(".zip")) {
            tempNewFilePath = tempDirPath + File.separator + id;
            ZipAndRarUtil.unZipFiles((File)tempFile, (String)(tempNewFilePath + "/"));
            tempFile = new File(tempNewFilePath);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".shp");
                }
            };
            name = tempFile.listFiles(fileFilter)[0].getName();
            name = name.substring(0, name.lastIndexOf("."));
        }
        JSONObject configJson = this.getEncryptionConfig();
        String declassificationUrl = configJson.getString("url");
        String declassificationRequestid = configJson.getString("requestid");
        String declassificationToken = configJson.getString("token");
        IFeatureWorkspace srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)tempNewFilePath);
        IFeatureClass featureClass = srcWorkspace.openFeatureClass(name);
        if (featureClass == null) {
            throw new RuntimeException(name + "\u56fe\u5c42\u6253\u5f00\u5931\u8d25");
        }
        IFeatureCursor cursor = featureClass.searchFeature((IQueryFilter)null);
        long step = 100L / featureClass.featureCount((IQueryFilter)null);
        long i = 0L;
        ArrayList<String> oldwkts = new ArrayList<String>();
        ArrayList<String> newwkts = new ArrayList<String>();
        IFeature feature = cursor.nextFeature();
        while (feature != null) {
            ++i;
            ArrayList<String> wkbList = new ArrayList<String>();
            Integer wkbnum = 1;
            wkbList.add(this.wktToWkb(feature.getGeometry().toWkt()));
            oldwkts.add(feature.getGeometry().toWkt());
            String newWktStr = this.S_Location_EncryptComplexGeometryByWKBArray(declassificationUrl, declassificationRequestid, declassificationToken, wkbnum, wkbList, true);
            newwkts.add(newWktStr);
            feature.setGeometry(GeometryFunc.createGeometry((String)newWktStr));
            if (i % step == 0L) {
                bizEncryptRecords.setProgress(i * step);
                this.saveOrUpdate(bizEncryptRecords);
            }
            cursor.updateFeature(feature);
            feature = cursor.nextFeature();
        }
        srcWorkspace.close();
        MultiPolygon oldMultiPolygon = this.mergePolygons(oldwkts);
        MultiPolygon newMultiPolygon = this.mergePolygons(newwkts);
        Path localPath = Paths.get(tempDirPath, new String[0]);
        String zipFile = localPath.resolve("new-" + name + ".zip").toString();
        ZipAndRarUtil.toZip((String)tempNewFilePath, (String)zipFile, (boolean)true);
        File newFile = new File(zipFile);
        FileServerResponse newResponse = this.fileServerService.sendFileToServer(newFile, null, false);
        bizEncryptRecords.setProgress(100L);
        bizEncryptRecords.setState(3);
        bizEncryptRecords.setResultfile(newResponse.getPath());
        bizEncryptRecords.setOldwkt(oldMultiPolygon.toText());
        bizEncryptRecords.setNewwkt(newMultiPolygon.toText());
        this.saveOrUpdate(bizEncryptRecords);
    }

    public MultiPolygon mergePolygons(List<String> wktPolygons) throws Exception {
        GeometryFactory geometryFactory = new GeometryFactory();
        WKTReader wktReader = new WKTReader(geometryFactory);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (String wkt : wktPolygons) {
            Geometry geometry = wktReader.read(wkt);
            if (geometry instanceof Polygon) {
                polygons.add((Polygon)geometry);
                continue;
            }
            throw new IllegalArgumentException("\u8f93\u5165\u7684 WKT \u4e0d\u662f\u6709\u6548\u7684 Polygon: " + wkt);
        }
        Polygon[] polygonArray = polygons.toArray(new Polygon[0]);
        return geometryFactory.createMultiPolygon(polygonArray);
    }

    public JSONObject getEncryptionConfig() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("hnSys", "encryptionConfig");
        return JSONObject.parseObject((String)sysParamDTO.getValue());
    }

    public double[] S_XYChangeList(String url, String requestId, String token, double x, double y, boolean isRepeat) {
        double[] newXy = new double[]{};
        JSONObject param = new JSONObject();
        param.put("requestId", (Object)requestId);
        param.put("x", (Object)x);
        param.put("y", (Object)y);
        Object data = null;
        try {
            String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)(url + "/hsm/v1.0/S_XYChange2")).body(param.toJSONString()).contentType("application/json").header("Authorization", "Bearer " + this.getToken(this.redisTemplate, url, token, false))).charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && jsonObject.getString("code").equals("401") && isRepeat) {
                return this.S_XYChangeList(url, requestId, this.getToken(this.redisTemplate, url, token, true), x, y, false);
            }
            System.out.println("\u63a5\u53e3\u8fd4\u56de\u6570\u636e ---------- " + jsonObject.toJSONString() + "\n");
            newXy = new double[]{jsonObject.getJSONObject("result").getDouble("xe"), jsonObject.getJSONObject("result").getDouble("ye")};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newXy;
    }

    public String S_Location_EncryptComplexGeometryByWKBArray(String url, String requestId, String token, Integer wkbnum, List wkbblob, boolean isRepeat) {
        JSONObject param = new JSONObject();
        param.put("requestId", (Object)requestId);
        param.put("wkbnum", (Object)wkbnum);
        param.put("wkbblob", (Object)wkbblob);
        String data = null;
        try {
            String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)(url + "/hsm/v1.0/S_Location_EncryptComplexGeometryByWKBArray")).body(param.toJSONString()).contentType("application/json").header("Authorization", "Bearer " + this.getToken(this.redisTemplate, url, token, false))).charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && jsonObject.getString("code").equals("401") && isRepeat) {
                return this.S_Location_EncryptComplexGeometryByWKBArray(url, requestId, this.getToken(this.redisTemplate, url, token, true), wkbnum, wkbblob, false);
            }
            System.out.println("\u63a5\u53e3\u8fd4\u56de\u6570\u636e ---------- " + jsonObject.toJSONString() + "\n");
            data = jsonObject.getJSONObject("result").getJSONArray("outwkbblob").getString(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.wkbToWkt(data);
    }

    public String S_Location_DecryptComplexGeometryByWKBArray(String url, String requestId, String token, Integer wkbnum, List wkbblob, boolean isRepeat) {
        JSONObject param = new JSONObject();
        param.put("requestId", (Object)requestId);
        param.put("wkbnum", (Object)wkbnum);
        param.put("wkbblob", (Object)wkbblob);
        String data = null;
        try {
            String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)(url + "/hsm/v1.0/S_Location_DecryptComplexGeometryByWKBArray")).body(param.toJSONString()).contentType("application/json").header("Authorization", "Bearer " + this.getToken(this.redisTemplate, url, token, false))).charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && jsonObject.getString("code").equals("401") && isRepeat) {
                return this.S_Location_DecryptComplexGeometryByWKBArray(url, requestId, this.getToken(this.redisTemplate, url, token, true), wkbnum, wkbblob, false);
            }
            data = jsonObject.getJSONObject("result").getJSONArray("outwkbblob").getString(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u63a5\u53e3\u8fd4\u56de\u6570\u636e ---------- " + data + "\n");
        return this.wkbToWkt(data);
    }

    public String polygontransform(String url, String requestId, String token, Integer wkbnum, String x_y_s, boolean isRepeat) {
        JSONObject param = new JSONObject();
        param.put("requestId", (Object)requestId);
        param.put("scount", (Object)wkbnum);
        param.put("x_y_s", (Object)x_y_s);
        System.out.println("\u63a5\u53e3\u8bf7\u6c42\u6570\u636e ---------- " + param.toJSONString().replace("\"[", "[").replace("]\"", "]") + "\n");
        String data = null;
        try {
            String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)(url + "/transform/polygonretransform")).body(param.toJSONString().replace("\"[", "[").replace("]\"", "]")).contentType("application/json").header("Authorization", "Bearer " + this.getToken(this.redisTemplate, url, token, false))).charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject.containsKey((Object)"code") && jsonObject.getString("code").equals("401") && isRepeat) {
                return this.polygontransform(url, requestId, this.getToken(this.redisTemplate, url, token, true), wkbnum, x_y_s, false);
            }
            System.out.println("\u63a5\u53e3\u8fd4\u56de\u6570\u636e ---------- " + jsonObject.toJSONString() + "\n");
            data = jsonObject.getJSONObject("data").getString("x_y_s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public String getToken(RedisTemplate redisTemplate, String url, String token, boolean isExpire) {
        if (!redisTemplate.hasKey((Object)"declassificationToken").booleanValue() && !isExpire) {
            redisTemplate.opsForValue().set((Object)"declassificationToken", (Object)token);
        }
        if (isExpire) {
            String nToken = this.login(url);
            redisTemplate.opsForValue().set((Object)"declassificationToken", (Object)nToken);
        }
        return redisTemplate.opsForValue().get((Object)"declassificationToken").toString();
    }

    public String login(String url) {
        JSONObject param = new JSONObject();
        param.put("username", (Object)"qiyige");
        param.put("password", (Object)"Qwer1234");
        String data = null;
        try {
            String result = ((HttpRequest)HttpRequest.post((String)(url + "/auth/login")).body(param.toJSONString()).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            data = jsonObject.getJSONObject("data").getString("access_token");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u63a5\u53e3\u8fd4\u56de\u6570\u636e ---------- " + data + "\n");
        return data;
    }

    public String wktToWkb(String wkt) {
        String encodedWkb = null;
        try {
            GeometryFactory geometryFactory = new GeometryFactory();
            WKTReader reader = new WKTReader(geometryFactory);
            WKBWriter writer = new WKBWriter();
            Geometry geometry = reader.read(wkt);
            byte[] wkb = writer.write(geometry);
            encodedWkb = Base64.getEncoder().encodeToString(wkb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedWkb;
    }

    public String wkbToWkt(String data) {
        byte[] encodeWkt = Base64.getDecoder().decode(data);
        String wkt = null;
        try {
            WKBReader wkbReader = new WKBReader();
            Geometry wktGeometry = wkbReader.read(encodeWkt);
            WKTWriter wktWriter = new WKTWriter();
            wkt = wktWriter.write(wktGeometry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wkt;
    }
}

