/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class ThreadPoolConfig {
    @Value(value="${threadPool.corePoolSize:5}")
    private int corePoolSize;
    @Value(value="${threadPool.maxPoolSize:10}")
    private int maxPoolSize;
    @Value(value="${threadPool.keepAliveSeconds:600}")
    private int keepAliveSeconds;
    @Value(value="${threadPool.queueCapacity:10000}")
    private int queueCapacity;

    @Bean(name={"executor"})
    public ThreadPoolTaskExecutor executor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        threadPoolTaskExecutor.setKeepAliveSeconds(this.keepAliveSeconds);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setThreadNamePrefix("OneMap");
        threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        return threadPoolTaskExecutor;
    }
}

