/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.proxy.config.ApplicationYmlConfig;
import com.geoway.ns.proxy.dto.RouteMatchObject;
import com.geoway.ns.proxy.entity.AccessRoll;
import com.geoway.ns.proxy.entity.ProxyApplication;
import com.geoway.ns.proxy.entity.ProxyObject;
import com.geoway.ns.proxy.entity.ProxyObjectRouter;
import com.geoway.ns.proxy.entity.ProxyToken;
import com.geoway.ns.proxy.mapper.AccessRollMapper;
import com.geoway.ns.proxy.service.ProxyApplicationService;
import com.geoway.ns.proxy.service.ProxyObjectRouterService;
import com.geoway.ns.proxy.service.ProxyObjectService;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.proxy.service.RedisTemplateService;
import com.geoway.ns.proxy.service.RouterMatchService;
import com.geoway.ns.proxy.service.SimpleZyfxServicesetService;
import com.geoway.ns.proxy.utils.IpVerification;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RouterMatchServiceImpl
implements RouterMatchService {
    @Value(value="${ProxyTimeOut:600}")
    public Integer proxyTimeOut;
    @Autowired
    ProxyObjectService proxyObjectService;
    @Autowired
    ProxyApplicationService proxyApplicationService;
    @Autowired
    ProxyTokenService proxyTokenService;
    @Autowired
    ProxyObjectRouterService proxyObjectRouterService;
    @Autowired
    SimpleZyfxServicesetService simpleZyfxServicesetService;
    @Autowired
    private AccessRollMapper rollMapper;
    @Autowired
    private IpVerification ipVerification;
    @Autowired
    RedisTemplateService redisTemplateService;
    @Autowired
    private ApplicationYmlConfig applicationYmlConfig;

    @Override
    public RouteMatchObject queryRouteMatch(HttpServletRequest request, String token) throws Exception {
        RouteMatchObject routeMatchObject = new RouteMatchObject();
        if (StrUtil.isBlank((CharSequence)token)) {
            routeMatchObject.addMessage(404, "token\u4e0d\u5b58\u5728\u6216\u65e0\u6548");
            return routeMatchObject;
        }
        String queryPath = (String)request.getAttribute("relPath");
        String proxyKey = String.format("proxy:%s:%s", token, queryPath);
        if (this.redisTemplateService.isHasKey(proxyKey).booleanValue()) {
            routeMatchObject = (RouteMatchObject)this.redisTemplateService.getObjectByBoundValueOps(proxyKey);
        } else {
            ProxyToken proxyToken = (ProxyToken)this.proxyTokenService.getById((Serializable)((Object)token));
            if (proxyToken == null) {
                routeMatchObject.addMessage(404, "token\u4e0d\u5b58\u5728\u6216\u65e0\u6548");
                return routeMatchObject;
            }
            routeMatchObject.setProxyToken(proxyToken);
            ProxyObjectRouter proxyObjectRouter = this.queryObjectRoute(queryPath, token);
            if (proxyObjectRouter == null) {
                routeMatchObject.addMessage(404, "\u8d44\u6e90\u4e0d\u5b58\u5728");
                return routeMatchObject;
            }
            routeMatchObject.setProxyObjectRouter(proxyObjectRouter);
            ProxyObject proxyObject = (ProxyObject)this.proxyObjectService.getById((Serializable)((Object)proxyObjectRouter.getObjectid()));
            if (proxyObject == null) {
                routeMatchObject.addMessage(404, "\u8d44\u6e90\u4e0d\u5b58\u5728");
                return routeMatchObject;
            }
            routeMatchObject.setProxyObject(proxyObject);
            String realURL = String.format("%s%s", proxyObjectRouter.getUrlprefix(), proxyObjectRouter.getRouter());
            if (StrUtil.isNotBlank((CharSequence)proxyObjectRouter.getParams())) {
                realURL = realURL + "?" + proxyObjectRouter.getParams();
            }
            if (proxyObject.getStatus().equals(2)) {
                routeMatchObject.addMessage(403, "\u670d\u52a1\u5df2\u505c\u7528");
                return routeMatchObject;
            }
            if (this.isOverdue(routeMatchObject, proxyObject.getExpiretime())) {
                return routeMatchObject;
            }
            if (this.isRoll(routeMatchObject, proxyObject.getToken())) {
                return routeMatchObject;
            }
            String newURL = this.xzqLimit(realURL, proxyObject.getXzqlimit(), proxyObject.getServicetype());
            routeMatchObject.setServiceType(proxyObject.getServicetype());
            routeMatchObject.setServiceId(proxyObject.getServiceid());
            routeMatchObject.setUrl(newURL);
            routeMatchObject.setRouteId(proxyObjectRouter.getId());
            int secondOut = routeMatchObject.queryTimeOut() > this.proxyTimeOut || routeMatchObject.queryTimeOut() <= 0 ? this.proxyTimeOut.intValue() : routeMatchObject.queryTimeOut();
            this.redisTemplateService.setInfoByBoundValueOps(proxyKey, routeMatchObject, secondOut, TimeUnit.SECONDS);
        }
        ProxyObject proxyObject = routeMatchObject.getProxyObject();
        if (this.isForbiddenOnIp(proxyObject, request)) {
            String msg = "\u60a8\u7684IP\u5730\u5740\u7981\u6b62\u8bbf\u95ee\u8be5\u670d\u52a1\uff01";
            routeMatchObject.addMessage(403, msg);
            return routeMatchObject;
        }
        if (this.isOutFrequency(proxyObject.getFrequency(), proxyObject.getId())) {
            routeMatchObject.addMessage(429, "\u8d85\u51fa\u8bbf\u95ee\u9650\u5236");
            return routeMatchObject;
        }
        return routeMatchObject;
    }

    @Override
    public RouteMatchObject queryRouteMatchByServerName(String routerId, String serverName, String token) throws Exception {
        return null;
    }

    private ProxyObjectRouter queryObjectRoute(String queryPath, String token) {
        if (StrUtil.isBlank((CharSequence)queryPath)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyObjectRouter::getToken, (Object)token);
        List proxyObjectRouters = this.proxyObjectRouterService.list((Wrapper)queryWrapper);
        ProxyObjectRouter matchRouter = null;
        for (ProxyObjectRouter proxyObjectRouter : proxyObjectRouters) {
            String arouter = proxyObjectRouter.getArouter();
            if (!StrUtil.isNotBlank((CharSequence)arouter) || !queryPath.endsWith(arouter)) continue;
            matchRouter = proxyObjectRouter;
            break;
        }
        if (matchRouter == null) {
            String path = this.extractPathFromUrl(queryPath);
            for (ProxyObjectRouter proxyObjectRouter : proxyObjectRouters) {
                String arouter = proxyObjectRouter.getArouter();
                if (StrUtil.isBlank((CharSequence)arouter) || !this.isPathMatching(path, arouter)) continue;
                matchRouter = proxyObjectRouter;
                matchRouter.setArouter(this.replaceWildcard(path, arouter));
                matchRouter.setRouter(this.replaceWildcard(path, matchRouter.getRouter()));
                break;
            }
        }
        return matchRouter;
    }

    private String extractPathFromUrl(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return "";
        }
        String path = url.replaceAll("^https?://[^/]+", "");
        path = path.replaceAll("\\?.*$", "");
        return path;
    }

    private boolean isPathMatching(String actualPath, String pattern) {
        String[] patternSegments;
        String[] actualSegments = actualPath.split("/");
        if (actualSegments.length != (patternSegments = pattern.split("/")).length) {
            return false;
        }
        for (int i = 0; i < actualSegments.length; ++i) {
            String actual = actualSegments[i];
            String patternSeg = patternSegments[i];
            if (StrUtil.isBlank((CharSequence)actual) && StrUtil.isBlank((CharSequence)patternSeg) || this.isWildcardSegment(patternSeg) || actual.equals(patternSeg)) continue;
            return false;
        }
        return true;
    }

    private String replaceWildcard(String actualPath, String pattern) {
        String[] actualSegments = actualPath.split("/");
        String[] patternSegments = pattern.split("/");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < actualSegments.length; ++i) {
            String patternSeg;
            if (i > 0) {
                result.append("/");
            }
            if (this.isWildcardSegment(patternSeg = patternSegments[i])) {
                result.append(actualSegments[i]);
                continue;
            }
            result.append(patternSeg);
        }
        return result.toString();
    }

    private boolean isWildcardSegment(String segment) {
        return StrUtil.isNotBlank((CharSequence)segment) && segment.startsWith("{") && segment.endsWith("}") && segment.substring(1, segment.length() - 1).matches("\\d+");
    }

    private boolean isRoll(RouteMatchObject routeMatchObject, String authorizerId) {
        long count;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AccessRoll::getAuthorizerId, (Object)authorizerId);
        List rolls = this.rollMapper.selectList((Wrapper)wrapper);
        if (rolls.size() > 0 && (count = rolls.stream().filter(f -> "all".equals(f.getAuthorizerId()) || f.getAuthorizerId().equals(f.getAuthorizerId())).count()) > 0L) {
            String msg = "\u60a8\u5df2\u88ab\u5217\u5165\u9ed1\u540d\u5355\uff01\u65e0\u6743\u8bbf\u95ee\u8be5\u670d\u52a1\u8d44\u6e90\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01";
            routeMatchObject.addMessage(304, msg);
            return true;
        }
        return false;
    }

    private boolean isOverdue(RouteMatchObject routeMatchObject, Date expiretime) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentSecond = currentTimeMillis / 1000L;
        routeMatchObject.setCreateSecond(currentSecond);
        if (expiretime == null) {
            routeMatchObject.setExpireSecond(-1L);
        } else {
            long expireTimeMillis = expiretime.getTime();
            routeMatchObject.setExpireSecond(expireTimeMillis / 1000L);
            if (currentTimeMillis > expireTimeMillis) {
                routeMatchObject.addMessage(302, "\u60a8\u7684\u6388\u6743\u5df2\u8fc7\u671f");
                return true;
            }
        }
        return false;
    }

    private boolean isOutFrequency(String frequency, String proxyObjectId) throws Exception {
        JSONObject object;
        boolean flag = false;
        if (StrUtil.isBlank((CharSequence)frequency)) {
            return flag;
        }
        if (this.verificationAccess(proxyObjectId).booleanValue()) {
            return true;
        }
        List list = JSONObject.parseArray((String)frequency, JSONObject.class);
        Iterator iterator = list.iterator();
        while (!(!iterator.hasNext() || (object = (JSONObject)iterator.next()).getInteger("value") != 0 && this.verifaictionDate(object.getJSONArray("time"), object.getString("type")) && (flag = this.restrict(object, proxyObjectId)))) {
        }
        return flag;
    }

    private String xzqLimit(String url, String xzqLimit, String serviceType) {
        String newURL = url;
        if (StringUtils.isNotBlank((CharSequence)xzqLimit) && serviceType.equals("vec")) {
            Map map = (Map)JSONObject.parseObject((String)xzqLimit, Map.class);
            String[] split = xzqLimit.split("/");
            xzqLimit = split[split.length - 1];
            String filter = (String)map.get("filter");
            if (!"0000".equals(xzqLimit.substring(2))) {
                filter = "00".equals(xzqLimit.substring(4)) ? filter + xzqLimit.substring(0, 4) : filter + xzqLimit;
                newURL = newURL.contains("?") ? newURL + "&" + filter : newURL + "?" + filter;
            }
        }
        return newURL;
    }

    private JSONObject getResouceInfo(String id, Integer type) throws Exception {
        JSONObject jsonObject = null;
        String key = "resouce:" + type + ":" + id;
        Boolean aBoolean = this.redisTemplateService.isHasKey(key);
        if (aBoolean.booleanValue()) {
            String info = this.redisTemplateService.getInfoByBoundValueOps(key);
            if (StrUtil.isBlank((CharSequence)info)) {
                throw new Exception("\u67e5\u8be2\u670d\u52a1\u4e3a\u7a7a\uff01");
            }
            jsonObject = (JSONObject)JSON.parseObject((String)this.redisTemplateService.getInfoByBoundValueOps(key), JSONObject.class);
        }
        return jsonObject;
    }

    private void saveOnRedis(JSONObject result, Integer type) {
        String id = result.getString("id");
        String key = "resouce:" + type + ":" + id;
        Boolean aBoolean = this.redisTemplateService.isHasKey(key);
        if (!aBoolean.booleanValue()) {
            this.redisTemplateService.setInfoByBoundValueOps(key, result, 3, TimeUnit.MINUTES);
        }
    }

    public void verifaicationReferer(String refer, String referer) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)refer)) {
            Boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)referer)) {
                List<String> asList = Arrays.asList(refer.split(","));
                for (String referers : asList) {
                    if (!referer.equals(referers)) continue;
                    flag = true;
                }
            }
            if (!flag.booleanValue()) {
                throw new Exception("\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650\uff01");
            }
        }
    }

    private boolean verifaictionDate(JSONArray time, String type) throws ParseException {
        if (time != null && time.size() > 0) {
            if (StringUtils.isBlank((CharSequence)time.getString(0)) || StringUtils.isBlank((CharSequence)time.getString(1))) {
                return true;
            }
            DateTimeFormatter pattern = type.equals("HOURS") ? DateTimeFormatter.ofPattern("HH") : DateTimeFormatter.ofPattern("HH:mm");
            LocalTime str = LocalTime.parse(time.getString(0), pattern);
            LocalTime end = LocalTime.parse(time.getString(1), pattern);
            LocalTime now = LocalTime.now();
            return now.compareTo(str) != -1 && end.compareTo(now) != -1;
        }
        return true;
    }

    public boolean isForbiddenOnIp(ProxyObject proxyObject, HttpServletRequest request) {
        ProxyApplication proxyApplication;
        String uip = proxyObject.getIpscope();
        ProxyToken proxyToken = (ProxyToken)this.proxyTokenService.getById((Serializable)((Object)proxyObject.getToken()));
        if (proxyToken != null && (proxyApplication = (ProxyApplication)this.proxyApplicationService.getById((Serializable)((Object)proxyToken.getObjectid()))) != null && StringUtils.isNotBlank((CharSequence)proxyApplication.getUrls())) {
            uip = uip + (StrUtil.isBlank((CharSequence)uip) ? "" : ",") + proxyApplication.getUrls();
        }
        if (StrUtil.isBlank((CharSequence)uip)) {
            return false;
        }
        String reqIP = request.getHeader("Referer") == null ? "" : request.getHeader("Referer");
        String proxyIpKey = String.format("proxy:restrict:%s-%s", proxyObject.getId(), reqIP);
        if (this.redisTemplateService.isHasKey(proxyIpKey).booleanValue()) {
            return true;
        }
        if (!this.ipVerification.ipExistsInRange(reqIP, uip)) {
            this.redisTemplateService.getRedisTemplate().opsForValue().set((Object)proxyIpKey, (Object)"1");
            this.redisTemplateService.getRedisTemplate().expire((Object)proxyIpKey, (long)this.proxyTimeOut.intValue(), TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    private Boolean verificationAccess(String proxyObjectId) {
        Boolean flag = this.redisTemplateService.isHasKey("restrictBlack:" + proxyObjectId);
        return flag;
    }

    private void setVerificationAccess(String proxyObjectId, long time, TimeUnit timeUnit) {
        this.redisTemplateService.setFrequency("restrictBlack:" + proxyObjectId, 1, time, timeUnit);
    }

    private boolean restrict(JSONObject object, String proxyObjectId) throws Exception {
        boolean flag = false;
        String type = object.getString("type");
        TimeUnit timeUnit = TimeUnit.MINUTES;
        if ("MINUTES".equals(type)) {
            timeUnit = TimeUnit.MINUTES;
        } else if ("HOURS".equals(type)) {
            timeUnit = TimeUnit.HOURS;
        } else if ("DAY".equals(type)) {
            timeUnit = TimeUnit.DAYS;
        }
        flag = this.saveAuthorizer(proxyObjectId, object.getInteger("value"), timeUnit);
        return flag;
    }

    private boolean saveAuthorizer(String token, Integer access, TimeUnit timeUnit) {
        boolean isOut = false;
        Integer count = this.redisTemplateService.getFrequency("restrict:" + token);
        long tomorrow = LocalDateTime.of(LocalDate.now().plusDays(1L), LocalTime.MIN).toInstant(ZoneOffset.of("+8")).getEpochSecond();
        long now = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        long time = tomorrow - now;
        if (count != null) {
            if (count >= access) {
                this.redisTemplateService.setFrequency("restrictBlack:" + token, 1, timeUnit == TimeUnit.DAYS ? time : 10L, timeUnit == TimeUnit.DAYS ? TimeUnit.SECONDS : TimeUnit.MINUTES);
                isOut = true;
            }
        } else {
            count = 0;
        }
        this.redisTemplateService.setFrequency("restrict:" + token, count + 1, timeUnit == TimeUnit.DAYS ? time : 1L, timeUnit == TimeUnit.DAYS ? TimeUnit.SECONDS : timeUnit);
        return isOut;
    }
}

