/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.utils.cesium;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumCartesian2;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumCartographic;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumRectangle;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumTileOption;
import com.geoway.ns.proxy.utils.cesium.dto.ImageDTO;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public class CesiumUtil {
    public static List<List<CesiumTileOption>> getNWTileOptions(CesiumCartesian2 swXY, CesiumCartesian2 neXY, int level, int tileWidth, int tileHeight, CesiumRectangle offsetRectangle) {
        int minX = swXY.getX();
        int minY = neXY.getY();
        int maxX = neXY.getX();
        int maxY = swXY.getY();
        Integer x = minX;
        Integer y = minY;
        Integer top = 0;
        Integer left = 0;
        Integer width = 0;
        Integer height = 0;
        Double stepHeight = 0.0;
        Double stepWidth = 0.0;
        Integer countTileWidth = 0;
        Integer countTileHeight = 0;
        CesiumRectangle tileRectangle = new CesiumRectangle();
        CesiumRectangle intersectionRectangle = new CesiumRectangle();
        ArrayList<List<CesiumTileOption>> tileOptions = new ArrayList<List<CesiumTileOption>>();
        BigDecimal tileHeightDec = BigDecimal.valueOf(tileHeight);
        BigDecimal tileWidthDec = BigDecimal.valueOf(tileWidth);
        while (y <= maxY) {
            ArrayList<CesiumTileOption> tileRowOptions = new ArrayList<CesiumTileOption>();
            x = minX;
            countTileWidth = 0;
            while (x <= maxX) {
                tileRectangle = GeographicTilingScheme.tileXYToRectangle(x, y, level, tileWidth);
                stepHeight = tileHeightDec.divide(BigDecimal.valueOf(tileRectangle.getHeight()), 11, 4).doubleValue();
                stepWidth = tileWidthDec.divide(BigDecimal.valueOf(tileRectangle.getWidth()), 11, 4).doubleValue();
                intersectionRectangle = Rectangle.intersection(tileRectangle, offsetRectangle);
                if (intersectionRectangle == null) {
                    x = x + 1;
                    continue;
                }
                top = (int)Math.abs(Math.floor(new BigDecimal(intersectionRectangle.getNorth()).subtract(BigDecimal.valueOf(tileRectangle.getNorth())).multiply(BigDecimal.valueOf(stepHeight)).doubleValue()));
                left = (int)Math.abs(Math.floor(new BigDecimal(intersectionRectangle.getWest()).subtract(BigDecimal.valueOf(tileRectangle.getWest())).multiply(BigDecimal.valueOf(stepWidth)).doubleValue()));
                width = (int)Math.ceil(new BigDecimal(intersectionRectangle.getWidth()).multiply(BigDecimal.valueOf(stepWidth)).doubleValue());
                height = (int)Math.ceil(new BigDecimal(intersectionRectangle.getHeight()).multiply(BigDecimal.valueOf(stepHeight)).doubleValue());
                height = Math.min(height, tileHeight - top);
                width = Math.min(width, tileWidth - left);
                width = Math.min(width, tileWidth - countTileWidth);
                if (top >= tileHeight) {
                    ++minY;
                    break;
                }
                if (height <= 0) {
                    --maxY;
                    break;
                }
                if (left >= tileWidth) {
                    ++minX;
                    break;
                }
                if (width <= 0) {
                    --maxX;
                    break;
                }
                countTileWidth = countTileWidth + width;
                CesiumTileOption option = new CesiumTileOption(x, y, level);
                option.setCropOption(new CesiumTileOption.CropOption(left, top, width, height));
                tileRowOptions.add(option);
                x = x + 1;
            }
            if (!tileRowOptions.isEmpty()) {
                tileOptions.add(tileRowOptions);
            }
            y = y + 1;
        }
        if (!tileOptions.isEmpty()) {
            for (int i = 0; i < ((List)tileOptions.get(0)).size(); ++i) {
                List cesiumTileOptions;
                countTileHeight = 0;
                for (int j = 0; j < tileOptions.size() && !(cesiumTileOptions = (List)tileOptions.get(j)).isEmpty(); ++j) {
                    CesiumTileOption tile = (CesiumTileOption)cesiumTileOptions.get(i);
                    if (countTileHeight + tile.getCropOption().getHeight() > tileHeight) {
                        tile.getCropOption().setHeight(tileHeight - countTileHeight);
                    }
                    countTileHeight = countTileHeight + tile.getCropOption().getHeight();
                    if (tile.getCropOption().getHeight() != 0) continue;
                    ((List)tileOptions.get(j)).remove(i);
                    if (!((List)tileOptions.get(--j)).isEmpty()) continue;
                    tileOptions.remove(j);
                    --j;
                }
                if (countTileHeight == tileHeight) continue;
                List lastRow = (List)tileOptions.get(tileOptions.size() - 1);
                CesiumTileOption lastTile = (CesiumTileOption)lastRow.get(i);
                lastTile.getCropOption().setHeight(lastTile.getCropOption().getHeight() + (tileHeight - countTileHeight));
                lastTile.getCropOption().setTop(tileHeight - lastTile.getCropOption().getHeight());
            }
        }
        tileOptions.removeIf(f -> f.size() == 0);
        return tileOptions;
    }

    public static CesiumCartographic getOffsetPosition(double longitude, double latitude) {
        double val = 0.0;
        double x = BigDecimal.valueOf(Math.toDegrees(longitude)).setScale(8, 4).doubleValue();
        double y = BigDecimal.valueOf(Math.toDegrees(latitude)).setScale(8, 4).doubleValue();
        CesiumCartographic cartographic = Cartographic.fromDegrees(x + val, y + val);
        return cartographic;
    }

    public static ImageDTO requestImage(String url, CesiumTileOption option) {
        url = url.replace("{x}", option.getX().toString()).replace("{y}", option.getY().toString()).replace("{zz}", option.getLevel().toString()).replace("{z}", option.getLevel().toString()).replace("{zzz}", option.getLevel().toString());
        HttpResponse execute = HttpUtil.createGet((String)url).execute();
        try {
            BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(execute.bodyBytes()));
            BufferedImage bufferedImage = Thumbnails.of((BufferedImage[])new BufferedImage[]{originalImage}).sourceRegion(option.getCropOption().getLeft(), option.getCropOption().getTop(), option.getCropOption().getWidth(), option.getCropOption().getHeight()).scale(1.0).asBufferedImage();
            return new ImageDTO(bufferedImage, option.getCropOption().getLeft(), option.getCropOption().getTop());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedImage manageImage(List<ImageDTO> images, int tileWidth, int tileHeight) {
        BufferedImage firstImage = images.get(0).getImage();
        int channels = firstImage.getColorModel().getNumComponents();
        BufferedImage canvas = new BufferedImage(tileWidth, tileHeight, channels == 4 ? 2 : 1);
        Graphics2D g2d = canvas.createGraphics();
        if (channels == 4) {
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, tileWidth, tileHeight);
            g2d.setComposite(AlphaComposite.SrcOver);
        } else {
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, tileWidth, tileHeight);
        }
        for (ImageDTO input : images) {
            g2d.drawImage((Image)input.getImage(), input.getX(), input.getY(), null);
        }
        g2d.dispose();
        return canvas;
    }

    public static class CesiumMath {
        public static final double RADIANS_PER_DEGREE = Math.PI / 180;

        public static double toRadians(double degrees) {
            return degrees * (Math.PI / 180);
        }
    }

    public static class Cartographic {
        public static CesiumCartographic fromDegrees(double longitude, double latitude) {
            longitude = CesiumMath.toRadians(longitude);
            latitude = CesiumMath.toRadians(latitude);
            return new CesiumCartographic(longitude, latitude);
        }
    }

    public static class Rectangle {
        private static final double TWO_PI = Math.PI * 2;
        private static final double PI = Math.PI;

        public static CesiumRectangle intersection(CesiumRectangle rectangle, CesiumRectangle otherRectangle) {
            double north;
            double rectangleEast = rectangle.getEast();
            double rectangleWest = rectangle.getWest();
            double otherRectangleEast = otherRectangle.getEast();
            double otherRectangleWest = otherRectangle.getWest();
            if (rectangleEast < rectangleWest) {
                if (otherRectangleEast > 0.0) {
                    rectangleEast += Math.PI * 2;
                } else if (otherRectangleWest < 0.0) {
                    otherRectangleWest += Math.PI * 2;
                }
            } else if (otherRectangleEast < otherRectangleWest) {
                if (rectangleEast > 0.0) {
                    otherRectangleEast += Math.PI * 2;
                } else if (rectangleWest < 0.0) {
                    rectangleWest += Math.PI * 2;
                }
            }
            double west = Rectangle.negativePiToPi(Math.max(rectangleWest, otherRectangleWest));
            double east = Rectangle.negativePiToPi(Math.min(rectangleEast, otherRectangleEast));
            if ((rectangle.getWest() < rectangle.getEast() || otherRectangle.getWest() < otherRectangle.getEast()) && east <= west) {
                return null;
            }
            double south = Math.max(rectangle.getSouth(), otherRectangle.getSouth());
            if (south >= (north = Math.min(rectangle.getNorth(), otherRectangle.getNorth()))) {
                return null;
            }
            return new CesiumRectangle(west, south, east, north);
        }

        private static double negativePiToPi(double angle) {
            if ((angle %= Math.PI * 2) > Math.PI) {
                angle -= Math.PI * 2;
            } else if (angle < -Math.PI) {
                angle += Math.PI * 2;
            }
            return angle;
        }
    }

    public static class GeographicTilingScheme {
        private static final CesiumRectangle rectangle = new CesiumRectangle();

        public static CesiumRectangle tileXYToRectangle(int x, int y, int level, int width) {
            int xTiles = GeographicTilingScheme.getNumberOfXTilesAtLevel(level, width);
            int yTiles = GeographicTilingScheme.getNumberOfYTilesAtLevel(level, width);
            double xTileWidth = rectangle.getWidth() / (double)xTiles;
            double west = (double)x * xTileWidth + rectangle.getWest();
            double east = (double)(x + 1) * xTileWidth + rectangle.getWest();
            double yTileHeight = rectangle.getHeight() / (double)yTiles;
            double v = (double)y * yTileHeight;
            double north = rectangle.getNorth() - v;
            double v1 = (double)(y + 1) * yTileHeight;
            double south = rectangle.getNorth() - v1;
            return new CesiumRectangle(west, south, east, north);
        }

        public static CesiumCartesian2 positionToTileXY(CesiumCartographic position, int level, int width) {
            int yTileCoordinate;
            int xTileCoordinate;
            int xTiles = GeographicTilingScheme.getNumberOfXTilesAtLevel(level, width);
            int yTiles = GeographicTilingScheme.getNumberOfYTilesAtLevel(level, width);
            double xTileWidth = rectangle.getWidth() / (double)xTiles;
            double yTileHeight = rectangle.getHeight() / (double)yTiles;
            double longitude = position.getLongitude();
            if (rectangle.getEast() < rectangle.getWest()) {
                longitude += Math.PI * 2;
            }
            if ((xTileCoordinate = (int)((longitude - rectangle.getWest()) / xTileWidth)) >= xTiles) {
                xTileCoordinate = xTiles - 1;
            }
            if ((yTileCoordinate = (int)((rectangle.getNorth() - position.getLatitude()) / yTileHeight)) >= yTiles) {
                yTileCoordinate = yTiles - 1;
            }
            return new CesiumCartesian2(xTileCoordinate, yTileCoordinate);
        }

        private static int getNumberOfXTilesAtLevel(int level, int width) {
            if (width == 256) {
                return 2 << level;
            }
            return 1 << level;
        }

        private static int getNumberOfYTilesAtLevel(int level, int width) {
            if (width == 256) {
                return 1 << level;
            }
            return (1 << level) / 2;
        }
    }
}

