/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.utils.httpclient;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.proxy.constant.enums.ResponseExceptionType;
import com.geoway.ns.proxy.utils.UnityUtils;
import com.geoway.ns.proxy.utils.httpclient.HTTPClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;

public class ProxyHttpClient
implements HTTPClient {
    @Override
    public void fetchs(String url, Map<String, Object> map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        String json = this.inputStreamPra(request.getInputStream());
        RequestConfig resquestConfig = RequestConfig.custom().setSocketTimeout(300000).setConnectTimeout(20000).setConnectionRequestTimeout(20000).build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.getMethod()).setUri(uriBuilder.build()).setEntity((HttpEntity)new StringEntity(json, "UTF-8")).setConfig(resquestConfig);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            if (!"content-type".equals(header)) continue;
            requestBuilder.setHeader(header, request.getHeader(header));
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if ("gk".equals(name)) continue;
            requestBuilder.addParameter(name, request.getParameter(name));
        }
        for (Map.Entry entry : map.entrySet()) {
            requestBuilder.addParameter((String)entry.getKey(), entry.getValue().toString());
        }
        try (CloseableHttpClient client = "https".equals(url.substring(0, 5)) ? this.createSSLClientDefault() : HttpClients.createDefault();){
            CloseableHttpResponse closeableHttpResponse = client.execute(requestBuilder.build());
            HttpEntity entity = closeableHttpResponse.getEntity();
            for (Header header : closeableHttpResponse.getAllHeaders()) {
                response.setHeader(header.getName(), header.getValue());
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if (entity.isStreaming()) {
                entity.writeTo((OutputStream)outputStream);
            }
            outputStream.flush();
            outputStream.close();
            closeableHttpResponse.close();
            return;
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> fetch(String url, HttpServletRequest request, HttpServletResponse response) throws Exception {
        double costTime;
        JSONObject log = new JSONObject();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        int code = 1000;
        long afterTime = 0L;
        long beforeTime = System.currentTimeMillis();
        Object res = null;
        CloseableHttpClient client = "https".equals(url.substring(0, 5)) ? this.createSSLClientDefault() : HttpClients.createDefault();
        CloseableHttpResponse result = null;
        HttpEntity entity = null;
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            HttpUriRequest execute = this.getExecute(url, log, requestHeader, request);
            result = client.execute(execute);
            afterTime = System.currentTimeMillis();
            code = result.getStatusLine().getStatusCode();
            entity = result.getEntity();
            entity = new BufferedHttpEntity(entity);
            for (Header header : result.getAllHeaders()) {
                response.setHeader(header.getName(), header.getValue());
            }
            entity.writeTo((OutputStream)outputStream);
            costTime = afterTime == 0L ? (double)afterTime : (double)(afterTime - beforeTime) / 1000.0;
        }
        catch (Exception e) {
            double costTime2;
            try {
                if (result == null) {
                    String message = e.getMessage();
                    String msg = message == "" ? "\u8f6c\u53d1\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u65e0\u6cd5\u8bbf\u95ee\uff01" : message;
                    map.put("msg", "\u8bbf\u95ee\u5730\u5740\u5f02\u5e38\uff1a" + msg);
                }
                costTime2 = afterTime == 0L ? (double)afterTime : (double)(afterTime - beforeTime) / 1000.0;
            }
            catch (Throwable throwable) {
                double costTime3 = afterTime == 0L ? (double)afterTime : (double)(afterTime - beforeTime) / 1000.0;
                Integer exception = code >= 200 && code <= 207 ? ResponseExceptionType.NotException.value : ResponseExceptionType.Exception.value;
                HashMap responseHeader = new HashMap();
                if (exception == ResponseExceptionType.Exception.value && entity != null) {
                    InputStream in = entity.getContent();
                    String collect = "";
                    collect = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    log.put("result", (Object)collect);
                    in.close();
                } else if (exception == ResponseExceptionType.NotException.value) {
                    log.put("result", (Object)"succeed");
                } else {
                    log.put("result", (Object)(map.get("msg") == null ? "" : map.get("msg")));
                }
                int index = url.indexOf("?");
                log.put("code", (Object)code);
                log.put("costTime", (Object)costTime3);
                log.put("exception", (Object)exception);
                log.put("responseHeader", responseHeader);
                log.put("requestHeader", requestHeader);
                log.put("url", (Object)url.substring(0, index == -1 ? url.length() : index));
                log.put("method", (Object)request.getMethod());
                log.put("accessTime", (Object)LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
                map.put("code", code);
                map.put("costTime", costTime3);
                map.put("exception", exception);
                map.put("log", log);
                outputStream.flush();
                outputStream.close();
                if (result != null) {
                    result.close();
                }
                client.close();
                throw throwable;
            }
            Integer exception = code >= 200 && code <= 207 ? ResponseExceptionType.NotException.value : ResponseExceptionType.Exception.value;
            HashMap responseHeader = new HashMap();
            if (exception == ResponseExceptionType.Exception.value && entity != null) {
                InputStream in = entity.getContent();
                String collect = "";
                collect = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                log.put("result", (Object)collect);
                in.close();
            } else if (exception == ResponseExceptionType.NotException.value) {
                log.put("result", (Object)"succeed");
            } else {
                log.put("result", (Object)(map.get("msg") == null ? "" : map.get("msg")));
            }
            int index = url.indexOf("?");
            log.put("code", (Object)code);
            log.put("costTime", (Object)costTime2);
            log.put("exception", (Object)exception);
            log.put("responseHeader", responseHeader);
            log.put("requestHeader", requestHeader);
            log.put("url", (Object)url.substring(0, index == -1 ? url.length() : index));
            log.put("method", (Object)request.getMethod());
            log.put("accessTime", (Object)LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
            map.put("code", code);
            map.put("costTime", costTime2);
            map.put("exception", exception);
            map.put("log", log);
            outputStream.flush();
            outputStream.close();
            if (result != null) {
                result.close();
            }
            client.close();
        }
        Integer exception = code >= 200 && code <= 207 ? ResponseExceptionType.NotException.value : ResponseExceptionType.Exception.value;
        HashMap responseHeader = new HashMap();
        if (exception == ResponseExceptionType.Exception.value && entity != null) {
            InputStream in = entity.getContent();
            String collect = "";
            collect = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            log.put("result", (Object)collect);
            in.close();
        } else if (exception == ResponseExceptionType.NotException.value) {
            log.put("result", (Object)"succeed");
        } else {
            log.put("result", (Object)(map.get("msg") == null ? "" : map.get("msg")));
        }
        int index = url.indexOf("?");
        log.put("code", (Object)code);
        log.put("costTime", (Object)costTime);
        log.put("exception", (Object)exception);
        log.put("responseHeader", responseHeader);
        log.put("requestHeader", requestHeader);
        log.put("url", (Object)url.substring(0, index == -1 ? url.length() : index));
        log.put("method", (Object)request.getMethod());
        log.put("accessTime", (Object)LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
        map.put("code", code);
        map.put("costTime", costTime);
        map.put("exception", exception);
        map.put("log", log);
        outputStream.flush();
        outputStream.close();
        if (result != null) {
            result.close();
        }
        client.close();
        return map;
    }

    private HttpUriRequest getExecute(String url, JSONObject log, HashMap<String, String> requestHeader, HttpServletRequest request) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(UnityUtils.getRealUrlUtil(url, 5));
        RequestConfig resquestConfig = RequestConfig.custom().setSocketTimeout(0x6DDD00).setConnectTimeout(180000).build();
        String method = request.getMethod();
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setConfig(resquestConfig).setUri(uriBuilder.build());
        if (Method.POST.toString().equalsIgnoreCase(method)) {
            ArrayList<BasicNameValuePair> forms = new ArrayList<BasicNameValuePair>();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                if ("gk".equals(name)) continue;
                forms.add(new BasicNameValuePair(name, request.getParameter(name)));
            }
            String json = this.inputStreamPra(request.getInputStream());
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(forms);
            if (StringUtils.isBlank((CharSequence)json)) {
                requestBuilder.setEntity((HttpEntity)form);
                log.put("params", forms);
            } else {
                requestBuilder.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
                requestBuilder.setHeader("Content-Type", "application/json");
                log.put("params", (Object)json);
            }
            List<NameValuePair> params = this.getQueryParam(url, request);
            if (!params.isEmpty()) {
                params.forEach(f -> requestBuilder.addParameters(new NameValuePair[]{f}));
            }
        } else {
            List<NameValuePair> params = this.getParams(url, request);
            params.forEach(nameValuePair -> requestBuilder.addParameters(new NameValuePair[]{nameValuePair}));
            requestBuilder.setUri(uriBuilder.build()).setConfig(resquestConfig);
            log.put("params", params);
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            if (!StringUtils.isNotBlank((CharSequence)header) || "content-type".equalsIgnoreCase(header) || "content-length".equalsIgnoreCase(header) || "host".equalsIgnoreCase(header)) continue;
            requestBuilder.setHeader(header, request.getHeader(header));
            requestHeader.put(header, request.getHeader(header));
        }
        return requestBuilder.build();
    }

    public String inputStreamPra(ServletInputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        String s = "";
        while ((s = br.readLine()) != null) {
            sb.append(s);
        }
        return sb.toString();
    }

    private List<NameValuePair> getParams(String url, HttpServletRequest request) throws Exception {
        ArrayList<NameValuePair> mapParam = new ArrayList<NameValuePair>();
        String param = UnityUtils.getRealUrlUtil(url, 4);
        List<String> list = Arrays.asList(param.split("&"));
        list.forEach(f -> {
            int index;
            if (!f.contains("gk") && (index = f.indexOf("=")) > 0) {
                try {
                    String name = f.substring(0, index);
                    String value = URLDecoder.decode(f.substring(index + 1), StandardCharsets.UTF_8.name());
                    mapParam.add((NameValuePair)new BasicNameValuePair(name, value));
                }
                catch (UnsupportedEncodingException e) {
                    mapParam.add((NameValuePair)new BasicNameValuePair(f.substring(0, index), f.substring(index + 1)));
                }
            }
        });
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if ("gk".equals(name) || mapParam.stream().filter(s -> s.getName().equals(name)).collect(Collectors.toList()).size() != 0) continue;
            mapParam.add((NameValuePair)new BasicNameValuePair(name, request.getParameter(name)));
        }
        Object mask = request.getAttribute("mask");
        if (ObjectUtil.isNotEmpty((Object)mask)) {
            mapParam.add((NameValuePair)new BasicNameValuePair("mask", mask.toString()));
        }
        return mapParam;
    }

    private List<NameValuePair> getQueryParam(String url, HttpServletRequest request) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        String param = UnityUtils.getRealUrlUtil(url, 4);
        List<String> list = Arrays.asList(param.split("&"));
        list.forEach(f -> {
            int index;
            if (!f.contains("gk") && (index = f.indexOf("=")) > 0) {
                try {
                    String name = f.substring(0, index);
                    String value = URLDecoder.decode(f.substring(index + 1), StandardCharsets.UTF_8.name());
                    paramList.add((NameValuePair)new BasicNameValuePair(name, value));
                }
                catch (UnsupportedEncodingException e) {
                    paramList.add((NameValuePair)new BasicNameValuePair(f.substring(0, index), f.substring(index + 1)));
                }
            }
        });
        return paramList;
    }

    private CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }
}

