/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.proxy.config.ApplicationYmlConfig;
import com.geoway.ns.proxy.constant.enums.TokenModel;
import com.geoway.ns.proxy.dto.ProxyObjectLimit;
import com.geoway.ns.proxy.entity.AuthorizeToken;
import com.geoway.ns.proxy.entity.ProxyObject;
import com.geoway.ns.proxy.entity.ProxyObjectRouter;
import com.geoway.ns.proxy.entity.ProxyToken;
import com.geoway.ns.proxy.entity.SimpleZyfxObject;
import com.geoway.ns.proxy.entity.SimpleZyfxServiceset;
import com.geoway.ns.proxy.entity.SimpleZyfxServicesetApi;
import com.geoway.ns.proxy.mapper.AuthorizeTokenMapper;
import com.geoway.ns.proxy.mapper.ProxyObjectMapper;
import com.geoway.ns.proxy.service.ProxyObjectRouterService;
import com.geoway.ns.proxy.service.ProxyObjectService;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.proxy.service.RedisTemplateService;
import com.geoway.ns.proxy.service.SimpleZyfxObjectService;
import com.geoway.ns.proxy.service.SimpleZyfxServicesetApiService;
import com.geoway.ns.proxy.service.SimpleZyfxServicesetService;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProxyObjectServiceImpl
extends MPJBaseServiceImpl<ProxyObjectMapper, ProxyObject>
implements ProxyObjectService {
    @Resource
    SimpleZyfxObjectService simpleZyfxObjectService;
    @Resource
    SimpleZyfxServicesetService simpleZyfxServicesetService;
    @Resource
    ProxyTokenService proxyTokenService;
    @Resource
    ProxyObjectRouterService proxyObjectRouterService;
    @Resource
    ApplicationYmlConfig applicationYmlConfig;
    @Resource
    AuthorizeTokenMapper authorizeTokenMapper;
    @Autowired
    RedisTemplateService redisTemplateService;
    @Autowired
    private SimpleZyfxServicesetApiService simpleZyfxServicesetApiService;

    @Override
    public void saveOneProxyObject(int authWay, ProxyObject proxyObject) throws BizException {
        ProxyToken proxyToken;
        TokenModel tokenModel = TokenModel.User;
        String token = proxyObject.getToken();
        if (token.startsWith(TokenModel.application.tag)) {
            tokenModel = TokenModel.application;
        }
        if ((proxyToken = (ProxyToken)this.proxyTokenService.getById((Serializable)((Object)token))) == null || proxyToken.getDisable() == 1) {
            throw new BizException("\u65e0\u6548token");
        }
        SimpleZyfxObject simpleZyfxObject = (SimpleZyfxObject)this.simpleZyfxObjectService.getById((Serializable)((Object)proxyObject.getServiceid()));
        if (simpleZyfxObject == null) {
            throw new BizException("\u7ed1\u5b9a\u7684\u8d44\u6e90\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyObject::getToken, (Object)proxyObject.getToken());
        queryWrapper.eq(ProxyObject::getServiceid, (Object)proxyObject.getServiceid());
        queryWrapper.last(" limit 1");
        ProxyObject proxyObjectOld = (ProxyObject)this.getOne((Wrapper)queryWrapper);
        if (proxyObjectOld != null) {
            proxyObject.setId(proxyObjectOld.getId());
        }
        proxyObject.setAuthway(authWay);
        proxyObject.setServicetype(simpleZyfxObject.getGs());
        proxyObject.setAuthtype(proxyToken.getType());
        proxyObject.setServicename(simpleZyfxObject.getName());
        this.saveOrUpdate(proxyObject);
        SimpleZyfxServiceset simpleZyfxServiceset = (SimpleZyfxServiceset)this.simpleZyfxServicesetService.getById((Serializable)((Object)proxyObject.getServiceid()));
        this.addProxyObjectRouter(proxyObject.getId(), proxyObject.getServicetype(), simpleZyfxServiceset, proxyObject.getToken());
    }

    @Override
    public void updateProxyRoute(String serviceId) throws BizException {
        SimpleZyfxObject simpleZyfxObject = (SimpleZyfxObject)this.simpleZyfxObjectService.getById((Serializable)((Object)serviceId));
        if (simpleZyfxObject == null) {
            return;
        }
        SimpleZyfxServiceset simpleZyfxServiceset = (SimpleZyfxServiceset)this.simpleZyfxServicesetService.getById((Serializable)((Object)serviceId));
        if (simpleZyfxServiceset == null) {
            return;
        }
        this.updateOldProxy(simpleZyfxServiceset);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyObject::getServiceid, (Object)serviceId);
        List proxyObjects = this.list((Wrapper)queryWrapper);
        if (proxyObjects == null || proxyObjects.size() == 0) {
            return;
        }
        for (ProxyObject proxyObject : proxyObjects) {
            proxyObject.setServicetype(simpleZyfxObject.getGs());
            List rid = this.proxyObjectRouterService.listObjs((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProxyObjectRouter.class).eq(ProxyObjectRouter::getObjectid, (Object)proxyObject.getId())).select(new SFunction[]{ProxyObjectRouter::getId}), Object::toString);
            List<String> nids = this.addProxyObjectRouter(proxyObject.getId(), proxyObject.getServicetype(), simpleZyfxServiceset, proxyObject.getToken());
            rid.removeIf(nids::contains);
            if (!rid.isEmpty()) {
                this.proxyObjectRouterService.removeBatchByIds(rid);
            }
            String key = "proxy:" + proxyObject.getToken();
            this.redisTemplateService.deleteKey(key);
        }
        this.updateBatchById(proxyObjects);
    }

    @Override
    public IPage<ProxyObject> queryByFilter(String filterParam, String sortParam, String serviceName, int page, int size) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ProxyObject.class);
        queryWrapper.selectAll(ProxyObject.class);
        queryWrapper.selectAs("u", SimpleZyfxObject::getName, ProxyObject::getServiceNewname);
        queryWrapper.leftJoin(SimpleZyfxObject.class, "u", SimpleZyfxObject::getId, ProxyObject::getServiceid);
        if (StrUtil.isNotBlank((CharSequence)serviceName)) {
            queryWrapper.like(SimpleZyfxObject::getName, (Object)serviceName);
        }
        Page pageT = new Page((long)page, (long)size);
        IPage pageResults = this.page((IPage)pageT, (Wrapper)queryWrapper);
        return pageResults;
    }

    @Override
    public IPage<ProxyObject> queryProxyObjectByObject(String objectId, int objectType, String filterParam, String sortParam, String serviceName, int page, int size) throws Exception {
        boolean flag;
        boolean bl = flag = objectType == 1 || objectType == 2;
        if (!flag || StrUtil.isBlank((CharSequence)objectId)) {
            throw new BizException("\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b");
        }
        TokenModel tokenModel = TokenModel.User;
        if (objectType == 2) {
            tokenModel = TokenModel.application;
        }
        String token = this.proxyTokenService.fetchToken(objectId, null, tokenModel);
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";Q_token_S_EQ=" + token;
        return this.queryByFilter(filterParam, sortParam, serviceName, page, size);
    }

    @Override
    public IPage<ProxyObject> queryAllProxyObjectByObject(String objectId, int objectType, String filterParam, String sortParam, String serviceName, int page, int size) throws Exception {
        boolean flag;
        boolean bl = flag = objectType == 1 || objectType == 2;
        if (!flag || StrUtil.isBlank((CharSequence)objectId)) {
            throw new BizException("\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b");
        }
        TokenModel tokenModel = TokenModel.User;
        if (objectType == 2) {
            tokenModel = TokenModel.application;
        }
        String token = this.proxyTokenService.fetchToken(objectId, null, tokenModel);
        Page proxyObjectPage = new Page((long)page, (long)size);
        List<ProxyObject> proxyObjectList = ((ProxyObjectMapper)this.baseMapper).queryAllProxyObjectByObject(token, objectId, serviceName, filterParam);
        proxyObjectPage.setTotal((long)proxyObjectList.size());
        proxyObjectPage.setPages((long)Math.ceil(proxyObjectList.size() / page));
        proxyObjectPage.setRecords(proxyObjectList.subList((page - 1) * size, page * size > proxyObjectList.size() ? proxyObjectList.size() : page * size));
        return proxyObjectPage;
    }

    @Override
    public void batchAddProxyObject(String objectId, String objectName, int objectType, int authWay, String serviceIds, ProxyObjectLimit proxyObjectLimit) throws BizException {
        String[] serviceIdArr;
        boolean flag;
        boolean bl = flag = objectType == 1 || objectType == 2;
        if (!flag || StrUtil.isBlank((CharSequence)objectId)) {
            throw new BizException("\u4e0d\u652f\u6301\u7684\u5bf9\u8c61\u7c7b\u578b");
        }
        TokenModel tokenModel = TokenModel.User;
        if (objectType == 2) {
            tokenModel = TokenModel.application;
        }
        String token = this.proxyTokenService.fetchToken(objectId, objectName, tokenModel);
        for (String serviceId : serviceIdArr = serviceIds.split(",")) {
            ProxyObject proxyObject = new ProxyObject();
            proxyObject.setAuthway(authWay);
            proxyObject.setAuthtype(objectType);
            proxyObject.setToken(token);
            proxyObject.setServiceid(serviceId);
            proxyObject.setIpscope(proxyObjectLimit.getIpScope());
            proxyObject.setExpiretime(proxyObjectLimit.getExpiretime());
            proxyObject.setFrequency(proxyObjectLimit.getFrequency());
            proxyObject.setXzqlimit(proxyObjectLimit.getXzqlimit());
            proxyObject.setExtension(proxyObjectLimit.getExtension());
            this.saveOneProxyObject(authWay, proxyObject);
        }
    }

    @Override
    public void deleteProxyObject(String id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyObjectRouter::getObjectid, (Object)id);
        this.proxyObjectRouterService.remove((Wrapper)queryWrapper);
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void batchDeleteProxyObject(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(ProxyObjectRouter::getObjectid, idList);
        this.proxyObjectRouterService.remove((Wrapper)queryWrapper);
        this.removeBatchByIds(idList);
        this.authorizeTokenMapper.deleteBatchIds(idList);
    }

    @Override
    public void toggleProxyObjectEnable(String ids, boolean enable) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        int status = enable ? 1 : 2;
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.set(ProxyObject::getStatus, (Object)status);
        updateWrapper.in(ProxyObject::getId, idList);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void saveLimitParams(String ids, ProxyObjectLimit proxyObjectLimit) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            ProxyObject proxyObject = (ProxyObject)this.getById((Serializable)((Object)id));
            if (proxyObject != null) {
                proxyObject.setExpiretime(proxyObjectLimit.getExpiretime());
                proxyObject.setIpscope(proxyObjectLimit.getIpScope());
                proxyObject.setFrequency(proxyObjectLimit.getFrequency());
                proxyObject.setExtension(proxyObjectLimit.getExtension());
                this.updateById(proxyObject);
                continue;
            }
            AuthorizeToken authorizeToken = (AuthorizeToken)this.authorizeTokenMapper.selectById((Serializable)((Object)id));
            authorizeToken.setIndate(proxyObjectLimit.getExpiretime());
            authorizeToken.setIpScope(proxyObjectLimit.getIpScope());
            authorizeToken.setFrequency(proxyObjectLimit.getFrequency());
            this.authorizeTokenMapper.updateById(authorizeToken);
        }
    }

    @Override
    public String queryProxyURL(String id) {
        ProxyObject proxyObject = (ProxyObject)this.getById((Serializable)((Object)id));
        SimpleZyfxServiceset simpleZyfxServiceset = (SimpleZyfxServiceset)this.simpleZyfxServicesetService.getById((Serializable)((Object)proxyObject.getServiceid()));
        String orgUrl = simpleZyfxServiceset.getUrl();
        URL netURL = URLUtil.url((String)orgUrl);
        String relPath = netURL.getPath();
        String proxyURL = String.format("%s%s?gk=%s", this.applicationYmlConfig.getProxyUrl(), relPath, proxyObject.getToken());
        return proxyURL;
    }

    @Override
    public String queryProxyURL2(String proxyUrl, String id) {
        ProxyObject proxyObject = (ProxyObject)this.getById((Serializable)((Object)id));
        String proxyURL = null;
        if (proxyObject != null) {
            SimpleZyfxServiceset simpleZyfxServiceset = (SimpleZyfxServiceset)this.simpleZyfxServicesetService.getById((Serializable)((Object)proxyObject.getServiceid()));
            String orgUrl = simpleZyfxServiceset.getUrl();
            URL netURL = URLUtil.url((String)orgUrl);
            String relPath = StringUtils.isEmpty((CharSequence)simpleZyfxServiceset.getVirtualUrl()) ? netURL.getPath() : simpleZyfxServiceset.getVirtualUrl();
            proxyURL = String.format("%s%s?gk=%s", proxyUrl, relPath, proxyObject.getToken());
        } else {
            AuthorizeToken authorizeToken = (AuthorizeToken)this.authorizeTokenMapper.selectById((Serializable)((Object)id));
            proxyURL = String.format("%s%s", proxyUrl, authorizeToken.getRelativeUrl());
        }
        return proxyURL;
    }

    private List<String> addProxyObjectRouter(String objectId, String serviceType, SimpleZyfxServiceset simpleZyfxServiceset, String token) throws BizException {
        List<SimpleZyfxServicesetApi> apiList = this.simpleZyfxServicesetApiService.queryByOid(simpleZyfxServiceset.getId());
        ArrayList<ProxyObjectRouter> proxyObjectRouters = new ArrayList<ProxyObjectRouter>();
        String resoureURL = simpleZyfxServiceset.getUrl();
        URL netURL = URLUtil.url((String)resoureURL);
        String urlprefix = String.format("%s://%s:%s", netURL.getProtocol(), netURL.getHost(), netURL.getPort());
        ProxyObjectRouter router = this.getRouter(objectId, token, urlprefix, resoureURL, simpleZyfxServiceset.getVirtualUrl());
        proxyObjectRouters.add(router);
        if (!apiList.isEmpty()) {
            for (SimpleZyfxServicesetApi api : apiList) {
                ProxyObjectRouter objectRouter = this.getRouter(objectId, token, urlprefix, api.getUrl(), api.getVirtualUrl());
                boolean match = proxyObjectRouters.stream().anyMatch(a -> a.getRouter().equals(objectRouter.getRouter()));
                if (match) continue;
                proxyObjectRouters.add(objectRouter);
            }
        }
        this.proxyObjectRouterService.saveOrUpdateBatch(proxyObjectRouters);
        return proxyObjectRouters.stream().map(m -> m.getId()).collect(Collectors.toList());
    }

    private ProxyObjectRouter getRouter(String objectId, String token, String urlprefix, String url, String virtualPath) {
        URL netURL = URLUtil.url((String)url);
        String path = netURL.getPath();
        String query = netURL.getQuery();
        ProxyObjectRouter proxyObjectRouter = new ProxyObjectRouter();
        proxyObjectRouter.setObjectid(objectId);
        proxyObjectRouter.setToken(token);
        proxyObjectRouter.setUrlprefix(urlprefix);
        proxyObjectRouter.setRouter(path);
        proxyObjectRouter.setArouter(StringUtils.isBlank((CharSequence)virtualPath) ? path : virtualPath);
        proxyObjectRouter.setParams(query);
        ProxyObjectRouter oldRoute = this.findExists(objectId, path);
        if (oldRoute != null) {
            proxyObjectRouter.setId(oldRoute.getId());
        }
        return proxyObjectRouter;
    }

    private ProxyObjectRouter findExists(String objectId, String vecURL) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyObjectRouter::getObjectid, (Object)objectId);
        queryWrapper.eq(ProxyObjectRouter::getRouter, (Object)vecURL);
        queryWrapper.last(" limit 1");
        return (ProxyObjectRouter)this.proxyObjectRouterService.getOne((Wrapper)queryWrapper);
    }

    private List<String> getVectorTilePath(String path, String styleId) throws BizException {
        String serviceName = null;
        ArrayList<String> vecUrls = new ArrayList<String>();
        if (path.matches("/mapserver/all/\\w+/getMap") || path.matches("/mapserver/vmap/\\w+/getMap") || path.matches("/mapserver/data/\\w+/getData") || path.matches("/mapserver/label/\\w+/getImg") || path.matches("/mapserver/label/\\w+/getData")) {
            int indexPosEnd = path.lastIndexOf("/");
            int indexPos = path.lastIndexOf("/", indexPosEnd - 1);
            serviceName = path.substring(indexPos + 1, indexPosEnd);
        } else if (path.matches("/mapserver/vmap/WMTS/1.0/\\w+") || path.matches("/mapserver/vmap/WMS/1.0/\\w+") || path.matches("/mapserver/label/WMTS/1.0/\\w+") || path.matches("/mapserver/label/WMS/1.0/\\w+")) {
            int indexPos = path.lastIndexOf("/");
            serviceName = path.substring(indexPos + 1);
        }
        if (StrUtil.isBlank((CharSequence)serviceName)) {
            throw new BizException("\u83b7\u53d6\u670d\u52a1\u5730\u5740\u5931\u8d25");
        }
        vecUrls.add(String.format("/mapserver/all/%s/getMap", serviceName));
        vecUrls.add(String.format("/mapserver/vmap/%s/getMap", serviceName));
        vecUrls.add(String.format("/mapserver/data/%s/getData", serviceName));
        vecUrls.add(String.format("/mapserver/label/%s/getImg", serviceName));
        vecUrls.add(String.format("/mapserver/label/%s/getData", serviceName));
        vecUrls.add("/mapserver/vmap/WMTS/1.0/" + serviceName + (styleId != null ? "/" + styleId : ""));
        vecUrls.add("/mapserver/vmap/WMS/1.0/" + serviceName + (styleId != null ? "/" + styleId : ""));
        vecUrls.add("/mapserver/label/WMTS/1.0/" + serviceName + (styleId != null ? "/" + styleId : ""));
        vecUrls.add("/mapserver/label/WMS/1.0/" + serviceName + (styleId != null ? "/" + styleId : ""));
        vecUrls.add(String.format("/mapserver/styleInfo/%s", serviceName));
        vecUrls.add(String.format("/mapserver/%s", serviceName));
        vecUrls.add(String.format("/mapserver/control/setControl", new Object[0]));
        vecUrls.add(String.format("/mapserver/serverInfo/%s", serviceName));
        return vecUrls;
    }

    private void updateOldProxy(SimpleZyfxServiceset serviceset) {
        List tokens = this.authorizeTokenMapper.selectList((Wrapper)Wrappers.lambdaQuery(AuthorizeToken.class).eq(AuthorizeToken::getResourceId, (Object)serviceset.getId()));
        if (!tokens.isEmpty()) {
            for (AuthorizeToken token : tokens) {
                token.setUrl(serviceset.getUrl());
                this.authorizeTokenMapper.updateById(token);
            }
        }
    }
}

