/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.utils.cesium.dto;

public class CesiumRectangle {
    private double west;
    private double south;
    private double east;
    private double north;

    public CesiumRectangle(double west, double south, double east, double north) {
        this.west = west;
        this.south = south;
        this.east = east;
        this.north = north;
    }

    public CesiumRectangle() {
        this.west = -Math.PI;
        this.south = -1.5707963267948966;
        this.east = Math.PI;
        this.north = 1.5707963267948966;
    }

    public double getWidth() {
        return this.east - this.west;
    }

    public double getHeight() {
        return this.north - this.south;
    }

    public double[] southwest() {
        return new double[]{this.south, this.west};
    }

    public double[] northeast() {
        return new double[]{this.north, this.east};
    }

    public double getWest() {
        return this.west;
    }

    public void setWest(double west) {
        this.west = west;
    }

    public double getSouth() {
        return this.south;
    }

    public void setSouth(double south) {
        this.south = south;
    }

    public double getEast() {
        return this.east;
    }

    public void setEast(double east) {
        this.east = east;
    }

    public double getNorth() {
        return this.north;
    }

    public void setNorth(double north) {
        this.north = north;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CesiumRectangle that = (CesiumRectangle)o;
        return Double.compare(this.west, that.west) == 0 && Double.compare(this.south, that.south) == 0 && Double.compare(this.east, that.east) == 0 && Double.compare(this.north, that.north) == 0;
    }
}

