/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.proxy.constant.enums.TokenModel;
import com.geoway.ns.proxy.entity.ProxyToken;
import com.geoway.ns.proxy.mapper.ProxyApplicationMapper;
import com.geoway.ns.proxy.mapper.ProxyTokenMapper;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.sys.service.ITokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProxyTokenServiceImpl
extends ServiceImpl<ProxyTokenMapper, ProxyToken>
implements ProxyTokenService {
    private static final Logger log = LoggerFactory.getLogger(ProxyTokenServiceImpl.class);
    @Autowired
    ITokenService tokenService;
    @Autowired
    ProxyApplicationMapper proxyApplicationMapper;

    @Override
    public String fetchToken(String objectId, String objectName, TokenModel tokenModel) {
        if (tokenModel == TokenModel.temp) {
            return this.createTempToken();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyToken::getObjectid, (Object)objectId);
        queryWrapper.eq(ProxyToken::getDisable, (Object)0);
        queryWrapper.orderByDesc(ProxyToken::getCreatetime);
        queryWrapper.last(" limit 1");
        ProxyToken proxyToken = (ProxyToken)this.getOne((Wrapper)queryWrapper);
        if (proxyToken == null) {
            proxyToken = this.createProxyToken(objectId, objectName, tokenModel);
        }
        return proxyToken.getId();
    }

    @Override
    public String createTempToken() {
        return this.createToken(TokenModel.temp);
    }

    @Override
    public ProxyToken createProxyToken(String objectId, String objectName, TokenModel tokenModel) {
        String token = this.createToken(tokenModel);
        ProxyToken proxyToken = new ProxyToken();
        proxyToken.setId(token);
        proxyToken.setObjectid(objectId);
        proxyToken.setObjectname(objectName);
        proxyToken.setType(tokenModel.value);
        this.save(proxyToken);
        return proxyToken;
    }

    @Override
    public void setDisable(String id, boolean disable) {
        int flag = disable ? 1 : 0;
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.set(ProxyToken::getDisable, (Object)flag);
        updateWrapper.eq(ProxyToken::getId, (Object)id);
        this.update((Wrapper)updateWrapper);
    }

    private String createToken(TokenModel tokenModel) {
        String tag = tokenModel.tag;
        String uuid = UUID.fastUUID().toString().substring(0, 20);
        String token = String.format("%s%s", tag, uuid.replace("-", ""));
        return token;
    }
}

