/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.proxy.config.ApplicationYmlConfig;
import com.geoway.ns.proxy.constant.enums.ResponseExceptionType;
import com.geoway.ns.proxy.constant.enums.ServiceType;
import com.geoway.ns.proxy.dto.ExcursionDTO;
import com.geoway.ns.proxy.dto.RouteMatchObject;
import com.geoway.ns.proxy.entity.ProxyObject;
import com.geoway.ns.proxy.entity.ProxyToken;
import com.geoway.ns.proxy.entity.TempStatistics;
import com.geoway.ns.proxy.mapper.AuthorizeTokenMapper;
import com.geoway.ns.proxy.mapper.TempStatisticsMapper;
import com.geoway.ns.proxy.service.AccessForwardService;
import com.geoway.ns.proxy.service.AccessVerifcationService;
import com.geoway.ns.proxy.service.AsyncService;
import com.geoway.ns.proxy.service.MapExcursionService;
import com.geoway.ns.proxy.service.RedisTemplateService;
import com.geoway.ns.proxy.service.RouterMatchService;
import com.geoway.ns.proxy.service.RouterProxyService;
import com.geoway.ns.proxy.service.impl.AccessVerifcationServiceImpl;
import com.geoway.ns.proxy.utils.UnityUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RouterProxyServiceImpl
implements RouterProxyService {
    @Value(value="${scheduled.enable:false}")
    private Boolean enable;
    public static final String MD5EncryptConst = "0c85cd60-9303-40af-84e4-db8b17cf76a4";
    @Autowired
    RouterMatchService routerMatchService;
    @Autowired
    private AccessForwardService forwardService;
    @Autowired
    private AccessVerifcationService verifcationService;
    @Autowired
    private AuthorizeTokenMapper authorizeMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private AccessVerifcationServiceImpl accessVerifcationService;
    @Autowired
    private TempStatisticsMapper tempStatisticsMapper;
    @Autowired
    private ApplicationYmlConfig applicationYmlConfig;
    @Autowired
    private AsyncService asyncService;
    @Value(value="${logRecord:false}")
    private Boolean LOG_RECORD;
    @Value(value="${py.enable:false}")
    private Boolean pyEnable;
    @Value(value="${py.cacheLevel:0}")
    private Integer cacheLevel;
    @Autowired
    private MapExcursionService mapExcursionService;

    @Override
    public void dropcache(HttpServletRequest request, HttpServletResponse response, String gk) throws Exception {
        request.setAttribute("requestURL", (Object)request.getAttribute("requestURL").toString().replace("/dropcache", ""));
        request.setAttribute("relPath", (Object)request.getAttribute("relPath").toString().replace("/dropcache", ""));
        RouteMatchObject routeMatchObject = this.routerMatchService.queryRouteMatch(request, gk);
        if (routeMatchObject == null || routeMatchObject.getStatus() == 404) {
            response.setStatus(404);
        } else if (routeMatchObject.getStatus() == 200) {
            String realURL = routeMatchObject.getUrl();
            String requestURL = (String)request.getAttribute("requestURL");
            JSONObject object = JSON.parseObject((String)routeMatchObject.getProxyObject().getExtension());
            Boolean offset = object != null && object.containsKey((Object)"rectifyOffset") ? object.getBoolean("rectifyOffset") : false;
            if (this.pyEnable.booleanValue() && offset.booleanValue()) {
                this.mapExcursionService.dropcache(realURL);
            } else {
                String addChar = realURL.indexOf("?") > -1 ? "&" : "?";
                String queyrParam = request.getQueryString();
                if (StrUtil.isNotBlank((CharSequence)queyrParam)) {
                    realURL = realURL + addChar + queyrParam;
                }
                this.forwardService.proxyHttpClient(realURL, gk, request, response);
            }
        }
    }

    @Override
    public void proxy(HttpServletRequest request, HttpServletResponse response, String gk) throws Exception {
        Integer code;
        RouteMatchObject routeMatchObject = this.routerMatchService.queryRouteMatch(request, gk);
        Map<String, Object> responeMap = new HashMap<String, Object>();
        responeMap.put("exception", 1);
        responeMap.put("costTime", 0);
        responeMap.put("log", "{}");
        responeMap.put("code", routeMatchObject.getStatus());
        responeMap.put("msg", routeMatchObject.getMessage());
        if (routeMatchObject == null || routeMatchObject.getStatus() == 404) {
            response.setStatus(404);
        } else if (routeMatchObject.getStatus() == 200) {
            String realURL = routeMatchObject.getUrl();
            String requestURL = (String)request.getAttribute("requestURL");
            JSONObject object = JSON.parseObject((String)routeMatchObject.getProxyObject().getExtension());
            Boolean offset = object != null && object.containsKey((Object)"rectifyOffset") ? object.getBoolean("rectifyOffset") : false;
            ExcursionDTO excursionDTO = new ExcursionDTO();
            this.mapExcursionService.analysisUrl(requestURL, excursionDTO);
            if (this.pyEnable.booleanValue() && !excursionDTO.getException().booleanValue() && offset.booleanValue() && excursionDTO.getLevel() > this.cacheLevel) {
                BufferedImage image = this.mapExcursionService.excursion(realURL + (realURL.indexOf("?") > -1 ? "&" : "?") + UnityUtils.getRealUrlUtil(requestURL, 4));
                if (image != null) {
                    ServletOutputStream outputStream = response.getOutputStream();
                    ImageIO.write((RenderedImage)image, "png", (OutputStream)outputStream);
                    return;
                }
            } else {
                String addChar = realURL.indexOf("?") > -1 ? "&" : "?";
                String queyrParam = request.getQueryString();
                if (StrUtil.isNotBlank((CharSequence)queyrParam)) {
                    realURL = realURL + addChar + queyrParam;
                }
                responeMap = this.forwardService.proxyHttpClient(realURL, gk, request, response);
            }
        } else {
            response.setContentType("text/html;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setStatus(routeMatchObject.getStatus());
            response.getWriter().println(routeMatchObject.getMessage());
        }
        if (routeMatchObject.getProxyObject() != null) {
            this.saveRecordInfo(routeMatchObject, responeMap);
            this.logManage(request, responeMap.get("log").toString(), routeMatchObject.getProxyToken(), routeMatchObject.getProxyObject());
        }
        if ((code = Integer.valueOf(Integer.parseInt(responeMap.get("code").toString()))) == 1000) {
            response.setStatus(code.intValue());
            response.getWriter().println(responeMap.get("msg").toString());
        }
    }

    @Override
    public void proxyTServer(HttpServletRequest request, HttpServletResponse response, String gk, String severName, String routerId) {
    }

    private Map<String, Object> manageLog(HttpServletRequest request, JSONObject verification, String url, Map<String, Object> map) {
        int index = url.indexOf("?");
        String result = "\u8bbf\u95ee\u6821\u9a8c\u5f02\u5e38\uff1a" + verification.getString("message");
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            if (!StringUtils.isNotBlank((CharSequence)header) || "content-length".equalsIgnoreCase(header)) continue;
            requestHeader.put(header, request.getHeader(header));
        }
        JSONObject log = new JSONObject();
        log.put("code", (Object)1000);
        log.put("costTime", (Object)0);
        log.put("requestHeader", requestHeader);
        log.put("exception", (Object)ResponseExceptionType.Exception.value);
        log.put("url", (Object)url.substring(0, index == -1 ? url.length() : index));
        log.put("method", (Object)request.getMethod());
        log.put("accessTime", (Object)LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli());
        log.put("result", (Object)result);
        map.put("code", 1000);
        map.put("costTime", 0);
        map.put("exception", ResponseExceptionType.Exception.value);
        map.put("msg", result);
        map.put("log", log);
        return map;
    }

    private void logManage(HttpServletRequest request, String logInfo, ProxyToken proxyToken, ProxyObject proxyObject) throws Exception {
        if (this.LOG_RECORD.booleanValue()) {
            JSONObject log = JSONObject.parseObject((String)logInfo);
            log.put("gk", (Object)proxyObject.getToken());
            log.put("userId", (Object)proxyToken.getObjectid());
            log.put("userName", (Object)proxyToken.getObjectname());
            log.put("userType", (Object)proxyObject.getAuthtype());
            log.put("serviceType", (Object)proxyObject.getServicetype());
            log.put("serviceName", (Object)proxyObject.getServicename());
            log.put("serviceId", (Object)proxyObject.getServiceid());
            log.put("authway", (Object)proxyObject.getAuthway());
            log.put("ipAddress", (Object)ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            this.asyncService.saveLogInfo(log.toJSONString());
        }
    }

    private String getProxyModelUrl(String url, Object requestUrl, Integer type) {
        if (type == ServiceType.MAP.values && ObjectUtil.isNotEmpty((Object)requestUrl)) {
            url = UnityUtils.getRealUrlUtil(url, 1) + UnityUtils.getRealUrlUtil(requestUrl.toString(), 2);
        }
        return url;
    }

    private JSONObject getProxyModelInfo(String gk) {
        Boolean hasKey = this.redisTemplateService.isHasKey("proxyModel:" + gk);
        if (hasKey.booleanValue()) {
            String info = this.redisTemplateService.getInfoByBoundValueOps("proxyModel:" + gk);
            info = info.replaceAll("\\\\", "");
            JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)info, JSONObject.class);
            return jsonObject;
        }
        return null;
    }

    private void saveRecordInfo(RouteMatchObject routeMatchObject, Map<String, Object> responeMap) {
        ProxyObject proxyObject = routeMatchObject.getProxyObject();
        TempStatistics tempStatistics = new TempStatistics();
        String token = proxyObject.getToken();
        Integer exception = Integer.valueOf(responeMap.get("exception").toString());
        Double costTime = Double.valueOf(responeMap.get("costTime").toString());
        tempStatistics.setId(null);
        tempStatistics.setResourceId(proxyObject.getServiceid());
        tempStatistics.setAccessId(routeMatchObject.getProxyToken().getObjectid());
        tempStatistics.setAccessType(proxyObject.getAuthtype());
        tempStatistics.setAccessTime(new Date());
        tempStatistics.setAccessCount(1L);
        tempStatistics.setCostTime(costTime);
        tempStatistics.setResourceType(2);
        tempStatistics.setToken(proxyObject.getToken());
        tempStatistics.setParams(routeMatchObject.getProxyObjectRouter() != null ? routeMatchObject.getProxyObjectRouter().getParams() : null);
        if (exception == ResponseExceptionType.Exception.value) {
            tempStatistics.setException(1L);
        }
        BoundListOperations tempList = this.redisTemplate.boundListOps((Object)"tempList");
        tempList.rightPush((Object)tempStatistics);
    }

    @Scheduled(cron="${scheduled.Task_AccessSave_cron:0/5 * * * * ?}")
    @Transactional(rollbackFor={Exception.class})
    private void cleanMap() {
        if (this.enable.booleanValue()) {
            Long size;
            BoundListOperations tempList = this.redisTemplate.boundListOps((Object)"tempList");
            BoundListOperations logTempList = this.redisTemplate.boundListOps((Object)"logTempList");
            if (logTempList.size() > 0L) {
                this.asyncService.saveLogInfoByTime();
            }
            if ((size = tempList.size()) > 0L) {
                List<Object> list = new ArrayList<TempStatistics>();
                for (long index = 1L; size >= index; ++index) {
                    TempStatistics temp = (TempStatistics)tempList.leftPop();
                    list.add(temp);
                }
                if (size > 1L) {
                    list = list.stream().collect(Collectors.toMap(TempStatistics::getToken, a -> a, (v1, v2) -> {
                        v1.setAccessCount(v1.getAccessCount() + v2.getAccessCount());
                        v1.setCostTime(v1.getCostTime() + v2.getCostTime());
                        v1.setException(v1.getException() + v2.getException());
                        v1.setAccessTime(v2.getAccessTime());
                        return v1;
                    })).values().stream().collect(Collectors.toList());
                }
                System.out.println("\u6b63\u5728\u5b58\u5165\u4e34\u65f6\u8868\uff01\u5171\u8ba1\u3010" + size + "\u3011\u6761\uff01\u7d2f\u52a0\u540e\u5171\u8ba1\u3010" + list.size() + "\u3011\u6761\u5165\u5e93\uff01");
                list.forEach(f -> this.tempStatisticsMapper.insert(f));
            }
        }
    }
}

