/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.proxy.config.ApplicationYmlConfig;
import com.geoway.ns.proxy.constant.enums.DataServiceType;
import com.geoway.ns.proxy.constant.enums.ResponseExceptionType;
import com.geoway.ns.proxy.constant.enums.ServiceType;
import com.geoway.ns.proxy.constant.enums.VertorTypeEnums;
import com.geoway.ns.proxy.constant.enums.VertorTypeExEnums;
import com.geoway.ns.proxy.dto.ResourceInfoDTO;
import com.geoway.ns.proxy.entity.AccessRoll;
import com.geoway.ns.proxy.entity.AuthorizeToken;
import com.geoway.ns.proxy.mapper.AccessRollMapper;
import com.geoway.ns.proxy.mapper.AuthorizeTokenMapper;
import com.geoway.ns.proxy.service.AccessVerifcationService;
import com.geoway.ns.proxy.service.RedisTemplateService;
import com.geoway.ns.proxy.utils.IpVerification;
import com.geoway.ns.proxy.utils.UnityUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AccessVerifcationServiceImpl
implements AccessVerifcationService {
    @Value(value="${xzqLimit:}")
    private String XZQ_LIMITS;
    @Autowired
    private AuthorizeTokenMapper authorizeTokenMapper;
    @Autowired
    private AccessRollMapper rollMapper;
    @Autowired
    private IpVerification ipVerification;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private ApplicationYmlConfig applicationYmlConfig;
    @Autowired
    private HttpServletRequest request;

    @Override
    public JSONObject verification(String token, HttpServletRequest request) throws Exception {
        JSONObject result = new JSONObject();
        ResourceInfoDTO resouceInfo = new ResourceInfoDTO();
        if (StrUtil.isBlank((CharSequence)token)) {
            String msg = "\u4f20\u9012\u7684Token\u4e3anull\uff01";
            throw new Exception(msg);
        }
        AuthorizeToken authorizeToken = this.getAuthorization(token);
        resouceInfo = (ResourceInfoDTO)JSON.parseObject((String)authorizeToken.getParams(), ResourceInfoDTO.class);
        result.put("status", (Object)ResponseExceptionType.NotException.value);
        try {
            if (authorizeToken.getStatus() != 0) {
                String msg = "token\u4e3a\u3010" + token + "\u3011\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650\uff01\uff01\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u662f\u5426\u6388\u6743\uff01";
                throw new Exception(msg);
            }
            String realUrl = authorizeToken.getUrl();
            String relativeUrl = authorizeToken.getRelativeUrl();
            String requestUrl = (String)request.getAttribute("requestURL");
            String rKey = "verify:" + MD5.create().digestHex(requestUrl);
            if (!this.redisTemplateService.isHasKey(rKey).booleanValue()) {
                this.isOverdue(authorizeToken.getIndate());
                this.isRoll(authorizeToken.getAuthorizerId());
                this.verificationOnIp(authorizeToken.getIpScope(), request);
                this.isFrequency(authorizeToken.getFrequency(), authorizeToken.getToken());
                this.serviceVerification(requestUrl, relativeUrl, authorizeToken, resouceInfo);
                this.redisTemplateService.setInfoByBoundValueOps(rKey, "", 10, TimeUnit.SECONDS);
            }
            this.xzqLimit(authorizeToken.getXzqLimit(), authorizeToken.getResourceType());
            String realURL = authorizeToken.getUrl();
            String addChar = realURL.indexOf("?") > -1 ? "&" : "?";
            String queyrParam = request.getQueryString();
            if (StrUtil.isNotBlank((CharSequence)queyrParam)) {
                realURL = realURL + addChar + queyrParam;
            }
            resouceInfo.setSourceUrl(realURL);
        }
        catch (Exception e) {
            resouceInfo.setSourceUrl(authorizeToken.getUrl());
            result.put("status", (Object)ResponseExceptionType.Exception.value);
            result.put("message", (Object)e.getMessage());
        }
        result.put("authorizeToken", (Object)authorizeToken);
        result.put("resultInfo", (Object)resouceInfo);
        return result;
    }

    private void serviceVerification(String requestUrl, String relativeUrl, AuthorizeToken authorizeToken, ResourceInfoDTO resource) throws Exception {
        if (requestUrl.contains("/proxy")) {
            return;
        }
        if (ServiceType.MAP.value == authorizeToken.getResourceType()) {
            String type;
            String string = type = resource.getSourceGroupType() == null ? resource.getGroupId() : resource.getSourceGroupType();
            if (DataServiceType.verification(Integer.valueOf(type)).booleanValue()) {
                if (DataServiceType.SLWP.value == Integer.valueOf(type)) {
                    this.mapServerVerify(requestUrl, relativeUrl, resource);
                }
                return;
            }
        }
        if (!requestUrl.contains(authorizeToken.getRelativeUrl())) {
            throw new Exception("\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u670d\u52a1\u5730\u5740\uff01");
        }
    }

    private void mapServerVerify(String requestUrl, String realPath, ResourceInfoDTO resource) {
        List<Integer> sourceType = resource.getSourceType();
        List<String> sourceStyle = resource.getSourceStyle();
        if (!CollectionUtil.isEmpty(sourceStyle)) {
            String styleId = this.request.getParameter("styleId");
            if (StringUtils.isBlank((CharSequence)styleId)) {
                String[] split = UnityUtils.getRealUrlUtil(requestUrl, 2).split("/");
                styleId = split[split.length - 1];
            }
            String finalStyleId = styleId;
            if (!sourceStyle.stream().anyMatch(a -> a.equalsIgnoreCase(finalStyleId))) {
                throw new RuntimeException("\u6837\u5f0f\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6837\u5f0f\uff01");
            }
        }
        Boolean flag = false;
        if (!CollectionUtil.isEmpty(sourceType)) {
            for (Integer type : sourceType) {
                VertorTypeEnums enums = VertorTypeEnums.getEnumByValue(type);
                String rule = enums.rule;
                String path = rule.replace("serviceName", resource.getSourceName());
                if (!requestUrl.contains(path)) continue;
                flag = true;
                break;
            }
        } else {
            String requestPath = UnityUtils.getRealUrlUtil(requestUrl, 2);
            List<String> requestPathList = Arrays.asList(requestPath.split("/"));
            List<String> realPathList = Arrays.asList(realPath.split("/"));
            if (realPathList.get(1).equals(requestPathList.get(1))) {
                for (String name : requestPathList) {
                    int index = name.indexOf(".");
                    String string = name = index < 0 ? name : name.substring(0, index);
                    if (!realPathList.get(3).equals(name)) continue;
                    flag = true;
                }
            }
        }
        if (!flag.booleanValue() && VertorTypeExEnums.verify(UnityUtils.getRealUrlUtil(requestUrl, 2), resource.getSourceName()).booleanValue()) {
            flag = true;
        }
        if (!flag.booleanValue()) {
            throw new RuntimeException("\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u670d\u52a1\u5730\u5740\uff01");
        }
    }

    private String getUrl(String requestUrl, String realUrl) {
        return UnityUtils.getRealUrlUtil(realUrl, 1) + UnityUtils.getRealUrlUtil(requestUrl, 3);
    }

    private AuthorizeToken getAuthorization(String token) throws Exception {
        AuthorizeToken authorizeToken;
        String key = "authorizers:" + token;
        if (this.redisTemplateService.isHasKey(key).booleanValue()) {
            authorizeToken = this.redisTemplateService.getAuthorizeToken(key);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_token", (Object)token);
            queryWrapper.ne((Object)"f_status", (Object)2);
            authorizeToken = (AuthorizeToken)this.authorizeTokenMapper.selectOne((Wrapper)queryWrapper);
            this.redisTemplateService.setAuthorizeToken("authorizers:" + token, authorizeToken);
        }
        if (authorizeToken == null) {
            String msg = "\u4e0d\u5b58\u5728token\u4e3a\u3010" + token + "\u3011\u7684\u6388\u6743\u7528\u6237\uff01\uff01\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u662f\u5426\u6388\u6743\uff01";
            throw new Exception(msg);
        }
        return authorizeToken;
    }

    private void isRoll(String authorizerId) throws Exception {
        long count;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AccessRoll::getAuthorizerId, (Object)authorizerId);
        List rolls = this.rollMapper.selectList((Wrapper)wrapper);
        if (rolls.size() > 0 && (count = rolls.stream().filter(f -> "all".equals(f.getAuthorizerId()) || f.getAuthorizerId().equals(f.getAuthorizerId())).count()) > 0L) {
            String msg = "\u60a8\u5df2\u88ab\u5217\u5165\u9ed1\u540d\u5355\uff01\u65e0\u6743\u8bbf\u95ee\u8be5\u670d\u52a1\u8d44\u6e90\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01";
            throw new Exception(msg);
        }
    }

    private void isOverdue(Date indate) throws Exception {
        String format;
        SimpleDateFormat sdf;
        Date newDate;
        if (indate != null && indate.before(newDate = (sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5")).parse(format = sdf.format(new Date())))) {
            String msg = "\u60a8\u7684\u6388\u6743\u5df2\u8fc7\u671f\uff01\u8bf7\u91cd\u65b0\u7533\u8bf7\uff01";
            throw new Exception(msg);
        }
    }

    private void isFrequency(String frequency, String token) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)frequency)) {
            this.verificationAccess(token);
            List list = JSONObject.parseArray((String)frequency, JSONObject.class);
            for (JSONObject object : list) {
                if (object.getInteger("value") == 0 || !this.verifaictionDate(object.getJSONArray("time"), object.getString("type"))) continue;
                this.restrict(object, token);
            }
        }
    }

    private void xzqLimit(String xzqLimit, Integer resourceType) {
        if (StringUtils.isNotBlank((CharSequence)xzqLimit) && ServiceType.MAP.value == resourceType) {
            Map map = (Map)JSONObject.parseObject((String)this.XZQ_LIMITS, Map.class);
            String[] split = xzqLimit.split("/");
            xzqLimit = split[split.length - 1];
            String filter = (String)map.get("filter");
            if (!"0000".equals(xzqLimit.substring(2))) {
                filter = "00".equals(xzqLimit.substring(4)) ? filter + xzqLimit.substring(0, 4) : filter + xzqLimit;
                map.put("filter", filter);
                this.request.setAttribute("mask", (Object)JSONObject.toJSONString((Object)map));
            }
        }
    }

    private JSONObject getResouceInfo(String id, Integer type) throws Exception {
        JSONObject jsonObject = null;
        String key = "resouce:" + type + ":" + id;
        Boolean aBoolean = this.redisTemplateService.isHasKey(key);
        if (aBoolean.booleanValue()) {
            String info = this.redisTemplateService.getInfoByBoundValueOps(key);
            if (StrUtil.isBlank((CharSequence)info)) {
                throw new Exception("\u67e5\u8be2\u670d\u52a1\u4e3a\u7a7a\uff01");
            }
            jsonObject = (JSONObject)JSON.parseObject((String)this.redisTemplateService.getInfoByBoundValueOps(key), JSONObject.class);
        }
        return jsonObject;
    }

    private Boolean dataServerParamVerification(Boolean flag, List<String> requestPathList, String realUrl, String requestUrl) {
        String s2;
        List<String> asList = Arrays.asList(realUrl.split("&"));
        Map<String, String> map = asList.stream().map(s -> s.split("=")).collect(Collectors.toMap(str -> str[0], str -> str[1]));
        String styleIds = this.request.getParameter("styleId");
        String tilesizes = this.request.getParameter("tilesize");
        if (StringUtils.isNotBlank((CharSequence)styleIds) && !styleIds.equals(s2 = map.get("styleId"))) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)tilesizes) && !tilesizes.equals(s2 = map.get("tilesize"))) {
            return false;
        }
        s2 = map.get("styleId");
        for (String name : requestPathList) {
            if (!s2.equals(name)) continue;
            flag = true;
        }
        return flag;
    }

    private void saveOnRedis(JSONObject result, Integer type) {
        String id = result.getString("id");
        String key = "resouce:" + type + ":" + id;
        Boolean aBoolean = this.redisTemplateService.isHasKey(key);
        if (!aBoolean.booleanValue()) {
            this.redisTemplateService.setInfoByBoundValueOps(key, result, 3, TimeUnit.MINUTES);
        }
    }

    public void verifaicationReferer(String refer, String referer) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)refer)) {
            Boolean flag = false;
            if (StringUtils.isNotBlank((CharSequence)referer)) {
                List<String> asList = Arrays.asList(refer.split(","));
                for (String referers : asList) {
                    if (!referer.equals(referers)) continue;
                    flag = true;
                }
            }
            if (!flag.booleanValue()) {
                throw new Exception("\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650\uff01");
            }
        }
    }

    private boolean verifaictionDate(JSONArray time, String type) throws ParseException {
        if (time != null && time.size() > 0) {
            if (StringUtils.isBlank((CharSequence)time.getString(0)) || StringUtils.isBlank((CharSequence)time.getString(1))) {
                return true;
            }
            DateTimeFormatter pattern = type.equals("HOURS") ? DateTimeFormatter.ofPattern("HH") : DateTimeFormatter.ofPattern("HH:mm");
            LocalTime str = LocalTime.parse(time.getString(0), pattern);
            LocalTime end = LocalTime.parse(time.getString(1), pattern);
            LocalTime now = LocalTime.now();
            return now.compareTo(str) != -1 && end.compareTo(now) != -1;
        }
        return true;
    }

    public void verificationOnIp(String uip, HttpServletRequest request) throws Exception {
        if (StrUtil.isBlank((CharSequence)uip)) {
            return;
        }
        String ip = request.getRemoteAddr();
        if (!this.ipVerification.ipExistsInRange(ip, uip)) {
            String msg = "\u60a8\u7684IP\u5730\u5740\u7981\u6b62\u8bbf\u95ee\u8be5\u670d\u52a1\uff01";
            throw new Exception(msg);
        }
    }

    private void verificationAccess(String token) throws Exception {
        Boolean flag = this.redisTemplateService.isHasKey("restrictBlack:" + token);
        if (flag.booleanValue()) {
            String msg = "\u60a8\u7684\u8bbf\u95ee\u5df2\u88ab\u9650\u5236\uff01";
            throw new Exception(msg);
        }
    }

    private void restrict(JSONObject object, String token) throws Exception {
        String type = object.getString("type");
        if ("MINUTES".equals(type)) {
            this.saveAuthorizer(token, object.getInteger("value"), TimeUnit.MINUTES);
        } else if ("HOURS".equals(type)) {
            this.saveAuthorizer(token, object.getInteger("value"), TimeUnit.HOURS);
        } else if ("DAY".equals(type)) {
            this.saveAuthorizer(token, object.getInteger("value"), TimeUnit.DAYS);
        }
    }

    private void saveAuthorizer(String token, Integer access, TimeUnit timeUnit) throws Exception {
        Integer count = this.redisTemplateService.getFrequency("restrict:" + token);
        long tomorrow = LocalDateTime.of(LocalDate.now().plusDays(1L), LocalTime.MIN).toInstant(ZoneOffset.of("+8")).getEpochSecond();
        long now = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        long time = tomorrow - now;
        if (count != null) {
            if (count >= access) {
                this.redisTemplateService.setFrequency("restrictBlack:" + token, 1, timeUnit == TimeUnit.DAYS ? time : 10L, timeUnit == TimeUnit.DAYS ? TimeUnit.SECONDS : TimeUnit.MINUTES);
                String msg = "\u60a8\u7684\u8bbf\u95ee\u5df2\u88ab\u9650\u5236\uff01";
                throw new Exception(msg);
            }
        } else {
            count = 0;
        }
        this.redisTemplateService.setFrequency("restrict:" + token, count + 1, timeUnit == TimeUnit.DAYS ? time : 1L, timeUnit == TimeUnit.DAYS ? TimeUnit.SECONDS : timeUnit);
    }
}

