/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.ns.proxy.config.MongoClientConfig;
import com.geoway.ns.proxy.dto.ExcursionDTO;
import com.geoway.ns.proxy.service.MapExcursionService;
import com.geoway.ns.proxy.utils.ExcursionUtil;
import com.geoway.ns.proxy.utils.UnityUtils;
import com.geoway.ns.proxy.utils.cesium.CesiumUtil;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumCartesian2;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumCartographic;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumRectangle;
import com.geoway.ns.proxy.utils.cesium.dto.CesiumTileOption;
import com.geoway.ns.proxy.utils.cesium.dto.ImageDTO;
import com.geoway.ns.sys.exception.ServiceException;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class MapExcursionServiceImpl
implements MapExcursionService {
    private static final Logger logger = LogManager.getLogger(MapExcursionServiceImpl.class);
    @Autowired
    private ExcursionUtil excursionUtil;
    @Autowired
    private MongoClientConfig mongoCache;
    @Autowired
    private ThreadPoolTaskExecutor executor;

    @Override
    public BufferedImage excursion(String url) throws Exception {
        try {
            BufferedImage image;
            Instant start = Instant.now();
            ExcursionDTO excursionDTO = new ExcursionDTO();
            url = this.analysisUrl(url, excursionDTO);
            if (excursionDTO.getX() == null || excursionDTO.getY() == null || excursionDTO.getLevel() == null) {
                return null;
            }
            String cacheKey = String.format("%s_%s_%s_%s_%s", UnityUtils.getRealUrlUtil(url, 2), excursionDTO.getX(), excursionDTO.getY(), excursionDTO.getLevel(), excursionDTO.getWidth());
            if (excursionDTO.getCache().booleanValue() && this.mongoCache.has(cacheKey) && !excursionDTO.getMask().booleanValue()) {
                byte[] bytes = this.mongoCache.get(cacheKey);
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                image = ImageIO.read(in);
                logger.info("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff08mongo\u7f13\u5b58\uff09\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0);
            } else {
                image = this.excursionStart(excursionDTO, url);
                logger.info("\u504f\u79fb\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\u4e3a\uff1a" + (double)Duration.between(start, Instant.now()).toMillis() / 1000.0);
                if (image != null && excursionDTO.getCache().booleanValue() && !excursionDTO.getMask().booleanValue()) {
                    this.executor.execute(() -> {
                        try {
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)image, "png", stream);
                            this.mongoCache.save(cacheKey, stream.toByteArray());
                        }
                        catch (IOException e) {
                            logger.error("\u3010" + cacheKey + "\u3011\u7f13\u5b58\u5931\u8d25\uff01" + e.getMessage());
                        }
                    });
                }
            }
            return image;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void dropcache(String url) throws Exception {
        String cacheKey = UnityUtils.getRealUrlUtil(url, 2);
        this.mongoCache.clearByKey(cacheKey);
    }

    private BufferedImage excursionStart(ExcursionDTO ex, String url) {
        String uuid = UUID.randomUUID().toString();
        logger.info("\u3010" + uuid + "\u3011\u8f6c\u6362\u524d\u884c\u5217\u53f7\u4e3a\uff1a" + ex.getX() + "_" + ex.getY() + "_" + ex.getLevel());
        Integer level = ex.getLevel();
        level = level - 1;
        CesiumRectangle wgs84Rectangle = CesiumUtil.GeographicTilingScheme.tileXYToRectangle(ex.getX(), ex.getY(), level, ex.getWidth());
        double[] southwest = wgs84Rectangle.southwest();
        double[] northeast = wgs84Rectangle.northeast();
        JSONObject xyPoint = this.excursionUtil.getXyPoint(southwest[1], southwest[0]);
        JSONObject xyPoint1 = this.excursionUtil.getXyPoint(northeast[1], northeast[0]);
        CesiumCartographic offsetSouthwest = CesiumUtil.Cartographic.fromDegrees(xyPoint.getDouble("xe"), xyPoint.getDouble("ye"));
        CesiumCartographic offsetNortheast = CesiumUtil.Cartographic.fromDegrees(xyPoint1.getDouble("xe"), xyPoint1.getDouble("ye"));
        CesiumRectangle offsetRectangle = new CesiumRectangle(offsetSouthwest.getLongitude(), offsetSouthwest.getLatitude(), offsetNortheast.getLongitude(), offsetNortheast.getLatitude());
        ArrayList<CesiumTileOption> list = new ArrayList<CesiumTileOption>();
        if (offsetRectangle.equals(wgs84Rectangle)) {
            CesiumTileOption dto = new CesiumTileOption(ex.getX(), ex.getX(), ex.getLevel());
            dto.setCropOption(new CesiumTileOption.CropOption(0, 0, ex.getWidth(), ex.getHeight()));
            list.add(dto);
        } else {
            CesiumCartesian2 swXY = CesiumUtil.GeographicTilingScheme.positionToTileXY(offsetSouthwest, level, ex.getWidth());
            CesiumCartesian2 neXY = CesiumUtil.GeographicTilingScheme.positionToTileXY(offsetNortheast, level, ex.getWidth());
            List<List<CesiumTileOption>> lists = this.getNWTileOptions(swXY, neXY, level, ex.getWidth(), ex.getWidth(), offsetRectangle);
            List<CesiumTileOption> cesiumTileOptions = lists.get(0);
            list.add(cesiumTileOptions.get(0));
            if (cesiumTileOptions.size() > 1) {
                list.add(cesiumTileOptions.get(1));
            }
            if (lists.size() > 1) {
                List<CesiumTileOption> cesiumTile = lists.get(1);
                CesiumTileOption cesiumTileOption = cesiumTile.get(0);
                cesiumTileOption.getCropOption().setTop(0);
                list.add(cesiumTileOption);
                if (cesiumTile.size() > 1) {
                    cesiumTileOption = cesiumTile.get(1);
                    cesiumTileOption.getCropOption().setTop(0);
                    list.add(cesiumTileOption);
                }
            }
        }
        ArrayList<ImageDTO> images = new ArrayList<ImageDTO>();
        logger.info("\u3010" + uuid + "\u3011\u8f6c\u6362\u540e\u74e6\u7247\u5185\u5bb9\uff1a" + JSON.toJSONString(list));
        for (CesiumTileOption option : list) {
            ImageDTO image = this.requestImage(url, option, ex.getLevel());
            if (image == null) continue;
            images.add(image);
        }
        if (images.size() == 0) {
            return null;
        }
        BufferedImage image = this.manageImage(images, ex.getWidth(), ex.getHeight());
        return image;
    }

    private ImageDTO requestImage(String url, CesiumTileOption option, Integer level) {
        url = url.replace("{x}", option.getX().toString()).replace("{y}", option.getY().toString()).replace("{zz}", level.toString()).replace("{z}", level.toString()).replace("{zzz}", level.toString());
        HttpResponse execute = HttpUtil.createGet((String)url).execute();
        logger.info("\u8bf7\u6c42\u74e6\u7247\u5730\u5740\u4ee5\u4e3a\uff1a" + url);
        String contentType = execute.header("Content-Type");
        if ("text/html;charset=UTF-8".equals(contentType)) {
            return null;
        }
        try {
            CesiumTileOption.CropOption crop = option.getCropOption();
            int imgWidth = crop.getWidth();
            int imgHeight = crop.getHeight();
            int cropLeft = crop.getLeft();
            int cropTop = crop.getTop();
            BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(execute.bodyBytes()));
            BufferedImage bufferedImage = Thumbnails.of((BufferedImage[])new BufferedImage[]{originalImage}).sourceRegion(cropLeft, cropTop, imgWidth, imgHeight).imageType(2).scale(1.0).asBufferedImage();
            return new ImageDTO(bufferedImage, option.getCropOption().getWidth(), option.getCropOption().getHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BufferedImage manageImage(List<ImageDTO> images, int tileWidth, int tileHeight) {
        BufferedImage canvas = new BufferedImage(tileWidth, tileHeight, 2);
        Graphics2D g2d = canvas.createGraphics();
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, tileWidth, tileHeight);
        g2d.setComposite(AlphaComposite.SrcOver);
        int x = 0;
        int y = 0;
        for (int i = 0; i < images.size(); ++i) {
            ImageDTO input = images.get(i);
            if (i == 1 && images.size() == 2 && (input.getX() == 256 || input.getX() == 512)) {
                x = 0;
                y = images.get(0).getY();
            }
            if (i == 1 && images.size() == 2 && (input.getY() == 256 || input.getY() == 512)) {
                x = images.get(0).getX();
                y = 0;
            }
            g2d.drawImage((Image)input.getImage(), x, y, null);
            if (i == 0) {
                x = images.get(0).getX();
                y = 0;
            }
            if (i == 1) {
                y = images.get(0).getY();
                x = 0;
            }
            if (i != 2) continue;
            x = images.get(0).getX();
            y = images.get(0).getY();
        }
        g2d.dispose();
        return canvas;
    }

    private List<List<CesiumTileOption>> getNWTileOptions(CesiumCartesian2 swXY, CesiumCartesian2 neXY, int level, int tileWidth, int tileHeight, CesiumRectangle offsetRectangle) {
        int minX = swXY.getX();
        int minY = neXY.getY();
        int maxX = neXY.getX();
        int maxY = swXY.getY();
        Integer x = minX;
        Integer y = minY;
        Integer top = 0;
        Integer left = 0;
        Integer width = 0;
        Integer height = 0;
        Double stepHeight = 0.0;
        Double stepWidth = 0.0;
        Integer countTileWidth = 0;
        Integer countTileHeight = 0;
        CesiumRectangle tileRectangle = new CesiumRectangle();
        CesiumRectangle intersectionRectangle = new CesiumRectangle();
        ArrayList<List<CesiumTileOption>> tileOptions = new ArrayList<List<CesiumTileOption>>();
        BigDecimal tileHeightDec = BigDecimal.valueOf(tileHeight);
        BigDecimal tileWidthDec = BigDecimal.valueOf(tileWidth);
        while (y <= maxY) {
            ArrayList<CesiumTileOption> tileRowOptions = new ArrayList<CesiumTileOption>();
            x = minX;
            countTileWidth = 0;
            while (x <= maxX) {
                tileRectangle = CesiumUtil.GeographicTilingScheme.tileXYToRectangle(x, y, level, tileWidth);
                stepHeight = tileHeightDec.divide(BigDecimal.valueOf(tileRectangle.getHeight()), 11, 4).doubleValue();
                stepWidth = tileWidthDec.divide(BigDecimal.valueOf(tileRectangle.getWidth()), 11, 4).doubleValue();
                intersectionRectangle = CesiumUtil.Rectangle.intersection(tileRectangle, offsetRectangle);
                if (intersectionRectangle == null) {
                    x = x + 1;
                    continue;
                }
                top = (int)Math.abs(Math.floor(new BigDecimal(intersectionRectangle.getNorth()).subtract(BigDecimal.valueOf(tileRectangle.getNorth())).multiply(BigDecimal.valueOf(stepHeight)).doubleValue()));
                left = (int)Math.abs(Math.floor(new BigDecimal(intersectionRectangle.getWest()).subtract(BigDecimal.valueOf(tileRectangle.getWest())).multiply(BigDecimal.valueOf(stepWidth)).doubleValue()));
                width = (int)Math.ceil(new BigDecimal(intersectionRectangle.getWidth()).multiply(BigDecimal.valueOf(stepWidth)).doubleValue());
                height = (int)Math.ceil(new BigDecimal(intersectionRectangle.getHeight()).multiply(BigDecimal.valueOf(stepHeight)).doubleValue());
                height = Math.min(height, tileHeight - top);
                width = Math.min(width, tileWidth - left);
                width = Math.min(width, tileWidth - countTileWidth);
                if (top >= tileHeight) {
                    ++minY;
                    break;
                }
                if (height <= 0) {
                    --maxY;
                    break;
                }
                if (left >= tileWidth) {
                    ++minX;
                    break;
                }
                if (width <= 0) {
                    --maxX;
                    break;
                }
                countTileWidth = countTileWidth + width;
                CesiumTileOption option = new CesiumTileOption(x, y, level);
                option.setCropOption(new CesiumTileOption.CropOption(left, top, width, height));
                tileRowOptions.add(option);
                x = x + 1;
            }
            if (!tileRowOptions.isEmpty()) {
                tileOptions.add(tileRowOptions);
            }
            y = y + 1;
        }
        if (!tileOptions.isEmpty()) {
            for (int i = 0; i < ((List)tileOptions.get(0)).size(); ++i) {
                List cesiumTileOptions;
                countTileHeight = 0;
                for (int j = 0; j < tileOptions.size() && !(cesiumTileOptions = (List)tileOptions.get(j)).isEmpty(); ++j) {
                    CesiumTileOption tile = (CesiumTileOption)cesiumTileOptions.get(i);
                    if (countTileHeight + tile.getCropOption().getHeight() > tileHeight) {
                        tile.getCropOption().setHeight(tileHeight - countTileHeight);
                    }
                    countTileHeight = countTileHeight + tile.getCropOption().getHeight();
                    if (tile.getCropOption().getHeight() != 0) continue;
                    ((List)tileOptions.get(j)).remove(i);
                    if (!((List)tileOptions.get(--j)).isEmpty()) continue;
                    tileOptions.remove(j);
                    --j;
                }
                if (countTileHeight == tileHeight) continue;
                List lastRow = (List)tileOptions.get(tileOptions.size() - 1);
                CesiumTileOption lastTile = (CesiumTileOption)lastRow.get(i);
                lastTile.getCropOption().setHeight(lastTile.getCropOption().getHeight() + (tileHeight - countTileHeight));
                lastTile.getCropOption().setTop(tileHeight - lastTile.getCropOption().getHeight());
            }
        }
        tileOptions.removeIf(f -> f.size() == 0);
        return tileOptions;
    }

    @Override
    public String analysisUrl(String url, ExcursionDTO excursion) throws Exception {
        String s;
        HashMap<String, String> params = new HashMap<String, String>();
        URL uri = new URL(url);
        String query = uri.getQuery();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                String key = pair.substring(0, idx);
                String value = pair.substring(idx + 1);
                params.put(key.toLowerCase(), value);
            }
        }
        if (params.get("x") != null) {
            s = (String)params.get("x");
            excursion.setX(Integer.valueOf(s));
            url = url.replace("x=" + s, "x={x}");
        }
        if (params.get("y") != null) {
            s = (String)params.get("y");
            excursion.setY(Integer.valueOf(s));
            url = url.replace("y=" + s, "y={y}");
        }
        if (params.get("l") != null) {
            s = (String)params.get("l");
            excursion.setLevel(Integer.valueOf(s));
            url = url.replace("l=" + s, "l={z}");
        }
        if (params.get("tilesize") != null) {
            excursion.setWidth(Integer.valueOf(((String)params.get("tilesize")).toString()));
            excursion.setHeight(Integer.valueOf(((String)params.get("tilesize")).toString()));
        }
        if (params.get("tilecol") != null) {
            s = (String)params.get("tilecol");
            excursion.setX(Integer.valueOf(s));
            url = url.replace("tilecol=" + s, "tilecol={x}");
        }
        if (params.get("tilerow") != null) {
            s = (String)params.get("tilerow");
            excursion.setY(Integer.valueOf(s));
            url = url.replace("tilerow=" + s, "tilerow={y}");
        }
        if (params.get("tilematrix") != null) {
            s = (String)params.get("tilematrix");
            excursion.setLevel(Integer.valueOf(s));
            url = url.replace("tilematrix=" + s, "tilematrix={z}");
        }
        if (params.get("tileSize") != null) {
            excursion.setWidth(Integer.valueOf(((String)params.get("tileSize")).toString()));
            excursion.setHeight(Integer.valueOf(((String)params.get("tileSize")).toString()));
        }
        if (params.get("mask") != null) {
            excursion.setMask(true);
        }
        if (params.get("request") != null) {
            excursion.setException(((String)params.get("request")).toString().toLowerCase().equals("getcapabilities"));
        }
        if (url.toLowerCase().contains("legend.json") && !excursion.getException().booleanValue()) {
            excursion.setException(true);
        }
        excursion.setCache(params.get("controlId") == null && params.get("control") == null);
        return url;
    }
}

